import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="common">topic-source-item{align-items:center;height:64px;margin:0 10px;width:calc(100% - 20px)}iron-list>*:not(:first-of-type){border-top:var(--cr-separator-line)}iron-list>:focus{background-color:var(--cros-sys-hover_on_subtle,--cr-focused-item-color)}</style>

<h3 id="topicSourceTitle" class="ambient-subpage-element-title">
  $i18n{ambientModeTopicSourceTitle}
</h3>

<iron-list id="topicSourceList" items="[[topicSources]]"
    aria-describedby="topicSourceTitle" role="radiogroup">
  <template>
    <topic-source-item topic-source="[[item]]"
        disabled="[[isTopicSourceDisabled_(item, selectedAmbientTheme)]]"
        role="radio"
        tabindex$="[[tabIndex]]"
        has-google-photos-albums="[[hasGooglePhotosAlbums]]"
        checked="[[isSelected_(item, selectedTopicSource)]]">
    </topic-source-item>
  </template>
</iron-list>
<!--_html_template_end_-->`;
}
