import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-icons common cros-button-style">#paragraph1{margin-block-start:0px}cr-dialog::part(dialog){width:410px}</style>

<cr-dialog id="systemGeolocationDialog" show-on-attach>
  <div slot="title">
    $i18n{systemGeolocationDialogTitle}
  </div>
  <div slot="body" id="dialogBody">
    <p id="paragraph1">[[bodyTextParagraph1]]</p>
    <template is="dom-if" if="[[bodyTextParagraph2]]">
      <localized-link
          aria-describedby="paragraph1"
          localized-string="[[bodyTextParagraph2]]"
          link-url="$i18n{geolocationAccuracyLearnMoreUrl}">
      </localized-link>
    </template>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton"
        class="cancel-button"
        on-click="onCancelClicked_">
      [[cancelButtonText]]
    </cr-button>
    <cr-button id="confirmButton"
        class="action-button"
        on-click="onEnableClicked_">
      [[confirmButtonText]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
