import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="common">:host{-webkit-tap-highlight-color:transparent;align-items:center;cursor:pointer;display:flex;height:var(--color-container-size);justify-content:center;width:var(--color-container-size)}.color-inner-container{align-items:center;border-radius:50%;display:flex;justify-content:center;position:relative}:host-context([aria-checked='true']) .color-inner-container{height:36px;width:36px}:host-context([aria-checked='false']) .color-inner-container{height:28px;width:28px}:host-context(.zone-title-container) .color-inner-container{height:27px;outline-color:white !important;outline-offset:-1px !important;width:27px}:host-context(.zone-title-container) .wallpaper-icon{background-color:white !important}:host-context(.zone-title-container) .wallpaper-icon svg{fill:var(--cros-sys-primary)}.dark-icon{fill:var(--cros-icon-color-primary-dark)}.light-icon{fill:var(--cros-icon-color-primary-light)}</style>
<template is="dom-if" if="[[isWallpaperColorId_(colorId)]]">
  <div class="color-inner-container wallpaper-icon"
        style$="[[getWallpaperColorInnerContainerStyle_(wallpaperColor_)]]">
      <svg class$="[[getWallpaperIconColorClass_(wallpaperColor_)]]" viewBox="0 0 20 20" width="16" height="16">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M12.0605 5.585L13.5805 6.935C14.3705 7.715 14.2005 8.985 13.4105 9.765L4.76469 18.4108C3.98364 19.1918 2.71731 19.1918 1.93626 18.4108L0.583834 17.0584C-0.196879 16.2776 -0.197265 15.012 0.582974 14.2308L7.40048 7.405L9.23048 5.585C10.0105 4.805 11.2805 4.805 12.0605 5.585ZM8.82101 8.81494L1.95101 15.6849L3.36101 17.1049L10.231 10.2249L8.82101 8.81494Z">
        </path>
        <path d="M16 6L15.06 3.94L13 3L15.06 2.06L16 0L16.94 2.06L19 3L16.94 3.94L16 6Z">
        </path>
        <path d="M17.001 17L16.061 14.94L14.001 14L16.061 13.06L17.001 11L17.941 13.06L20.001 14L17.941 14.94L17.001 17Z">
        </path>
        <path d="M17.001 17L16.061 14.94L14.001 14L16.061 13.06L17.001 11L17.941 13.06L20.001 14L17.941 14.94L17.001 17Z">
        </path>
        <path d="M3.06 4.94L4 7L4.94 4.94L7 4L4.94 3.06L4 1L3.06 3.06L1 4L3.06 4.94Z">
        </path>
      </svg>
  </div>
</template>
<template is="dom-if" if="[[!isWallpaperColorId_(colorId)]]">
  <div class="color-inner-container" style$="[[getColorInnerContainerStyle_(colorId)]]">
  </div>
</template>
<!--_html_template_end_-->`;
}
