import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="common">#selector{display:flex;flex-flow:row wrap;margin-top:14px;position:relative}#wallpaperIconAndDesc{column-gap:5.5px;display:flex;flex-flow:row wrap}#wallpaperColorDescription{color:var(--cros-text-color-secondary);font:var(--cros-body-2-font);height:48px;line-height:48px}.divider{align-self:center;border-inline-start:1px solid var(--cros-separator-color);height:20px}.selectable color-icon:focus-visible{border-radius:50%;outline:2px solid var(--cros-focus-ring-color);outline-offset:-2px}#toast{cursor:default;display:flex;flex-direction:column;position:absolute;top:var(--color-container-size);z-index:1}#toastDot{background-color:var(--cros-button-background-color-primary);border-radius:100%;height:8px;margin-block-end:5px;margin-inline-start:20px;width:8px}#toastContent{align-items:center;background-color:var(--cros-button-background-color-primary);border-radius:20px;display:flex;flex-direction:row;padding:8px 0}#toastContent>svg{fill:var(--cros-button-label-color-primary);padding:0 14px}#toastContent span{color:var(--cros-button-label-color-primary);font:var(--cros-body-2-font);margin-inline-end:14px}::slotted(.customization-button-container){align-self:center;display:flex;margin-inline-start:auto}@media (max-width:690px){#selector{column-gap:11px}:host-context(zone-customization) #selector{column-gap:0}#toast.multizone-supported{top:calc(var(--color-container-size) * 2)}}@media (max-width:823px) and (min-width:691px){#wallpaperIconAndDesc{flex-flow:column wrap}#wallpaperColorDescription{height:auto;line-height:12px;margin-inline-start:-18px}::slotted(.customization-button-container){margin-block-start:-12px}#toast.multizone-supported{top:calc(var(--color-container-size) + 20px)}}</style>
<div id="container">
  <iron-a11y-keys id="keys" keys="left right enter" on-keys-pressed="onKeysPress_">
  </iron-a11y-keys>
  <iron-selector id="selector" selected="0" selectable=".selectable"
      selected-item="{{ironSelectedColor_}}"
      role="radiogroup" aria-label="[[getColorSelectorAriaLabel_()]]">
    <template is="dom-if" if="[[!isMultiZoneRgbKeyboardSupported_]]">
      <div id$="[[wallpaperColorId_]]"
          class$="[[getWallpaperColorContainerClass_(selectedColor)]]"
          on-click="onWallpaperColorSelected_"
          on-keypress="onWallpaperColorSelected_">
        <color-icon
            tabindex="0"
            aria-label="$i18n{wallpaperColor}"
            aria-checked$="[[getWallpaperColorAriaChecked_(selectedColor)]]"
            title$="[[getWallpaperColorTitle_()]]"
            role="radio"
            color-id="[[wallpaperColorId_]]">
        </color-icon>
        <template is="dom-if" if="[[shouldShowNudge_]]">
          <div id="toast">
            <div id="toastDot"></div>
            <div id="toastContent">
              <svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M8.375 4.375L6.5 0.25L4.625 4.375L0.5 6.25L4.625 8.125L6.5 12.25L8.375 8.125L12.5 6.25L8.375 4.375ZM12.5 7.75L11.5625 9.8125L9.5 10.75L11.5625 11.6875L12.5 13.75L13.4375 11.6875L15.5 10.75L13.4375 9.8125L12.5 7.75Z"></path>
              </svg>
              <span>$i18n{wallpaperColorNudgeText}</span>
            </div>
          </div>
        </template>
      </div>
    </template>
    <template is="dom-if" if="[[!isMultiZoneRgbKeyboardSupported_]]">
      <div class="divider"></div>
    </template>
    <template is="dom-repeat" items="[[presetColorIds_]]" as="presetColorId">
      <div id$="[[presetColorId]]"
          class$="[[getPresetColorContainerClass_(presetColorId, presetColors_, selectedColor)]]"
          on-click="onPresetColorSelected_" on-keypress="onPresetColorSelected_">
        <color-icon
            tabindex$="[[getPresetColorTabIndex_(isMultiZoneRgbKeyboardSupported_, presetColorId)]]"
            aria-label$="[[getPresetColorAriaLabel_(presetColorId)]]"
            role="radio"
            aria-checked$="[[getPresetColorAriaChecked_(presetColorId, presetColors_, selectedColor)]]"
            title$="[[getPresetColorAriaLabel_(presetColorId)]]"
            color-id="[[presetColorId]]">
        </color-icon>
      </div>
    </template>
    <template is="dom-if" if="[[!isCustomizedDialog]]">
      <div id$="[[rainbowColorId_]]"
          class$="[[getRainbowColorContainerClass_(selectedColor)]]"
          on-click="onRainbowColorSelected_" on-keypress="onRainbowColorSelected_">
        <color-icon
            aria-label="$i18n{rainbowColor}"
            role="radio"
            aria-checked$="[[getRainbowColorAriaChecked_(selectedColor)]]"
            title="$i18n{rainbowColor}"
            color-id="[[rainbowColorId_]]">
        </color-icon>
      </div>
    </template>
    <template is="dom-if" if="[[isMultiZoneRgbKeyboardSupported_]]">
      <div id$="[[wallpaperColorId_]]"
          class$="[[getWallpaperColorContainerClass_(selectedColor)]]"
          on-click="onWallpaperColorSelected_"
          on-keypress="onWallpaperColorSelected_">
        <div id="wallpaperIconAndDesc">
          <color-icon
              aria-label="$i18n{wallpaperColor}"
              aria-checked$="[[getWallpaperColorAriaChecked_(selectedColor)]]"
              id="wallpaperColorIcon"
              title$="[[getWallpaperColorTitle_()]]"
              role="radio"
              color-id="[[wallpaperColorId_]]">
          </color-icon>
          <template is="dom-if" if="[[!isCustomizedDialog]]">
            <div id="wallpaperColorDescription">
                $i18n{wallpaperColorDescription}
            </div>
          </template>
        </div>
        <template is="dom-if" if="[[shouldShowNudge_]]">
          <div id="toast" class="multizone-supported">
            <div id="toastDot"></div>
            <div id="toastContent">
              <svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M8.375 4.375L6.5 0.25L4.625 4.375L0.5 6.25L4.625 8.125L6.5 12.25L8.375 8.125L12.5 6.25L8.375 4.375ZM12.5 7.75L11.5625 9.8125L9.5 10.75L11.5625 11.6875L12.5 13.75L13.4375 11.6875L15.5 10.75L13.4375 9.8125L12.5 7.75Z"></path>
              </svg>
              <span>$i18n{wallpaperColorNudgeText}</span>
            </div>
          </div>
        </template>
      </div>
      <slot name="button-container"></slot>
    </template>
  </iron-selector>
</div>
<!--_html_template_end_-->`;
}
