import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="common cros-button-style">:host{--color-container-size:48px}#container{display:grid;grid-template-areas:'. label   .' '. options .' '. .       .';grid-template-columns:12px 1fr 20px;grid-template-rows:auto 1fr 20px}@media (max-width:700px){#container.preview-container{grid-template-rows:auto 1fr 8px}}#keyboardBacklightLabel{align-items:center;background:none;border:none;display:flex;flex-flow:row nowrap;grid-area:label;justify-content:space-between;margin-block-start:20px;margin-inline-start:8px}#keyboardBacklightLabel>p{color:var(--cros-text-color-primary);font:var(--personalization-app-label-font);margin:0}color-selector{grid-area:options}#zoneCustomizationButton[aria-pressed='true']{background-color:var(--cros-sys-primary,var(--cros-button-background-color-primary));color:var(--cros-sys-on_primary,var(--cros-button-label-color-primary))}#zoneCustomizationButton[aria-pressed='true'] .text{margin-inline-start:8px}#zoneCustomizationButton:not([aria-pressed='true']) iron-icon{display:none}</style>
<div id="container" class="preview-container">
  <div id="keyboardBacklightLabel">
    <p class="title">$i18n{keyboardBacklightTitle}</p>
  </div>
  <color-selector
      selected-color="[[backlightColor_]]"
      on-wallpaper-color-selected="onWallpaperColorSelected_"
      on-preset-color-selected="onPresetColorSelected_"
      on-rainbow-color-selected="onRainbowColorSelected_">
    <div slot="button-container" class="customization-button-container">
      <cr-button id="zoneCustomizationButton" on-click="showZoneCustomizationDialog_"
          class="secondary"
          aria-pressed$="[[getZoneCustomizationButtonAriaPressed_(currentBacklightState_)]]">
        <iron-icon
            class="customized-checkmark"
            icon="personalization-shared:circle-checkmark">
        </iron-icon>
        <div class="text">$i18n{zoneCustomize}</div>
      </cr-button>
    </div>
  </color-selector>
  <template is="dom-if" if="[[isZoneCustomizationDialogOpen_]]" restamp>
    <zone-customization on-cancel="closeZoneCustomizationDialog_"></zone-customization>
  </template>
</div>
<!--_html_template_end_-->`;
}
