import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="common cros-button-style">:host{--cros-tab-slider-track-color:var(--cros-button-stroke-color-secondary)}cr-dialog::part(dialog){padding-bottom:28px;width:642px}@media (max-width:650px){cr-dialog::part(dialog){width:560px}}#zoneSelector{background-color:var(--cros-tab-slider-track-color);border-radius:24px;column-gap:2px;display:grid;grid-template-columns:repeat(auto-fit,minmax(0,1fr));grid-template-rows:minmax(0,1fr);margin-block-end:28px;margin-block-start:2px;width:100%}paper-ripple{border-radius:24px;--paper-ripple-opacity:var(--cros-button-primary-ripple-opacity)}.zone-tab[aria-selected=false] paper-ripple{color:var(--cros-sys-ripple_neutral_on_subtle)}.zone-tab[aria-selected=true] paper-ripple{color:var(--cros-sys-ripple_primary)}.zone-tab{-webkit-tap-highlight-color:transparent;border:2px solid var(--cros-tab-slider-track-color);border-radius:24px;box-sizing:border-box;color:var(--cros-sys-secondary,var(--cros-button-label-color-secondary));cursor:pointer;font:var(--cros-button-2-font);height:100%;padding:6px 0 6px 0;position:relative;width:100%}.zone-tab[aria-selected=true]{background-color:var(--cros-sys-primary,var(--cros-button-background-color-primary));color:var(--cros-sys-on_primary,var(--cros-button-label-color-primary))}.zone-tab[aria-selected=false]:hover{background-color:var(--cros-sys-hover_on_subtle,var(--cros-ripple-color));color:var(--cros-sys-on_surface)}.zone-title-container{align-items:center;display:grid;grid-template-columns:auto minmax(0,1fr);height:100%;width:100%}.zone-title-container>color-icon{height:auto;margin-inline-start:8px;width:auto}#zoneTitle{margin-inline:4px 8px;text-align:center;word-break:break-all;word-wrap:break-word}#zoneSelector:focus-visible,color-selector:focus-visible{outline:none}.zone-tab:focus-visible{outline:2px solid var(--cros-focus-ring-color)}</style>
<cr-dialog id="dialog" show-on-attach>
  <div slot="body" aria-label=" ">
    <iron-a11y-keys id="zoneKeys" keys="left right enter" on-keys-pressed="onZoneKeysPress_">
    </iron-a11y-keys>
    <iron-selector
        id="zoneSelector"
        selected="0"
        selected-item="{{ironSelectedZone_}}"
        aria-label$="[[getZoneTabListAriaLabel_()]]"
        role="tablist">
      <template is="dom-repeat" items="[[zoneIdxs_]]" as="zoneIdx">
        <div
            id$="[[zoneIdx]]"
            class="zone-tab"
            tabindex$="[[getZoneTabIndex_(zoneIdx, zoneSelected_)]]"
            data-zone-idx$="[[zoneIdx]]"
            on-click="onClickZoneTab_"
            aria-description$="[[getZoneColorDescription_(zoneIdx, zoneColors_)]]"
            aria-selected$="[[getZoneAriaSelected_(zoneIdx, zoneSelected_)]]"
            role="tab">
          <paper-ripple fit></paper-ripple>
          <div class="zone-title-container">
            <color-icon color-id="[[getColorId_(zoneIdx, zoneColors_)]]"></color-icon>
            <div id="zoneTitle">[[getZoneTitle_(zoneIdx)]]</div>
          </div>
        </div>
      </template>
    </iron-selector>
    <color-selector
        is-customized-dialog
        selected-color="[[getSelectedColor_(zoneSelected_, zoneColors_)]]"
        on-wallpaper-color-selected="onWallpaperColorSelected_"
        on-preset-color-selected="onPresetColorSelected_"
        role="tabpanel">
      <div slot="button-container" class="customization-button-container">
        <cr-button class="primary action-button" id="dialogCloseButton"
            on-click="onClickCloseDialog_">
          $i18n{dismissButtonText}
        </cr-button>
      </div>
    </color-selector>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
