import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-icons common cros-button-style">#container{align-items:center;box-sizing:border-box;display:flex;flex-flow:row nowrap;height:100%;padding:0 10px}#backButton{--cr-icon-button-margin-start:-12px;--cr-icon-button-margin-end:8px}#selector{align-items:center;box-sizing:border-box;color:var(--cros-text-color-secondary);display:flex;flex-flow:row nowrap;font:var(--cros-title-1-font);height:100%;width:100%}#homeButton{--cr-icon-button-size:36px;margin-inline-end:6px;margin-inline-start:-10px}.breadcrumb{--ink-color:rgba(var(--cros-ripple-color-rgb),1);--paper-ripple-opacity:var(--cros-ripple-opacity);--text-color:var(--cros-sys-on_surface) !important;background-color:transparent !important;border:none;min-width:48px}.breadcrumb:not(last-of-type){flex:0 0 auto}.breadcrumb:last-of-type{flex:0 1 auto}iron-icon[icon='cr:chevron-right']{flex:0 0 auto}#seaPenDropdown{--iron-icon-fill-color:var(--cros-sys-secondary);padding-inline-start:12px}.dropdown-check{margin-inline-end:16px}button:not([aria-checked='true']) iron-icon.dropdown-check{visibility:hidden}button{font:var(--cros-button-2-font);padding:8px 32px 8px 16px}</style>
<nav id="container">
    <iron-a11y-keys id="keys" keys="left right" on-keys-pressed="onKeysPress_">
    </iron-a11y-keys>
    <iron-selector id="selector" selectable=".selectable" selected="0"
        selected-item="{{selectedBreadcrumb_}}">
      <cr-icon-button id="homeButton"
          class="selectable"
          role="link"
          aria-label$="[[getHomeButtonAriaLabel_()]]"
          iron-icon="personalization:home"
          on-click="onHomeIconClick_">
      </cr-icon-button>
      <iron-icon icon="cr:chevron-right" aria-hidden="true"></iron-icon>
      <template is="dom-repeat" items="[[breadcrumbs_]]" as="breadcrumb">
        <template is="dom-if" if="[[index]]">
          <iron-icon icon="cr:chevron-right" aria-hidden="true"></iron-icon>
        </template>
        <template is="dom-if" if="[[!shouldShowSeaPenDropdown_(path, breadcrumb)]]" restamp>
          <cr-button class="breadcrumb selectable"
              role="link"
              aria-current$="[[getBreadcrumbAriaCurrent_(index, breadcrumbs_)]]"
              tabindex="-1"
              id="breadcrumb[[index]]"
              on-click="onBreadcrumbClick_">
            <div class="ellipsis" title$="[[breadcrumb]]">[[breadcrumb]]</div>
          </cr-button>
        </template>
        <template is="dom-if" if="[[shouldShowSeaPenDropdown_(path, breadcrumb)]]" restamp>
          <cr-button class="breadcrumb selectable"
              aria-haspopup="true"
              aria-controls="actionMenu"
              id="breadcrumb[[index]]"
              on-click="onClickMenuIcon_">
            <div class="ellipsis" title$="[[breadcrumb]]">[[breadcrumb]]</div>
            <iron-icon id="seaPenDropdown" icon="cr:arrow-drop-down"></iron-icon>
          </cr-button>
        </template>
      </template>
      <cr-action-menu
          id="actionMenu"
          accessibility-label="$i18n{seaPenTemplateHeading}"
          role-description="$i18n{seaPenMenuRoleDescription}">
        <template is="dom-repeat" items="[[seaPenTemplates_]]" as="template">
          <button
              aria-checked$="[[getAriaChecked_(template.id, seaPenTemplateId)]]"
              class="dropdown-item"
              role="menuitemcheckbox"
              data-id$="[[template.id]]"
              on-click="onClickMenuItem_">
            <iron-icon class="dropdown-check" icon="cr:check"></iron-icon>
            [[template.title]]
          </button>
        </template>
      </cr-action-menu>
    </iron-selector>
</nav>
<!--_html_template_end_-->`;
}
