// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { assert } from 'chrome://resources/js/assert.js';
import { ColorScheme } from '../color_scheme.mojom-webui.js';
import { StaticColor, TopicSource } from '../personalization_app.mojom-webui.js';
import { GeolocationAccessLevel } from './geolocation_dialog.js';
import { Paths } from './personalization_router_element.js';
function toMetricsEnum(path) {
    switch (path) {
        case Paths.AMBIENT:
            return 0 /* MetricsPath.AMBIENT */;
        case Paths.AMBIENT_ALBUMS:
            return 1 /* MetricsPath.AMBIENT_ALBUMS */;
        case Paths.COLLECTION_IMAGES:
            return 2 /* MetricsPath.WALLPAPER_COLLECTION_IMAGES */;
        case Paths.COLLECTIONS:
            return 3 /* MetricsPath.WALLPAPER */;
        case Paths.GOOGLE_PHOTOS_COLLECTION:
            return 4 /* MetricsPath.WALLPAPER_GOOGLE_PHOTO_COLLECTION */;
        case Paths.LOCAL_COLLECTION:
            return 5 /* MetricsPath.WALLPAPER_LOCAL_COLLECTION */;
        case Paths.ROOT:
            return 6 /* MetricsPath.ROOT */;
        case Paths.USER:
            return 7 /* MetricsPath.USER */;
        case Paths.SEA_PEN_COLLECTION:
            return 8 /* MetricsPath.WALLPAPER_SEA_PEN_COLLECTION */;
        case Paths.SEA_PEN_RESULTS:
            return 9 /* MetricsPath.WALLPAPER_SEA_PEN_RESULTS */;
        case Paths.SEA_PEN_FREEFORM:
            return 10 /* MetricsPath.WALLPAPER_SEA_PEN_FREEFORM */;
    }
}
export function logPersonalizationPathUMA(path) {
    const metricsPath = toMetricsEnum(path);
    assert(metricsPath <= 10 /* MetricsPath.MAX_VALUE */);
    chrome.metricsPrivate.recordEnumerationValue("Ash.Personalization.Path" /* HistogramName.PATH */, metricsPath, 10 /* MetricsPath.MAX_VALUE */ + 1);
}
export function logAmbientAlbumsPathUMA(topicSource) {
    chrome.metricsPrivate.recordEnumerationValue("Ash.Personalization.AmbientMode.AlbumsPath" /* HistogramName.AMBIENT_ALBUMS_PATH */, topicSource, TopicSource.MAX_VALUE + 1);
}
export function logAmbientModeOptInUMA() {
    chrome.metricsPrivate.recordBoolean("Ash.Personalization.AmbientMode.OptIn" /* HistogramName.AMBIENT_OPTIN */, true);
}
export function logGooglePhotosPreviewsLoadTime() {
    // Get elapsed time in ms since the page initialized.
    const timeMs = Math.round(performance.now());
    console.debug("Ash.Personalization.Ambient.GooglePhotosPreviewsLoadTime" /* HistogramName.AMBIENT_PERFORMANCE_GOOGLE_PHOTOS_PREVIEWS */, timeMs);
    chrome.metricsPrivate.recordTime("Ash.Personalization.Ambient.GooglePhotosPreviewsLoadTime" /* HistogramName.AMBIENT_PERFORMANCE_GOOGLE_PHOTOS_PREVIEWS */, timeMs);
}
export function logKeyboardBacklightOpenZoneCustomizationUMA() {
    chrome.metricsPrivate.recordBoolean("Ash.Personalization.KeyboardBacklight.OpenZoneCustomization" /* HistogramName.KEYBOARD_BACKLIGHT_OPEN_ZONE_CUSTOMIZATION */, true);
}
export function logDynamicColorToggleButtonClick(enabled) {
    chrome.metricsPrivate.recordBoolean("Ash.Personalization.DynamicColor.ToggleButton" /* HistogramName.DYNAMIC_COLOR_TOGGLE_BUTTON */, enabled);
}
export function logDynamicColorStaticColorButtonClick(color) {
    chrome.metricsPrivate.recordEnumerationValue("Ash.Personalization.DynamicColor.StaticColorButton" /* HistogramName.DYNAMIC_COLOR_STATIC_COLOR_BUTTON */, color, StaticColor.MAX_VALUE);
}
export function logDynamicColorColorSchemeButtonClick(color) {
    chrome.metricsPrivate.recordEnumerationValue("Ash.Personalization.DynamicColor.ColorSchemeButton" /* HistogramName.DYNAMIC_COLOR_COLOR_SCHEME_BUTTON */, color, ColorScheme.MAX_VALUE);
}
export function logAmbientModeLinkToGooglePhotosClick() {
    chrome.metricsPrivate.recordBoolean("Ash.Personalization.Ambient.LinkToGooglePhotosClicked" /* HistogramName.AMBIENT_LINK_TO_GOOGLE_PHOTOS_CLICKED */, true);
}
export function logSystemLocationPermissionChange(accessLevel) {
    chrome.metricsPrivate.recordEnumerationValue("ChromeOS.PrivacyHub.Geolocation.AccessLevelChanged.GeolocationDialog" /* HistogramName.LOCATION_PERMISSION_CHANGE_FROM_DIALOG */, accessLevel, GeolocationAccessLevel.MAX_VALUE + 1);
}
