import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="common">#container{display:flex;flex-flow:column nowrap;position:relative;width:100%}#breadcrumbArea{background-color:var(--cros-sys-app_base_shaded);display:grid;grid-template-areas:'. . breadcrumb . .';grid-template-columns:1fr 10px minmax(568px,920px) 10px 1fr;grid-template-rows:var(--personalization-app-breadcrumb-height);position:sticky;top:0;width:100%;z-index:3}personalization-breadcrumb{grid-area:breadcrumb}personalization-toast{bottom:16px;left:16px;max-width:380px;position:sticky}sea-pen-router{--sea-pen-router-min-height:var(--personalization-app-subpage-container-min-height)}wallpaper-fullscreen{bottom:0;height:100%;left:0;pointer-events:none;position:absolute;width:100%}sea-pen-router .wallpaperSelectedHidden{height:1px;left:-2px;overflow:hidden;position:fixed;top:-2px;width:1px}</style>
<div id="container">
  <!-- dwell-time is set to 200ms to populate history state more quickly while
       still respecting the grace period defined in iron-location.  -->
  <iron-location path="{{path_}}" query="{{query_}}" dwell-time="200">
  </iron-location>
  <iron-query-params params-object="{{queryParams_}}"
    params-string="{{query_}}">
  </iron-query-params>
  <template is="dom-if" if="[[shouldShowBreadcrumb_(path_)]]">
    <div id="breadcrumbArea">
      <personalization-breadcrumb path="[[path_]]"
          collection-id="[[queryParams_.id]]"
          google-photos-album-id="[[queryParams_.googlePhotosAlbumId]]"
          topic-source="[[queryParams_.topicSource]]"
          sea-pen-template-id="[[queryParams_.seaPenTemplateId]]">
      </personalization-breadcrumb>
    </div>
  </template>
  <template is="dom-if" if="[[shouldShowRootPage_(path_)]]">
    <personalization-main path="[[path_]]"></personalization-main>
  </template>
  <template is="dom-if" if="[[shouldShowAmbientSubpage_(path_)]]" restamp>
    <ambient-subpage path="[[path_]]" query-params="[[queryParams_]]">
    </ambient-subpage>
  </template>
  <template is="dom-if" if="[[shouldShowUserSubpage_(path_)]]" restamp>
    <user-subpage path="[[path_]]"></user-subpage>
  </template>
  <template is="dom-if" if="[[shouldShowWallpaperSubpage_(path_)]]" restamp>
    <wallpaper-subpage path="[[path_]]" query-params="[[queryParams_]]">
    </wallpaper-subpage>
  </template>
  <template is="dom-if" if="[[shouldShowSeaPen_(path_)]]" restamp>
    <sea-pen-router base-path="[[seaPenBasePath_]]" class="always-show-top">
      <wallpaper-selected id="wallpaperSelected" class$="[[getWallpaperSelectedClass_(path_)]]">
      </wallpaper-selected>
    </sea-pen-router>
  </template>
  <personalization-toast></personalization-toast>
  <wallpaper-fullscreen></wallpaper-fullscreen>
</div>
<!--_html_template_end_-->`;
}
