import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cros-button-style">:host{--iron-icon-fill-color:var(--cros-sys-primary_container)}cr-button{background-color:var(--cros-tab-slider-track-color);border:0;display:flex;flex-flow:column nowrap;height:60px;padding-bottom:8px;padding-top:8px;--ink-color:rgba(var(--cros-ripple-color-rgb),1);--paper-ripple-opacity:var(--cros-button-primary-ripple-opacity)}cr-button[aria-checked=true] .text{color:var(--cros-button-label-color-primary) !important}cr-button[aria-checked=true] iron-icon{--iron-icon-fill-color:var(--cros-button-label-color-primary) !important}cr-button .text,cr-button:hover .text{color:var(--cros-text-color-secondary);font:var(--personalization-app-label-font);padding-top:4px}cr-button iron-icon,cr-button:hover iron-icon{--iron-icon-fill-color:var(--cros-text-color-secondary)}cr-button:hover{--hover-bg-color:var(--cros-sys-hover_on_subtle);background-color:rgba(var(--cros-ripple-color-rgb),var(--cros-button-primary-ripple-opacity))}#selector>cr-button[aria-checked=true]:hover::part(hoverBackground){--hover-bg-color:var(--cros-sys-hover_on_prominent);background-color:var(--hover-bg-color);display:block}#selector>cr-button[aria-checked=true]{background-color:var(--cros-button-background-color-primary)}#selector{position:relative;display:grid;gap:8px;grid-template-columns:auto auto auto}#geolocationWarningDiv{display:flex;width:inherit;margin-top:5px}#warningIcon{margin-inline-end:5px;min-width:var(--iron-icon-width)}#autoMode{overflow:visible}.consumer-tooltip{--cr-icon-size:22px;--cr-tooltip-icon-fill-color:var(--cros-sys-primary_container);border-radius:50%;inset-block-end:-2px;inset-inline-end:-2px;position:absolute;box-shadow:inset 0 0 0 4px var(--cros-sys-primary_container)}.managed-tooltip{--cr-icon-size:16px;--cr-tooltip-icon-fill-color:var(--cros-button-background-color-primary);border-radius:50%;inset-block-end:-0px;inset-inline-end:-0px;position:absolute;box-shadow:0 0 0 4px var(--cros-sys-primary_container);background-color:var(--cros-sys-primary_container)}</style>
<div id="container">
  <dynamic-color></dynamic-color>
  <iron-a11y-keys id="keys" keys="left right" on-keys-pressed="onKeysPress_">
  </iron-a11y-keys>
  <iron-selector id="selector" selected="0"
      selected-item="{{selectedButton_}}" role="radiogroup"
      selectable="cr-button">
    <cr-button id="lightMode" data-color-mode="LIGHT"
        on-click="onClickColorModeButton_"
        aria-checked$="[[getLightAriaChecked_(colorModeAutoScheduleEnabled_, darkModeEnabled_)]]"
        aria-description="$i18n{ariaLabelEnableLightColorMode}"
        role="radio">
      <iron-icon icon="personalization:light" aria-hidden="true"></iron-icon>
      <div class="text">$i18n{lightColorMode}</div>
    </cr-button>
    <cr-button id="darkMode" data-color-mode="DARK"
        on-click="onClickColorModeButton_"
        on-keypress="onClickColorModeButton_" tabindex="-1"
        aria-checked$="[[getDarkAriaChecked_(colorModeAutoScheduleEnabled_, darkModeEnabled_)]]"
        aria-description="$i18n{ariaLabelEnableDarkColorMode}"
        role="radio">
      <iron-icon icon="personalization:dark" aria-hidden="true"></iron-icon>
      <div class="text">$i18n{darkColorMode}</div>
    </cr-button>
    <cr-button id="autoMode"
        on-click="onClickAutoModeButton_"
        on-keypress="onClickAutoModeButton_" tabindex="-1"
        aria-checked$="[[getAutoAriaChecked_(colorModeAutoScheduleEnabled_)]]"
        aria-describedby="autoColorModeDescription hiddenSeparator locationDeniedInfoIcon"
        aria-label="$i18n{autoColorMode}"
        title="$i18n{tooltipAutoColorMode}"
        role="radio">
      <iron-icon icon="personalization:auto" aria-hidden="true"></iron-icon>
      <div class="text" aria-hidden="true">$i18n{autoColorMode}</div>
      <p hidden id="autoColorModeDescription">$i18n{tooltipAutoColorMode}</p>
      <p hidden id="hiddenSeparator">.</p>
    </cr-button>
    <template is="dom-if"
        if="[[computeShouldShowTooltipIcon_(colorModeAutoScheduleEnabled_, geolocationPermissionEnabled_)]]"
        restamp>
      <template is="dom-if" if="[[geolocationIsUserModifiable_]]">
        <cr-tooltip-icon
            id="locationDeniedInfoIcon"
            icon-class="cr:error"
            tooltip-text="$i18n{errorTooltipAutoColorMode}"
            icon-aria-label="$i18n{errorTooltipAutoColorMode}"
            class="consumer-tooltip">
        </cr-tooltip-icon>
      </template>
      <template is="dom-if" if="[[!geolocationIsUserModifiable_]]">
        <cr-tooltip-icon
            id="locationDeniedInfoIcon"
            icon-class="personalization:managed"
            tooltip-text="$i18n{managedErrorTooltipAutoColorMode}"
            icon-aria-label="$i18n{managedErrorTooltipAutoColorMode}"
            class="managed-tooltip">
        </cr-tooltip-icon>
      </template>
    </template>
  </iron-selector>
</div>

<template is="dom-if" if="[[shouldShowGeolocationDialog_]]" restamp>
  <geolocation-dialog id="geolocationDialog"
      body-text-paragraph1="[[computeAutoModeGeolocationDialogText_(sunriseTime_, sunsetTime_)]]"
      confirm-button-text="$i18n{autoModeGeolocationDialogConfirmButton}"
      cancel-button-text="$i18n{autoModeGeolocationDialogCancelButton}"
      on-geolocation-enabled="onGeolocationEnabled_"
      on-close="onGeolocationDialogClose_">
  </geolocation-dialog>
</template>
<!--_html_template_end_-->`;
}
