import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="wallpaper">#container{box-sizing:border-box;display:grid;grid-template-areas:'.     . .' 'image . text';grid-template-columns:96px 20px minmax(0,1fr);grid-template-rows:20px 96px;height:100%}:host-context(user-subpage) #container{grid-template-rows:6px 96px;padding-left:10px}#imageContainer{grid-area:image;position:relative}#imageBorderContainer{background-color:var(--personalization-app-grid-item-background-color);border:0;border-radius:50%;height:96px;width:96px}#imageContainer #imageBorderContainer img{background-size:96px 96px;border:0;border-radius:50%;height:96px;width:96px}#imageContainer img{border:0;border-radius:50%;height:96px;width:96px}#imageContainer img.clickable{cursor:pointer}#imageContainer img.clickable:hover,#iconContainer:hover~img{filter:brightness(0.94)}#infoContainer{display:flex;flex-flow:column nowrap;grid-area:text;justify-content:center;margin:0}#infoContainer>*{margin:0}#infoContainer>h1{color:var(--cros-text-color-primary);font:var(--cros-display-6_regular-font);line-height:24px}.avatar-link{align-items:center;cursor:pointer;display:flex;flex-flow:row nowrap;padding-top:4px;text-decoration:none;width:fit-content}.avatar-link:focus-visible{outline:2px solid var(--cros-focus-ring-color)}.avatar-link>span{color:var(--cros-sys-secondary,var(--cros-link-color));font:var(--cros-body-2-font);margin:0}iron-icon[icon='cr:open-in-new']{--iron-icon-height:12px;--iron-icon-width:12px;--iron-icon-fill-color:var(--cros-sys-secondary,var(--cros-link-color));margin-inline-start:6px}paper-ripple{color:rgba(var(--cros-ripple-color-rgb),1);--paper-ripple-opacity:var(--cros-button-primary-ripple-opacity)}#iconContainer,#enterpriseIconContainer{-webkit-tap-highlight-color:transparent;border-radius:50%;bottom:0;box-shadow:none;display:inline-block;height:32px;line-height:32px;position:absolute;right:0;text-align:center;vertical-align:middle;width:32px}#iconContainer{align-items:center;background-color:var(--cros-icon-color-prominent);cursor:pointer;display:flex;flex-flow:row nowrap;justify-content:center;z-index:1}#iconContainer>svg{fill:var(--cros-sys-on_primary,var(--cros-button-label-color-primary))}#enterpriseIconContainer{--iron-icon-fill-color:var(--google-grey-800);--iron-icon-height:16px;--iron-icon-width:16px;background-color:var(--cros-sys-on_primary_container)}@media (prefers-color-scheme:dark){#enterpriseIconContainer{--iron-icon-fill-color:var(--google-grey-300)}}#enterpriseIconContainer iron-icon{--iron-icon-fill-color:var(--cros-sys-on_primary);--iron-icon-height:12px;--iron-icon-width:13.33px;text-align:center}#avatar:focus-visible{outline:2px solid var(--cros-focus-ring-color)}</style>
<div id="container">
  <div id="imageContainer"
      class="tast-open-subpage"
      aria-label$="[[getImageContainerAriaLabel_(path, imageIsEnterpriseManaged_)]]">
    <template is="dom-if" if="[[imageUrl_]]">
      <template is="dom-if" if="[[imageIsEnterpriseManaged_]]">
        <img id="avatar" class="managed" src$="[[getAvatarUrl_(imageUrl_.url)]]"
            alt="$i18n{managedSetting}" title="$i18n{managedSetting}">
        <div id="enterpriseIconContainer">
          <iron-icon icon="personalization:managed"
              title="$i18n{managedSetting}">
          </iron-icon>
        </div>
      </template>
      <template is="dom-if"
          if="[[shouldShowMainPageView_(path, imageIsEnterpriseManaged_)]]">
        <div id="iconContainer"
            on-click="onClickUserSubpageLink_"
            on-keypress="onClickUserSubpageLink_">
          <svg width="14" height="14" viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd" clip-rule="evenodd"
                d="M12.928 2.148L11.848 1.068C11.224 0.443998 10.208 0.443998 9.58397 1.068L7.31997 3.324L0.599976 10.052V13.396H3.94398L12.928 4.412C13.56 3.788 13.56 2.772 12.928 2.148ZM2.19998 11.796V10.708L8.45598 4.452L9.58397 5.58L3.32798 11.844L2.19998 11.796Z">
            </path>
          </svg>
        </div>
        <paper-ripple class="circle"></paper-ripple>
        <div id="imageBorderContainer">
          <img
              tabindex="0"
              id="avatar"
              class="clickable"
              src$="[[getAvatarUrl_(imageUrl_.url)]]"
              alt$="[[getImageAlt_(image_)]]"
              role="button"
              on-click="onClickUserSubpageLink_"
              on-keypress="onClickUserSubpageLink_"
              on-error="onImgError_"
              style$="[[getImgBackgroundStyle_(imageUrl_.url)]]">
        </div>
      </template>
      <template is="dom-if"
          if="[[shouldShowSubpageView_(path, imageIsEnterpriseManaged_)]]">
        <img id="avatar2" src$="[[getAvatarUrl_(imageUrl_.url)]]"
            alt$="[[getImageAlt_(image_)]]">
      </template>
    </template>
  </div>
  <div id="infoContainer">
    <template is="dom-if" if="[[info_]]">
      <h1 id="name">[[info_.name]]</h1>
      <template is="dom-if" if="[[info_.email]]">
        <a id="emailContainer"
            class="avatar-link"
            href="chrome://os-settings/osPeople"
            target="_blank"
            aria-description="$i18n{ariaLabelGoToAccountSettings}">
          <span id="email">[[info_.email]]</span>
          <iron-icon icon="cr:open-in-new"></iron-icon>
        </a>
      </template>
    </template>
    <template is="dom-if" if="[[shouldShowDeprecatedImageSourceInfo_(image_)]]">
      <a id="sourceInfo" class="avatar-link" href$="[[getDeprecatedWebsite_(image_)]]"
          target="_blank">
        <span>[[getDeprecatedAuthor_(image_)]]</span>
        <iron-icon icon="cr:open-in-new"></iron-icon>
      </a>
    </template>
  </div>
</div>
<!--_html_template_end_-->`;
}
