import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="wallpaper common cros-button-style">:host{overflow:hidden}#main{display:flex;flex-direction:column;height:100%;overflow:hidden;width:100%}#tabStrip{flex:0 0 auto;margin:4px calc(var(--personalization-app-grid-item-spacing) / 2) calc(var(--personalization-app-grid-item-spacing) / 2);width:100%}#tabStrip cr-button{border:0;border-radius:16px}#tabStrip cr-button+cr-button{margin-inline-start:8px}#tabStrip cr-button[aria-pressed='false']{background-color:unset;color:var(--cros-text-color-secondary)}#tabStrip cr-button[aria-pressed='false']:hover{background-color:var(--cros-sys-hover_on_subtle,var(--cros-button-background-color-secondary-hover))}#albumsContent,#photosByAlbumIdContent,#photosContent,#zeroState{flex:1 1 auto;height:100%;overflow:hidden;width:100%}</style>
<main id="main" aria-label="$i18n{googlePhotosLabel}" tabindex="-1">
  <template is="dom-if" if="[[isTabStripVisible_(albumId, albums_, albumsShared_)]]">
    <div id="tabStrip">
      <cr-button id="photosTab" aria-pressed="[[isPhotosTabSelected_(tab_)]]"
        on-click="onTabSelected_" class="secondary">
        <div class="text">$i18n{googlePhotosPhotosTabLabel}</div>
      </cr-button>
      <cr-button id="albumsTab" aria-pressed="[[isAlbumsTabSelected_(tab_)]]"
        on-click="onTabSelected_" class="secondary">
        <div class="text">$i18n{googlePhotosAlbumsTabLabel}</div>
      </cr-button>
    </div>
  </template>
  <google-photos-photos id="photosContent"
    hidden="[[!isPhotosTabContentVisible_(photos_, tab_)]]">
  </google-photos-photos>
  <template is="dom-if" if="[[!isAlbumsEmpty_(albums_, albumsShared_)]]">
    <google-photos-albums id="albumsContent"
      hidden="[[!isAlbumsTabContentVisible_(tab_)]]">
    </google-photos-albums>
    <google-photos-photos-by-album-id id="photosByAlbumIdContent"
      album-id="[[albumId]]"
      hidden="[[!isPhotosByAlbumIdTabContentVisible_(albumId, photosByAlbumId_, tab_)]]">
    </google-photos-photos-by-album-id>
  </template>
  <template is="dom-if"
    if="[[isZeroStateVisible_(albumId, photos_, photosByAlbumId_, tab_)]]">
    <google-photos-zero-state id="zeroState" tab="[[tab_]]">
    </google-photos-zero-state>
  </template>
</main>
<!--_html_template_end_-->`;
}
