import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="wallpaper common">:host{overflow:hidden}iron-scroll-threshold,iron-list{width:100%}.row{display:flex;flex-direction:column;width:100%}.row:focus-visible{outline:0}.photo-row-info{box-sizing:border-box;color:var(--cros-text-color-secondary);font:var(--cros-button-2-font);margin:0;padding:calc(var(--personalization-app-grid-item-spacing) / 2);width:100%}.location{color:var(--cros-text-color-disabled);font:var(--cros-body-2-font);padding-inline-start:12px}.photos{align-items:center;display:flex;flex-direction:row;justify-content:flex-start;width:100%}
</style>
<iron-scroll-threshold id="gridScrollThreshold"
    on-lower-threshold="onGridScrollThresholdReached_" scroll-target="document">
  <iron-list id="grid" items="[[photosByRow_]]" as="row"
      scroll-target="document"
      aria-setsize$="[[getPhotosAriaSetSize_(photos_, photosByRow_)]]"
      role="listbox">
    <template>
      <div class="row" rowindex$="[[index]]" tabindex$="[[tabIndex]]"
          on-mousedown="onGridRowMouseDown_"
          on-focus="onGridRowFocused_"
          on-keydown="onGridRowKeyDown_">
        <template is="dom-if"
            if="[[isGridRowTitleVisible_(row, photosBySection_)]]">
          <p class="photo-row-info ellipsis">
            <span class="date">[[getGridRowDate_(row, photosBySection_)]]</span>
            <span class="location">
              [[getGridRowLocations_(row, photosBySection_)]]
            </span>
          </p>
        </template>
        <div class="photos">
          <template is="dom-repeat" items="[[row]]" as="photo">
            <div hidden id$="[[getPhotoDescriptionId_(photo)]]">
              <p>[[getPhotoDate_(photo)]]</p>
              <p>[[photo.location]]</p>
            </div>
            <wallpaper-grid-item
                aria-label$="[[getPhotoAriaLabel_(photo)]]"
                aria-describedby$="[[getPhotoDescriptionId_(photo)]]"
                aria-posinset$="[[getPhotoAriaIndex_(photo.index)]]"
                class="photo"
                colindex$="[[index]]"
                disabled="[[isPhotoPlaceholder_(photo)]]"
                index="[[photo.index]]"
                is-google-photos
                on-wallpaper-grid-item-selected="onPhotoSelected_"
                photoindex$="[[photo.index]]"
                role="option"
                selected="[[isPhotoSelected_(photo, currentSelected_, pendingSelected_)]]"
                src="[[photo.url]]"
                tabindex="-1">
            </wallpaper-grid-item>
          </template>
        </div>
      </div>
    </template>
  </iron-list>
</iron-scroll-threshold>
<!--_html_template_end_-->`;
}
