import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="common wallpaper">wallpaper-grid-item[data-is-time-of-day-wallpaper]{--personalization-app-grid-item-border-radius:40px}wallpaper-grid-item[data-is-time-of-day-wallpaper]::part(border){border:unset}wallpaper-grid-item[data-is-time-of-day-wallpaper]::part(item){overflow:unset}wallpaper-grid-item[data-is-time-of-day-wallpaper]::part(icon){left:3px;top:3px}</style>
<main id="main" tabindex="-1"
    aria-label$="[[getMainAriaLabel_(collectionId, collections_)]]">
  <iron-media-query query="(prefers-color-scheme: dark)"
      query-matches="{{isDarkModeActive}}">
  </iron-media-query>
  <template is="dom-if" if="[[tiles_]]">
    <iron-list grid items="[[tiles_]]" role="listbox"
        aria-setsize$="[[tiles_.length]]">
      <template>
        <wallpaper-grid-item
            aria-label$="[[getAriaLabel_(item)]]"
            aria-posinset$="[[getAriaIndex_(index)]]"
            data-is-time-of-day-wallpaper$="[[isTimeOfDayWallpaper_(item)]]"
            disabled="[[isLoadingTile_(item)]]"
            index="[[index]]"
            on-wallpaper-grid-item-selected="onImageSelected_"
            role="option"
            selected="[[isTileSelected_(item, selectedUnitId_, pendingSelectedUnitId_)]]"
            src="[[item.preview]]"
            tabindex$="[[tabIndex]]">
        </wallpaper-grid-item>
      </template>
    </iron-list>
  </template>
  <template is="dom-if" if="[[pendingTimeOfDayWallpaper_]]" restamp>
    <time-of-day-wallpaper-dialog
        on-time-of-day-wallpaper-dialog-accept="onConfirmTimeOfDayDialog_"
        on-cancel="onCloseTimeOfDayDialog_">
    </time-of-day-wallpaper-dialog>
  </template>
</main>
<!--_html_template_end_-->`;
}
