import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="common cros-button-style">#container{display:grid;grid-template-areas:'. label .' '. image .' '. .     .' '. theme .' '. .     .';grid-template-columns:20px minmax(0,1fr) 20px;grid-template-rows:auto auto 16px auto 20px;height:100%}#wallpaperLabel{align-items:center;background:none;border:none;display:flex;flex-flow:row nowrap;grid-area:label;height:44px;justify-content:space-between;margin-top:12px}#wallpaperLabel>cr-icon-button{--cr-icon-button-size:44px;margin-inline-end:-18px}#wallpaperLabel>h2{color:var(--cros-text-color-primary);display:inline-block;font:var(--personalization-app-label-font);margin:12px 0}#imageContainer,#imagePlaceholder{aspect-ratio:340/220;background-color:var(--personalization-app-grid-item-background-color);grid-area:image;justify-self:center;max-width:460px;min-width:278px}::slotted(personalization-theme){grid-area:theme}.photo-images-container{background-color:var(--personalization-app-grid-item-background-color);border-radius:16px;box-sizing:border-box;display:flex;flex-flow:row wrap;height:100%;justify-content:center;overflow:hidden;position:relative;width:100%}.photo-images-container img{flex:1 1 0;height:100%;object-fit:cover;width:100%}iron-icon[icon='personalization:managed']{--iron-icon-height:16px;--iron-icon-width:16px}</style>
<div class="preview-container" id="container">
  <template is="dom-if" if="[[loading_]]">
    <div id="wallpaperLabel">
      <h2>$i18n{wallpaperLabel}</h2>
    </div>
    <div id="imagePlaceholder" class="photo-images-container placeholder"></div>
  </template>
  <template is="dom-if" if="[[!loading_]]">
    <template is="dom-if" if="[[!policyControlled_]]">
      <div id="wallpaperLabel">
        <h2 on-click="onClickWallpaper_" class="clickable">
          $i18n{wallpaperLabel}
        </h2>
        <cr-icon-button iron-icon="cr:chevron-right"
            role="button" on-click="onClickWallpaper_"
            class="tast-open-subpage"
            aria-label="$i18n{ariaLabelChangeWallpaper}">
        </cr-icon-button>
      </div>
      <div id="imageContainer" class="photo-images-container clickable"
          on-click="onClickWallpaper_" on-keypress="onClickWallpaper_">
        <div class="photo-images-border"></div>
        <img alt$="[[getImageAltDescription_(image_, attribution_)]]"
            src$="[[getWallpaperSrc_(image_)]]">
      </div>
    </template>
    <template is="dom-if" if="[[policyControlled_]]">
      <div id="wallpaperLabel" class="disabled">
        <p>$i18n{wallpaperLabel}</p>
        <iron-icon icon="personalization:managed" disabled
            title="$i18n{managedSetting}">
        </iron-icon>
      </div>
      <div id="imageContainer" class="photo-images-container">
        <div class="photo-images-border"></div>
        <img alt$="[[getImageAltDescription_(image_, attribution_)]]"
            aria-description="$i18n{managedSetting}"
            class="disabled"
            src$="[[getWallpaperSrc_(image_)]]">
      </div>
    </template>
  </template>
  <slot></slot>
</div>
<!--_html_template_end_-->`;
}
