import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="wallpaper common cros-button-style">#container{border:none;box-sizing:border-box;display:grid;grid-template-columns:224px 20px minmax(0,1fr);grid-template-rows:1fr 16px 34px 20px;height:100%;margin:0 10px}#container:not(.loading){grid-template-areas:'image . text' 'image . .' 'image . buttons' '.     . .'}#container.loading{grid-template-areas:'image . text' 'image . text' 'image . text' '.     . .'}#imageContainer,#imagePlaceholder{--animation-delay:1s;background-color:var(--personalization-app-grid-item-background-color);grid-area:image}#textContainer,#textPlaceholder{grid-area:text}#buttonContainer{display:flex;flex-flow:row wrap;gap:8px;grid-area:buttons;justify-content:flex-start}#wallpaperOptions .text,#descriptionOptions .text,.collection-options .text{margin-inline-start:8px}iron-icon{--iron-icon-height:20px;--iron-icon-width:20px}cr-button+cr-button{margin-inline-start:8px}#descriptionDialog h3[slot='title'],#descriptionDialog p[slot='body']{margin:0;white-space:pre-wrap}#descriptionDialog h3[slot='title']{color:var(--cros-sys-on_secondary_container);font:var(--cros-title-1-font);padding-top:24px}#descriptionDialog p[slot='body']{color:var(--cros-sys-secondary);font:var(--cros-body-1-font)}#descriptionDialog div[slot='button-container']{height:36px;padding:8px 20px 20px 20px}#descriptionDialogLearnMore{align-self:center;margin-inline-end:auto}#descriptionDialog div[slot='button-container'] cr-button{border-radius:18px;font:var(--cros-button-2-font);height:100%}info-svg::part(path){fill:var(--text-color)}</style>
<header id="container" class$="[[getContainerClass_(isLoading_, showImage_)]]">
  <template is="dom-if" if="[[showPlaceholders_(isLoading_, showImage_)]]">
    <div id="imagePlaceholder" class="placeholder"></div>
    <div id="textPlaceholder" class="preview-text-placeholder">
      <div class="placeholder"></div>
      <div class="placeholder"></div>
      <div class="placeholder"></div>
    </div>
  </template>
  <template is="dom-if" if="[[showImage_]]">
    <div id="imageContainer" class="preview-image-container">
      <div class="preview-image-border"></div>
      <img aria-hidden="true"
          class="preview-image"
          src$="[[getWallpaperSrc_(image_)]]">
    </div>
    <h2 id="textContainer" class="preview-text-container" aria-live="polite"
        aria-label$="[[getAriaLabel_(image_, attribution_, dailyRefreshState_)]]">
      <span id="currentlySet" aria-hidden="true">$i18n{currentlySet}</span>
      <span id="imageTitle" title$="[[imageTitle_]]" aria-hidden="true">
        [[imageTitle_]]
      </span>
      <dom-repeat items="[[imageOtherAttribution_]]">
        <template>
          <span title$="[[item]]" aria-hidden="true">[[item]]</span>
        </template>
      </dom-repeat>
    </h2>
    <div id="buttonContainer">
      <template is="dom-if" if="[[showLayoutOptions_]]">
        <div id="wallpaperOptions">
          <cr-button id="fill" data-layout="FILL" on-click="onClickLayoutIcon_"
              class="secondary"
              aria-pressed$="[[getFillAriaPressed_(image_)]]">
            <iron-icon icon="[[fillIcon_]]"></iron-icon>
            <div class="text">$i18n{fill}</div>
          </cr-button>
          <cr-button id="center" data-layout="CENTER"
              on-click="onClickLayoutIcon_"
              class="secondary"
              aria-pressed$="[[getCenterAriaPressed_(image_)]]">
            <iron-icon icon="[[centerIcon_]]"></iron-icon>
            <div class="text">$i18n{center}</div>
          </cr-button>
        </div>
      </template>
      <template is="dom-if" if="[[showDailyRefreshButton_]]">
        <div class="collection-options">
          <cr-button id="dailyRefresh" class="secondary"
              aria-label="$i18n{ariaLabelChangeDaily}"
              aria-pressed$="[[ariaPressed_]]"
              on-click="onClickDailyRefreshToggle_">
            <iron-icon icon="[[dailyRefreshIcon_]]"></iron-icon>
            <div class="text">$i18n{changeDaily}</div>
          </cr-button>
        </div>
      </template>
      <template is="dom-if" if="[[showRefreshButton_]]">
        <div class="collection-options">
          <cr-button id="refreshWallpaper" class="secondary"
              aria-label="$i18n{ariaLabelRefresh}"
              on-click="onClickUpdateDailyRefreshWallpaper_">
            <iron-icon icon="personalization-shared:refresh"></iron-icon>
            <div class="text">$i18n{refresh}</div>
          </cr-button>
        </div>
      </template>
      <template is="dom-if" if="[[showDescriptionButton_]]" restamp>
        <div id="descriptionOptions">
          <cr-button on-click="onClickShowDescription_">
            <info-svg></info-svg>
            <div class="text">$i18n{descriptionDialogOpen}</div>
          </cr-button>
        </div>
      </template>
    </div>
    <template
        is="dom-if"
        if="[[showDailyRefreshConfirmationDialog_]]"
        restamp>
      <google-photos-shared-album-dialog
          on-shared-album-dialog-accept="onAcceptDailyRefreshDialog_"
          on-cancel="closeDailyRefreshConfirmationDialog_">
      </google-photos-shared-album-dialog>
    </template>
    <template is="dom-if" if="[[showDescriptionDialog_]]" restamp>
      <cr-dialog aria-description-text="[[image_.descriptionContent]]"
          id="descriptionDialog"
          on-close="closeDescriptionDialog_"
          show-on-attach>
        <h3 slot="title" id="descriptionDialogTitle">[[image_.descriptionTitle]]</h3>
        <p slot="body" id="descriptionDialogBody">[[image_.descriptionContent]]</p>
        <div slot="button-container">
          <template is="dom-if" if="[[actionUrl_]]" restamp>
            <div id="descriptionDialogLearnMore">
              <a aria-describedby="descriptionDialogTitle"
                  aria-label="$i18n{descriptionDialogLearnMoreAriaLabel}"
                  href$="[[actionUrl_]]"
                  target="_blank">
                $i18n{descriptionDialogLearnMore}
              </a>
            </div>
          </template>
          <cr-button class="primary action-button" id="dialogCloseButton"
              on-click="closeDescriptionDialog_">
            $i18n{descriptionDialogClose}
          </cr-button>
        </div>
      </cr-dialog>
    </template>
  </template>
</header>
<!--_html_template_end_-->`;
}
