// ash/webui/personalization_app/mojom/personalization_app.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { ColorSchemeSpec as ash_style_mojom_ColorSchemeSpec } from './color_scheme.mojom-webui.js';
import { BigBufferSpec as mojoBase_mojom_BigBufferSpec } from '//resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js';
import { FilePathSpec as mojoBase_mojom_FilePathSpec } from '//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js';
import { String16Spec as mojoBase_mojom_String16Spec } from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import { TimeSpec as mojoBase_mojom_TimeSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { SkColorSpec as skia_mojom_SkColorSpec } from '//resources/mojo/skia/public/mojom/skcolor.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const STATIC_COLOR_GOOGLE_BLUE = 0x4285F4;
export const STATIC_COLOR_LIGHT_PINK = 0xFFD6D6;
export const STATIC_COLOR_DARK_GREEN = 0x485045;
export const STATIC_COLOR_LIGHT_PURPLE = 0xCBBFFF;
export const WHITE_COLOR = 0xFFFFFF;
export const RED_COLOR = 0xEE675C;
export const YELLOW_COLOR = 0xFBBC04;
export const GREEN_COLOR = 0x34A853;
export const BLUE_COLOR = 0x00A3C2;
export const INDIGO_COLOR = 0x4285F4;
export const PURPLE_COLOR = 0xB76DF8;
export const WallpaperLayoutSpec = { $: mojo.internal.Enum() };
export var WallpaperLayout;
(function (WallpaperLayout) {
    WallpaperLayout[WallpaperLayout["MIN_VALUE"] = 0] = "MIN_VALUE";
    WallpaperLayout[WallpaperLayout["MAX_VALUE"] = 3] = "MAX_VALUE";
    WallpaperLayout[WallpaperLayout["kCenter"] = 0] = "kCenter";
    WallpaperLayout[WallpaperLayout["kCenterCropped"] = 1] = "kCenterCropped";
    WallpaperLayout[WallpaperLayout["kStretch"] = 2] = "kStretch";
    WallpaperLayout[WallpaperLayout["kTile"] = 3] = "kTile";
})(WallpaperLayout || (WallpaperLayout = {}));
export const WallpaperTypeSpec = { $: mojo.internal.Enum() };
export var WallpaperType;
(function (WallpaperType) {
    WallpaperType[WallpaperType["MIN_VALUE"] = 0] = "MIN_VALUE";
    WallpaperType[WallpaperType["MAX_VALUE"] = 13] = "MAX_VALUE";
    WallpaperType[WallpaperType["kDaily"] = 0] = "kDaily";
    WallpaperType[WallpaperType["kCustomized"] = 1] = "kCustomized";
    WallpaperType[WallpaperType["kDefault"] = 2] = "kDefault";
    WallpaperType[WallpaperType["kOnline"] = 4] = "kOnline";
    WallpaperType[WallpaperType["kPolicy"] = 5] = "kPolicy";
    WallpaperType[WallpaperType["kThirdParty"] = 6] = "kThirdParty";
    WallpaperType[WallpaperType["kDevice"] = 7] = "kDevice";
    WallpaperType[WallpaperType["kOneShot"] = 8] = "kOneShot";
    WallpaperType[WallpaperType["kDailyGooglePhotos"] = 10] = "kDailyGooglePhotos";
    WallpaperType[WallpaperType["kOnceGooglePhotos"] = 11] = "kOnceGooglePhotos";
    WallpaperType[WallpaperType["kOobe"] = 12] = "kOobe";
    WallpaperType[WallpaperType["kSeaPen"] = 13] = "kSeaPen";
})(WallpaperType || (WallpaperType = {}));
export const OnlineImageTypeSpec = { $: mojo.internal.Enum() };
export var OnlineImageType;
(function (OnlineImageType) {
    OnlineImageType[OnlineImageType["MIN_VALUE"] = 0] = "MIN_VALUE";
    OnlineImageType[OnlineImageType["MAX_VALUE"] = 5] = "MAX_VALUE";
    OnlineImageType[OnlineImageType["kUnknown"] = 0] = "kUnknown";
    OnlineImageType[OnlineImageType["kLight"] = 1] = "kLight";
    OnlineImageType[OnlineImageType["kDark"] = 2] = "kDark";
    OnlineImageType[OnlineImageType["kPreview"] = 3] = "kPreview";
    OnlineImageType[OnlineImageType["kMorning"] = 4] = "kMorning";
    OnlineImageType[OnlineImageType["kLateAfternoon"] = 5] = "kLateAfternoon";
})(OnlineImageType || (OnlineImageType = {}));
export const GooglePhotosEnablementStateSpec = { $: mojo.internal.Enum() };
export var GooglePhotosEnablementState;
(function (GooglePhotosEnablementState) {
    GooglePhotosEnablementState[GooglePhotosEnablementState["MIN_VALUE"] = 0] = "MIN_VALUE";
    GooglePhotosEnablementState[GooglePhotosEnablementState["MAX_VALUE"] = 2] = "MAX_VALUE";
    GooglePhotosEnablementState[GooglePhotosEnablementState["kError"] = 0] = "kError";
    GooglePhotosEnablementState[GooglePhotosEnablementState["kDisabled"] = 1] = "kDisabled";
    GooglePhotosEnablementState[GooglePhotosEnablementState["kEnabled"] = 2] = "kEnabled";
})(GooglePhotosEnablementState || (GooglePhotosEnablementState = {}));
export const StaticColorSpec = { $: mojo.internal.Enum() };
export var StaticColor;
(function (StaticColor) {
    StaticColor[StaticColor["MIN_VALUE"] = 0] = "MIN_VALUE";
    StaticColor[StaticColor["MAX_VALUE"] = 4] = "MAX_VALUE";
    StaticColor[StaticColor["kUnknown"] = 0] = "kUnknown";
    StaticColor[StaticColor["kGoogleBlue"] = 1] = "kGoogleBlue";
    StaticColor[StaticColor["kLightPink"] = 2] = "kLightPink";
    StaticColor[StaticColor["kDarkGreen"] = 3] = "kDarkGreen";
    StaticColor[StaticColor["kLightPurple"] = 4] = "kLightPurple";
})(StaticColor || (StaticColor = {}));
export const AmbientThemeSpec = { $: mojo.internal.Enum() };
export var AmbientTheme;
(function (AmbientTheme) {
    AmbientTheme[AmbientTheme["MIN_VALUE"] = 0] = "MIN_VALUE";
    AmbientTheme[AmbientTheme["MAX_VALUE"] = 3] = "MAX_VALUE";
    AmbientTheme[AmbientTheme["kSlideshow"] = 0] = "kSlideshow";
    AmbientTheme[AmbientTheme["kFeelTheBreeze"] = 1] = "kFeelTheBreeze";
    AmbientTheme[AmbientTheme["kFloatOnBy"] = 2] = "kFloatOnBy";
    AmbientTheme[AmbientTheme["kVideo"] = 3] = "kVideo";
})(AmbientTheme || (AmbientTheme = {}));
export const TopicSourceSpec = { $: mojo.internal.Enum() };
export var TopicSource;
(function (TopicSource) {
    TopicSource[TopicSource["MIN_VALUE"] = 0] = "MIN_VALUE";
    TopicSource[TopicSource["MAX_VALUE"] = 2] = "MAX_VALUE";
    TopicSource[TopicSource["kGooglePhotos"] = 0] = "kGooglePhotos";
    TopicSource[TopicSource["kArtGallery"] = 1] = "kArtGallery";
    TopicSource[TopicSource["kVideo"] = 2] = "kVideo";
})(TopicSource || (TopicSource = {}));
export const TemperatureUnitSpec = { $: mojo.internal.Enum() };
export var TemperatureUnit;
(function (TemperatureUnit) {
    TemperatureUnit[TemperatureUnit["MIN_VALUE"] = 0] = "MIN_VALUE";
    TemperatureUnit[TemperatureUnit["MAX_VALUE"] = 1] = "MAX_VALUE";
    TemperatureUnit[TemperatureUnit["kFahrenheit"] = 0] = "kFahrenheit";
    TemperatureUnit[TemperatureUnit["kCelsius"] = 1] = "kCelsius";
})(TemperatureUnit || (TemperatureUnit = {}));
export const AmbientUiVisibilitySpec = { $: mojo.internal.Enum() };
export var AmbientUiVisibility;
(function (AmbientUiVisibility) {
    AmbientUiVisibility[AmbientUiVisibility["MIN_VALUE"] = 0] = "MIN_VALUE";
    AmbientUiVisibility[AmbientUiVisibility["MAX_VALUE"] = 3] = "MAX_VALUE";
    AmbientUiVisibility[AmbientUiVisibility["kShouldShow"] = 0] = "kShouldShow";
    AmbientUiVisibility[AmbientUiVisibility["kPreview"] = 1] = "kPreview";
    AmbientUiVisibility[AmbientUiVisibility["kHidden"] = 2] = "kHidden";
    AmbientUiVisibility[AmbientUiVisibility["kClosed"] = 3] = "kClosed";
})(AmbientUiVisibility || (AmbientUiVisibility = {}));
export const BacklightColorSpec = { $: mojo.internal.Enum() };
export var BacklightColor;
(function (BacklightColor) {
    BacklightColor[BacklightColor["MIN_VALUE"] = 0] = "MIN_VALUE";
    BacklightColor[BacklightColor["MAX_VALUE"] = 100] = "MAX_VALUE";
    BacklightColor[BacklightColor["kWallpaper"] = 0] = "kWallpaper";
    BacklightColor[BacklightColor["kWhite"] = 1] = "kWhite";
    BacklightColor[BacklightColor["kRed"] = 2] = "kRed";
    BacklightColor[BacklightColor["kYellow"] = 3] = "kYellow";
    BacklightColor[BacklightColor["kGreen"] = 4] = "kGreen";
    BacklightColor[BacklightColor["kBlue"] = 5] = "kBlue";
    BacklightColor[BacklightColor["kIndigo"] = 6] = "kIndigo";
    BacklightColor[BacklightColor["kPurple"] = 7] = "kPurple";
    BacklightColor[BacklightColor["kRainbow"] = 100] = "kRainbow";
})(BacklightColor || (BacklightColor = {}));
export class WallpaperObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.WallpaperObserver', scope);
    }
}
export class WallpaperObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(WallpaperObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onWallpaperPreviewEnded() {
        this.proxy.sendMessage(0, WallpaperObserver_OnWallpaperPreviewEnded_ParamsSpec.$, null, [], false);
    }
    onAttributionChanged(attribution) {
        this.proxy.sendMessage(1, WallpaperObserver_OnAttributionChanged_ParamsSpec.$, null, [
            attribution
        ], false);
    }
    onWallpaperChanged(image) {
        this.proxy.sendMessage(2, WallpaperObserver_OnWallpaperChanged_ParamsSpec.$, null, [
            image
        ], false);
    }
}
;
/**
 * An object which receives request messages for the WallpaperObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WallpaperObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WallpaperObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, WallpaperObserver_OnWallpaperPreviewEnded_ParamsSpec.$, null, impl.onWallpaperPreviewEnded.bind(impl), false);
        this.helper_internal_.registerHandler(1, WallpaperObserver_OnAttributionChanged_ParamsSpec.$, null, impl.onAttributionChanged.bind(impl), false);
        this.helper_internal_.registerHandler(2, WallpaperObserver_OnWallpaperChanged_ParamsSpec.$, null, impl.onWallpaperChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class WallpaperObserver {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.WallpaperObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new WallpaperObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the WallpaperObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WallpaperObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WallpaperObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onWallpaperPreviewEnded =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, WallpaperObserver_OnWallpaperPreviewEnded_ParamsSpec.$, null, this.onWallpaperPreviewEnded.createReceiverHandler(false /* expectsResponse */), false);
        this.onAttributionChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, WallpaperObserver_OnAttributionChanged_ParamsSpec.$, null, this.onAttributionChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onWallpaperChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, WallpaperObserver_OnWallpaperChanged_ParamsSpec.$, null, this.onWallpaperChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class WallpaperProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.WallpaperProvider', scope);
    }
}
export class WallpaperProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(WallpaperProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    makeTransparent() {
        this.proxy.sendMessage(0, WallpaperProvider_MakeTransparent_ParamsSpec.$, null, [], false);
    }
    makeOpaque() {
        this.proxy.sendMessage(1, WallpaperProvider_MakeOpaque_ParamsSpec.$, null, [], false);
    }
    fetchCollections() {
        return this.proxy.sendMessage(2, WallpaperProvider_FetchCollections_ParamsSpec.$, WallpaperProvider_FetchCollections_ResponseParamsSpec.$, [], false);
    }
    fetchImagesForCollection(collectionId) {
        return this.proxy.sendMessage(3, WallpaperProvider_FetchImagesForCollection_ParamsSpec.$, WallpaperProvider_FetchImagesForCollection_ResponseParamsSpec.$, [
            collectionId
        ], false);
    }
    fetchGooglePhotosAlbums(resumeToken) {
        return this.proxy.sendMessage(4, WallpaperProvider_FetchGooglePhotosAlbums_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosAlbums_ResponseParamsSpec.$, [
            resumeToken
        ], false);
    }
    fetchGooglePhotosSharedAlbums(resumeToken) {
        return this.proxy.sendMessage(5, WallpaperProvider_FetchGooglePhotosSharedAlbums_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosSharedAlbums_ResponseParamsSpec.$, [
            resumeToken
        ], false);
    }
    fetchGooglePhotosEnabled() {
        return this.proxy.sendMessage(6, WallpaperProvider_FetchGooglePhotosEnabled_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosEnabled_ResponseParamsSpec.$, [], false);
    }
    fetchGooglePhotosPhotos(itemId, albumId, resumeToken) {
        return this.proxy.sendMessage(7, WallpaperProvider_FetchGooglePhotosPhotos_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosPhotos_ResponseParamsSpec.$, [
            itemId,
            albumId,
            resumeToken
        ], false);
    }
    getLocalImages() {
        return this.proxy.sendMessage(8, WallpaperProvider_GetLocalImages_ParamsSpec.$, WallpaperProvider_GetLocalImages_ResponseParamsSpec.$, [], false);
    }
    getDefaultImageThumbnail() {
        return this.proxy.sendMessage(9, WallpaperProvider_GetDefaultImageThumbnail_ParamsSpec.$, WallpaperProvider_GetDefaultImageThumbnail_ResponseParamsSpec.$, [], false);
    }
    getLocalImageThumbnail(filePath) {
        return this.proxy.sendMessage(10, WallpaperProvider_GetLocalImageThumbnail_ParamsSpec.$, WallpaperProvider_GetLocalImageThumbnail_ResponseParamsSpec.$, [
            filePath
        ], false);
    }
    setWallpaperObserver(observer) {
        this.proxy.sendMessage(11, WallpaperProvider_SetWallpaperObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    selectWallpaper(unitId, previewMode) {
        return this.proxy.sendMessage(12, WallpaperProvider_SelectWallpaper_ParamsSpec.$, WallpaperProvider_SelectWallpaper_ResponseParamsSpec.$, [
            unitId,
            previewMode
        ], false);
    }
    selectDefaultImage() {
        return this.proxy.sendMessage(13, WallpaperProvider_SelectDefaultImage_ParamsSpec.$, WallpaperProvider_SelectDefaultImage_ResponseParamsSpec.$, [], false);
    }
    selectLocalImage(path, layout, previewMode) {
        return this.proxy.sendMessage(14, WallpaperProvider_SelectLocalImage_ParamsSpec.$, WallpaperProvider_SelectLocalImage_ResponseParamsSpec.$, [
            path,
            layout,
            previewMode
        ], false);
    }
    selectGooglePhotosPhoto(id, layout, previewMode) {
        return this.proxy.sendMessage(15, WallpaperProvider_SelectGooglePhotosPhoto_ParamsSpec.$, WallpaperProvider_SelectGooglePhotosPhoto_ResponseParamsSpec.$, [
            id,
            layout,
            previewMode
        ], false);
    }
    selectGooglePhotosAlbum(id) {
        return this.proxy.sendMessage(16, WallpaperProvider_SelectGooglePhotosAlbum_ParamsSpec.$, WallpaperProvider_SelectGooglePhotosAlbum_ResponseParamsSpec.$, [
            id
        ], false);
    }
    getGooglePhotosDailyRefreshAlbumId() {
        return this.proxy.sendMessage(17, WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ParamsSpec.$, WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ResponseParamsSpec.$, [], false);
    }
    setCurrentWallpaperLayout(layout) {
        this.proxy.sendMessage(18, WallpaperProvider_SetCurrentWallpaperLayout_ParamsSpec.$, null, [
            layout
        ], false);
    }
    setDailyRefreshCollectionId(collectionId) {
        return this.proxy.sendMessage(19, WallpaperProvider_SetDailyRefreshCollectionId_ParamsSpec.$, WallpaperProvider_SetDailyRefreshCollectionId_ResponseParamsSpec.$, [
            collectionId
        ], false);
    }
    getDailyRefreshCollectionId() {
        return this.proxy.sendMessage(20, WallpaperProvider_GetDailyRefreshCollectionId_ParamsSpec.$, WallpaperProvider_GetDailyRefreshCollectionId_ResponseParamsSpec.$, [], false);
    }
    updateDailyRefreshWallpaper() {
        return this.proxy.sendMessage(21, WallpaperProvider_UpdateDailyRefreshWallpaper_ParamsSpec.$, WallpaperProvider_UpdateDailyRefreshWallpaper_ResponseParamsSpec.$, [], false);
    }
    isInTabletMode() {
        return this.proxy.sendMessage(22, WallpaperProvider_IsInTabletMode_ParamsSpec.$, WallpaperProvider_IsInTabletMode_ResponseParamsSpec.$, [], false);
    }
    confirmPreviewWallpaper() {
        this.proxy.sendMessage(23, WallpaperProvider_ConfirmPreviewWallpaper_ParamsSpec.$, null, [], false);
    }
    cancelPreviewWallpaper() {
        this.proxy.sendMessage(24, WallpaperProvider_CancelPreviewWallpaper_ParamsSpec.$, null, [], false);
    }
    shouldShowTimeOfDayWallpaperDialog() {
        return this.proxy.sendMessage(25, WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ParamsSpec.$, WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the WallpaperProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WallpaperProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WallpaperProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, WallpaperProvider_MakeTransparent_ParamsSpec.$, null, impl.makeTransparent.bind(impl), false);
        this.helper_internal_.registerHandler(1, WallpaperProvider_MakeOpaque_ParamsSpec.$, null, impl.makeOpaque.bind(impl), false);
        this.helper_internal_.registerHandler(2, WallpaperProvider_FetchCollections_ParamsSpec.$, WallpaperProvider_FetchCollections_ResponseParamsSpec.$, impl.fetchCollections.bind(impl), false);
        this.helper_internal_.registerHandler(3, WallpaperProvider_FetchImagesForCollection_ParamsSpec.$, WallpaperProvider_FetchImagesForCollection_ResponseParamsSpec.$, impl.fetchImagesForCollection.bind(impl), false);
        this.helper_internal_.registerHandler(4, WallpaperProvider_FetchGooglePhotosAlbums_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosAlbums_ResponseParamsSpec.$, impl.fetchGooglePhotosAlbums.bind(impl), false);
        this.helper_internal_.registerHandler(5, WallpaperProvider_FetchGooglePhotosSharedAlbums_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosSharedAlbums_ResponseParamsSpec.$, impl.fetchGooglePhotosSharedAlbums.bind(impl), false);
        this.helper_internal_.registerHandler(6, WallpaperProvider_FetchGooglePhotosEnabled_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosEnabled_ResponseParamsSpec.$, impl.fetchGooglePhotosEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(7, WallpaperProvider_FetchGooglePhotosPhotos_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosPhotos_ResponseParamsSpec.$, impl.fetchGooglePhotosPhotos.bind(impl), false);
        this.helper_internal_.registerHandler(8, WallpaperProvider_GetLocalImages_ParamsSpec.$, WallpaperProvider_GetLocalImages_ResponseParamsSpec.$, impl.getLocalImages.bind(impl), false);
        this.helper_internal_.registerHandler(9, WallpaperProvider_GetDefaultImageThumbnail_ParamsSpec.$, WallpaperProvider_GetDefaultImageThumbnail_ResponseParamsSpec.$, impl.getDefaultImageThumbnail.bind(impl), false);
        this.helper_internal_.registerHandler(10, WallpaperProvider_GetLocalImageThumbnail_ParamsSpec.$, WallpaperProvider_GetLocalImageThumbnail_ResponseParamsSpec.$, impl.getLocalImageThumbnail.bind(impl), false);
        this.helper_internal_.registerHandler(11, WallpaperProvider_SetWallpaperObserver_ParamsSpec.$, null, impl.setWallpaperObserver.bind(impl), false);
        this.helper_internal_.registerHandler(12, WallpaperProvider_SelectWallpaper_ParamsSpec.$, WallpaperProvider_SelectWallpaper_ResponseParamsSpec.$, impl.selectWallpaper.bind(impl), false);
        this.helper_internal_.registerHandler(13, WallpaperProvider_SelectDefaultImage_ParamsSpec.$, WallpaperProvider_SelectDefaultImage_ResponseParamsSpec.$, impl.selectDefaultImage.bind(impl), false);
        this.helper_internal_.registerHandler(14, WallpaperProvider_SelectLocalImage_ParamsSpec.$, WallpaperProvider_SelectLocalImage_ResponseParamsSpec.$, impl.selectLocalImage.bind(impl), false);
        this.helper_internal_.registerHandler(15, WallpaperProvider_SelectGooglePhotosPhoto_ParamsSpec.$, WallpaperProvider_SelectGooglePhotosPhoto_ResponseParamsSpec.$, impl.selectGooglePhotosPhoto.bind(impl), false);
        this.helper_internal_.registerHandler(16, WallpaperProvider_SelectGooglePhotosAlbum_ParamsSpec.$, WallpaperProvider_SelectGooglePhotosAlbum_ResponseParamsSpec.$, impl.selectGooglePhotosAlbum.bind(impl), false);
        this.helper_internal_.registerHandler(17, WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ParamsSpec.$, WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ResponseParamsSpec.$, impl.getGooglePhotosDailyRefreshAlbumId.bind(impl), false);
        this.helper_internal_.registerHandler(18, WallpaperProvider_SetCurrentWallpaperLayout_ParamsSpec.$, null, impl.setCurrentWallpaperLayout.bind(impl), false);
        this.helper_internal_.registerHandler(19, WallpaperProvider_SetDailyRefreshCollectionId_ParamsSpec.$, WallpaperProvider_SetDailyRefreshCollectionId_ResponseParamsSpec.$, impl.setDailyRefreshCollectionId.bind(impl), false);
        this.helper_internal_.registerHandler(20, WallpaperProvider_GetDailyRefreshCollectionId_ParamsSpec.$, WallpaperProvider_GetDailyRefreshCollectionId_ResponseParamsSpec.$, impl.getDailyRefreshCollectionId.bind(impl), false);
        this.helper_internal_.registerHandler(21, WallpaperProvider_UpdateDailyRefreshWallpaper_ParamsSpec.$, WallpaperProvider_UpdateDailyRefreshWallpaper_ResponseParamsSpec.$, impl.updateDailyRefreshWallpaper.bind(impl), false);
        this.helper_internal_.registerHandler(22, WallpaperProvider_IsInTabletMode_ParamsSpec.$, WallpaperProvider_IsInTabletMode_ResponseParamsSpec.$, impl.isInTabletMode.bind(impl), false);
        this.helper_internal_.registerHandler(23, WallpaperProvider_ConfirmPreviewWallpaper_ParamsSpec.$, null, impl.confirmPreviewWallpaper.bind(impl), false);
        this.helper_internal_.registerHandler(24, WallpaperProvider_CancelPreviewWallpaper_ParamsSpec.$, null, impl.cancelPreviewWallpaper.bind(impl), false);
        this.helper_internal_.registerHandler(25, WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ParamsSpec.$, WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ResponseParamsSpec.$, impl.shouldShowTimeOfDayWallpaperDialog.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class WallpaperProvider {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.WallpaperProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new WallpaperProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the WallpaperProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WallpaperProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WallpaperProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.makeTransparent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, WallpaperProvider_MakeTransparent_ParamsSpec.$, null, this.makeTransparent.createReceiverHandler(false /* expectsResponse */), false);
        this.makeOpaque =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, WallpaperProvider_MakeOpaque_ParamsSpec.$, null, this.makeOpaque.createReceiverHandler(false /* expectsResponse */), false);
        this.fetchCollections =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, WallpaperProvider_FetchCollections_ParamsSpec.$, WallpaperProvider_FetchCollections_ResponseParamsSpec.$, this.fetchCollections.createReceiverHandler(true /* expectsResponse */), false);
        this.fetchImagesForCollection =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, WallpaperProvider_FetchImagesForCollection_ParamsSpec.$, WallpaperProvider_FetchImagesForCollection_ResponseParamsSpec.$, this.fetchImagesForCollection.createReceiverHandler(true /* expectsResponse */), false);
        this.fetchGooglePhotosAlbums =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, WallpaperProvider_FetchGooglePhotosAlbums_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosAlbums_ResponseParamsSpec.$, this.fetchGooglePhotosAlbums.createReceiverHandler(true /* expectsResponse */), false);
        this.fetchGooglePhotosSharedAlbums =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, WallpaperProvider_FetchGooglePhotosSharedAlbums_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosSharedAlbums_ResponseParamsSpec.$, this.fetchGooglePhotosSharedAlbums.createReceiverHandler(true /* expectsResponse */), false);
        this.fetchGooglePhotosEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, WallpaperProvider_FetchGooglePhotosEnabled_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosEnabled_ResponseParamsSpec.$, this.fetchGooglePhotosEnabled.createReceiverHandler(true /* expectsResponse */), false);
        this.fetchGooglePhotosPhotos =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, WallpaperProvider_FetchGooglePhotosPhotos_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosPhotos_ResponseParamsSpec.$, this.fetchGooglePhotosPhotos.createReceiverHandler(true /* expectsResponse */), false);
        this.getLocalImages =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, WallpaperProvider_GetLocalImages_ParamsSpec.$, WallpaperProvider_GetLocalImages_ResponseParamsSpec.$, this.getLocalImages.createReceiverHandler(true /* expectsResponse */), false);
        this.getDefaultImageThumbnail =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, WallpaperProvider_GetDefaultImageThumbnail_ParamsSpec.$, WallpaperProvider_GetDefaultImageThumbnail_ResponseParamsSpec.$, this.getDefaultImageThumbnail.createReceiverHandler(true /* expectsResponse */), false);
        this.getLocalImageThumbnail =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, WallpaperProvider_GetLocalImageThumbnail_ParamsSpec.$, WallpaperProvider_GetLocalImageThumbnail_ResponseParamsSpec.$, this.getLocalImageThumbnail.createReceiverHandler(true /* expectsResponse */), false);
        this.setWallpaperObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, WallpaperProvider_SetWallpaperObserver_ParamsSpec.$, null, this.setWallpaperObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.selectWallpaper =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, WallpaperProvider_SelectWallpaper_ParamsSpec.$, WallpaperProvider_SelectWallpaper_ResponseParamsSpec.$, this.selectWallpaper.createReceiverHandler(true /* expectsResponse */), false);
        this.selectDefaultImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, WallpaperProvider_SelectDefaultImage_ParamsSpec.$, WallpaperProvider_SelectDefaultImage_ResponseParamsSpec.$, this.selectDefaultImage.createReceiverHandler(true /* expectsResponse */), false);
        this.selectLocalImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, WallpaperProvider_SelectLocalImage_ParamsSpec.$, WallpaperProvider_SelectLocalImage_ResponseParamsSpec.$, this.selectLocalImage.createReceiverHandler(true /* expectsResponse */), false);
        this.selectGooglePhotosPhoto =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, WallpaperProvider_SelectGooglePhotosPhoto_ParamsSpec.$, WallpaperProvider_SelectGooglePhotosPhoto_ResponseParamsSpec.$, this.selectGooglePhotosPhoto.createReceiverHandler(true /* expectsResponse */), false);
        this.selectGooglePhotosAlbum =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, WallpaperProvider_SelectGooglePhotosAlbum_ParamsSpec.$, WallpaperProvider_SelectGooglePhotosAlbum_ResponseParamsSpec.$, this.selectGooglePhotosAlbum.createReceiverHandler(true /* expectsResponse */), false);
        this.getGooglePhotosDailyRefreshAlbumId =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(17, WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ParamsSpec.$, WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ResponseParamsSpec.$, this.getGooglePhotosDailyRefreshAlbumId.createReceiverHandler(true /* expectsResponse */), false);
        this.setCurrentWallpaperLayout =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(18, WallpaperProvider_SetCurrentWallpaperLayout_ParamsSpec.$, null, this.setCurrentWallpaperLayout.createReceiverHandler(false /* expectsResponse */), false);
        this.setDailyRefreshCollectionId =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(19, WallpaperProvider_SetDailyRefreshCollectionId_ParamsSpec.$, WallpaperProvider_SetDailyRefreshCollectionId_ResponseParamsSpec.$, this.setDailyRefreshCollectionId.createReceiverHandler(true /* expectsResponse */), false);
        this.getDailyRefreshCollectionId =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(20, WallpaperProvider_GetDailyRefreshCollectionId_ParamsSpec.$, WallpaperProvider_GetDailyRefreshCollectionId_ResponseParamsSpec.$, this.getDailyRefreshCollectionId.createReceiverHandler(true /* expectsResponse */), false);
        this.updateDailyRefreshWallpaper =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(21, WallpaperProvider_UpdateDailyRefreshWallpaper_ParamsSpec.$, WallpaperProvider_UpdateDailyRefreshWallpaper_ResponseParamsSpec.$, this.updateDailyRefreshWallpaper.createReceiverHandler(true /* expectsResponse */), false);
        this.isInTabletMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(22, WallpaperProvider_IsInTabletMode_ParamsSpec.$, WallpaperProvider_IsInTabletMode_ResponseParamsSpec.$, this.isInTabletMode.createReceiverHandler(true /* expectsResponse */), false);
        this.confirmPreviewWallpaper =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(23, WallpaperProvider_ConfirmPreviewWallpaper_ParamsSpec.$, null, this.confirmPreviewWallpaper.createReceiverHandler(false /* expectsResponse */), false);
        this.cancelPreviewWallpaper =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(24, WallpaperProvider_CancelPreviewWallpaper_ParamsSpec.$, null, this.cancelPreviewWallpaper.createReceiverHandler(false /* expectsResponse */), false);
        this.shouldShowTimeOfDayWallpaperDialog =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(25, WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ParamsSpec.$, WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ResponseParamsSpec.$, this.shouldShowTimeOfDayWallpaperDialog.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ThemeObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.ThemeObserver', scope);
    }
}
export class ThemeObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ThemeObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onColorModeChanged(darkModeEnabled) {
        this.proxy.sendMessage(0, ThemeObserver_OnColorModeChanged_ParamsSpec.$, null, [
            darkModeEnabled
        ], false);
    }
    onColorModeAutoScheduleChanged(enabled) {
        this.proxy.sendMessage(1, ThemeObserver_OnColorModeAutoScheduleChanged_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    onColorSchemeChanged(colorScheme) {
        this.proxy.sendMessage(2, ThemeObserver_OnColorSchemeChanged_ParamsSpec.$, null, [
            colorScheme
        ], false);
    }
    onSampleColorSchemesChanged(sampleColorSchemes) {
        this.proxy.sendMessage(3, ThemeObserver_OnSampleColorSchemesChanged_ParamsSpec.$, null, [
            sampleColorSchemes
        ], false);
    }
    onStaticColorChanged(color) {
        this.proxy.sendMessage(4, ThemeObserver_OnStaticColorChanged_ParamsSpec.$, null, [
            color
        ], false);
    }
    onGeolocationPermissionForSystemServicesChanged(enabled, isUserModifiable) {
        this.proxy.sendMessage(5, ThemeObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, null, [
            enabled,
            isUserModifiable
        ], false);
    }
    onDaylightTimeChanged(sunriseTime, sunsetTime) {
        this.proxy.sendMessage(6, ThemeObserver_OnDaylightTimeChanged_ParamsSpec.$, null, [
            sunriseTime,
            sunsetTime
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ThemeObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ThemeObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ThemeObserver_OnColorModeChanged_ParamsSpec.$, null, impl.onColorModeChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, ThemeObserver_OnColorModeAutoScheduleChanged_ParamsSpec.$, null, impl.onColorModeAutoScheduleChanged.bind(impl), false);
        this.helper_internal_.registerHandler(2, ThemeObserver_OnColorSchemeChanged_ParamsSpec.$, null, impl.onColorSchemeChanged.bind(impl), false);
        this.helper_internal_.registerHandler(3, ThemeObserver_OnSampleColorSchemesChanged_ParamsSpec.$, null, impl.onSampleColorSchemesChanged.bind(impl), false);
        this.helper_internal_.registerHandler(4, ThemeObserver_OnStaticColorChanged_ParamsSpec.$, null, impl.onStaticColorChanged.bind(impl), false);
        this.helper_internal_.registerHandler(5, ThemeObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, null, impl.onGeolocationPermissionForSystemServicesChanged.bind(impl), false);
        this.helper_internal_.registerHandler(6, ThemeObserver_OnDaylightTimeChanged_ParamsSpec.$, null, impl.onDaylightTimeChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ThemeObserver {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.ThemeObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ThemeObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ThemeObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ThemeObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onColorModeChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ThemeObserver_OnColorModeChanged_ParamsSpec.$, null, this.onColorModeChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onColorModeAutoScheduleChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ThemeObserver_OnColorModeAutoScheduleChanged_ParamsSpec.$, null, this.onColorModeAutoScheduleChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onColorSchemeChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ThemeObserver_OnColorSchemeChanged_ParamsSpec.$, null, this.onColorSchemeChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onSampleColorSchemesChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, ThemeObserver_OnSampleColorSchemesChanged_ParamsSpec.$, null, this.onSampleColorSchemesChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onStaticColorChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, ThemeObserver_OnStaticColorChanged_ParamsSpec.$, null, this.onStaticColorChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onGeolocationPermissionForSystemServicesChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, ThemeObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, null, this.onGeolocationPermissionForSystemServicesChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onDaylightTimeChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, ThemeObserver_OnDaylightTimeChanged_ParamsSpec.$, null, this.onDaylightTimeChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ThemeProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.ThemeProvider', scope);
    }
}
export class ThemeProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ThemeProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setThemeObserver(observer) {
        this.proxy.sendMessage(0, ThemeProvider_SetThemeObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    setColorModePref(darkModeEnabled) {
        this.proxy.sendMessage(1, ThemeProvider_SetColorModePref_ParamsSpec.$, null, [
            darkModeEnabled
        ], false);
    }
    setColorModeAutoScheduleEnabled(enabled) {
        this.proxy.sendMessage(2, ThemeProvider_SetColorModeAutoScheduleEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    setColorScheme(colorScheme) {
        this.proxy.sendMessage(3, ThemeProvider_SetColorScheme_ParamsSpec.$, null, [
            colorScheme
        ], false);
    }
    setStaticColor(staticColor) {
        this.proxy.sendMessage(4, ThemeProvider_SetStaticColor_ParamsSpec.$, null, [
            staticColor
        ], false);
    }
    enableGeolocationForSystemServices() {
        this.proxy.sendMessage(5, ThemeProvider_EnableGeolocationForSystemServices_ParamsSpec.$, null, [], false);
    }
    getColorScheme() {
        return this.proxy.sendMessage(6, ThemeProvider_GetColorScheme_ParamsSpec.$, ThemeProvider_GetColorScheme_ResponseParamsSpec.$, [], false);
    }
    getStaticColor() {
        return this.proxy.sendMessage(7, ThemeProvider_GetStaticColor_ParamsSpec.$, ThemeProvider_GetStaticColor_ResponseParamsSpec.$, [], false);
    }
    generateSampleColorSchemes() {
        return this.proxy.sendMessage(8, ThemeProvider_GenerateSampleColorSchemes_ParamsSpec.$, ThemeProvider_GenerateSampleColorSchemes_ResponseParamsSpec.$, [], false);
    }
    isColorModeAutoScheduleEnabled() {
        return this.proxy.sendMessage(9, ThemeProvider_IsColorModeAutoScheduleEnabled_ParamsSpec.$, ThemeProvider_IsColorModeAutoScheduleEnabled_ResponseParamsSpec.$, [], false);
    }
    isDarkModeEnabled() {
        return this.proxy.sendMessage(10, ThemeProvider_IsDarkModeEnabled_ParamsSpec.$, ThemeProvider_IsDarkModeEnabled_ResponseParamsSpec.$, [], false);
    }
    isGeolocationEnabledForSystemServices() {
        return this.proxy.sendMessage(11, ThemeProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, ThemeProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, [], false);
    }
    isGeolocationUserModifiable() {
        return this.proxy.sendMessage(12, ThemeProvider_IsGeolocationUserModifiable_ParamsSpec.$, ThemeProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the ThemeProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ThemeProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ThemeProvider_SetThemeObserver_ParamsSpec.$, null, impl.setThemeObserver.bind(impl), false);
        this.helper_internal_.registerHandler(1, ThemeProvider_SetColorModePref_ParamsSpec.$, null, impl.setColorModePref.bind(impl), false);
        this.helper_internal_.registerHandler(2, ThemeProvider_SetColorModeAutoScheduleEnabled_ParamsSpec.$, null, impl.setColorModeAutoScheduleEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(3, ThemeProvider_SetColorScheme_ParamsSpec.$, null, impl.setColorScheme.bind(impl), false);
        this.helper_internal_.registerHandler(4, ThemeProvider_SetStaticColor_ParamsSpec.$, null, impl.setStaticColor.bind(impl), false);
        this.helper_internal_.registerHandler(5, ThemeProvider_EnableGeolocationForSystemServices_ParamsSpec.$, null, impl.enableGeolocationForSystemServices.bind(impl), false);
        this.helper_internal_.registerHandler(6, ThemeProvider_GetColorScheme_ParamsSpec.$, ThemeProvider_GetColorScheme_ResponseParamsSpec.$, impl.getColorScheme.bind(impl), false);
        this.helper_internal_.registerHandler(7, ThemeProvider_GetStaticColor_ParamsSpec.$, ThemeProvider_GetStaticColor_ResponseParamsSpec.$, impl.getStaticColor.bind(impl), false);
        this.helper_internal_.registerHandler(8, ThemeProvider_GenerateSampleColorSchemes_ParamsSpec.$, ThemeProvider_GenerateSampleColorSchemes_ResponseParamsSpec.$, impl.generateSampleColorSchemes.bind(impl), false);
        this.helper_internal_.registerHandler(9, ThemeProvider_IsColorModeAutoScheduleEnabled_ParamsSpec.$, ThemeProvider_IsColorModeAutoScheduleEnabled_ResponseParamsSpec.$, impl.isColorModeAutoScheduleEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(10, ThemeProvider_IsDarkModeEnabled_ParamsSpec.$, ThemeProvider_IsDarkModeEnabled_ResponseParamsSpec.$, impl.isDarkModeEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(11, ThemeProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, ThemeProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, impl.isGeolocationEnabledForSystemServices.bind(impl), false);
        this.helper_internal_.registerHandler(12, ThemeProvider_IsGeolocationUserModifiable_ParamsSpec.$, ThemeProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, impl.isGeolocationUserModifiable.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ThemeProvider {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.ThemeProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ThemeProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ThemeProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ThemeProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setThemeObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ThemeProvider_SetThemeObserver_ParamsSpec.$, null, this.setThemeObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.setColorModePref =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ThemeProvider_SetColorModePref_ParamsSpec.$, null, this.setColorModePref.createReceiverHandler(false /* expectsResponse */), false);
        this.setColorModeAutoScheduleEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ThemeProvider_SetColorModeAutoScheduleEnabled_ParamsSpec.$, null, this.setColorModeAutoScheduleEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.setColorScheme =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, ThemeProvider_SetColorScheme_ParamsSpec.$, null, this.setColorScheme.createReceiverHandler(false /* expectsResponse */), false);
        this.setStaticColor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, ThemeProvider_SetStaticColor_ParamsSpec.$, null, this.setStaticColor.createReceiverHandler(false /* expectsResponse */), false);
        this.enableGeolocationForSystemServices =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, ThemeProvider_EnableGeolocationForSystemServices_ParamsSpec.$, null, this.enableGeolocationForSystemServices.createReceiverHandler(false /* expectsResponse */), false);
        this.getColorScheme =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, ThemeProvider_GetColorScheme_ParamsSpec.$, ThemeProvider_GetColorScheme_ResponseParamsSpec.$, this.getColorScheme.createReceiverHandler(true /* expectsResponse */), false);
        this.getStaticColor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, ThemeProvider_GetStaticColor_ParamsSpec.$, ThemeProvider_GetStaticColor_ResponseParamsSpec.$, this.getStaticColor.createReceiverHandler(true /* expectsResponse */), false);
        this.generateSampleColorSchemes =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, ThemeProvider_GenerateSampleColorSchemes_ParamsSpec.$, ThemeProvider_GenerateSampleColorSchemes_ResponseParamsSpec.$, this.generateSampleColorSchemes.createReceiverHandler(true /* expectsResponse */), false);
        this.isColorModeAutoScheduleEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, ThemeProvider_IsColorModeAutoScheduleEnabled_ParamsSpec.$, ThemeProvider_IsColorModeAutoScheduleEnabled_ResponseParamsSpec.$, this.isColorModeAutoScheduleEnabled.createReceiverHandler(true /* expectsResponse */), false);
        this.isDarkModeEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, ThemeProvider_IsDarkModeEnabled_ParamsSpec.$, ThemeProvider_IsDarkModeEnabled_ResponseParamsSpec.$, this.isDarkModeEnabled.createReceiverHandler(true /* expectsResponse */), false);
        this.isGeolocationEnabledForSystemServices =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, ThemeProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, ThemeProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, this.isGeolocationEnabledForSystemServices.createReceiverHandler(true /* expectsResponse */), false);
        this.isGeolocationUserModifiable =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, ThemeProvider_IsGeolocationUserModifiable_ParamsSpec.$, ThemeProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, this.isGeolocationUserModifiable.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class UserImageObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.UserImageObserver', scope);
    }
}
export class UserImageObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(UserImageObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onUserImageChanged(userImage) {
        this.proxy.sendMessage(0, UserImageObserver_OnUserImageChanged_ParamsSpec.$, null, [
            userImage
        ], false);
    }
    onUserProfileImageUpdated(profileImage) {
        this.proxy.sendMessage(1, UserImageObserver_OnUserProfileImageUpdated_ParamsSpec.$, null, [
            profileImage
        ], false);
    }
    onCameraPresenceCheckDone(isCameraPresent) {
        this.proxy.sendMessage(2, UserImageObserver_OnCameraPresenceCheckDone_ParamsSpec.$, null, [
            isCameraPresent
        ], false);
    }
    onIsEnterpriseManagedChanged(isEnterpriseManaged) {
        this.proxy.sendMessage(3, UserImageObserver_OnIsEnterpriseManagedChanged_ParamsSpec.$, null, [
            isEnterpriseManaged
        ], false);
    }
}
;
/**
 * An object which receives request messages for the UserImageObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UserImageObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UserImageObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, UserImageObserver_OnUserImageChanged_ParamsSpec.$, null, impl.onUserImageChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, UserImageObserver_OnUserProfileImageUpdated_ParamsSpec.$, null, impl.onUserProfileImageUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(2, UserImageObserver_OnCameraPresenceCheckDone_ParamsSpec.$, null, impl.onCameraPresenceCheckDone.bind(impl), false);
        this.helper_internal_.registerHandler(3, UserImageObserver_OnIsEnterpriseManagedChanged_ParamsSpec.$, null, impl.onIsEnterpriseManagedChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class UserImageObserver {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.UserImageObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new UserImageObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the UserImageObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UserImageObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UserImageObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onUserImageChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, UserImageObserver_OnUserImageChanged_ParamsSpec.$, null, this.onUserImageChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onUserProfileImageUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, UserImageObserver_OnUserProfileImageUpdated_ParamsSpec.$, null, this.onUserProfileImageUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onCameraPresenceCheckDone =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, UserImageObserver_OnCameraPresenceCheckDone_ParamsSpec.$, null, this.onCameraPresenceCheckDone.createReceiverHandler(false /* expectsResponse */), false);
        this.onIsEnterpriseManagedChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, UserImageObserver_OnIsEnterpriseManagedChanged_ParamsSpec.$, null, this.onIsEnterpriseManagedChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class UserProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.UserProvider', scope);
    }
}
export class UserProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(UserProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setUserImageObserver(observer) {
        this.proxy.sendMessage(0, UserProvider_SetUserImageObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    getUserInfo() {
        return this.proxy.sendMessage(1, UserProvider_GetUserInfo_ParamsSpec.$, UserProvider_GetUserInfo_ResponseParamsSpec.$, [], false);
    }
    getDefaultUserImages() {
        return this.proxy.sendMessage(2, UserProvider_GetDefaultUserImages_ParamsSpec.$, UserProvider_GetDefaultUserImages_ResponseParamsSpec.$, [], false);
    }
    selectDefaultImage(index) {
        this.proxy.sendMessage(3, UserProvider_SelectDefaultImage_ParamsSpec.$, null, [
            index
        ], false);
    }
    selectProfileImage() {
        this.proxy.sendMessage(4, UserProvider_SelectProfileImage_ParamsSpec.$, null, [], false);
    }
    selectCameraImage(data) {
        this.proxy.sendMessage(5, UserProvider_SelectCameraImage_ParamsSpec.$, null, [
            data
        ], false);
    }
    selectImageFromDisk() {
        this.proxy.sendMessage(6, UserProvider_SelectImageFromDisk_ParamsSpec.$, null, [], false);
    }
    selectLastExternalUserImage() {
        this.proxy.sendMessage(7, UserProvider_SelectLastExternalUserImage_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the UserProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UserProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UserProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, UserProvider_SetUserImageObserver_ParamsSpec.$, null, impl.setUserImageObserver.bind(impl), false);
        this.helper_internal_.registerHandler(1, UserProvider_GetUserInfo_ParamsSpec.$, UserProvider_GetUserInfo_ResponseParamsSpec.$, impl.getUserInfo.bind(impl), false);
        this.helper_internal_.registerHandler(2, UserProvider_GetDefaultUserImages_ParamsSpec.$, UserProvider_GetDefaultUserImages_ResponseParamsSpec.$, impl.getDefaultUserImages.bind(impl), false);
        this.helper_internal_.registerHandler(3, UserProvider_SelectDefaultImage_ParamsSpec.$, null, impl.selectDefaultImage.bind(impl), false);
        this.helper_internal_.registerHandler(4, UserProvider_SelectProfileImage_ParamsSpec.$, null, impl.selectProfileImage.bind(impl), false);
        this.helper_internal_.registerHandler(5, UserProvider_SelectCameraImage_ParamsSpec.$, null, impl.selectCameraImage.bind(impl), false);
        this.helper_internal_.registerHandler(6, UserProvider_SelectImageFromDisk_ParamsSpec.$, null, impl.selectImageFromDisk.bind(impl), false);
        this.helper_internal_.registerHandler(7, UserProvider_SelectLastExternalUserImage_ParamsSpec.$, null, impl.selectLastExternalUserImage.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class UserProvider {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.UserProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new UserProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the UserProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UserProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UserProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setUserImageObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, UserProvider_SetUserImageObserver_ParamsSpec.$, null, this.setUserImageObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.getUserInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, UserProvider_GetUserInfo_ParamsSpec.$, UserProvider_GetUserInfo_ResponseParamsSpec.$, this.getUserInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.getDefaultUserImages =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, UserProvider_GetDefaultUserImages_ParamsSpec.$, UserProvider_GetDefaultUserImages_ResponseParamsSpec.$, this.getDefaultUserImages.createReceiverHandler(true /* expectsResponse */), false);
        this.selectDefaultImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, UserProvider_SelectDefaultImage_ParamsSpec.$, null, this.selectDefaultImage.createReceiverHandler(false /* expectsResponse */), false);
        this.selectProfileImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, UserProvider_SelectProfileImage_ParamsSpec.$, null, this.selectProfileImage.createReceiverHandler(false /* expectsResponse */), false);
        this.selectCameraImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, UserProvider_SelectCameraImage_ParamsSpec.$, null, this.selectCameraImage.createReceiverHandler(false /* expectsResponse */), false);
        this.selectImageFromDisk =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, UserProvider_SelectImageFromDisk_ParamsSpec.$, null, this.selectImageFromDisk.createReceiverHandler(false /* expectsResponse */), false);
        this.selectLastExternalUserImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, UserProvider_SelectLastExternalUserImage_ParamsSpec.$, null, this.selectLastExternalUserImage.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class AmbientObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.AmbientObserver', scope);
    }
}
export class AmbientObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AmbientObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onAmbientModeEnabledChanged(ambientModeEnabled) {
        this.proxy.sendMessage(0, AmbientObserver_OnAmbientModeEnabledChanged_ParamsSpec.$, null, [
            ambientModeEnabled
        ], false);
    }
    onAmbientThemeChanged(ambientTheme) {
        this.proxy.sendMessage(1, AmbientObserver_OnAmbientThemeChanged_ParamsSpec.$, null, [
            ambientTheme
        ], false);
    }
    onTopicSourceChanged(topicSource) {
        this.proxy.sendMessage(2, AmbientObserver_OnTopicSourceChanged_ParamsSpec.$, null, [
            topicSource
        ], false);
    }
    onScreenSaverDurationChanged(minutes) {
        this.proxy.sendMessage(3, AmbientObserver_OnScreenSaverDurationChanged_ParamsSpec.$, null, [
            minutes
        ], false);
    }
    onTemperatureUnitChanged(temperatureUnit) {
        this.proxy.sendMessage(4, AmbientObserver_OnTemperatureUnitChanged_ParamsSpec.$, null, [
            temperatureUnit
        ], false);
    }
    onAlbumsChanged(albums) {
        this.proxy.sendMessage(5, AmbientObserver_OnAlbumsChanged_ParamsSpec.$, null, [
            albums
        ], false);
    }
    onPreviewsFetched(previews) {
        this.proxy.sendMessage(6, AmbientObserver_OnPreviewsFetched_ParamsSpec.$, null, [
            previews
        ], false);
    }
    onAmbientUiVisibilityChanged(visibility) {
        this.proxy.sendMessage(7, AmbientObserver_OnAmbientUiVisibilityChanged_ParamsSpec.$, null, [
            visibility
        ], false);
    }
    onGeolocationPermissionForSystemServicesChanged(enabled, isUserModifiable) {
        this.proxy.sendMessage(8, AmbientObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, null, [
            enabled,
            isUserModifiable
        ], false);
    }
    onAmbientThemePreviewImagesChanged(previews) {
        this.proxy.sendMessage(9, AmbientObserver_OnAmbientThemePreviewImagesChanged_ParamsSpec.$, null, [
            previews
        ], false);
    }
}
;
/**
 * An object which receives request messages for the AmbientObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AmbientObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AmbientObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AmbientObserver_OnAmbientModeEnabledChanged_ParamsSpec.$, null, impl.onAmbientModeEnabledChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, AmbientObserver_OnAmbientThemeChanged_ParamsSpec.$, null, impl.onAmbientThemeChanged.bind(impl), false);
        this.helper_internal_.registerHandler(2, AmbientObserver_OnTopicSourceChanged_ParamsSpec.$, null, impl.onTopicSourceChanged.bind(impl), false);
        this.helper_internal_.registerHandler(3, AmbientObserver_OnScreenSaverDurationChanged_ParamsSpec.$, null, impl.onScreenSaverDurationChanged.bind(impl), false);
        this.helper_internal_.registerHandler(4, AmbientObserver_OnTemperatureUnitChanged_ParamsSpec.$, null, impl.onTemperatureUnitChanged.bind(impl), false);
        this.helper_internal_.registerHandler(5, AmbientObserver_OnAlbumsChanged_ParamsSpec.$, null, impl.onAlbumsChanged.bind(impl), false);
        this.helper_internal_.registerHandler(6, AmbientObserver_OnPreviewsFetched_ParamsSpec.$, null, impl.onPreviewsFetched.bind(impl), false);
        this.helper_internal_.registerHandler(7, AmbientObserver_OnAmbientUiVisibilityChanged_ParamsSpec.$, null, impl.onAmbientUiVisibilityChanged.bind(impl), false);
        this.helper_internal_.registerHandler(8, AmbientObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, null, impl.onGeolocationPermissionForSystemServicesChanged.bind(impl), false);
        this.helper_internal_.registerHandler(9, AmbientObserver_OnAmbientThemePreviewImagesChanged_ParamsSpec.$, null, impl.onAmbientThemePreviewImagesChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AmbientObserver {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.AmbientObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AmbientObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AmbientObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AmbientObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AmbientObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onAmbientModeEnabledChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AmbientObserver_OnAmbientModeEnabledChanged_ParamsSpec.$, null, this.onAmbientModeEnabledChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onAmbientThemeChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AmbientObserver_OnAmbientThemeChanged_ParamsSpec.$, null, this.onAmbientThemeChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onTopicSourceChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, AmbientObserver_OnTopicSourceChanged_ParamsSpec.$, null, this.onTopicSourceChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onScreenSaverDurationChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, AmbientObserver_OnScreenSaverDurationChanged_ParamsSpec.$, null, this.onScreenSaverDurationChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onTemperatureUnitChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, AmbientObserver_OnTemperatureUnitChanged_ParamsSpec.$, null, this.onTemperatureUnitChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onAlbumsChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, AmbientObserver_OnAlbumsChanged_ParamsSpec.$, null, this.onAlbumsChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onPreviewsFetched =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, AmbientObserver_OnPreviewsFetched_ParamsSpec.$, null, this.onPreviewsFetched.createReceiverHandler(false /* expectsResponse */), false);
        this.onAmbientUiVisibilityChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, AmbientObserver_OnAmbientUiVisibilityChanged_ParamsSpec.$, null, this.onAmbientUiVisibilityChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onGeolocationPermissionForSystemServicesChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, AmbientObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, null, this.onGeolocationPermissionForSystemServicesChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onAmbientThemePreviewImagesChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, AmbientObserver_OnAmbientThemePreviewImagesChanged_ParamsSpec.$, null, this.onAmbientThemePreviewImagesChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class AmbientProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.AmbientProvider', scope);
    }
}
export class AmbientProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AmbientProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    isAmbientModeEnabled() {
        return this.proxy.sendMessage(0, AmbientProvider_IsAmbientModeEnabled_ParamsSpec.$, AmbientProvider_IsAmbientModeEnabled_ResponseParamsSpec.$, [], false);
    }
    setAmbientModeEnabled(enabled) {
        this.proxy.sendMessage(1, AmbientProvider_SetAmbientModeEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    setAmbientObserver(observer) {
        this.proxy.sendMessage(2, AmbientProvider_SetAmbientObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    setAmbientTheme(ambientTheme) {
        this.proxy.sendMessage(3, AmbientProvider_SetAmbientTheme_ParamsSpec.$, null, [
            ambientTheme
        ], false);
    }
    setScreenSaverDuration(minutes) {
        this.proxy.sendMessage(4, AmbientProvider_SetScreenSaverDuration_ParamsSpec.$, null, [
            minutes
        ], false);
    }
    setTopicSource(topicSource) {
        this.proxy.sendMessage(5, AmbientProvider_SetTopicSource_ParamsSpec.$, null, [
            topicSource
        ], false);
    }
    setTemperatureUnit(temperatureUnit) {
        this.proxy.sendMessage(6, AmbientProvider_SetTemperatureUnit_ParamsSpec.$, null, [
            temperatureUnit
        ], false);
    }
    setAlbumSelected(id, topicSource, selected) {
        this.proxy.sendMessage(7, AmbientProvider_SetAlbumSelected_ParamsSpec.$, null, [
            id,
            topicSource,
            selected
        ], false);
    }
    setPageViewed() {
        this.proxy.sendMessage(8, AmbientProvider_SetPageViewed_ParamsSpec.$, null, [], false);
    }
    fetchSettingsAndAlbums() {
        this.proxy.sendMessage(9, AmbientProvider_FetchSettingsAndAlbums_ParamsSpec.$, null, [], false);
    }
    startScreenSaverPreview() {
        this.proxy.sendMessage(10, AmbientProvider_StartScreenSaverPreview_ParamsSpec.$, null, [], false);
    }
    shouldShowTimeOfDayBanner() {
        return this.proxy.sendMessage(11, AmbientProvider_ShouldShowTimeOfDayBanner_ParamsSpec.$, AmbientProvider_ShouldShowTimeOfDayBanner_ResponseParamsSpec.$, [], false);
    }
    handleTimeOfDayBannerDismissed() {
        this.proxy.sendMessage(12, AmbientProvider_HandleTimeOfDayBannerDismissed_ParamsSpec.$, null, [], false);
    }
    isGeolocationEnabledForSystemServices() {
        return this.proxy.sendMessage(13, AmbientProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, AmbientProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, [], false);
    }
    isGeolocationUserModifiable() {
        return this.proxy.sendMessage(14, AmbientProvider_IsGeolocationUserModifiable_ParamsSpec.$, AmbientProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, [], false);
    }
    enableGeolocationForSystemServices() {
        this.proxy.sendMessage(15, AmbientProvider_EnableGeolocationForSystemServices_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the AmbientProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AmbientProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AmbientProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AmbientProvider_IsAmbientModeEnabled_ParamsSpec.$, AmbientProvider_IsAmbientModeEnabled_ResponseParamsSpec.$, impl.isAmbientModeEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(1, AmbientProvider_SetAmbientModeEnabled_ParamsSpec.$, null, impl.setAmbientModeEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(2, AmbientProvider_SetAmbientObserver_ParamsSpec.$, null, impl.setAmbientObserver.bind(impl), false);
        this.helper_internal_.registerHandler(3, AmbientProvider_SetAmbientTheme_ParamsSpec.$, null, impl.setAmbientTheme.bind(impl), false);
        this.helper_internal_.registerHandler(4, AmbientProvider_SetScreenSaverDuration_ParamsSpec.$, null, impl.setScreenSaverDuration.bind(impl), false);
        this.helper_internal_.registerHandler(5, AmbientProvider_SetTopicSource_ParamsSpec.$, null, impl.setTopicSource.bind(impl), false);
        this.helper_internal_.registerHandler(6, AmbientProvider_SetTemperatureUnit_ParamsSpec.$, null, impl.setTemperatureUnit.bind(impl), false);
        this.helper_internal_.registerHandler(7, AmbientProvider_SetAlbumSelected_ParamsSpec.$, null, impl.setAlbumSelected.bind(impl), false);
        this.helper_internal_.registerHandler(8, AmbientProvider_SetPageViewed_ParamsSpec.$, null, impl.setPageViewed.bind(impl), false);
        this.helper_internal_.registerHandler(9, AmbientProvider_FetchSettingsAndAlbums_ParamsSpec.$, null, impl.fetchSettingsAndAlbums.bind(impl), false);
        this.helper_internal_.registerHandler(10, AmbientProvider_StartScreenSaverPreview_ParamsSpec.$, null, impl.startScreenSaverPreview.bind(impl), false);
        this.helper_internal_.registerHandler(11, AmbientProvider_ShouldShowTimeOfDayBanner_ParamsSpec.$, AmbientProvider_ShouldShowTimeOfDayBanner_ResponseParamsSpec.$, impl.shouldShowTimeOfDayBanner.bind(impl), false);
        this.helper_internal_.registerHandler(12, AmbientProvider_HandleTimeOfDayBannerDismissed_ParamsSpec.$, null, impl.handleTimeOfDayBannerDismissed.bind(impl), false);
        this.helper_internal_.registerHandler(13, AmbientProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, AmbientProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, impl.isGeolocationEnabledForSystemServices.bind(impl), false);
        this.helper_internal_.registerHandler(14, AmbientProvider_IsGeolocationUserModifiable_ParamsSpec.$, AmbientProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, impl.isGeolocationUserModifiable.bind(impl), false);
        this.helper_internal_.registerHandler(15, AmbientProvider_EnableGeolocationForSystemServices_ParamsSpec.$, null, impl.enableGeolocationForSystemServices.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AmbientProvider {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.AmbientProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AmbientProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AmbientProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AmbientProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AmbientProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.isAmbientModeEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AmbientProvider_IsAmbientModeEnabled_ParamsSpec.$, AmbientProvider_IsAmbientModeEnabled_ResponseParamsSpec.$, this.isAmbientModeEnabled.createReceiverHandler(true /* expectsResponse */), false);
        this.setAmbientModeEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AmbientProvider_SetAmbientModeEnabled_ParamsSpec.$, null, this.setAmbientModeEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.setAmbientObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, AmbientProvider_SetAmbientObserver_ParamsSpec.$, null, this.setAmbientObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.setAmbientTheme =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, AmbientProvider_SetAmbientTheme_ParamsSpec.$, null, this.setAmbientTheme.createReceiverHandler(false /* expectsResponse */), false);
        this.setScreenSaverDuration =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, AmbientProvider_SetScreenSaverDuration_ParamsSpec.$, null, this.setScreenSaverDuration.createReceiverHandler(false /* expectsResponse */), false);
        this.setTopicSource =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, AmbientProvider_SetTopicSource_ParamsSpec.$, null, this.setTopicSource.createReceiverHandler(false /* expectsResponse */), false);
        this.setTemperatureUnit =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, AmbientProvider_SetTemperatureUnit_ParamsSpec.$, null, this.setTemperatureUnit.createReceiverHandler(false /* expectsResponse */), false);
        this.setAlbumSelected =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, AmbientProvider_SetAlbumSelected_ParamsSpec.$, null, this.setAlbumSelected.createReceiverHandler(false /* expectsResponse */), false);
        this.setPageViewed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, AmbientProvider_SetPageViewed_ParamsSpec.$, null, this.setPageViewed.createReceiverHandler(false /* expectsResponse */), false);
        this.fetchSettingsAndAlbums =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, AmbientProvider_FetchSettingsAndAlbums_ParamsSpec.$, null, this.fetchSettingsAndAlbums.createReceiverHandler(false /* expectsResponse */), false);
        this.startScreenSaverPreview =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, AmbientProvider_StartScreenSaverPreview_ParamsSpec.$, null, this.startScreenSaverPreview.createReceiverHandler(false /* expectsResponse */), false);
        this.shouldShowTimeOfDayBanner =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, AmbientProvider_ShouldShowTimeOfDayBanner_ParamsSpec.$, AmbientProvider_ShouldShowTimeOfDayBanner_ResponseParamsSpec.$, this.shouldShowTimeOfDayBanner.createReceiverHandler(true /* expectsResponse */), false);
        this.handleTimeOfDayBannerDismissed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, AmbientProvider_HandleTimeOfDayBannerDismissed_ParamsSpec.$, null, this.handleTimeOfDayBannerDismissed.createReceiverHandler(false /* expectsResponse */), false);
        this.isGeolocationEnabledForSystemServices =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, AmbientProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, AmbientProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, this.isGeolocationEnabledForSystemServices.createReceiverHandler(true /* expectsResponse */), false);
        this.isGeolocationUserModifiable =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, AmbientProvider_IsGeolocationUserModifiable_ParamsSpec.$, AmbientProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, this.isGeolocationUserModifiable.createReceiverHandler(true /* expectsResponse */), false);
        this.enableGeolocationForSystemServices =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, AmbientProvider_EnableGeolocationForSystemServices_ParamsSpec.$, null, this.enableGeolocationForSystemServices.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class KeyboardBacklightObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.KeyboardBacklightObserver', scope);
    }
}
export class KeyboardBacklightObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(KeyboardBacklightObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onBacklightStateChanged(currentBacklightState) {
        this.proxy.sendMessage(0, KeyboardBacklightObserver_OnBacklightStateChanged_ParamsSpec.$, null, [
            currentBacklightState
        ], false);
    }
    onWallpaperColorChanged(wallpaperColor) {
        this.proxy.sendMessage(1, KeyboardBacklightObserver_OnWallpaperColorChanged_ParamsSpec.$, null, [
            wallpaperColor
        ], false);
    }
}
;
/**
 * An object which receives request messages for the KeyboardBacklightObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class KeyboardBacklightObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardBacklightObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, KeyboardBacklightObserver_OnBacklightStateChanged_ParamsSpec.$, null, impl.onBacklightStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, KeyboardBacklightObserver_OnWallpaperColorChanged_ParamsSpec.$, null, impl.onWallpaperColorChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class KeyboardBacklightObserver {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.KeyboardBacklightObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new KeyboardBacklightObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the KeyboardBacklightObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class KeyboardBacklightObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardBacklightObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onBacklightStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, KeyboardBacklightObserver_OnBacklightStateChanged_ParamsSpec.$, null, this.onBacklightStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onWallpaperColorChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, KeyboardBacklightObserver_OnWallpaperColorChanged_ParamsSpec.$, null, this.onWallpaperColorChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class KeyboardBacklightProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.KeyboardBacklightProvider', scope);
    }
}
export class KeyboardBacklightProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(KeyboardBacklightProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setKeyboardBacklightObserver(observer) {
        this.proxy.sendMessage(0, KeyboardBacklightProvider_SetKeyboardBacklightObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    setBacklightColor(backlightColor) {
        this.proxy.sendMessage(1, KeyboardBacklightProvider_SetBacklightColor_ParamsSpec.$, null, [
            backlightColor
        ], false);
    }
    setBacklightZoneColor(zone, backlightColor) {
        this.proxy.sendMessage(2, KeyboardBacklightProvider_SetBacklightZoneColor_ParamsSpec.$, null, [
            zone,
            backlightColor
        ], false);
    }
    shouldShowNudge() {
        return this.proxy.sendMessage(3, KeyboardBacklightProvider_ShouldShowNudge_ParamsSpec.$, KeyboardBacklightProvider_ShouldShowNudge_ResponseParamsSpec.$, [], false);
    }
    handleNudgeShown() {
        this.proxy.sendMessage(4, KeyboardBacklightProvider_HandleNudgeShown_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the KeyboardBacklightProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class KeyboardBacklightProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardBacklightProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, KeyboardBacklightProvider_SetKeyboardBacklightObserver_ParamsSpec.$, null, impl.setKeyboardBacklightObserver.bind(impl), false);
        this.helper_internal_.registerHandler(1, KeyboardBacklightProvider_SetBacklightColor_ParamsSpec.$, null, impl.setBacklightColor.bind(impl), false);
        this.helper_internal_.registerHandler(2, KeyboardBacklightProvider_SetBacklightZoneColor_ParamsSpec.$, null, impl.setBacklightZoneColor.bind(impl), false);
        this.helper_internal_.registerHandler(3, KeyboardBacklightProvider_ShouldShowNudge_ParamsSpec.$, KeyboardBacklightProvider_ShouldShowNudge_ResponseParamsSpec.$, impl.shouldShowNudge.bind(impl), false);
        this.helper_internal_.registerHandler(4, KeyboardBacklightProvider_HandleNudgeShown_ParamsSpec.$, null, impl.handleNudgeShown.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class KeyboardBacklightProvider {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.KeyboardBacklightProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new KeyboardBacklightProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the KeyboardBacklightProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class KeyboardBacklightProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardBacklightProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setKeyboardBacklightObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, KeyboardBacklightProvider_SetKeyboardBacklightObserver_ParamsSpec.$, null, this.setKeyboardBacklightObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.setBacklightColor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, KeyboardBacklightProvider_SetBacklightColor_ParamsSpec.$, null, this.setBacklightColor.createReceiverHandler(false /* expectsResponse */), false);
        this.setBacklightZoneColor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, KeyboardBacklightProvider_SetBacklightZoneColor_ParamsSpec.$, null, this.setBacklightZoneColor.createReceiverHandler(false /* expectsResponse */), false);
        this.shouldShowNudge =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, KeyboardBacklightProvider_ShouldShowNudge_ParamsSpec.$, KeyboardBacklightProvider_ShouldShowNudge_ResponseParamsSpec.$, this.shouldShowNudge.createReceiverHandler(true /* expectsResponse */), false);
        this.handleNudgeShown =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, KeyboardBacklightProvider_HandleNudgeShown_ParamsSpec.$, null, this.handleNudgeShown.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const WallpaperCollectionSpec = { $: {} };
export const GooglePhotosAlbumSpec = { $: {} };
export const FetchGooglePhotosAlbumsResponseSpec = { $: {} };
export const WallpaperImageSpec = { $: {} };
export const GooglePhotosPhotoSpec = { $: {} };
export const FetchGooglePhotosPhotosResponseSpec = { $: {} };
export const CurrentAttributionSpec = { $: {} };
export const CurrentWallpaperSpec = { $: {} };
export const SampleColorSchemeSpec = { $: {} };
export const UserInfoSpec = { $: {} };
export const DeprecatedSourceInfoSpec = { $: {} };
export const DefaultUserImageSpec = { $: {} };
export const ProfileImageSpec = { $: {} };
export const InvalidImageSpec = { $: {} };
export const AmbientModeAlbumSpec = { $: {} };
export const WallpaperObserver_OnWallpaperPreviewEnded_ParamsSpec = { $: {} };
export const WallpaperObserver_OnAttributionChanged_ParamsSpec = { $: {} };
export const WallpaperObserver_OnWallpaperChanged_ParamsSpec = { $: {} };
export const WallpaperProvider_MakeTransparent_ParamsSpec = { $: {} };
export const WallpaperProvider_MakeOpaque_ParamsSpec = { $: {} };
export const WallpaperProvider_FetchCollections_ParamsSpec = { $: {} };
export const WallpaperProvider_FetchCollections_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_FetchImagesForCollection_ParamsSpec = { $: {} };
export const WallpaperProvider_FetchImagesForCollection_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_FetchGooglePhotosAlbums_ParamsSpec = { $: {} };
export const WallpaperProvider_FetchGooglePhotosAlbums_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_FetchGooglePhotosSharedAlbums_ParamsSpec = { $: {} };
export const WallpaperProvider_FetchGooglePhotosSharedAlbums_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_FetchGooglePhotosEnabled_ParamsSpec = { $: {} };
export const WallpaperProvider_FetchGooglePhotosEnabled_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_FetchGooglePhotosPhotos_ParamsSpec = { $: {} };
export const WallpaperProvider_FetchGooglePhotosPhotos_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_GetLocalImages_ParamsSpec = { $: {} };
export const WallpaperProvider_GetLocalImages_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_GetDefaultImageThumbnail_ParamsSpec = { $: {} };
export const WallpaperProvider_GetDefaultImageThumbnail_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_GetLocalImageThumbnail_ParamsSpec = { $: {} };
export const WallpaperProvider_GetLocalImageThumbnail_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_SetWallpaperObserver_ParamsSpec = { $: {} };
export const WallpaperProvider_SelectWallpaper_ParamsSpec = { $: {} };
export const WallpaperProvider_SelectWallpaper_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_SelectDefaultImage_ParamsSpec = { $: {} };
export const WallpaperProvider_SelectDefaultImage_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_SelectLocalImage_ParamsSpec = { $: {} };
export const WallpaperProvider_SelectLocalImage_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_SelectGooglePhotosPhoto_ParamsSpec = { $: {} };
export const WallpaperProvider_SelectGooglePhotosPhoto_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_SelectGooglePhotosAlbum_ParamsSpec = { $: {} };
export const WallpaperProvider_SelectGooglePhotosAlbum_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ParamsSpec = { $: {} };
export const WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_SetCurrentWallpaperLayout_ParamsSpec = { $: {} };
export const WallpaperProvider_SetDailyRefreshCollectionId_ParamsSpec = { $: {} };
export const WallpaperProvider_SetDailyRefreshCollectionId_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_GetDailyRefreshCollectionId_ParamsSpec = { $: {} };
export const WallpaperProvider_GetDailyRefreshCollectionId_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_UpdateDailyRefreshWallpaper_ParamsSpec = { $: {} };
export const WallpaperProvider_UpdateDailyRefreshWallpaper_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_IsInTabletMode_ParamsSpec = { $: {} };
export const WallpaperProvider_IsInTabletMode_ResponseParamsSpec = { $: {} };
export const WallpaperProvider_ConfirmPreviewWallpaper_ParamsSpec = { $: {} };
export const WallpaperProvider_CancelPreviewWallpaper_ParamsSpec = { $: {} };
export const WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ParamsSpec = { $: {} };
export const WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ResponseParamsSpec = { $: {} };
export const ThemeObserver_OnColorModeChanged_ParamsSpec = { $: {} };
export const ThemeObserver_OnColorModeAutoScheduleChanged_ParamsSpec = { $: {} };
export const ThemeObserver_OnColorSchemeChanged_ParamsSpec = { $: {} };
export const ThemeObserver_OnSampleColorSchemesChanged_ParamsSpec = { $: {} };
export const ThemeObserver_OnStaticColorChanged_ParamsSpec = { $: {} };
export const ThemeObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec = { $: {} };
export const ThemeObserver_OnDaylightTimeChanged_ParamsSpec = { $: {} };
export const ThemeProvider_SetThemeObserver_ParamsSpec = { $: {} };
export const ThemeProvider_SetColorModePref_ParamsSpec = { $: {} };
export const ThemeProvider_SetColorModeAutoScheduleEnabled_ParamsSpec = { $: {} };
export const ThemeProvider_SetColorScheme_ParamsSpec = { $: {} };
export const ThemeProvider_SetStaticColor_ParamsSpec = { $: {} };
export const ThemeProvider_EnableGeolocationForSystemServices_ParamsSpec = { $: {} };
export const ThemeProvider_GetColorScheme_ParamsSpec = { $: {} };
export const ThemeProvider_GetColorScheme_ResponseParamsSpec = { $: {} };
export const ThemeProvider_GetStaticColor_ParamsSpec = { $: {} };
export const ThemeProvider_GetStaticColor_ResponseParamsSpec = { $: {} };
export const ThemeProvider_GenerateSampleColorSchemes_ParamsSpec = { $: {} };
export const ThemeProvider_GenerateSampleColorSchemes_ResponseParamsSpec = { $: {} };
export const ThemeProvider_IsColorModeAutoScheduleEnabled_ParamsSpec = { $: {} };
export const ThemeProvider_IsColorModeAutoScheduleEnabled_ResponseParamsSpec = { $: {} };
export const ThemeProvider_IsDarkModeEnabled_ParamsSpec = { $: {} };
export const ThemeProvider_IsDarkModeEnabled_ResponseParamsSpec = { $: {} };
export const ThemeProvider_IsGeolocationEnabledForSystemServices_ParamsSpec = { $: {} };
export const ThemeProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec = { $: {} };
export const ThemeProvider_IsGeolocationUserModifiable_ParamsSpec = { $: {} };
export const ThemeProvider_IsGeolocationUserModifiable_ResponseParamsSpec = { $: {} };
export const UserImageObserver_OnUserImageChanged_ParamsSpec = { $: {} };
export const UserImageObserver_OnUserProfileImageUpdated_ParamsSpec = { $: {} };
export const UserImageObserver_OnCameraPresenceCheckDone_ParamsSpec = { $: {} };
export const UserImageObserver_OnIsEnterpriseManagedChanged_ParamsSpec = { $: {} };
export const UserProvider_SetUserImageObserver_ParamsSpec = { $: {} };
export const UserProvider_GetUserInfo_ParamsSpec = { $: {} };
export const UserProvider_GetUserInfo_ResponseParamsSpec = { $: {} };
export const UserProvider_GetDefaultUserImages_ParamsSpec = { $: {} };
export const UserProvider_GetDefaultUserImages_ResponseParamsSpec = { $: {} };
export const UserProvider_SelectDefaultImage_ParamsSpec = { $: {} };
export const UserProvider_SelectProfileImage_ParamsSpec = { $: {} };
export const UserProvider_SelectCameraImage_ParamsSpec = { $: {} };
export const UserProvider_SelectImageFromDisk_ParamsSpec = { $: {} };
export const UserProvider_SelectLastExternalUserImage_ParamsSpec = { $: {} };
export const AmbientObserver_OnAmbientModeEnabledChanged_ParamsSpec = { $: {} };
export const AmbientObserver_OnAmbientThemeChanged_ParamsSpec = { $: {} };
export const AmbientObserver_OnTopicSourceChanged_ParamsSpec = { $: {} };
export const AmbientObserver_OnScreenSaverDurationChanged_ParamsSpec = { $: {} };
export const AmbientObserver_OnTemperatureUnitChanged_ParamsSpec = { $: {} };
export const AmbientObserver_OnAlbumsChanged_ParamsSpec = { $: {} };
export const AmbientObserver_OnPreviewsFetched_ParamsSpec = { $: {} };
export const AmbientObserver_OnAmbientUiVisibilityChanged_ParamsSpec = { $: {} };
export const AmbientObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec = { $: {} };
export const AmbientObserver_OnAmbientThemePreviewImagesChanged_ParamsSpec = { $: {} };
export const AmbientProvider_IsAmbientModeEnabled_ParamsSpec = { $: {} };
export const AmbientProvider_IsAmbientModeEnabled_ResponseParamsSpec = { $: {} };
export const AmbientProvider_SetAmbientModeEnabled_ParamsSpec = { $: {} };
export const AmbientProvider_SetAmbientObserver_ParamsSpec = { $: {} };
export const AmbientProvider_SetAmbientTheme_ParamsSpec = { $: {} };
export const AmbientProvider_SetScreenSaverDuration_ParamsSpec = { $: {} };
export const AmbientProvider_SetTopicSource_ParamsSpec = { $: {} };
export const AmbientProvider_SetTemperatureUnit_ParamsSpec = { $: {} };
export const AmbientProvider_SetAlbumSelected_ParamsSpec = { $: {} };
export const AmbientProvider_SetPageViewed_ParamsSpec = { $: {} };
export const AmbientProvider_FetchSettingsAndAlbums_ParamsSpec = { $: {} };
export const AmbientProvider_StartScreenSaverPreview_ParamsSpec = { $: {} };
export const AmbientProvider_ShouldShowTimeOfDayBanner_ParamsSpec = { $: {} };
export const AmbientProvider_ShouldShowTimeOfDayBanner_ResponseParamsSpec = { $: {} };
export const AmbientProvider_HandleTimeOfDayBannerDismissed_ParamsSpec = { $: {} };
export const AmbientProvider_IsGeolocationEnabledForSystemServices_ParamsSpec = { $: {} };
export const AmbientProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec = { $: {} };
export const AmbientProvider_IsGeolocationUserModifiable_ParamsSpec = { $: {} };
export const AmbientProvider_IsGeolocationUserModifiable_ResponseParamsSpec = { $: {} };
export const AmbientProvider_EnableGeolocationForSystemServices_ParamsSpec = { $: {} };
export const KeyboardBacklightObserver_OnBacklightStateChanged_ParamsSpec = { $: {} };
export const KeyboardBacklightObserver_OnWallpaperColorChanged_ParamsSpec = { $: {} };
export const KeyboardBacklightProvider_SetKeyboardBacklightObserver_ParamsSpec = { $: {} };
export const KeyboardBacklightProvider_SetBacklightColor_ParamsSpec = { $: {} };
export const KeyboardBacklightProvider_SetBacklightZoneColor_ParamsSpec = { $: {} };
export const KeyboardBacklightProvider_ShouldShowNudge_ParamsSpec = { $: {} };
export const KeyboardBacklightProvider_ShouldShowNudge_ResponseParamsSpec = { $: {} };
export const KeyboardBacklightProvider_HandleNudgeShown_ParamsSpec = { $: {} };
export const UserImageSpec = { $: {} };
export const CurrentBacklightStateSpec = { $: {} };
mojo.internal.Struct(WallpaperCollectionSpec.$, 'WallpaperCollection', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('descriptionContent', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('previews', 24, 0, mojo.internal.Array(url_mojom_UrlSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(GooglePhotosAlbumSpec.$, 'GooglePhotosAlbum', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('photoCount', 16, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('preview', 24, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('timestamp', 32, 0, mojoBase_mojom_TimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isShared', 20, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(FetchGooglePhotosAlbumsResponseSpec.$, 'FetchGooglePhotosAlbumsResponse', [
    mojo.internal.StructField('albums', 0, 0, mojo.internal.Array(GooglePhotosAlbumSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resumeToken', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WallpaperImageSpec.$, 'WallpaperImage', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('attribution', 8, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('assetId', 16, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('unitId', 24, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 32, 0, OnlineImageTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(GooglePhotosPhotoSpec.$, 'GooglePhotosPhoto', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('dedupKey', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('date', 24, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 32, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('location', 40, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(FetchGooglePhotosPhotosResponseSpec.$, 'FetchGooglePhotosPhotosResponse', [
    mojo.internal.StructField('photos', 0, 0, mojo.internal.Array(GooglePhotosPhotoSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resumeToken', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CurrentAttributionSpec.$, 'CurrentAttribution', [
    mojo.internal.StructField('attribution', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('key', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CurrentWallpaperSpec.$, 'CurrentWallpaper', [
    mojo.internal.StructField('layout', 0, 0, WallpaperLayoutSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 4, 0, WallpaperTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('key', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('descriptionTitle', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('descriptionContent', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('actionUrl', 32, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(SampleColorSchemeSpec.$, 'SampleColorScheme', [
    mojo.internal.StructField('scheme', 0, 0, ash_style_mojom_ColorSchemeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('primary', 8, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('secondary', 16, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tertiary', 24, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(UserInfoSpec.$, 'UserInfo', [
    mojo.internal.StructField('email', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(DeprecatedSourceInfoSpec.$, 'DeprecatedSourceInfo', [
    mojo.internal.StructField('author', 0, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('website', 8, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(DefaultUserImageSpec.$, 'DefaultUserImage', [
    mojo.internal.StructField('index', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 16, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sourceInfo', 24, 0, DeprecatedSourceInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(ProfileImageSpec.$, 'ProfileImage', [], [[0, 8],]);
mojo.internal.Struct(InvalidImageSpec.$, 'InvalidImage', [], [[0, 8],]);
mojo.internal.Struct(AmbientModeAlbumSpec.$, 'AmbientModeAlbum', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('checked', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('description', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('numberOfPhotos', 12, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('topicSource', 32, 0, TopicSourceSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 40, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(WallpaperObserver_OnWallpaperPreviewEnded_ParamsSpec.$, 'WallpaperObserver_OnWallpaperPreviewEnded_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperObserver_OnAttributionChanged_ParamsSpec.$, 'WallpaperObserver_OnAttributionChanged_Params', [
    mojo.internal.StructField('attribution', 0, 0, CurrentAttributionSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperObserver_OnWallpaperChanged_ParamsSpec.$, 'WallpaperObserver_OnWallpaperChanged_Params', [
    mojo.internal.StructField('image', 0, 0, CurrentWallpaperSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_MakeTransparent_ParamsSpec.$, 'WallpaperProvider_MakeTransparent_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_MakeOpaque_ParamsSpec.$, 'WallpaperProvider_MakeOpaque_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_FetchCollections_ParamsSpec.$, 'WallpaperProvider_FetchCollections_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_FetchCollections_ResponseParamsSpec.$, 'WallpaperProvider_FetchCollections_ResponseParams', [
    mojo.internal.StructField('collections', 0, 0, mojo.internal.Array(WallpaperCollectionSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchImagesForCollection_ParamsSpec.$, 'WallpaperProvider_FetchImagesForCollection_Params', [
    mojo.internal.StructField('collectionId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchImagesForCollection_ResponseParamsSpec.$, 'WallpaperProvider_FetchImagesForCollection_ResponseParams', [
    mojo.internal.StructField('images', 0, 0, mojo.internal.Array(WallpaperImageSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosAlbums_ParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosAlbums_Params', [
    mojo.internal.StructField('resumeToken', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosAlbums_ResponseParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosAlbums_ResponseParams', [
    mojo.internal.StructField('response', 0, 0, FetchGooglePhotosAlbumsResponseSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosSharedAlbums_ParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosSharedAlbums_Params', [
    mojo.internal.StructField('resumeToken', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosSharedAlbums_ResponseParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosSharedAlbums_ResponseParams', [
    mojo.internal.StructField('response', 0, 0, FetchGooglePhotosAlbumsResponseSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosEnabled_ParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosEnabled_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosEnabled_ResponseParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosEnabled_ResponseParams', [
    mojo.internal.StructField('state', 0, 0, GooglePhotosEnablementStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosPhotos_ParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosPhotos_Params', [
    mojo.internal.StructField('itemId', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('albumId', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resumeToken', 16, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosPhotos_ResponseParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosPhotos_ResponseParams', [
    mojo.internal.StructField('response', 0, 0, FetchGooglePhotosPhotosResponseSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_GetLocalImages_ParamsSpec.$, 'WallpaperProvider_GetLocalImages_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_GetLocalImages_ResponseParamsSpec.$, 'WallpaperProvider_GetLocalImages_ResponseParams', [
    mojo.internal.StructField('images', 0, 0, mojo.internal.Array(mojoBase_mojom_FilePathSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_GetDefaultImageThumbnail_ParamsSpec.$, 'WallpaperProvider_GetDefaultImageThumbnail_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_GetDefaultImageThumbnail_ResponseParamsSpec.$, 'WallpaperProvider_GetDefaultImageThumbnail_ResponseParams', [
    mojo.internal.StructField('data', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_GetLocalImageThumbnail_ParamsSpec.$, 'WallpaperProvider_GetLocalImageThumbnail_Params', [
    mojo.internal.StructField('filePath', 0, 0, mojoBase_mojom_FilePathSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_GetLocalImageThumbnail_ResponseParamsSpec.$, 'WallpaperProvider_GetLocalImageThumbnail_ResponseParams', [
    mojo.internal.StructField('data', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SetWallpaperObserver_ParamsSpec.$, 'WallpaperProvider_SetWallpaperObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(WallpaperObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SelectWallpaper_ParamsSpec.$, 'WallpaperProvider_SelectWallpaper_Params', [
    mojo.internal.StructField('unitId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('previewMode', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WallpaperProvider_SelectWallpaper_ResponseParamsSpec.$, 'WallpaperProvider_SelectWallpaper_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SelectDefaultImage_ParamsSpec.$, 'WallpaperProvider_SelectDefaultImage_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_SelectDefaultImage_ResponseParamsSpec.$, 'WallpaperProvider_SelectDefaultImage_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SelectLocalImage_ParamsSpec.$, 'WallpaperProvider_SelectLocalImage_Params', [
    mojo.internal.StructField('path', 0, 0, mojoBase_mojom_FilePathSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('layout', 8, 0, WallpaperLayoutSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('previewMode', 12, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WallpaperProvider_SelectLocalImage_ResponseParamsSpec.$, 'WallpaperProvider_SelectLocalImage_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SelectGooglePhotosPhoto_ParamsSpec.$, 'WallpaperProvider_SelectGooglePhotosPhoto_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('layout', 8, 0, WallpaperLayoutSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('previewMode', 12, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WallpaperProvider_SelectGooglePhotosPhoto_ResponseParamsSpec.$, 'WallpaperProvider_SelectGooglePhotosPhoto_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SelectGooglePhotosAlbum_ParamsSpec.$, 'WallpaperProvider_SelectGooglePhotosAlbum_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SelectGooglePhotosAlbum_ResponseParamsSpec.$, 'WallpaperProvider_SelectGooglePhotosAlbum_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ParamsSpec.$, 'WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ResponseParamsSpec.$, 'WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ResponseParams', [
    mojo.internal.StructField('albumId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SetCurrentWallpaperLayout_ParamsSpec.$, 'WallpaperProvider_SetCurrentWallpaperLayout_Params', [
    mojo.internal.StructField('layout', 0, 0, WallpaperLayoutSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SetDailyRefreshCollectionId_ParamsSpec.$, 'WallpaperProvider_SetDailyRefreshCollectionId_Params', [
    mojo.internal.StructField('collectionId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SetDailyRefreshCollectionId_ResponseParamsSpec.$, 'WallpaperProvider_SetDailyRefreshCollectionId_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_GetDailyRefreshCollectionId_ParamsSpec.$, 'WallpaperProvider_GetDailyRefreshCollectionId_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_GetDailyRefreshCollectionId_ResponseParamsSpec.$, 'WallpaperProvider_GetDailyRefreshCollectionId_ResponseParams', [
    mojo.internal.StructField('collectionId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_UpdateDailyRefreshWallpaper_ParamsSpec.$, 'WallpaperProvider_UpdateDailyRefreshWallpaper_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_UpdateDailyRefreshWallpaper_ResponseParamsSpec.$, 'WallpaperProvider_UpdateDailyRefreshWallpaper_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_IsInTabletMode_ParamsSpec.$, 'WallpaperProvider_IsInTabletMode_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_IsInTabletMode_ResponseParamsSpec.$, 'WallpaperProvider_IsInTabletMode_ResponseParams', [
    mojo.internal.StructField('tabletMode', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_ConfirmPreviewWallpaper_ParamsSpec.$, 'WallpaperProvider_ConfirmPreviewWallpaper_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_CancelPreviewWallpaper_ParamsSpec.$, 'WallpaperProvider_CancelPreviewWallpaper_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ParamsSpec.$, 'WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ResponseParamsSpec.$, 'WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ResponseParams', [
    mojo.internal.StructField('shouldShowDialog', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeObserver_OnColorModeChanged_ParamsSpec.$, 'ThemeObserver_OnColorModeChanged_Params', [
    mojo.internal.StructField('darkModeEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeObserver_OnColorModeAutoScheduleChanged_ParamsSpec.$, 'ThemeObserver_OnColorModeAutoScheduleChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeObserver_OnColorSchemeChanged_ParamsSpec.$, 'ThemeObserver_OnColorSchemeChanged_Params', [
    mojo.internal.StructField('colorScheme', 0, 0, ash_style_mojom_ColorSchemeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeObserver_OnSampleColorSchemesChanged_ParamsSpec.$, 'ThemeObserver_OnSampleColorSchemesChanged_Params', [
    mojo.internal.StructField('sampleColorSchemes', 0, 0, mojo.internal.Array(SampleColorSchemeSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeObserver_OnStaticColorChanged_ParamsSpec.$, 'ThemeObserver_OnStaticColorChanged_Params', [
    mojo.internal.StructField('color', 0, 0, skia_mojom_SkColorSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, 'ThemeObserver_OnGeolocationPermissionForSystemServicesChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isUserModifiable', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeObserver_OnDaylightTimeChanged_ParamsSpec.$, 'ThemeObserver_OnDaylightTimeChanged_Params', [
    mojo.internal.StructField('sunriseTime', 0, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sunsetTime', 8, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ThemeProvider_SetThemeObserver_ParamsSpec.$, 'ThemeProvider_SetThemeObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(ThemeObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_SetColorModePref_ParamsSpec.$, 'ThemeProvider_SetColorModePref_Params', [
    mojo.internal.StructField('darkModeEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_SetColorModeAutoScheduleEnabled_ParamsSpec.$, 'ThemeProvider_SetColorModeAutoScheduleEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_SetColorScheme_ParamsSpec.$, 'ThemeProvider_SetColorScheme_Params', [
    mojo.internal.StructField('colorScheme', 0, 0, ash_style_mojom_ColorSchemeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_SetStaticColor_ParamsSpec.$, 'ThemeProvider_SetStaticColor_Params', [
    mojo.internal.StructField('staticColor', 0, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_EnableGeolocationForSystemServices_ParamsSpec.$, 'ThemeProvider_EnableGeolocationForSystemServices_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_GetColorScheme_ParamsSpec.$, 'ThemeProvider_GetColorScheme_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_GetColorScheme_ResponseParamsSpec.$, 'ThemeProvider_GetColorScheme_ResponseParams', [
    mojo.internal.StructField('colorScheme', 0, 0, ash_style_mojom_ColorSchemeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_GetStaticColor_ParamsSpec.$, 'ThemeProvider_GetStaticColor_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_GetStaticColor_ResponseParamsSpec.$, 'ThemeProvider_GetStaticColor_ResponseParams', [
    mojo.internal.StructField('staticColor', 0, 0, skia_mojom_SkColorSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_GenerateSampleColorSchemes_ParamsSpec.$, 'ThemeProvider_GenerateSampleColorSchemes_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_GenerateSampleColorSchemes_ResponseParamsSpec.$, 'ThemeProvider_GenerateSampleColorSchemes_ResponseParams', [
    mojo.internal.StructField('sampleColorSchemes', 0, 0, mojo.internal.Array(SampleColorSchemeSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_IsColorModeAutoScheduleEnabled_ParamsSpec.$, 'ThemeProvider_IsColorModeAutoScheduleEnabled_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_IsColorModeAutoScheduleEnabled_ResponseParamsSpec.$, 'ThemeProvider_IsColorModeAutoScheduleEnabled_ResponseParams', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_IsDarkModeEnabled_ParamsSpec.$, 'ThemeProvider_IsDarkModeEnabled_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_IsDarkModeEnabled_ResponseParamsSpec.$, 'ThemeProvider_IsDarkModeEnabled_ResponseParams', [
    mojo.internal.StructField('darkModeEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, 'ThemeProvider_IsGeolocationEnabledForSystemServices_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, 'ThemeProvider_IsGeolocationEnabledForSystemServices_ResponseParams', [
    mojo.internal.StructField('geolocationEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_IsGeolocationUserModifiable_ParamsSpec.$, 'ThemeProvider_IsGeolocationUserModifiable_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, 'ThemeProvider_IsGeolocationUserModifiable_ResponseParams', [
    mojo.internal.StructField('geolocationIsUserModifiable', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserImageObserver_OnUserImageChanged_ParamsSpec.$, 'UserImageObserver_OnUserImageChanged_Params', [
    mojo.internal.StructField('userImage', 0, 0, UserImageSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(UserImageObserver_OnUserProfileImageUpdated_ParamsSpec.$, 'UserImageObserver_OnUserProfileImageUpdated_Params', [
    mojo.internal.StructField('profileImage', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserImageObserver_OnCameraPresenceCheckDone_ParamsSpec.$, 'UserImageObserver_OnCameraPresenceCheckDone_Params', [
    mojo.internal.StructField('isCameraPresent', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserImageObserver_OnIsEnterpriseManagedChanged_ParamsSpec.$, 'UserImageObserver_OnIsEnterpriseManagedChanged_Params', [
    mojo.internal.StructField('isEnterpriseManaged', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserProvider_SetUserImageObserver_ParamsSpec.$, 'UserProvider_SetUserImageObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(UserImageObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserProvider_GetUserInfo_ParamsSpec.$, 'UserProvider_GetUserInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(UserProvider_GetUserInfo_ResponseParamsSpec.$, 'UserProvider_GetUserInfo_ResponseParams', [
    mojo.internal.StructField('userInfo', 0, 0, UserInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserProvider_GetDefaultUserImages_ParamsSpec.$, 'UserProvider_GetDefaultUserImages_Params', [], [[0, 8],]);
mojo.internal.Struct(UserProvider_GetDefaultUserImages_ResponseParamsSpec.$, 'UserProvider_GetDefaultUserImages_ResponseParams', [
    mojo.internal.StructField('defaultUserImages', 0, 0, mojo.internal.Array(DefaultUserImageSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserProvider_SelectDefaultImage_ParamsSpec.$, 'UserProvider_SelectDefaultImage_Params', [
    mojo.internal.StructField('index', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserProvider_SelectProfileImage_ParamsSpec.$, 'UserProvider_SelectProfileImage_Params', [], [[0, 8],]);
mojo.internal.Struct(UserProvider_SelectCameraImage_ParamsSpec.$, 'UserProvider_SelectCameraImage_Params', [
    mojo.internal.StructField('data', 0, 0, mojoBase_mojom_BigBufferSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(UserProvider_SelectImageFromDisk_ParamsSpec.$, 'UserProvider_SelectImageFromDisk_Params', [], [[0, 8],]);
mojo.internal.Struct(UserProvider_SelectLastExternalUserImage_ParamsSpec.$, 'UserProvider_SelectLastExternalUserImage_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientObserver_OnAmbientModeEnabledChanged_ParamsSpec.$, 'AmbientObserver_OnAmbientModeEnabledChanged_Params', [
    mojo.internal.StructField('ambientModeEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnAmbientThemeChanged_ParamsSpec.$, 'AmbientObserver_OnAmbientThemeChanged_Params', [
    mojo.internal.StructField('ambientTheme', 0, 0, AmbientThemeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnTopicSourceChanged_ParamsSpec.$, 'AmbientObserver_OnTopicSourceChanged_Params', [
    mojo.internal.StructField('topicSource', 0, 0, TopicSourceSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnScreenSaverDurationChanged_ParamsSpec.$, 'AmbientObserver_OnScreenSaverDurationChanged_Params', [
    mojo.internal.StructField('minutes', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnTemperatureUnitChanged_ParamsSpec.$, 'AmbientObserver_OnTemperatureUnitChanged_Params', [
    mojo.internal.StructField('temperatureUnit', 0, 0, TemperatureUnitSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnAlbumsChanged_ParamsSpec.$, 'AmbientObserver_OnAlbumsChanged_Params', [
    mojo.internal.StructField('albums', 0, 0, mojo.internal.Array(AmbientModeAlbumSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnPreviewsFetched_ParamsSpec.$, 'AmbientObserver_OnPreviewsFetched_Params', [
    mojo.internal.StructField('previews', 0, 0, mojo.internal.Array(url_mojom_UrlSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnAmbientUiVisibilityChanged_ParamsSpec.$, 'AmbientObserver_OnAmbientUiVisibilityChanged_Params', [
    mojo.internal.StructField('visibility', 0, 0, AmbientUiVisibilitySpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, 'AmbientObserver_OnGeolocationPermissionForSystemServicesChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isUserModifiable', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnAmbientThemePreviewImagesChanged_ParamsSpec.$, 'AmbientObserver_OnAmbientThemePreviewImagesChanged_Params', [
    mojo.internal.StructField('previews', 0, 0, mojo.internal.Map(AmbientThemeSpec.$, url_mojom_UrlSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_IsAmbientModeEnabled_ParamsSpec.$, 'AmbientProvider_IsAmbientModeEnabled_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_IsAmbientModeEnabled_ResponseParamsSpec.$, 'AmbientProvider_IsAmbientModeEnabled_ResponseParams', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_SetAmbientModeEnabled_ParamsSpec.$, 'AmbientProvider_SetAmbientModeEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_SetAmbientObserver_ParamsSpec.$, 'AmbientProvider_SetAmbientObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(AmbientObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_SetAmbientTheme_ParamsSpec.$, 'AmbientProvider_SetAmbientTheme_Params', [
    mojo.internal.StructField('ambientTheme', 0, 0, AmbientThemeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_SetScreenSaverDuration_ParamsSpec.$, 'AmbientProvider_SetScreenSaverDuration_Params', [
    mojo.internal.StructField('minutes', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_SetTopicSource_ParamsSpec.$, 'AmbientProvider_SetTopicSource_Params', [
    mojo.internal.StructField('topicSource', 0, 0, TopicSourceSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_SetTemperatureUnit_ParamsSpec.$, 'AmbientProvider_SetTemperatureUnit_Params', [
    mojo.internal.StructField('temperatureUnit', 0, 0, TemperatureUnitSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_SetAlbumSelected_ParamsSpec.$, 'AmbientProvider_SetAlbumSelected_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('topicSource', 8, 0, TopicSourceSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('selected', 12, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AmbientProvider_SetPageViewed_ParamsSpec.$, 'AmbientProvider_SetPageViewed_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_FetchSettingsAndAlbums_ParamsSpec.$, 'AmbientProvider_FetchSettingsAndAlbums_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_StartScreenSaverPreview_ParamsSpec.$, 'AmbientProvider_StartScreenSaverPreview_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_ShouldShowTimeOfDayBanner_ParamsSpec.$, 'AmbientProvider_ShouldShowTimeOfDayBanner_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_ShouldShowTimeOfDayBanner_ResponseParamsSpec.$, 'AmbientProvider_ShouldShowTimeOfDayBanner_ResponseParams', [
    mojo.internal.StructField('shouldShowBanner', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_HandleTimeOfDayBannerDismissed_ParamsSpec.$, 'AmbientProvider_HandleTimeOfDayBannerDismissed_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, 'AmbientProvider_IsGeolocationEnabledForSystemServices_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, 'AmbientProvider_IsGeolocationEnabledForSystemServices_ResponseParams', [
    mojo.internal.StructField('geolocationEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_IsGeolocationUserModifiable_ParamsSpec.$, 'AmbientProvider_IsGeolocationUserModifiable_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, 'AmbientProvider_IsGeolocationUserModifiable_ResponseParams', [
    mojo.internal.StructField('geolocationIsUserModifiable', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_EnableGeolocationForSystemServices_ParamsSpec.$, 'AmbientProvider_EnableGeolocationForSystemServices_Params', [], [[0, 8],]);
mojo.internal.Struct(KeyboardBacklightObserver_OnBacklightStateChanged_ParamsSpec.$, 'KeyboardBacklightObserver_OnBacklightStateChanged_Params', [
    mojo.internal.StructField('currentBacklightState', 0, 0, CurrentBacklightStateSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(KeyboardBacklightObserver_OnWallpaperColorChanged_ParamsSpec.$, 'KeyboardBacklightObserver_OnWallpaperColorChanged_Params', [
    mojo.internal.StructField('wallpaperColor', 0, 0, skia_mojom_SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardBacklightProvider_SetKeyboardBacklightObserver_ParamsSpec.$, 'KeyboardBacklightProvider_SetKeyboardBacklightObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(KeyboardBacklightObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardBacklightProvider_SetBacklightColor_ParamsSpec.$, 'KeyboardBacklightProvider_SetBacklightColor_Params', [
    mojo.internal.StructField('backlightColor', 0, 0, BacklightColorSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardBacklightProvider_SetBacklightZoneColor_ParamsSpec.$, 'KeyboardBacklightProvider_SetBacklightZoneColor_Params', [
    mojo.internal.StructField('zone', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('backlightColor', 4, 0, BacklightColorSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardBacklightProvider_ShouldShowNudge_ParamsSpec.$, 'KeyboardBacklightProvider_ShouldShowNudge_Params', [], [[0, 8],]);
mojo.internal.Struct(KeyboardBacklightProvider_ShouldShowNudge_ResponseParamsSpec.$, 'KeyboardBacklightProvider_ShouldShowNudge_ResponseParams', [
    mojo.internal.StructField('shouldShowNudge', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardBacklightProvider_HandleNudgeShown_ParamsSpec.$, 'KeyboardBacklightProvider_HandleNudgeShown_Params', [], [[0, 8],]);
mojo.internal.Union(UserImageSpec.$, 'UserImage', {
    'defaultImage': {
        'ordinal': 0,
        'type': DefaultUserImageSpec.$,
    },
    'externalImage': {
        'ordinal': 1,
        'type': mojoBase_mojom_BigBufferSpec.$,
    },
    'profileImage': {
        'ordinal': 2,
        'type': ProfileImageSpec.$,
    },
    'invalidImage': {
        'ordinal': 3,
        'type': InvalidImageSpec.$,
    },
});
export var UserImageFieldTags;
(function (UserImageFieldTags) {
    UserImageFieldTags[UserImageFieldTags["DEFAULT_IMAGE"] = 0] = "DEFAULT_IMAGE";
    UserImageFieldTags[UserImageFieldTags["EXTERNAL_IMAGE"] = 1] = "EXTERNAL_IMAGE";
    UserImageFieldTags[UserImageFieldTags["PROFILE_IMAGE"] = 2] = "PROFILE_IMAGE";
    UserImageFieldTags[UserImageFieldTags["INVALID_IMAGE"] = 3] = "INVALID_IMAGE";
})(UserImageFieldTags || (UserImageFieldTags = {}));
export function whichUserImage(u) {
    if (u.defaultImage !== null && u.defaultImage !== undefined) {
        return UserImageFieldTags.DEFAULT_IMAGE;
    }
    if (u.externalImage !== null && u.externalImage !== undefined) {
        return UserImageFieldTags.EXTERNAL_IMAGE;
    }
    if (u.profileImage !== null && u.profileImage !== undefined) {
        return UserImageFieldTags.PROFILE_IMAGE;
    }
    if (u.invalidImage !== null && u.invalidImage !== undefined) {
        return UserImageFieldTags.INVALID_IMAGE;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(CurrentBacklightStateSpec.$, 'CurrentBacklightState', {
    'color': {
        'ordinal': 0,
        'type': BacklightColorSpec.$,
    },
    'zoneColors': {
        'ordinal': 1,
        'type': mojo.internal.Array(BacklightColorSpec.$, false),
    },
});
export var CurrentBacklightStateFieldTags;
(function (CurrentBacklightStateFieldTags) {
    CurrentBacklightStateFieldTags[CurrentBacklightStateFieldTags["COLOR"] = 0] = "COLOR";
    CurrentBacklightStateFieldTags[CurrentBacklightStateFieldTags["ZONE_COLORS"] = 1] = "ZONE_COLORS";
})(CurrentBacklightStateFieldTags || (CurrentBacklightStateFieldTags = {}));
export function whichCurrentBacklightState(u) {
    if (u.color !== null && u.color !== undefined) {
        return CurrentBacklightStateFieldTags.COLOR;
    }
    if (u.zoneColors !== null && u.zoneColors !== undefined) {
        return CurrentBacklightStateFieldTags.ZONE_COLORS;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
