// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_icon_button/cr_icon_button.js";import"chrome://resources/ash/common/cr_elements/cr_icons.css.js";import"chrome://resources/ash/common/cr_elements/icons.html.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"chrome://resources/polymer/v3_0/iron-media-query/iron-media-query.js";import"chrome://resources/polymer/v3_0/paper-progress/paper-progress.js";import"./icons.html.js";import"./print_management_fonts.css.js";import"./print_management_shared.css.js";import"/strings.m.js";import{FocusRowMixin}from"chrome://resources/ash/common/cr_elements/focus_row_mixin.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{assert,assertNotReached}from"chrome://resources/js/assert.js";import{IronA11yAnnouncer}from"chrome://resources/polymer/v3_0/iron-a11y-announcer/iron-a11y-announcer.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getMetadataProvider}from"./mojo_interface_provider.js";import{getTemplate}from"./print_job_entry.html.js";import{PrinterErrorCode,PrintJobCompletionStatus}from"./printing_manager.mojom-webui.js";const GENERIC_FILE_EXTENSION_ICON="print-management:file-generic";const ICON_CLASS_MAP=new Map([["print-management:file-gdoc","file-icon-blue"],["print-management:file-word","file-icon-blue"],["print-management:file-generic","file-icon-gray"],["print-management:file-excel","file-icon-green"],["print-management:file-gform","file-icon-green"],["print-management:file-gsheet","file-icon-green"],["print-management:file-image","file-icon-red"],["print-management:file-gdraw","file-icon-red"],["print-management:file-gslide","file-icon-yellow"],["print-management:file-pdf","file-icon-red"],["print-management:file-ppt","file-icon-red"]]);function convertMojoTimeToJS(mojoTime){const windowsEpoch=Date.UTC(1601,0,1,0,0,0,0);const unixEpoch=Date.UTC(1970,0,1,0,0,0,0);const epochDeltaInMs=unixEpoch-windowsEpoch;const timeInMs=Number(mojoTime.internalValue)/1e3;return new Date(timeInMs-epochDeltaInMs)}function isToday(date){const todayDate=new Date;return date.getDate()===todayDate.getDate()&&date.getMonth()===todayDate.getMonth()&&date.getFullYear()===todayDate.getFullYear()}function getFileExtensionIconName(fileName){const ext=fileName.split(".").pop();if(ext===fileName||!ext){return""}switch(ext){case"pdf":case"xps":return"print-management:file-pdf";case"doc":case"docx":case"docm":return"print-management:file-word";case"png":case"jpeg":case"gif":case"raw":case"heic":case"svg":return"print-management:file-image";case"ppt":case"pptx":case"pptm":return"print-management:file-ppt";case"xlsx":case"xltx":case"xlr":return"print-management:file-excel";default:return GENERIC_FILE_EXTENSION_ICON}}function getGFileIconName(fileName){const ext=fileName.split("-").pop();if(ext===fileName||!ext){return""}const gExt=ext.substring(1);switch(gExt){case"Google Docs":return"print-management:file-gdoc";case"Google Sheets":return"print-management:file-gsheet";case"Google Forms":return"print-management:file-gform";case"Google Drawings":return"print-management:file-gdraw";case"Google Slides":return"print-management:file-gslide";default:return""}}const PrintJobEntryElementBase=FocusRowMixin(I18nMixin(PolymerElement));export class PrintJobEntryElement extends PrintJobEntryElementBase{static get is(){return"print-job-entry"}static get template(){return getTemplate()}static get properties(){return{jobEntry:{type:Object},jobTitle:{type:String,computed:"computeJobTitle(jobEntry.title)"},printerName:{type:String,computed:"computePrinterName(jobEntry.printerName)"},creationTime:{type:String,computed:"computeDate(jobEntry.creationTime)"},completionStatus:{type:String,computed:"computeCompletionStatus(jobEntry.completedInfo)"},ongoingErrorStatus:{type:String,computed:"getOngoingErrorStatus(jobEntry.printerErrorCode)"},readableProgress:{type:String,computed:"computeReadableProgress(jobEntry.activePrintJobInfo)"},jobEntryAriaLabel:{type:String,computed:"getJobEntryAriaLabel(jobEntry, jobTitle, printerName, "+"creationTime, completionStatus, "+"jobEntry.activePrintJobinfo.printedPages, jobEntry.numberOfPages)"},showFullOngoingStatus:Boolean,fileIcon:{type:String,computed:"computeFileIcon(jobTitle)"},fileIconClass:{type:String,computed:"computeFileIconClass(fileIcon)"}}}static get observers(){return["printJobEntryDataChanged(jobTitle, printerName, creationTime, "+"completionStatus)"]}constructor(){super();this.mojoInterfaceProvider=getMetadataProvider();this.addEventListener("click",(()=>this.onClick()))}getFileIconClass(){return this.fileIconClass}printJobEntryDataChanged(){if(!this.shadowRoot){return}Array.from(this.shadowRoot.querySelectorAll(".overflow-ellipsis")).forEach((e=>{if(e.offsetWidth<e.scrollWidth){e.setAttribute("title",e.textContent||"")}else{e.removeAttribute("title")}}))}onClick(){if(!this.shadowRoot){return}if(this.isCompletedPrintJob()){this.shadowRoot.querySelector("#completionStatus")?.focus();return}this.shadowRoot.querySelector("#cancelPrintJobButton")?.focus()}connectedCallback(){super.connectedCallback();IronA11yAnnouncer.requestAvailability()}computeCompletionStatus(){if(!this.jobEntry.completedInfo){return""}return this.convertStatusToString(this.jobEntry.completedInfo.completionStatus)}computeReadableProgress(){if(!this.jobEntry.activePrintJobInfo){return""}return loadTimeData.getStringF("printedPagesFraction",this.jobEntry.activePrintJobInfo.printedPages.toString(),this.jobEntry.numberOfPages.toString())}onCancelPrintJobClicked(){this.mojoInterfaceProvider.cancelPrintJob(this.jobEntry.id).then((()=>this.onPrintJobCanceled()))}onPrintJobCanceled(){this.dispatchEvent(new CustomEvent("iron-announce",{bubbles:true,composed:true,detail:{text:loadTimeData.getStringF("cancelledPrintJob",this.jobTitle)}}));this.dispatchEvent(new CustomEvent("remove-print-job",{bubbles:true,composed:true,detail:this.jobEntry.id}))}computeJobTitle(title){return title}computePrinterName(printerName){return printerName}computeDate(mojoTime){const jsDate=convertMojoTimeToJS(mojoTime);if(isToday(jsDate)){return jsDate.toLocaleTimeString(undefined,{hour:"numeric",minute:"numeric"})}return jsDate.toLocaleDateString(undefined,{month:"short",day:"numeric",year:"numeric"})}convertStatusToString(mojoCompletionStatus){switch(mojoCompletionStatus){case PrintJobCompletionStatus.kFailed:return this.getFailedStatusString(this.jobEntry.printerErrorCode);case PrintJobCompletionStatus.kCanceled:return loadTimeData.getString("completionStatusCanceled");case PrintJobCompletionStatus.kPrinted:return loadTimeData.getString("completionStatusPrinted");default:assertNotReached()}}isCompletedPrintJob(){return!!this.jobEntry.completedInfo&&!this.jobEntry.activePrintJobInfo}getJobEntryAriaLabel(){if(!this.jobEntry||this.jobEntry.numberOfPages===undefined||this.printerName===undefined||this.jobTitle===undefined||!this.creationTime){return""}assert(this.completionStatus?!this.jobEntry.activePrintJobInfo:this.jobEntry.activePrintJobInfo);if(this.isCompletedPrintJob()){return loadTimeData.getStringF("completePrintJobLabel",this.jobTitle,this.printerName,this.creationTime,this.completionStatus)}if(this.ongoingErrorStatus){return loadTimeData.getStringF("stoppedOngoingPrintJobLabel",this.jobTitle,this.printerName,this.creationTime,this.ongoingErrorStatus)}return loadTimeData.getStringF("ongoingPrintJobLabel",this.jobTitle,this.printerName,this.creationTime,this.jobEntry.activePrintJobInfo?this.jobEntry.activePrintJobInfo.printedPages.toString():"",this.jobEntry.numberOfPages.toString())}computePrintPagesProgress(printedPages,totalPages){assert(printedPages>=0);if(totalPages<=0){console.error("Total pages should be > 0. totalPages: "+totalPages)}assert(totalPages>0);if(printedPages>totalPages){console.error("Total pages should be more than printed pages. totalPages: "+totalPages+" printedPages: "+printedPages)}assert(printedPages<=totalPages);return printedPages*100/totalPages}computeFileIcon(){const fileExtension=getFileExtensionIconName(this.jobTitle);if(fileExtension&&fileExtension!==GENERIC_FILE_EXTENSION_ICON){return fileExtension}const gfileExtension=getGFileIconName(this.jobTitle);if(gfileExtension){return gfileExtension}return GENERIC_FILE_EXTENSION_ICON}computeFileIconClass(){const iconClass=ICON_CLASS_MAP.get(this.fileIcon);return`flex-center ${iconClass}`}getFailedStatusString(mojoPrinterErrorCode){switch(mojoPrinterErrorCode){case PrinterErrorCode.kNoError:return loadTimeData.getString("completionStatusPrinted");case PrinterErrorCode.kPaperJam:return loadTimeData.getString("paperJam");case PrinterErrorCode.kOutOfPaper:return loadTimeData.getString("outOfPaper");case PrinterErrorCode.kOutOfInk:return loadTimeData.getString("outOfInk");case PrinterErrorCode.kDoorOpen:return loadTimeData.getString("doorOpen");case PrinterErrorCode.kPrinterUnreachable:return loadTimeData.getString("printerUnreachable");case PrinterErrorCode.kTrayMissing:return loadTimeData.getString("trayMissing");case PrinterErrorCode.kOutputFull:return loadTimeData.getString("outputFull");case PrinterErrorCode.kStopped:return loadTimeData.getString("stopped");case PrinterErrorCode.kFilterFailed:return loadTimeData.getString("filterFailed");case PrinterErrorCode.kUnknownError:return loadTimeData.getString("unknownPrinterError");case PrinterErrorCode.kClientUnauthorized:return loadTimeData.getString("clientUnauthorized");case PrinterErrorCode.kExpiredCertificate:return loadTimeData.getString("expiredCertificate");default:assertNotReached()}}getOngoingErrorStatus(mojoPrinterErrorCode){if(this.isCompletedPrintJob()){return""}switch(mojoPrinterErrorCode){case PrinterErrorCode.kNoError:return"";case PrinterErrorCode.kPaperJam:return loadTimeData.getString("paperJamStopped");case PrinterErrorCode.kOutOfPaper:return loadTimeData.getString("outOfPaperStopped");case PrinterErrorCode.kOutOfInk:return loadTimeData.getString("outOfInkStopped");case PrinterErrorCode.kDoorOpen:return loadTimeData.getString("doorOpenStopped");case PrinterErrorCode.kTrayMissing:return loadTimeData.getString("trayMissingStopped");case PrinterErrorCode.kOutputFull:return loadTimeData.getString("outputFullStopped");case PrinterErrorCode.kStopped:return loadTimeData.getString("stoppedGeneric");case PrinterErrorCode.kFilterFailed:return loadTimeData.getString("filterFailed");case PrinterErrorCode.kUnknownError:return loadTimeData.getString("unknownPrinterErrorStopped");case PrinterErrorCode.kClientUnauthorized:return loadTimeData.getString("clientUnauthorized");case PrinterErrorCode.kExpiredCertificate:return loadTimeData.getString("expiredCertificate");case PrinterErrorCode.kPrinterUnreachable:return loadTimeData.getString("printerUnreachableStopped");default:assertNotReached()}}}customElements.define(PrintJobEntryElement.is,PrintJobEntryElement);