// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/icons.html.js";import"chrome://resources/ash/common/cr_elements/policy/cr_policy_indicator.js";import"chrome://resources/ash/common/cr_elements/cr_shared_style.css.js";import"chrome://resources/polymer/v3_0/iron-list/iron-list.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"chrome://resources/polymer/v3_0/paper-tooltip/paper-tooltip.js";import"./print_job_clear_history_dialog.js";import"./print_job_entry.js";import"./print_management_fonts.css.js";import"./print_management_shared.css.js";import"./printer_setup_info.js";import"/strings.m.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{ColorChangeUpdater}from"chrome://resources/cr_components/color_change_listener/colors_css_updater.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getMetadataProvider,getPrintManagementHandler}from"./mojo_interface_provider.js";import{getTemplate}from"./print_management.html.js";import{ActivePrintJobState,LaunchSource,PrintJobsObserverReceiver}from"./printing_manager.mojom-webui.js";const METADATA_STORED_INDEFINITELY=-1;const METADATA_STORED_FOR_ONE_DAY=1;const METADATA_NOT_STORED=0;function comparePrintJobsReverseChronologically(first,second){return-comparePrintJobsChronologically(first,second)}function comparePrintJobsChronologically(first,second){return Number(first.creationTime.internalValue)-Number(second.creationTime.internalValue)}const PrintManagementElementBase=I18nMixin(PolymerElement);export class PrintManagementElement extends PrintManagementElementBase{static get is(){return"print-management"}static get template(){return getTemplate()}static get properties(){return{printJobs:{type:Array,value:()=>[]},printJobHistoryExpirationPeriod:{type:String,value:""},activeHistoryInfoIcon:{type:String,value:""},isPolicyControlled:{type:Boolean,value:false},ongoingPrintJobs:{type:Array,value:()=>[]},lastFocused:Object,listBlurred:Boolean,showClearAllButton:{type:Boolean,value:false,reflectToAttribute:true},showClearAllDialog:{type:Boolean,value:false},deletePrintJobHistoryAllowedByPolicy:{type:Boolean,value:true},shouldDisableClearAllButton:{type:Boolean,computed:"computeShouldDisableClearAllButton(printJobs,"+"deletePrintJobHistoryAllowedByPolicy)"},printJobsObserverReceiver:{type:Object},printJobsLoaded:Boolean}}static get observers(){return["onClearAllButtonUpdated(shouldDisableClearAllButton)"]}constructor(){super();this.printJobsLoaded=false;this.mojoInterfaceProvider=getMetadataProvider();this.pageHandler=getPrintManagementHandler();window.CrPolicyStrings={controlledSettingPolicy:loadTimeData.getString("clearAllPrintJobPolicyIndicatorToolTip")};this.addEventListener("all-history-cleared",(()=>this.getPrintJobs()));this.addEventListener("remove-print-job",(e=>this.removePrintJob(e)))}connectedCallback(){super.connectedCallback();this.getPrintJobHistoryExpirationPeriod();this.startObservingPrintJobs();this.fetchDeletePrintJobHistoryPolicy();ColorChangeUpdater.forDocument().start()}disconnectedCallback(){super.disconnectedCallback();this.printJobsObserverReceiver.$.close()}startObservingPrintJobs(){this.printJobsObserverReceiver=new PrintJobsObserverReceiver(this);this.mojoInterfaceProvider.observePrintJobs(this.printJobsObserverReceiver.$.bindNewPipeAndPassRemote()).then((()=>{this.getPrintJobs()}))}fetchDeletePrintJobHistoryPolicy(){this.mojoInterfaceProvider.getDeletePrintJobHistoryAllowedByPolicy().then((param=>{this.onGetDeletePrintHistoryPolicy(param)}))}onGetDeletePrintHistoryPolicy(responseParam){this.showClearAllButton=true;this.deletePrintJobHistoryAllowedByPolicy=responseParam.isAllowedByPolicy}onAllPrintJobsDeleted(){this.getPrintJobs()}onPrintJobUpdate(job){assert(job.activePrintJobInfo);const idx=this.getIndexOfOngoingPrintJob(job.id);if(idx!==-1){this.splice("ongoingPrintJobs",idx,1,job)}else{this.push("ongoingPrintJobs",job)}if(job.activePrintJobInfo?.activeState===ActivePrintJobState.kDocumentDone){this.getPrintJobs()}}onPrintJobsReceived(jobs,requestStartTime){if(!this.printJobsLoaded){this.printJobsLoaded=true}const ongoingList=[];const historyList=[];for(const job of jobs.printJobs){if(job.activePrintJobInfo){ongoingList.push(job)}else{historyList.push(job)}}this.ongoingPrintJobs=ongoingList.sort(comparePrintJobsChronologically);this.printJobs=historyList.sort(comparePrintJobsReverseChronologically);this.pageHandler.recordGetPrintJobsRequestDuration(Date.now()-requestStartTime)}getPrintJobs(){const requestStartTime=Date.now();this.mojoInterfaceProvider.getPrintJobs().then((jobs=>this.onPrintJobsReceived(jobs,requestStartTime)))}onPrintJobHistoryExpirationPeriodReceived(printJobPolicyInfo){const expirationPeriod=printJobPolicyInfo.expirationPeriodInDays;if(expirationPeriod===METADATA_NOT_STORED){return}this.isPolicyControlled=printJobPolicyInfo.isFromPolicy;this.activeHistoryInfoIcon=this.isPolicyControlled?"enterpriseIcon":"infoIcon";switch(expirationPeriod){case METADATA_STORED_INDEFINITELY:this.printJobHistoryExpirationPeriod=loadTimeData.getString("printJobHistoryIndefinitePeriod");break;case METADATA_STORED_FOR_ONE_DAY:this.printJobHistoryExpirationPeriod=loadTimeData.getString("printJobHistorySingleDay");break;default:this.printJobHistoryExpirationPeriod=loadTimeData.getStringF("printJobHistoryExpirationPeriod",expirationPeriod)}}getPrintJobHistoryExpirationPeriod(){this.mojoInterfaceProvider.getPrintJobHistoryExpirationPeriod().then(this.onPrintJobHistoryExpirationPeriodReceived.bind(this))}removePrintJob(e){this.printJobsLoaded=false;const idx=this.getIndexOfOngoingPrintJob(e.detail);if(idx!==-1){this.splice("ongoingPrintJobs",idx,1)}}onClearHistoryClicked(){this.showClearAllDialog=true}onClearHistoryDialogClosed(){this.showClearAllDialog=false}getIndexOfOngoingPrintJob(expectedId){return this.ongoingPrintJobs.findIndex((arrJob=>arrJob.id===expectedId))}computeShouldDisableClearAllButton(){return!this.deletePrintJobHistoryAllowedByPolicy||!this.printJobs.length}onClearAllButtonUpdated(){this.$.deleteIcon.classList.toggle("delete-enabled",!this.shouldDisableClearAllButton);this.$.deleteIcon.classList.toggle("delete-disabled",this.shouldDisableClearAllButton)}shouldShowSetupAssistance(){return this.printJobsLoaded&&this.ongoingPrintJobs.length===0&&this.printJobs.length===0}shouldShowOngoingEmptyState(){return this.printJobs.length>0&&this.ongoingPrintJobs.length===0}shouldShowManagePrinterButton(){return this.ongoingPrintJobs.length>0||this.printJobs.length>0}onManagePrintersClicked(){this.pageHandler.launchPrinterSettings(LaunchSource.kHeaderButton)}}customElements.define(PrintManagementElement.is,PrintManagementElement);