// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{String16Spec as mojoBase_mojom_String16Spec}from"//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js";import{TimeSpec as mojoBase_mojom_TimeSpec}from"//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js";import{UrlSpec as url_mojom_UrlSpec}from"//resources/mojo/url/mojom/url.mojom-webui.js";export const PrintJobCompletionStatusSpec={$:mojo.internal.Enum()};export var PrintJobCompletionStatus;(function(PrintJobCompletionStatus){PrintJobCompletionStatus[PrintJobCompletionStatus["MIN_VALUE"]=0]="MIN_VALUE";PrintJobCompletionStatus[PrintJobCompletionStatus["MAX_VALUE"]=2]="MAX_VALUE";PrintJobCompletionStatus[PrintJobCompletionStatus["kFailed"]=0]="kFailed";PrintJobCompletionStatus[PrintJobCompletionStatus["kCanceled"]=1]="kCanceled";PrintJobCompletionStatus[PrintJobCompletionStatus["kPrinted"]=2]="kPrinted"})(PrintJobCompletionStatus||(PrintJobCompletionStatus={}));export const PrinterErrorCodeSpec={$:mojo.internal.Enum()};export var PrinterErrorCode;(function(PrinterErrorCode){PrinterErrorCode[PrinterErrorCode["MIN_VALUE"]=0]="MIN_VALUE";PrinterErrorCode[PrinterErrorCode["MAX_VALUE"]=12]="MAX_VALUE";PrinterErrorCode[PrinterErrorCode["kNoError"]=0]="kNoError";PrinterErrorCode[PrinterErrorCode["kPaperJam"]=1]="kPaperJam";PrinterErrorCode[PrinterErrorCode["kOutOfPaper"]=2]="kOutOfPaper";PrinterErrorCode[PrinterErrorCode["kOutOfInk"]=3]="kOutOfInk";PrinterErrorCode[PrinterErrorCode["kDoorOpen"]=4]="kDoorOpen";PrinterErrorCode[PrinterErrorCode["kPrinterUnreachable"]=5]="kPrinterUnreachable";PrinterErrorCode[PrinterErrorCode["kTrayMissing"]=6]="kTrayMissing";PrinterErrorCode[PrinterErrorCode["kOutputFull"]=7]="kOutputFull";PrinterErrorCode[PrinterErrorCode["kStopped"]=8]="kStopped";PrinterErrorCode[PrinterErrorCode["kFilterFailed"]=9]="kFilterFailed";PrinterErrorCode[PrinterErrorCode["kUnknownError"]=10]="kUnknownError";PrinterErrorCode[PrinterErrorCode["kClientUnauthorized"]=11]="kClientUnauthorized";PrinterErrorCode[PrinterErrorCode["kExpiredCertificate"]=12]="kExpiredCertificate"})(PrinterErrorCode||(PrinterErrorCode={}));export const ActivePrintJobStateSpec={$:mojo.internal.Enum()};export var ActivePrintJobState;(function(ActivePrintJobState){ActivePrintJobState[ActivePrintJobState["MIN_VALUE"]=0]="MIN_VALUE";ActivePrintJobState[ActivePrintJobState["MAX_VALUE"]=1]="MAX_VALUE";ActivePrintJobState[ActivePrintJobState["kStarted"]=0]="kStarted";ActivePrintJobState[ActivePrintJobState["kDocumentDone"]=1]="kDocumentDone"})(ActivePrintJobState||(ActivePrintJobState={}));export const LaunchSourceSpec={$:mojo.internal.Enum()};export var LaunchSource;(function(LaunchSource){LaunchSource[LaunchSource["MIN_VALUE"]=0]="MIN_VALUE";LaunchSource[LaunchSource["MAX_VALUE"]=1]="MAX_VALUE";LaunchSource[LaunchSource["kEmptyStateButton"]=0]="kEmptyStateButton";LaunchSource[LaunchSource["kHeaderButton"]=1]="kHeaderButton"})(LaunchSource||(LaunchSource={}));export class PrintJobsObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"chromeos.printing.printing_manager.mojom.PrintJobsObserver",scope)}}export class PrintJobsObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PrintJobsObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onAllPrintJobsDeleted(){this.proxy.sendMessage(0,PrintJobsObserver_OnAllPrintJobsDeleted_ParamsSpec.$,null,[],false)}onPrintJobUpdate(printJob){this.proxy.sendMessage(1,PrintJobsObserver_OnPrintJobUpdate_ParamsSpec.$,null,[printJob],false)}}export class PrintJobsObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PrintJobsObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PrintJobsObserver_OnAllPrintJobsDeleted_ParamsSpec.$,null,impl.onAllPrintJobsDeleted.bind(impl),false);this.helper_internal_.registerHandler(1,PrintJobsObserver_OnPrintJobUpdate_ParamsSpec.$,null,impl.onPrintJobUpdate.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PrintJobsObserver{static get $interfaceName(){return"chromeos.printing.printing_manager.mojom.PrintJobsObserver"}static getRemote(){let remote=new PrintJobsObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PrintJobsObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PrintJobsObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onAllPrintJobsDeleted=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PrintJobsObserver_OnAllPrintJobsDeleted_ParamsSpec.$,null,this.onAllPrintJobsDeleted.createReceiverHandler(false),false);this.onPrintJobUpdate=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,PrintJobsObserver_OnPrintJobUpdate_ParamsSpec.$,null,this.onPrintJobUpdate.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PrintingMetadataProviderPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"chromeos.printing.printing_manager.mojom.PrintingMetadataProvider",scope)}}export class PrintingMetadataProviderRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PrintingMetadataProviderPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}observePrintJobs(observer){return this.proxy.sendMessage(0,PrintingMetadataProvider_ObservePrintJobs_ParamsSpec.$,PrintingMetadataProvider_ObservePrintJobs_ResponseParamsSpec.$,[observer],false)}getPrintJobs(){return this.proxy.sendMessage(1,PrintingMetadataProvider_GetPrintJobs_ParamsSpec.$,PrintingMetadataProvider_GetPrintJobs_ResponseParamsSpec.$,[],false)}deleteAllPrintJobs(){return this.proxy.sendMessage(2,PrintingMetadataProvider_DeleteAllPrintJobs_ParamsSpec.$,PrintingMetadataProvider_DeleteAllPrintJobs_ResponseParamsSpec.$,[],false)}cancelPrintJob(id){return this.proxy.sendMessage(3,PrintingMetadataProvider_CancelPrintJob_ParamsSpec.$,PrintingMetadataProvider_CancelPrintJob_ResponseParamsSpec.$,[id],false)}getDeletePrintJobHistoryAllowedByPolicy(){return this.proxy.sendMessage(4,PrintingMetadataProvider_GetDeletePrintJobHistoryAllowedByPolicy_ParamsSpec.$,PrintingMetadataProvider_GetDeletePrintJobHistoryAllowedByPolicy_ResponseParamsSpec.$,[],false)}getPrintJobHistoryExpirationPeriod(){return this.proxy.sendMessage(5,PrintingMetadataProvider_GetPrintJobHistoryExpirationPeriod_ParamsSpec.$,PrintingMetadataProvider_GetPrintJobHistoryExpirationPeriod_ResponseParamsSpec.$,[],false)}}export class PrintingMetadataProviderReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PrintingMetadataProviderRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PrintingMetadataProvider_ObservePrintJobs_ParamsSpec.$,PrintingMetadataProvider_ObservePrintJobs_ResponseParamsSpec.$,impl.observePrintJobs.bind(impl),false);this.helper_internal_.registerHandler(1,PrintingMetadataProvider_GetPrintJobs_ParamsSpec.$,PrintingMetadataProvider_GetPrintJobs_ResponseParamsSpec.$,impl.getPrintJobs.bind(impl),false);this.helper_internal_.registerHandler(2,PrintingMetadataProvider_DeleteAllPrintJobs_ParamsSpec.$,PrintingMetadataProvider_DeleteAllPrintJobs_ResponseParamsSpec.$,impl.deleteAllPrintJobs.bind(impl),false);this.helper_internal_.registerHandler(3,PrintingMetadataProvider_CancelPrintJob_ParamsSpec.$,PrintingMetadataProvider_CancelPrintJob_ResponseParamsSpec.$,impl.cancelPrintJob.bind(impl),false);this.helper_internal_.registerHandler(4,PrintingMetadataProvider_GetDeletePrintJobHistoryAllowedByPolicy_ParamsSpec.$,PrintingMetadataProvider_GetDeletePrintJobHistoryAllowedByPolicy_ResponseParamsSpec.$,impl.getDeletePrintJobHistoryAllowedByPolicy.bind(impl),false);this.helper_internal_.registerHandler(5,PrintingMetadataProvider_GetPrintJobHistoryExpirationPeriod_ParamsSpec.$,PrintingMetadataProvider_GetPrintJobHistoryExpirationPeriod_ResponseParamsSpec.$,impl.getPrintJobHistoryExpirationPeriod.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PrintingMetadataProvider{static get $interfaceName(){return"chromeos.printing.printing_manager.mojom.PrintingMetadataProvider"}static getRemote(){let remote=new PrintingMetadataProviderRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PrintingMetadataProviderCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PrintingMetadataProviderRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.observePrintJobs=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PrintingMetadataProvider_ObservePrintJobs_ParamsSpec.$,PrintingMetadataProvider_ObservePrintJobs_ResponseParamsSpec.$,this.observePrintJobs.createReceiverHandler(true),false);this.getPrintJobs=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,PrintingMetadataProvider_GetPrintJobs_ParamsSpec.$,PrintingMetadataProvider_GetPrintJobs_ResponseParamsSpec.$,this.getPrintJobs.createReceiverHandler(true),false);this.deleteAllPrintJobs=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,PrintingMetadataProvider_DeleteAllPrintJobs_ParamsSpec.$,PrintingMetadataProvider_DeleteAllPrintJobs_ResponseParamsSpec.$,this.deleteAllPrintJobs.createReceiverHandler(true),false);this.cancelPrintJob=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,PrintingMetadataProvider_CancelPrintJob_ParamsSpec.$,PrintingMetadataProvider_CancelPrintJob_ResponseParamsSpec.$,this.cancelPrintJob.createReceiverHandler(true),false);this.getDeletePrintJobHistoryAllowedByPolicy=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,PrintingMetadataProvider_GetDeletePrintJobHistoryAllowedByPolicy_ParamsSpec.$,PrintingMetadataProvider_GetDeletePrintJobHistoryAllowedByPolicy_ResponseParamsSpec.$,this.getDeletePrintJobHistoryAllowedByPolicy.createReceiverHandler(true),false);this.getPrintJobHistoryExpirationPeriod=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,PrintingMetadataProvider_GetPrintJobHistoryExpirationPeriod_ParamsSpec.$,PrintingMetadataProvider_GetPrintJobHistoryExpirationPeriod_ResponseParamsSpec.$,this.getPrintJobHistoryExpirationPeriod.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PrintManagementHandlerPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"chromeos.printing.printing_manager.mojom.PrintManagementHandler",scope)}}export class PrintManagementHandlerRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PrintManagementHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}launchPrinterSettings(source){this.proxy.sendMessage(0,PrintManagementHandler_LaunchPrinterSettings_ParamsSpec.$,null,[source],false)}recordGetPrintJobsRequestDuration(duration){this.proxy.sendMessage(1,PrintManagementHandler_RecordGetPrintJobsRequestDuration_ParamsSpec.$,null,[duration],false)}}export class PrintManagementHandlerReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PrintManagementHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PrintManagementHandler_LaunchPrinterSettings_ParamsSpec.$,null,impl.launchPrinterSettings.bind(impl),false);this.helper_internal_.registerHandler(1,PrintManagementHandler_RecordGetPrintJobsRequestDuration_ParamsSpec.$,null,impl.recordGetPrintJobsRequestDuration.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PrintManagementHandler{static get $interfaceName(){return"chromeos.printing.printing_manager.mojom.PrintManagementHandler"}static getRemote(){let remote=new PrintManagementHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PrintManagementHandlerCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PrintManagementHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.launchPrinterSettings=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PrintManagementHandler_LaunchPrinterSettings_ParamsSpec.$,null,this.launchPrinterSettings.createReceiverHandler(false),false);this.recordGetPrintJobsRequestDuration=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,PrintManagementHandler_RecordGetPrintJobsRequestDuration_ParamsSpec.$,null,this.recordGetPrintJobsRequestDuration.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const CompletedPrintJobInfoSpec={$:{}};export const ActivePrintJobInfoSpec={$:{}};export const PrintJobInfoSpec={$:{}};export const PrintJobsObserver_OnAllPrintJobsDeleted_ParamsSpec={$:{}};export const PrintJobsObserver_OnPrintJobUpdate_ParamsSpec={$:{}};export const PrintingMetadataProvider_ObservePrintJobs_ParamsSpec={$:{}};export const PrintingMetadataProvider_ObservePrintJobs_ResponseParamsSpec={$:{}};export const PrintingMetadataProvider_GetPrintJobs_ParamsSpec={$:{}};export const PrintingMetadataProvider_GetPrintJobs_ResponseParamsSpec={$:{}};export const PrintingMetadataProvider_DeleteAllPrintJobs_ParamsSpec={$:{}};export const PrintingMetadataProvider_DeleteAllPrintJobs_ResponseParamsSpec={$:{}};export const PrintingMetadataProvider_CancelPrintJob_ParamsSpec={$:{}};export const PrintingMetadataProvider_CancelPrintJob_ResponseParamsSpec={$:{}};export const PrintingMetadataProvider_GetDeletePrintJobHistoryAllowedByPolicy_ParamsSpec={$:{}};export const PrintingMetadataProvider_GetDeletePrintJobHistoryAllowedByPolicy_ResponseParamsSpec={$:{}};export const PrintingMetadataProvider_GetPrintJobHistoryExpirationPeriod_ParamsSpec={$:{}};export const PrintingMetadataProvider_GetPrintJobHistoryExpirationPeriod_ResponseParamsSpec={$:{}};export const PrintManagementHandler_LaunchPrinterSettings_ParamsSpec={$:{}};export const PrintManagementHandler_RecordGetPrintJobsRequestDuration_ParamsSpec={$:{}};mojo.internal.Struct(CompletedPrintJobInfoSpec.$,"CompletedPrintJobInfo",[mojo.internal.StructField("completionStatus",0,0,PrintJobCompletionStatusSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ActivePrintJobInfoSpec.$,"ActivePrintJobInfo",[mojo.internal.StructField("printedPages",0,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("activeState",4,0,ActivePrintJobStateSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PrintJobInfoSpec.$,"PrintJobInfo",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("title",8,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("creationTime",16,0,mojoBase_mojom_TimeSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("numberOfPages",24,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("printerId",32,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("printerName",40,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("printerUri",48,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("printerErrorCode",28,0,PrinterErrorCodeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("completedInfo",56,0,CompletedPrintJobInfoSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("activePrintJobInfo",64,0,ActivePrintJobInfoSpec.$,null,true,0,undefined,undefined)],[[0,80]]);mojo.internal.Struct(PrintJobsObserver_OnAllPrintJobsDeleted_ParamsSpec.$,"PrintJobsObserver_OnAllPrintJobsDeleted_Params",[],[[0,8]]);mojo.internal.Struct(PrintJobsObserver_OnPrintJobUpdate_ParamsSpec.$,"PrintJobsObserver_OnPrintJobUpdate_Params",[mojo.internal.StructField("printJob",0,0,PrintJobInfoSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PrintingMetadataProvider_ObservePrintJobs_ParamsSpec.$,"PrintingMetadataProvider_ObservePrintJobs_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(PrintJobsObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PrintingMetadataProvider_ObservePrintJobs_ResponseParamsSpec.$,"PrintingMetadataProvider_ObservePrintJobs_ResponseParams",[],[[0,8]]);mojo.internal.Struct(PrintingMetadataProvider_GetPrintJobs_ParamsSpec.$,"PrintingMetadataProvider_GetPrintJobs_Params",[],[[0,8]]);mojo.internal.Struct(PrintingMetadataProvider_GetPrintJobs_ResponseParamsSpec.$,"PrintingMetadataProvider_GetPrintJobs_ResponseParams",[mojo.internal.StructField("printJobs",0,0,mojo.internal.Array(PrintJobInfoSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PrintingMetadataProvider_DeleteAllPrintJobs_ParamsSpec.$,"PrintingMetadataProvider_DeleteAllPrintJobs_Params",[],[[0,8]]);mojo.internal.Struct(PrintingMetadataProvider_DeleteAllPrintJobs_ResponseParamsSpec.$,"PrintingMetadataProvider_DeleteAllPrintJobs_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PrintingMetadataProvider_CancelPrintJob_ParamsSpec.$,"PrintingMetadataProvider_CancelPrintJob_Params",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PrintingMetadataProvider_CancelPrintJob_ResponseParamsSpec.$,"PrintingMetadataProvider_CancelPrintJob_ResponseParams",[mojo.internal.StructField("attemptedCancel",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PrintingMetadataProvider_GetDeletePrintJobHistoryAllowedByPolicy_ParamsSpec.$,"PrintingMetadataProvider_GetDeletePrintJobHistoryAllowedByPolicy_Params",[],[[0,8]]);mojo.internal.Struct(PrintingMetadataProvider_GetDeletePrintJobHistoryAllowedByPolicy_ResponseParamsSpec.$,"PrintingMetadataProvider_GetDeletePrintJobHistoryAllowedByPolicy_ResponseParams",[mojo.internal.StructField("isAllowedByPolicy",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PrintingMetadataProvider_GetPrintJobHistoryExpirationPeriod_ParamsSpec.$,"PrintingMetadataProvider_GetPrintJobHistoryExpirationPeriod_Params",[],[[0,8]]);mojo.internal.Struct(PrintingMetadataProvider_GetPrintJobHistoryExpirationPeriod_ResponseParamsSpec.$,"PrintingMetadataProvider_GetPrintJobHistoryExpirationPeriod_ResponseParams",[mojo.internal.StructField("expirationPeriodInDays",0,0,mojo.internal.Int16,0,false,0,undefined,undefined),mojo.internal.StructField("isFromPolicy",2,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PrintManagementHandler_LaunchPrinterSettings_ParamsSpec.$,"PrintManagementHandler_LaunchPrinterSettings_Params",[mojo.internal.StructField("source",0,0,LaunchSourceSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PrintManagementHandler_RecordGetPrintJobsRequestDuration_ParamsSpec.$,"PrintManagementHandler_RecordGetPrintJobsRequestDuration_Params",[mojo.internal.StructField("duration",0,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,16]]);