import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="print-management-shared print-management-fonts">:host{color:var(--print-management-default-text-color);font-family:var(--print-management-default-font-family);font-size:var(--print-management-default-font-size);font-weight:var(--print-management-default-font-weight)}:host-context(body.jelly-enabled){--cr-icon-button-focus-outline-color:var(--cros-sys-focus_ring);font:var(--cros-body-2-font)}:host-context(body.jelly-enabled) .list-item:focus-within{background-color:var(--cros-sys-hover_on_subtle)}:host-context(body.jelly-enabled) #numericalProgress{color:var(--cros-sys-primary)}:host-context(body.jelly-enabled) #rowWrapper:active{background-color:var(--cros-sys-hover_on_subtle)}:host-context(body.jelly-enabled) paper-progress{--paper-progress-active-color:var(--cros-sys-primary);--paper-progress-container-color:var(--cros-sys-highlight_shape)}.collapsed-status{color:var(--cros-color-prominent);font-family:var(--print-management-header-font-family);font-size:var(--print-management-header-font-size);font-weight:var(--print-management-header-font-weight)}.list-item:focus,.list-item>:focus{outline:none}.list-item:focus-within{background-color:var(--cros-highlight-color);outline:none}.list-item{min-height:40px;overflow:hidden;padding:0}#cancelPrintJobButton{--cr-icon-button-fill-color:var(--cros-icon-color-primary);margin-inline-start:4px;padding-bottom:2px}#fileIcon{margin-inline-end:16px;min-width:22px}#numericalProgress{color:var(--cros-text-color-prominent);margin-inline-end:16px}#rowWrapper:active{background-color:var(--cros-highlight-color);outline:none}paper-progress{--paper-progress-active-color:var(--cros-slider-color-active);--paper-progress-container-color:var(--cros-slider-track-color-active);width:72px}</style>
<div id="rowWrapper" focus-row-container>
  <!-- TODO(crbug/1073693): Update the a11y based on expert guidance -->
  <div class="list-item flex-center"
      aria-label$="[[jobEntryAriaLabel]]">
    <iron-icon id="fileIcon" class$="[[fileIconClass]]" icon="[[fileIcon]]"
        alt="">
    </iron-icon>
    <div id="jobTitle" class="file-name-column overflow-ellipsis"
        aria-hidden="true">
      [[jobTitle]]
    </div>
    <div id="printerName"
        class="printer-name-column overflow-ellipsis padded-left"
        aria-hidden="true">
      [[printerName]]
    </div>
    <div id="creationTime" class="date-column overflow-ellipsis padded-left"
        aria-hidden="true">
      [[creationTime]]
    </div>

    <template is="dom-if" if="[[isCompletedPrintJob(jobEntry)]]" restamp>
      <div id="completionStatus"
          class="status-column overflow-ellipsis padded-left"
          focus-row-control
          focus-type="completedStatus"
          aria-hidden="true">
        [[completionStatus]]
      </div>
    </template>

    <template is="dom-if" if="[[!isCompletedPrintJob(jobEntry)]]" restamp>
        <iron-media-query query="(min-width: 768px)"
            query-matches="{{showFullOngoingStatus}}">
        </iron-media-query>
        <div id="activeStatusContainer"
            class="status-column padded-left flex-center">
          <!-- Non-error printing status -->
          <template is="dom-if" if="[[!ongoingErrorStatus]]" restamp>
            <template is="dom-if" if="[[showFullOngoingStatus]]">
              <div id="numericalProgress" aria-hidden="true">
                [[readableProgress]]
              </div>
              <paper-progress
                  value="[[computePrintPagesProgress(
                      jobEntry.activePrintJobInfo.printedPages,
                      jobEntry.numberOfPages)]]"
                  aria-hidden="true">
              </paper-progress>
            </template>
            <div class="collapsed-status" hidden="[[showFullOngoingStatus]]"
                aria-hidden="true">
              [[i18n('collapsedPrintingText')]]
            </div>
          </template>
          <!-- Error printing status -->
          <template is="dom-if" if="[[ongoingErrorStatus]]" restamp>
            <div id="ongoingError" class="overflow-ellipsis" aria-hidden="true"
                hidden="[[!showFullOngoingStatus]]">
              [[ongoingErrorStatus]]
            </div>
            <div hidden="[[showFullOngoingStatus]]" aria-hidden="true">
              [[i18n('stoppedGeneric')]]
            </div>
          </template>
          <cr-icon-button id="cancelPrintJobButton"
              iron-icon="print-management:cancel"
              focus-row-control
              focus-type="cancelPrintJob"
              aria-hidden="true"
            on-click="onCancelPrintJobClicked">
          </cr-icon-button>
        </div>
    </template>
  </div>
</div>
<!--_html_template_end_-->`;
}
