import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style print-management-shared print-management-fonts">:host-context(body.jelly-enabled) .column-headers{font:var(--cros-button-2-font)}:host-context(body.jelly-enabled) .column-headers{font:var(--cros-button-2-font)}:host-context(body.jelly-enabled) #clearAllButton{font:var(--cros-button-2-font)}:host-context(body.jelly-enabled) #ongoingEmptyState{font:var(--cros-body-2-font)}:host-context(body.jelly-enabled) #printJobTitle{font:var(--cros-display-6-font)}.column-headers{color:var(--print-management-header-text-color);font-family:var(--print-management-header-font-family);font-size:var(--print-management-header-font-size);font-weight:var(--print-management-header-font-weight);line-height:20px;min-height:var(--cr-section-min-height)}.delete-enabled{--iron-icon-fill-color:var(--cros-icon-color-prominent)}.delete-disabled{--iron-icon-fill-color:var(--cros-icon-color-disabled)}.main-container{--cr-centered-card-max-width:960px}#clearAllButton{font-family:var(--print-management-button-font-family);font-size:var(--print-management-button-font-size);font-weight:var(--print-management-button-font-weight)}#clearAllContainer{column-gap:8px;display:flex}:host-context(body:not(.jelly-enabled)) #deleteIcon{--iron-icon-height:20px;--iron-icon-width:20px;margin-inline-end:4px}#enterpriseIcon{--iron-icon-fill-color:var(--cros-icon-color-secondary);--iron-icon-stroke-color:var(--cros-icon-color-secondary);--iron-icon-height:13px;--iron-icon-width:13px;margin-inline-start:8px}#headerContainer{border-bottom:1px solid var(--cros-separator-color);display:flex;justify-content:space-between;padding-bottom:20px;padding-top:32px}#infoIcon{--iron-icon-fill-color:var(--cros-icon-color-secondary);--iron-icon-stroke-color:var(--cros-icon-color-secondary);--iron-icon-height:13px;--iron-icon-width:13px;margin-inline-start:8px}#printJobTitle{color:var(--print-management-title-text-color);font-family:var(--print-management-title-font-family);font-size:var(--print-management-title-font-size);font-weight:var(--print-management-title-font-weight);line-height:28px;margin:0}#ongoingEmptyState{color:var(--cros-text-color-disabled);margin-inline-start:12px;padding-bottom:24px;padding-top:24px}#policyIcon{margin-inline-end:10px;padding-top:7px}h1{font-size:200%;font-weight:500;margin-bottom:0;margin-top:0}printer-setup-info{align-items:center;flex:1 1 auto;height:100%}</style>

<div class="main-container margin-border">
  <div id="headerContainer">
    <h1 id="printJobTitle">[[i18n('printJobTitle')]]</h1>
    <div id="clearAllContainer">
      <template is="dom-if" if="[[!deletePrintJobHistoryAllowedByPolicy]]">
        <cr-policy-indicator id="policyIcon" indicator-type="userPolicy">
        </cr-policy-indicator>
      </template>
      <cr-button id="clearAllButton" on-click="onClearHistoryClicked"
          disabled="[[shouldDisableClearAllButton]]"
          hidden="[[!showClearAllButton]]">
        <iron-icon id="deleteIcon" icon="print-management:delete"
            slot="prefix-icon">
        </iron-icon>
        [[i18n('clearAllHistoryLabel')]]
      </cr-button>
      <cr-button id="managePrinters" hidden="[[!shouldShowManagePrinterButton(
          ongoingPrintJobs.length, printJobs.length)]]"
          on-click="onManagePrintersClicked">
        <iron-icon id="openInNewIcon" icon="cr:open-in-new" slot="suffix-icon">
        </iron-icon>
        [[i18n('managePrintersButtonLabel')]]
      </cr-button>
    </div>
  </div>

  <template is="dom-if" if="[[showClearAllDialog]]" restamp>
    <print-job-clear-history-dialog id="clearHistoryDialog"
        on-close="onClearHistoryDialogClosed">
    </print-job-clear-history-dialog>
  </template>

  <div class="data-container">
    <div class="column-headers flex-center"
        aria-labelledby="fileNameColumn printerNameColumn dateColumn statusColumn">
      <div id="fileNameColumn" class="file-name-header-column overflow-ellipsis"
          aria-hidden="true">
        [[i18n('fileNameColumn')]]
      </div>
      <div id="printerNameColumn"
          class="printer-name-column overflow-ellipsis padded-left"
          aria-hidden="true">
        [[i18n('printerNameColumn')]]
      </div>
      <div id="dateColumn" class="date-column overflow-ellipsis padded-left"
          aria-hidden="true">
        [[i18n('dateColumn')]]
      </div>
      <div id="statusColumn" class="status-column overflow-ellipsis padded-left"
          aria-hidden="true">
        [[i18n('statusColumn')]]
      </div>
    </div>

    <template is="dom-if" if="[[ongoingPrintJobs.length]]" restamp>
      <iron-list id="ongoingList" items="[[ongoingPrintJobs]]" role="grid">
        <template>
          <print-job-entry job-entry="[[item]]" tabindex$="[[tabIndex]]"
              last-focused="{{lastFocused}}" list-blurred="{{listBlurred}}"
              focus-row-index="[[index]]" iron-list-tab-index="[[tabIndex]]">
          </print-job-entry>
        </template>
      </iron-list>
    </template>

    <div id="ongoingEmptyState" hidden="[[!shouldShowOngoingEmptyState(
          ongoingPrintJobs.length, printJobs.length)]]">
      [[i18n('noPrintJobInProgress')]]
    </div>

    <printer-setup-info hidden="[[!shouldShowSetupAssistance(
        printJobsLoaded, ongoingPrintJobs.length, printJobs.length)]]">
    </printer-setup-info>

    <template is="dom-if" if="[[printJobs.length]]" restamp>
      <div id="historyHeaderContainer" class="column-headers flex-center">
        <div aria-label$="[[printJobHistoryExpirationPeriod]]">
          [[i18n('historyHeader')]]
        </div>
        <iron-icon id="infoIcon" icon="cr:info-outline" aria-hidden="true"
            hidden="[[isPolicyControlled]]">
        </iron-icon>
        <iron-icon id="enterpriseIcon" icon="print-management:enterprise-icon"
            aria-hidden="true" hidden="[[!isPolicyControlled]]">
        </iron-icon>
        <paper-tooltip for="[[activeHistoryInfoIcon]]" fit-to-visible-bounds
            aria-hidden="true">
          [[printJobHistoryExpirationPeriod]]
        </paper-tooltip>
      </div>

      <iron-list id="entryList" items="[[printJobs]]" role="grid">
        <template>
          <print-job-entry job-entry="[[item]]" tabindex$="[[tabIndex]]"
              last-focused="{{lastFocused}}" list-blurred="{{listBlurred}}"
              focus-row-index="[[index]]" iron-list-tab-index="[[tabIndex]]">
          </print-job-entry>
        </template>
      </iron-list>
    </template>
  </div>
</div>
<!--_html_template_end_-->`;
}
