// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{EventTracker}from"chrome://resources/js/event_tracker.js";import{PrinterType}from"../../print.mojom-webui.js";import{createCustomEvent}from"../utils/event_utils.js";import{getDestinationProvider}from"../utils/mojo_data_providers.js";import{DESTINATION_MANAGER_ACTIVE_DESTINATION_CHANGED,DestinationManager}from"./destination_manager.js";export const CAPABILITIES_MANAGER_SESSION_INITIALIZED="capabilities-manager.session-initialized";export const CAPABILITIES_MANAGER_ACTIVE_DESTINATION_CAPS_LOADING="capabilities-manager.active-destination-caps-loading";export const CAPABILITIES_MANAGER_ACTIVE_DESTINATION_CAPS_READY="capabilities-manager.active-destination-caps-ready";export class CapabilitiesManager extends EventTarget{static{this.instance=null}static getInstance(){if(CapabilitiesManager.instance===null){CapabilitiesManager.instance=new CapabilitiesManager}return CapabilitiesManager.instance}static resetInstanceForTesting(){CapabilitiesManager.instance=null}constructor(){super();this.eventTracker=new EventTracker;this.destinationManager=DestinationManager.getInstance();this.capabilitiesCache=new Map;this.activeDestinationCapabilitiesLoaded=false;this.destinationProvider=getDestinationProvider();this.eventTracker.add(this.destinationManager,DESTINATION_MANAGER_ACTIVE_DESTINATION_CHANGED,(()=>this.fetchCapabilitesForActiveDestination()))}initializeSession(sessionContext){assert(!this.sessionContext,"SessionContext should only be configured once");this.sessionContext=sessionContext;this.dispatchEvent(createCustomEvent(CAPABILITIES_MANAGER_SESSION_INITIALIZED))}fetchCapabilitesForActiveDestination(){const destination=this.destinationManager.getActiveDestination();if(destination===null){return}this.setActiveCapabilitiesLoading();const cachedCapabilities=this.capabilitiesCache.get(destination.id);if(cachedCapabilities){this.setActiveCapabilitiesReady();return}this.destinationProvider.fetchCapabilities(destination.id,PrinterType.kPdf).then((response=>this.onCapabilitiesFetched(response.capabilities)))}onCapabilitiesFetched(caps){if(!caps){return}this.capabilitiesCache.set(caps.destinationId,caps);const activeDestination=this.destinationManager.getActiveDestination();assert(activeDestination);if(caps.destinationId===activeDestination.id){this.setActiveCapabilitiesReady()}}getActiveDestinationCapabilities(){const activeDestination=this.destinationManager.getActiveDestination();if(activeDestination===null){return undefined}return this.capabilitiesCache.get(activeDestination.id)}setActiveCapabilitiesLoading(){this.activeDestinationCapabilitiesLoaded=false;this.dispatchEvent(createCustomEvent(CAPABILITIES_MANAGER_ACTIVE_DESTINATION_CAPS_LOADING))}setActiveCapabilitiesReady(){this.activeDestinationCapabilitiesLoaded=true;this.dispatchEvent(createCustomEvent(CAPABILITIES_MANAGER_ACTIVE_DESTINATION_CAPS_READY))}areActiveDestinationCapabilitiesLoaded(){return this.activeDestinationCapabilitiesLoaded}isSessionInitialized(){return!!this.sessionContext}}