// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{EventTracker}from"//resources/js/event_tracker.js";import{assert}from"chrome://resources/js/assert.js";import{createCustomEvent}from"../utils/event_utils.js";import{getDestinationProvider}from"../utils/mojo_data_providers.js";import{isValidDestination}from"../utils/validation_utils.js";import{PDF_DESTINATION}from"./destination_constants.js";import{PRINT_TICKET_MANAGER_TICKET_CHANGED,PrintTicketManager}from"./print_ticket_manager.js";export var DestinationManagerState;(function(DestinationManagerState){DestinationManagerState[DestinationManagerState["NOT_LOADED"]=0]="NOT_LOADED";DestinationManagerState[DestinationManagerState["FETCHING"]=1]="FETCHING";DestinationManagerState[DestinationManagerState["LOADED"]=2]="LOADED"})(DestinationManagerState||(DestinationManagerState={}));export const DESTINATION_MANAGER_ACTIVE_DESTINATION_CHANGED="destination-manager.active-destination-changed";export const DESTINATION_MANAGER_DESTINATIONS_CHANGED="destination-manager.destinations-changed";export const DESTINATION_MANAGER_SESSION_INITIALIZED="destination-manager.session-initialized";export const DESTINATION_MANAGER_STATE_CHANGED="destination-manager.state-changed";export class DestinationManager extends EventTarget{static{this.instance=null}static getInstance(){if(DestinationManager.instance===null){DestinationManager.instance=new DestinationManager}return DestinationManager.instance}static resetInstanceForTesting(){DestinationManager.instance?.eventTracker.removeAll();DestinationManager.instance=null}initializeSession(sessionContext){assert(!this.sessionContext,"SessionContext should only be configured once");this.sessionContext=sessionContext;this.printTicketManager=PrintTicketManager.getInstance();this.eventTracker.add(this.printTicketManager,PRINT_TICKET_MANAGER_TICKET_CHANGED,(()=>this.onPrintTicketChanged()));this.fetchInitialDestinations();this.dispatchEvent(createCustomEvent(DESTINATION_MANAGER_SESSION_INITIALIZED))}isSessionInitialized(){return!!this.sessionContext}constructor(){super();this.destinations=[];this.destinationCache=new Map;this.activeDestinationId="";this.initialDestinationsLoaded=false;this.state=DestinationManagerState.NOT_LOADED;this.eventTracker=new EventTracker;this.destinationProvider=getDestinationProvider();this.destinationProvider.observeDestinationChanges(this);this.insertDigitalDestinations()}destinationExists(destinationId){return this.destinationCache.has(destinationId)}hasAnyDestinations(){return this.isSessionInitialized()&&this.initialDestinationsLoaded&&this.destinations.length>0}getDestination(destinationId){assert(this.destinationExists(destinationId));return this.destinationCache.get(destinationId)}getDestinations(){return this.destinations}getState(){return this.state}getActiveDestination(){if(this.activeDestinationId===""){return null}const active=this.destinationCache.get(this.activeDestinationId);assert(active);return active}onDestinationsChanged(destinations){this.addOrUpdateDestinations(destinations)}addOrUpdateDestinations(destinations){if(destinations.length===0){return}destinations.forEach((destination=>this.addOrUpdateDestination(destination)));this.dispatchEvent(createCustomEvent(DESTINATION_MANAGER_DESTINATIONS_CHANGED))}addOrUpdateDestination(destination){const existingDestination=this.destinationCache.get(destination.id);if(!existingDestination){this.destinationCache.set(destination.id,destination);this.destinations.push(destination);return}const index=this.destinations.findIndex((d=>d.id===destination.id));assert(index!==-1);this.destinationCache.set(destination.id,destination);this.destinations[index]=destination}fetchInitialDestinations(){assert(this.isSessionInitialized);this.updateState(DestinationManagerState.FETCHING);this.destinationProvider.getLocalDestinations().then((response=>{this.addOrUpdateDestinations(response.destinations);this.initialDestinationsLoaded=true;this.selectInitialDestination();this.updateState(DestinationManagerState.LOADED)}))}insertDigitalDestinations(){assert(!this.destinationCache.get(PDF_DESTINATION.id));this.addOrUpdateDestination(PDF_DESTINATION)}onPrintTicketChanged(){assert(this.printTicketManager);const currentPrintTicket=this.printTicketManager.getPrintTicket();assert(currentPrintTicket);const nextActiveDestinationId=currentPrintTicket.destinationId||"";if(nextActiveDestinationId===this.activeDestinationId){return}assert(isValidDestination(nextActiveDestinationId),"PrintTicket won't be set to an invalid ID");this.updateActiveDestination(nextActiveDestinationId)}selectInitialDestination(){assert(this.activeDestinationId==="");if(this.destinations.length===0){return}this.selectFallbackDestination()}selectFallbackDestination(){assert(this.destinations.length>0);if(this.destinationCache.get(PDF_DESTINATION.id)){this.updateActiveDestination(PDF_DESTINATION.id);return}this.updateActiveDestination(this.destinations[0].id)}updateActiveDestination(destinationId){this.activeDestinationId=destinationId;this.dispatchEvent(createCustomEvent(DESTINATION_MANAGER_ACTIVE_DESTINATION_CHANGED))}updateState(nextState){if(nextState===this.state){return}this.state=nextState;this.dispatchEvent(createCustomEvent(DESTINATION_MANAGER_STATE_CHANGED))}setDestinationForTesting(destination){this.destinationCache.set(destination.id,destination);const index=this.destinations.findIndex((d=>d.id===destination.id));if(index===-1){this.destinations.push(destination);return}this.destinationCache.set(destination.id,destination);this.destinations[index]=destination}removeDestinationForTesting(destinationId){if(this.destinationCache.delete(destinationId)){const index=this.destinations.findIndex((d=>d.id===destinationId));this.destinations.splice(index)}}}