// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{EventTracker}from"chrome://resources/js/event_tracker.js";import{getFakePreviewTicket}from"../fakes/fake_data.js";import{createCustomEvent}from"../utils/event_utils.js";import{getPrintPreviewPageHandler}from"../utils/mojo_data_providers.js";export const PREVIEW_REQUEST_STARTED_EVENT="preview-ticket-manager.preview-request-started";export const PREVIEW_REQUEST_FINISHED_EVENT="preview-ticket-manager.preview-request-finished";export const PREVIEW_TICKET_MANAGER_SESSION_INITIALIZED="preview-ticket-manager.session-initialized";export class PreviewTicketManager extends EventTarget{static{this.instance=null}static getInstance(){if(PreviewTicketManager.instance===null){PreviewTicketManager.instance=new PreviewTicketManager}return PreviewTicketManager.instance}static resetInstanceForTesting(){PreviewTicketManager.instance=null}constructor(){super();this.previewLoaded=false;this.eventTracker=new EventTracker;this.activeRequestId=0;this.printPreviewPageHandler=getPrintPreviewPageHandler();this.printPreviewPageHandler.observePreviewReady(this)}initializeSession(sessionContext){assert(!this.sessionContext,"SessionContext should only be configured once");this.sessionContext=sessionContext;this.dispatchEvent(createCustomEvent(PREVIEW_TICKET_MANAGER_SESSION_INITIALIZED));this.sendPreviewRequest()}isPreviewLoaded(){return this.previewLoaded}sendPreviewRequest(){++this.activeRequestId;this.previewLoaded=false;this.dispatchEvent(createCustomEvent(PREVIEW_REQUEST_STARTED_EVENT));this.printPreviewPageHandler.generatePreview(getFakePreviewTicket(this.activeRequestId))}onDocumentReady(previewRequestId){if(previewRequestId!==this.activeRequestId){return}this.previewLoaded=true;this.dispatchEvent(createCustomEvent(PREVIEW_REQUEST_FINISHED_EVENT))}isSessionInitialized(){return!!this.sessionContext}}