// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{EventTracker}from"chrome://resources/js/event_tracker.js";import{createCustomEvent}from"../utils/event_utils.js";import{getPrintPreviewPageHandler}from"../utils/mojo_data_providers.js";import{PrinterStatusReason}from"../utils/print_preview_cros_app_types.js";import{isValidDestination}from"../utils/validation_utils.js";import{DESTINATION_MANAGER_ACTIVE_DESTINATION_CHANGED,DestinationManager}from"./destination_manager.js";import{DEFAULT_PARTIAL_PRINT_TICKET}from"./ticket_constants.js";export const PRINT_REQUEST_STARTED_EVENT="print-ticket-manager.print-request-started";export const PRINT_REQUEST_FINISHED_EVENT="print-ticket-manager.print-request-finished";export const PRINT_TICKET_MANAGER_SESSION_INITIALIZED="print-ticket-manager.session-initialized";export const PRINT_TICKET_MANAGER_TICKET_CHANGED="print-ticket-manager.ticket-changed";export class PrintTicketManager extends EventTarget{static{this.instance=null}static getInstance(){if(PrintTicketManager.instance===null){PrintTicketManager.instance=new PrintTicketManager}return PrintTicketManager.instance}static resetInstanceForTesting(){PrintTicketManager.instance?.eventTracker.removeAll();PrintTicketManager.instance=null}constructor(){super();this.printRequestInProgress=false;this.printTicket=null;this.eventTracker=new EventTracker;this.printPreviewPageHandler=getPrintPreviewPageHandler()}initializeSession(sessionContext){assert(!this.sessionContext,"SessionContext should only be configured once");this.sessionContext=sessionContext;this.printTicket={...DEFAULT_PARTIAL_PRINT_TICKET,printPreviewId:this.sessionContext.printPreviewToken,previewModifiable:this.sessionContext.isModifiable,shouldPrintSelectionOnly:this.sessionContext.hasSelection,printerManuallySelected:false};this.destinationManager=DestinationManager.getInstance();const activeDest=this.destinationManager.getActiveDestination();if(activeDest===null){this.printTicket.destinationId="";this.eventTracker.add(this.destinationManager,DESTINATION_MANAGER_ACTIVE_DESTINATION_CHANGED,(()=>this.onActiveDestinationChanged()))}else{this.printTicket.destinationId=activeDest.id;this.printTicket.printerType=activeDest.printerType;this.printTicket.printerStatusReason=activeDest.printerStatusReason||PrinterStatusReason.UNKNOWN_REASON}this.dispatchEvent(createCustomEvent(PRINT_TICKET_MANAGER_SESSION_INITIALIZED))}sendPrintRequest(){assert(this.printPreviewPageHandler);if(this.printTicket===null){return}if(this.printRequestInProgress){return}this.printRequestInProgress=true;this.dispatchEvent(createCustomEvent(PRINT_REQUEST_STARTED_EVENT));this.printPreviewPageHandler.print(this.printTicket).finally((()=>{this.printRequestInProgress=false;this.dispatchEvent(createCustomEvent(PRINT_REQUEST_FINISHED_EVENT))}))}cancelPrintRequest(){assert(this.printPreviewPageHandler);this.printPreviewPageHandler.cancel()}getPrintTicket(){return this.printTicket}isPrintRequestInProgress(){return this.printRequestInProgress}isSessionInitialized(){return!!this.sessionContext}onActiveDestinationChanged(){assert(this.printTicket);const activeDest=this.destinationManager.getActiveDestination();if(activeDest===null){return}if(this.printTicket.destinationId===""){this.updateDestinationFields(activeDest.id,false)}this.eventTracker.remove(this.destinationManager,DESTINATION_MANAGER_ACTIVE_DESTINATION_CHANGED)}setPrintTicketDestination(destinationId){if(!this.isSessionInitialized()){return false}if(this.isPrintRequestInProgress()){return false}if(!isValidDestination(destinationId)||destinationId===this.printTicket.destinationId){return false}this.updateDestinationFields(destinationId,true);this.dispatchEvent(createCustomEvent(PRINT_TICKET_MANAGER_TICKET_CHANGED));return true}updateDestinationFields(destinationId,manuallySelected){assert(this.printTicket);const source=this.destinationManager.getDestination(destinationId);this.printTicket.destinationId=destinationId;this.printTicket.printerType=source.printerType;this.printTicket.printerStatusReason=source.printerStatusReason||PrinterStatusReason.UNKNOWN_REASON;this.printTicket.printerManuallySelected=manuallySelected}}