// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../css/print_preview_cros_shared.css.js";import"./destination_row.js";import{assert}from"chrome://resources/js/assert.js";import{EventTracker}from"chrome://resources/js/event_tracker.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./destination_dropdown.html.js";import{DESTINATION_DROPDOWN_DROPDOWN_DISABLED_CHANGED,DESTINATION_DROPDOWN_UPDATE_DESTINATIONS,DESTINATION_DROPDOWN_UPDATE_SELECTED_DESTINATION,DestinationDropdownController}from"./destination_dropdown_controller.js";export class DestinationDropdownElement extends PolymerElement{constructor(){super(...arguments);this.eventTracker=new EventTracker;this.destinations=[];this.open=false}static get is(){return"destination-dropdown"}static get template(){return getTemplate()}static get properties(){return{destinations:Array,disabled:{type:Boolean,reflectToAttribute:true},open:Boolean,selectedDestination:Object}}connectedCallback(){super.connectedCallback();this.controller=new DestinationDropdownController(this.eventTracker);this.eventTracker.add(this.controller,DESTINATION_DROPDOWN_DROPDOWN_DISABLED_CHANGED,(()=>this.onDestinationDropdownDisabledChanged()));this.eventTracker.add(this.controller,DESTINATION_DROPDOWN_UPDATE_SELECTED_DESTINATION,(()=>this.onDestinationDropdownUpdateSelectedDestination()));this.eventTracker.add(this.controller,DESTINATION_DROPDOWN_UPDATE_DESTINATIONS,(()=>this.onDestinationDropdownUpdateDestinations()));this.selectedDestination=this.controller.getSelectedDestination();this.destinations=this.controller.getDestinations();this.disabled=this.controller.shouldDisableDropdown()}disconnectedCallback(){super.disconnectedCallback();this.eventTracker.removeAll()}onSelectedClicked(){if(this.disabled){return}this.open=!this.open}onDestinationClicked(event){assert(event.target);const row=event.target;assert(row.destination);if(this.selectedDestination?.id===row.destination.id){this.open=false;return}const destinationUpdated=this.controller.updateActiveDestination(row.destination.id);if(destinationUpdated){this.selectedDestination=row.destination}this.open=false}onDestinationDropdownDisabledChanged(){this.disabled=this.controller.shouldDisableDropdown();if(this.disabled){this.open=false}}onDestinationDropdownUpdateDestinations(){this.destinations=[...this.controller.getDestinations()]}onDestinationDropdownUpdateSelectedDestination(){this.selectedDestination=this.controller.getSelectedDestination()}getControllerForTesting(){return this.controller}}customElements.define(DestinationDropdownElement.is,DestinationDropdownElement);