// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{DESTINATION_MANAGER_ACTIVE_DESTINATION_CHANGED,DESTINATION_MANAGER_DESTINATIONS_CHANGED,DESTINATION_MANAGER_STATE_CHANGED,DestinationManager}from"./data/destination_manager.js";import{PRINT_REQUEST_FINISHED_EVENT,PRINT_REQUEST_STARTED_EVENT,PrintTicketManager}from"./data/print_ticket_manager.js";import{createCustomEvent}from"./utils/event_utils.js";export const DESTINATION_DROPDOWN_DROPDOWN_DISABLED_CHANGED="destination-dropdown.dropdown-disabled-changed";export const DESTINATION_DROPDOWN_UPDATE_DESTINATIONS="destination-dropdown.update-destinations";export const DESTINATION_DROPDOWN_UPDATE_SELECTED_DESTINATION="destination-dropdown.update-selected-destination";export class DestinationDropdownController extends EventTarget{constructor(eventTracker){super();this.destinationManager=DestinationManager.getInstance();this.printTicketManager=PrintTicketManager.getInstance();eventTracker.add(this.destinationManager,DESTINATION_MANAGER_ACTIVE_DESTINATION_CHANGED,(()=>this.onDestinationManagerActiveDestinationChanged()));eventTracker.add(this.destinationManager,DESTINATION_MANAGER_DESTINATIONS_CHANGED,(()=>this.onDestinationManagerDestinationsChanged()));eventTracker.add(this.destinationManager,DESTINATION_MANAGER_STATE_CHANGED,(()=>this.dispatchDropdownDisabled()));eventTracker.add(this.printTicketManager,PRINT_REQUEST_FINISHED_EVENT,(()=>this.dispatchDropdownDisabled()));eventTracker.add(this.printTicketManager,PRINT_REQUEST_STARTED_EVENT,(()=>this.dispatchDropdownDisabled()))}shouldDisableDropdown(){return!this.destinationManager.hasAnyDestinations()||this.printTicketManager.isPrintRequestInProgress()}updateActiveDestination(destinationId){return this.printTicketManager.setPrintTicketDestination(destinationId)}dispatchDropdownDisabled(){this.dispatchEvent(createCustomEvent(DESTINATION_DROPDOWN_DROPDOWN_DISABLED_CHANGED))}onDestinationManagerActiveDestinationChanged(){this.dispatchEvent(createCustomEvent(DESTINATION_DROPDOWN_UPDATE_SELECTED_DESTINATION))}onDestinationManagerDestinationsChanged(){this.dispatchEvent(createCustomEvent(DESTINATION_DROPDOWN_UPDATE_DESTINATIONS))}getSelectedDestination(){return this.destinationManager.getActiveDestination()}getDestinations(){return this.destinationManager.getDestinations()}}