// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../css/print_preview_cros_shared.css.js";import"chrome://resources/cros_components/button/button.js";import{EventTracker}from"chrome://resources/js/event_tracker.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./summary_panel.html.js";import{PRINT_BUTTON_DISABLED_CHANGED_EVENT,SHEETS_USED_CHANGED_EVENT,SummaryPanelController}from"./summary_panel_controller.js";export class SummaryPanelElement extends PolymerElement{constructor(){super(...arguments);this.eventTracker=new EventTracker}static get is(){return"summary-panel"}static get template(){return getTemplate()}static get properties(){return{sheetsUsedText:String,printButtonDisabled:Boolean}}connectedCallback(){super.connectedCallback();this.controller=new SummaryPanelController(this.eventTracker);this.eventTracker.add(this.controller,PRINT_BUTTON_DISABLED_CHANGED_EVENT,(()=>this.onPrintButtonDisabledChanged()));this.eventTracker.add(this.controller,SHEETS_USED_CHANGED_EVENT,(()=>this.onSheetsUsedChanged()));this.sheetsUsedText=this.controller.getSheetsUsedText();this.printButtonDisabled=this.controller.shouldDisablePrintButton()}disconnectedCallback(){super.disconnectedCallback();this.eventTracker.removeAll()}getControllerForTesting(){return this.controller}onSheetsUsedChanged(){this.sheetsUsedText=this.controller.getSheetsUsedText()}onPrintClicked(){this.controller.handlePrintClicked()}onCancelClicked(){this.controller.handleCancelClicked()}onPrintButtonDisabledChanged(){this.printButtonDisabled=this.controller.shouldDisablePrintButton()}}customElements.define(SummaryPanelElement.is,SummaryPanelElement);