// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"chrome://resources/js/assert.js";import{CAPABILITIES_MANAGER_ACTIVE_DESTINATION_CAPS_LOADING,CAPABILITIES_MANAGER_ACTIVE_DESTINATION_CAPS_READY,CapabilitiesManager}from"./data/capabilities_manager.js";import{PREVIEW_REQUEST_FINISHED_EVENT,PREVIEW_REQUEST_STARTED_EVENT,PreviewTicketManager}from"./data/preview_ticket_manager.js";import{PRINT_REQUEST_FINISHED_EVENT,PRINT_REQUEST_STARTED_EVENT,PrintTicketManager}from"./data/print_ticket_manager.js";export const PRINT_BUTTON_DISABLED_CHANGED_EVENT="summary-panel-controller.print-button-disabled-changed";export const SHEETS_USED_CHANGED_EVENT="summary-panel-controller.sheets-used-changed";export class SummaryPanelController extends EventTarget{constructor(eventTracker){super();this.sheetsUsed=0;this.capabilitiesManager=CapabilitiesManager.getInstance();this.previewTicketManager=PreviewTicketManager.getInstance();this.printTicketManager=PrintTicketManager.getInstance();eventTracker.add(this.capabilitiesManager,CAPABILITIES_MANAGER_ACTIVE_DESTINATION_CAPS_LOADING,(()=>this.dispatchPrintButtonDisabledChangedEvent()));eventTracker.add(this.capabilitiesManager,CAPABILITIES_MANAGER_ACTIVE_DESTINATION_CAPS_READY,(()=>this.dispatchPrintButtonDisabledChangedEvent()));eventTracker.add(this.previewTicketManager,PREVIEW_REQUEST_STARTED_EVENT,(()=>this.dispatchPrintButtonDisabledChangedEvent()));eventTracker.add(this.previewTicketManager,PREVIEW_REQUEST_FINISHED_EVENT,(()=>this.dispatchPrintButtonDisabledChangedEvent()));eventTracker.add(this.printTicketManager,PRINT_REQUEST_STARTED_EVENT,(()=>this.dispatchPrintButtonDisabledChangedEvent()));eventTracker.add(this.printTicketManager,PRINT_REQUEST_FINISHED_EVENT,(()=>this.dispatchPrintButtonDisabledChangedEvent()))}getSheetsUsedText(){if(this.sheetsUsed<=0){return""}return`${this.sheetsUsed} used`}setSheetsUsedForTesting(sheetsUsed){assert(sheetsUsed>=0);this.sheetsUsed=sheetsUsed;this.dispatch(SHEETS_USED_CHANGED_EVENT)}handlePrintClicked(){this.printTicketManager.sendPrintRequest()}handleCancelClicked(){this.printTicketManager.cancelPrintRequest()}dispatch(eventName){this.dispatchEvent(new CustomEvent(eventName,{bubbles:true,composed:true}))}dispatchPrintButtonDisabledChangedEvent(){this.dispatch(PRINT_BUTTON_DISABLED_CHANGED_EVENT)}shouldDisablePrintButton(){return!this.capabilitiesManager.areActiveDestinationCapabilitiesLoaded()||!this.previewTicketManager.isPreviewLoaded()||this.printTicketManager.isPrintRequestInProgress()}}