// ash/webui/print_preview_cros/mojom/destination_provider.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { PrinterTypeSpec as printing_mojom_PrinterTypeSpec } from './print.mojom-webui.js';
import { CapabilitiesSpec as ash_printing_printPreview_mojom_CapabilitiesSpec } from './printer_capabilities.mojom-webui.js';
export class DestinationProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.printing.print_preview.mojom.DestinationProvider', scope);
    }
}
export class DestinationProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(DestinationProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    fetchCapabilities(destinationId, printerType) {
        return this.proxy.sendMessage(0, DestinationProvider_FetchCapabilities_ParamsSpec.$, DestinationProvider_FetchCapabilities_ResponseParamsSpec.$, [
            destinationId,
            printerType
        ], false);
    }
}
;
/**
 * An object which receives request messages for the DestinationProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DestinationProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DestinationProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, DestinationProvider_FetchCapabilities_ParamsSpec.$, DestinationProvider_FetchCapabilities_ResponseParamsSpec.$, impl.fetchCapabilities.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class DestinationProvider {
    static get $interfaceName() {
        return "ash.printing.print_preview.mojom.DestinationProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new DestinationProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the DestinationProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DestinationProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DestinationProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.fetchCapabilities =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, DestinationProvider_FetchCapabilities_ParamsSpec.$, DestinationProvider_FetchCapabilities_ResponseParamsSpec.$, this.fetchCapabilities.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const DestinationProvider_FetchCapabilities_ParamsSpec = { $: {} };
export const DestinationProvider_FetchCapabilities_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(DestinationProvider_FetchCapabilities_ParamsSpec.$, 'DestinationProvider_FetchCapabilities_Params', [
    mojo.internal.StructField('destinationId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('printerType', 8, 0, printing_mojom_PrinterTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(DestinationProvider_FetchCapabilities_ResponseParamsSpec.$, 'DestinationProvider_FetchCapabilities_ResponseParams', [
    mojo.internal.StructField('capabilities', 0, 0, ash_printing_printPreview_mojom_CapabilitiesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
