// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { DestinationProvider } from '../../destination_provider.mojom-webui.js';
import { FakeDestinationProvider } from '../fakes/fake_destination_provider.js';
/**
 * @fileoverview
 * 'destination_provider_composite' provides a temporary structure to support
 * the mojo implementation of the DestinationProvider mojom interface combined
 * with fake implementations until all methods can be mojo implemented.
 */
export class DestinationProviderComposite {
    constructor(useFakeProviders) {
        this.fakeDestinationProvider = new FakeDestinationProvider();
        this.destinationProviderInterface = null;
        if (useFakeProviders) {
            this.destinationProviderInterface = this.fakeDestinationProvider;
            return;
        }
        this.destinationProviderInterface = DestinationProvider.getRemote();
    }
    fetchCapabilities(destinationId, printerType) {
        return this.destinationProviderInterface.fetchCapabilities(destinationId, printerType);
    }
    getLocalDestinations() {
        return this.fakeDestinationProvider.getLocalDestinations();
    }
    observeDestinationChanges(observer) {
        this.fakeDestinationProvider.observeDestinationChanges(observer);
    }
}
