// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { ColorModel, DuplexMode, MarginType, PrinterType, ScalingType } from '../utils/print_preview_cros_app_types.js';
/**
 * @fileoverview
 * 'fake_data' contains fake data to be used for tests and mocks.
 */
export function getFakePreviewTicket(requestId = 1) {
    const previewTicket = {
        requestId: requestId,
        printPreviewId: '0'.repeat(32 /* token length */),
        destinationId: 'Default Printer',
        collate: true,
        color: ColorModel.COLOR,
        copies: 1,
        dpiHorizontal: 100,
        dpiVertical: 100,
        duplex: DuplexMode.SIMPLEX,
        headerFooterEnabled: true,
        landscape: false,
        marginsType: MarginType.DEFAULT_MARGINS,
        mediaSize: {
            heightMicrons: 279400,
            widthMicrons: 215900,
        },
        pagesPerSheet: 1,
        previewModifiable: true,
        printerType: PrinterType.LOCAL_PRINTER,
        rasterizePDF: false,
        scaleFactor: 100,
        scalingType: ScalingType.DEFAULT,
        shouldPrintBackgrounds: false,
        shouldPrintSelectionOnly: false,
        pageRange: [{ from: 1, to: 2 }],
        isFirstRequest: true,
    };
    return previewTicket;
}
