// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Based on printing::mojom::ColorModel.
export var ColorModel;
(function (ColorModel) {
    ColorModel[ColorModel["UNKNOWN_COLOR_MODEL"] = 0] = "UNKNOWN_COLOR_MODEL";
    ColorModel[ColorModel["GRAY"] = 1] = "GRAY";
    ColorModel[ColorModel["COLOR"] = 2] = "COLOR";
})(ColorModel || (ColorModel = {}));
// Constant values matching printing::DuplexMode enum.
export var DuplexMode;
(function (DuplexMode) {
    DuplexMode[DuplexMode["SIMPLEX"] = 0] = "SIMPLEX";
    DuplexMode[DuplexMode["LONG_EDGE"] = 1] = "LONG_EDGE";
    DuplexMode[DuplexMode["SHORT_EDGE"] = 2] = "SHORT_EDGE";
    DuplexMode[DuplexMode["UNKNOWN_DUPLEX_MODE"] = -1] = "UNKNOWN_DUPLEX_MODE";
})(DuplexMode || (DuplexMode = {}));
// Constant values matching printing::mojom::MarginType enum.
export var MarginType;
(function (MarginType) {
    // Default varies depending on headers being enabled or not
    MarginType[MarginType["DEFAULT_MARGINS"] = 0] = "DEFAULT_MARGINS";
    MarginType[MarginType["NO_MARGINS"] = 1] = "NO_MARGINS";
    MarginType[MarginType["PRINTABLE_AREA_MARGINS"] = 2] = "PRINTABLE_AREA_MARGINS";
    MarginType[MarginType["CUSTOM_MARGINS"] = 3] = "CUSTOM_MARGINS";
})(MarginType || (MarginType = {}));
/**
 * Printer types for capabilities and printer list requests.
 * Must match PrinterType in printing/mojom/print.mojom
 */
export var PrinterType;
(function (PrinterType) {
    PrinterType[PrinterType["PRIVET_PRINTER_DEPRECATED"] = 0] = "PRIVET_PRINTER_DEPRECATED";
    PrinterType[PrinterType["EXTENSION_PRINTER"] = 1] = "EXTENSION_PRINTER";
    PrinterType[PrinterType["PDF_PRINTER"] = 2] = "PDF_PRINTER";
    PrinterType[PrinterType["LOCAL_PRINTER"] = 3] = "LOCAL_PRINTER";
    PrinterType[PrinterType["CLOUD_PRINTER_DEPRECATED"] = 4] = "CLOUD_PRINTER_DEPRECATED";
})(PrinterType || (PrinterType = {}));
/**
 * Must be kept in sync with the C++ ScalingType enum in
 * printing/print_job_constants.h.
 */
export var ScalingType;
(function (ScalingType) {
    ScalingType[ScalingType["DEFAULT"] = 0] = "DEFAULT";
    ScalingType[ScalingType["FIT_TO_PAGE"] = 1] = "FIT_TO_PAGE";
    ScalingType[ScalingType["FIT_TO_PAPER"] = 2] = "FIT_TO_PAPER";
    ScalingType[ScalingType["CUSTOM"] = 3] = "CUSTOM";
})(ScalingType || (ScalingType = {}));
/**
 *  These values must be kept in sync with the Reason enum in
 *  /chromeos/printing/cups_printer_status.h
 */
export var PrinterStatusReason;
(function (PrinterStatusReason) {
    PrinterStatusReason[PrinterStatusReason["UNKNOWN_REASON"] = 0] = "UNKNOWN_REASON";
    PrinterStatusReason[PrinterStatusReason["DEVICE_ERROR"] = 1] = "DEVICE_ERROR";
    PrinterStatusReason[PrinterStatusReason["DOOR_OPEN"] = 2] = "DOOR_OPEN";
    PrinterStatusReason[PrinterStatusReason["LOW_ON_INK"] = 3] = "LOW_ON_INK";
    PrinterStatusReason[PrinterStatusReason["LOW_ON_PAPER"] = 4] = "LOW_ON_PAPER";
    PrinterStatusReason[PrinterStatusReason["NO_ERROR"] = 5] = "NO_ERROR";
    PrinterStatusReason[PrinterStatusReason["OUT_OF_INK"] = 6] = "OUT_OF_INK";
    PrinterStatusReason[PrinterStatusReason["OUT_OF_PAPER"] = 7] = "OUT_OF_PAPER";
    PrinterStatusReason[PrinterStatusReason["OUTPUT_ALMOST_FULL"] = 8] = "OUTPUT_ALMOST_FULL";
    PrinterStatusReason[PrinterStatusReason["OUTPUT_FULL"] = 9] = "OUTPUT_FULL";
    PrinterStatusReason[PrinterStatusReason["PAPER_JAM"] = 10] = "PAPER_JAM";
    PrinterStatusReason[PrinterStatusReason["PAUSED"] = 11] = "PAUSED";
    PrinterStatusReason[PrinterStatusReason["PRINTER_QUEUE_FULL"] = 12] = "PRINTER_QUEUE_FULL";
    PrinterStatusReason[PrinterStatusReason["PRINTER_UNREACHABLE"] = 13] = "PRINTER_UNREACHABLE";
    PrinterStatusReason[PrinterStatusReason["STOPPED"] = 14] = "STOPPED";
    PrinterStatusReason[PrinterStatusReason["TRAY_MISSING"] = 15] = "TRAY_MISSING";
})(PrinterStatusReason || (PrinterStatusReason = {}));
