import {svg} from "chrome://resources/mwc/lit/index.js";
export const images = new Map([["genai_error_general", svg`<svg xmlns="http://www.w3.org/2000/svg" width="200" height="100" viewBox="0 0 200 100" fill="none">
<g clip-path="url(#clip0_2195_26319)">
<path d="M159.075 41.481L137.937 24.8853C135.307 22.8697 133.574 19.8651 133.119 16.5318C132.664 13.1985 133.525 9.80944 135.511 7.10954C136.495 5.77196 137.725 4.64398 139.133 3.78998C140.541 2.93607 142.098 2.37281 143.715 2.13248C145.332 1.89214 146.978 1.97943 148.559 2.38933C150.14 2.79931 151.624 3.52384 152.927 4.52159L174.058 21.1163C176.69 23.131 178.424 26.1354 178.88 29.4689C179.337 32.8024 178.477 36.1922 176.49 38.893C174.503 41.5929 171.552 43.3821 168.286 43.8674C165.02 44.3527 161.707 43.4943 159.075 41.481Z" fill="var(--cros-sys-illo-secondary)" />
<path d="M38.7502 23.1417L29.7484 33.8612C28.6129 35.2134 28.7894 37.2292 30.1426 38.3635L40.7437 47.2518C42.0969 48.3868 44.1144 48.2105 45.2498 46.8584L54.2515 36.1386C55.3874 34.7866 55.2103 32.7707 53.8571 31.6362L43.2563 22.7478C41.9032 21.6132 39.8857 21.7895 38.7502 23.1417Z" fill="var(--cros-sys-illo-color4)" />
<path d="M57.8929 92.104C60.9634 91.4255 63.9958 90.5816 66.9762 89.5758C71.1224 88.3328 75.5794 88.7553 79.3682 90.7498C81.4382 91.9432 83.5718 93.026 85.7611 93.9942C93.5586 97.0549 102.599 92.9034 104.631 84.6198C106.417 77.3437 101.536 69.4587 93.928 68.332C90.413 67.7949 86.8396 68.4626 83.3059 68.2362C79.5443 68.0349 75.9874 66.5496 73.2446 64.0357C70.9002 61.8616 68.7508 59.4748 66.107 57.5949C63.5447 55.7538 60.5505 54.574 57.3929 54.1612C52.4041 53.5215 47.3326 54.8004 43.2294 57.7323C39.1263 60.6642 36.3062 65.0244 35.3537 69.9091C34.4012 74.7944 35.3893 79.8291 38.1133 83.9704C40.8373 88.1122 45.0881 91.0423 49.9848 92.1542C52.5885 92.6816 55.2824 92.6645 57.8929 92.104Z" fill="var(--cros-sys-illo-color1-2)" />
<path d="M146.019 95.1237C145.717 95.3808 145.365 95.5701 144.983 95.6795C144.602 95.7891 144.201 95.8165 143.808 95.7597C143.414 95.7027 143.035 95.5624 142.698 95.3485C142.361 95.1349 142.071 94.8525 141.849 94.519C137.93 88.697 136.272 81.6476 137.192 74.7205C138.112 67.7925 141.545 61.473 146.833 56.9712C152.122 52.4687 158.896 50.1001 165.858 50.3184C172.821 50.5365 179.483 53.3259 184.57 58.1531C184.861 58.4285 185.091 58.7618 185.246 59.1312C185.401 59.5008 185.477 59.898 185.469 60.2974C185.462 60.697 185.37 61.0896 185.202 61.4494C185.032 61.8095 184.789 62.1293 184.489 62.3875L146.019 95.1237Z" stroke="var(--cros-sys-illo-secondary)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="4 6" />
<path d="M122 82C126.97 82 131 77.9704 131 73C131 68.0292 126.97 64 122 64C117.029 64 113 68.0292 113 73C113 77.9704 117.029 82 122 82Z" stroke="var(--cros-sys-illo-color5)" stroke-width="3" stroke-miterlimit="10" />
<path d="M97 65C114.673 65 129 50.6731 129 33C129 15.3269 114.673 1 97 1C79.3269 1 65 15.3269 65 33C65 50.6731 79.3269 65 97 65Z" fill="var(--cros-sys-illo-color1-1)" />
<path fill-rule="evenodd" clip-rule="evenodd" d="M88.1366 40.7918C87.3907 41.6065 87.4464 42.8716 88.2611 43.6175C89.0758 44.3634 90.3409 44.3076 91.0868 43.4929L97.5324 36.453L104.44 43.0403C105.239 43.8026 106.505 43.7726 107.268 42.9732C108.03 42.1738 108 40.9079 107.201 40.1456L100.234 33.5021L106.735 26.402C107.481 25.5873 107.425 24.3222 106.61 23.5763C105.795 22.8304 104.53 22.8862 103.784 23.7009L97.3387 30.7411L90.4311 24.1538C89.6317 23.3915 88.3657 23.4215 87.6034 24.2209C86.8411 25.0203 86.8712 26.2862 87.6706 27.0485L94.637 33.6919L88.1366 40.7918Z" fill="var(--cros-sys-base_elevated)" />
</g>
<defs>
<clipPath id="clip0_2195_26319">
<rect width="200" height="100" fill="var(--cros-sys-base_elevated)" />
</clipPath>
</defs>
</svg>`],["genai_error_unsafe", svg`<svg xmlns="http://www.w3.org/2000/svg" width="200" height="100" viewBox="0 0 200 100" fill="none">
<g clip-path="url(#clip0_2195_26312)">
<path d="M40.4587 69.3503C48.4895 68.6502 54.4326 61.5719 53.7325 53.5412C53.0323 45.5097 45.954 39.5673 37.9233 40.2674C29.8918 40.9676 23.9494 48.0451 24.6496 56.0766C25.3497 64.1073 32.4273 70.0505 40.4587 69.3503Z" stroke="var(--cros-sys-illo-color5)" stroke-width="3" stroke-miterlimit="10" />
<path d="M156.993 71.3054C154.772 70.6787 154.06 67.8842 155.711 66.272L175.279 47.1611C176.93 45.5489 179.707 46.3261 180.281 48.561L187.103 75.1194C187.678 77.3599 185.609 79.3812 183.382 78.7529L156.993 71.3054Z" fill="var(--cros-sys-illo-secondary)" />
<rect x="6" y="53.2012" width="29.5179" height="29.5179" rx="14.759" transform="rotate(-20.9825 6 53.2012)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" stroke-dasharray="3 6" />
<path d="M152.026 38.1377L174.663 60.5736C174.934 60.8423 174.817 61.3033 174.45 61.4091L145.261 69.8377C144.899 69.9425 144.555 69.6228 144.634 69.2535L151.185 38.389C151.267 38.0019 151.745 37.8592 152.026 38.1377Z" stroke="var(--cros-sys-illo-color3)" stroke-width="3" />
<path d="M106.332 10.2669C108.712 7.91182 112.825 8.99923 113.701 12.2153L115.432 18.5682C116.015 20.71 118.165 22.0775 120.396 21.7262L127.014 20.684C130.363 20.1565 133.054 23.3967 131.834 26.4896L129.424 32.5992C128.612 34.659 129.538 36.9961 131.562 37.996L137.569 40.962C140.609 42.4634 140.849 46.6189 137.999 48.4072L132.368 51.9399C130.47 53.1308 129.819 55.545 130.863 57.5145L133.965 63.3553C135.534 66.3126 133.232 69.796 129.84 69.5966L123.14 69.2023C120.881 69.0697 118.9 70.6386 118.567 72.8255L117.578 79.3104C117.078 82.5935 113.113 84.074 110.475 81.9637L105.264 77.7938C103.508 76.3882 100.954 76.5127 99.3694 78.0807L94.6686 82.7333C92.2886 85.088 88.1757 84.0009 87.2998 80.7846L85.5686 74.4323C84.9852 72.2905 82.835 70.9228 80.604 71.2737L73.9863 72.3158C70.6361 72.8435 67.9456 69.6038 69.1661 66.5102L71.5766 60.4006C72.3888 58.3409 71.4626 56.0042 69.438 55.0046L63.4315 52.0382C60.3909 50.5367 60.1504 46.3813 63.0016 44.593L68.6321 41.0603C70.5302 39.8693 71.1818 37.4555 70.1362 35.4861L67.0356 29.6449C65.466 26.6879 67.7679 23.2045 71.1593 23.4038L77.8605 23.7974C80.1193 23.9301 82.0991 22.3614 82.4329 20.175L83.4219 13.6896C83.9227 10.4066 87.8876 8.92588 90.5251 11.0365L95.7366 15.2062C97.4929 16.612 100.045 16.4876 101.63 14.9192L106.332 10.2669Z" fill="var(--cros-sys-illo-color1-2)" />
<path d="M98.4177 51.3209L98.4003 50.1218C98.388 49.2739 98.4744 48.5458 98.6594 47.9374C98.844 47.3047 99.1625 46.7065 99.6146 46.1426C100.091 45.5542 100.736 44.927 101.55 44.261C102.077 43.8172 102.507 43.4111 102.841 43.0429C103.198 42.65 103.459 42.2343 103.622 41.7958C103.809 41.3327 103.899 40.8105 103.89 40.2291C103.876 39.2601 103.538 38.4897 102.875 37.9178C102.237 37.3213 101.324 37.0317 100.137 37.0489C99.4343 37.0591 98.8064 37.2015 98.2531 37.476C97.7241 37.7502 97.2936 38.1442 96.9619 38.6578C96.6298 39.1472 96.4081 39.7319 96.2968 40.412L92.6926 39.9918C92.7958 38.7546 93.1553 37.6469 93.771 36.6688C94.3865 35.6665 95.235 34.8667 96.3167 34.2695C97.3983 33.6723 98.6659 33.3631 100.119 33.342C101.694 33.3191 103.043 33.5782 104.165 34.1192C105.311 34.6356 106.195 35.3982 106.815 36.4068C107.435 37.3912 107.755 38.5617 107.775 39.9183C107.789 40.9357 107.645 41.8343 107.341 42.6141C107.037 43.3696 106.635 44.0539 106.135 44.6669C105.635 45.2799 105.098 45.8207 104.523 46.2894C103.972 46.7336 103.53 47.164 103.197 47.5808C102.888 47.9729 102.664 48.3881 102.525 48.8262C102.41 49.264 102.357 49.7857 102.366 50.3914L102.378 51.2634L98.4177 51.3209ZM100.509 60.1587C99.7334 60.1699 99.0755 59.9129 98.5348 59.3877C98.0184 58.8622 97.7547 58.2239 97.7438 57.4729C97.7329 56.722 97.9779 56.0763 98.4789 55.536C99.0041 54.9953 99.6543 54.7194 100.43 54.7081C101.18 54.6972 101.814 54.9545 102.331 55.4801C102.871 56.0053 103.147 56.6434 103.158 57.3944C103.169 58.1453 102.912 58.7911 102.387 59.3318C101.886 59.8721 101.26 60.1478 100.509 60.1587Z" fill="var(--cros-sys-illo-color1)" />
</g>
<defs>
<clipPath id="clip0_2195_26312">
<rect width="200" height="100" fill="var(--cros-sys-base_elevated)" />
</clipPath>
</defs>
</svg>`],["onboarding_speaker_label", svg`<svg xmlns="http://www.w3.org/2000/svg" width="512" height="236" viewBox="0 0 512 236" fill="none">
<rect width="512" height="236" fill="var(--cros-sys-illo-color1-2)" />
<path d="M86 47H290V143H86V47Z" fill="var(--cros-sys-illo-base)" />
<rect x="86" y="82.9199" width="3" height="7.32478" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="114" y="71" width="3" height="30.9895" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="142" y="71" width="3" height="30.9895" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="170" y="79.4141" width="3" height="14.0861" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="198" y="71" width="3" height="30.9895" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="93" y="80.8164" width="3" height="12.3958" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="121" y="74.5059" width="3" height="24.7916" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="149" y="81.5176" width="3" height="10.142" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="177" y="80.8164" width="3" height="12.3958" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="205" y="80.8164" width="3" height="12.3958" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="100" y="83.6211" width="3" height="5.63445" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="128" y="79.4141" width="3" height="14.6496" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="156" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="184" y="74.5059" width="3" height="24.7916" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="212" y="78.7129" width="3" height="15.7765" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="107" y="77.3105" width="3" height="19.1571" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="135" y="74.5059" width="3" height="24.7916" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="163" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="191" y="78.0117" width="3" height="18.0302" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="219" y="77" width="3" height="19" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="226" y="77" width="3" height="19" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="233" y="77" width="3" height="19" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="240" y="77" width="3" height="19" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="72" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="44" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="16" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="58" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="30" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="2" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="79" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="51" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="23" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="65" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="37" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="9" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<path d="M287 47H412C417.523 47 422 51.4772 422 57V133C422 138.523 417.523 143 412 143H287V47Z" fill="var(--cros-sys-illo-color1-1)" />
<rect x="289" y="82.9199" width="3" height="7.32478" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="317" y="71" width="3" height="30.9895" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="345" y="71" width="3" height="30.9895" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="373" y="79.4141" width="3" height="14.0861" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="401" y="71" width="3" height="30.9895" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="296" y="80.8164" width="3" height="12.3958" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="324" y="74.5059" width="3" height="24.7916" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="352" y="81.5176" width="3" height="10.142" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="380" y="80.8164" width="3" height="12.3958" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="408" y="80.8164" width="3" height="12.3958" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="303" y="83.6211" width="3" height="5.63445" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="331" y="79.4141" width="3" height="14.6496" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="359" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="387" y="74.5059" width="3" height="24.7916" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="415" y="78.7129" width="3" height="15.7765" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="310" y="77.3105" width="3" height="19.1571" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="338" y="74.5059" width="3" height="24.7916" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="366" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="394" y="78.0117" width="3" height="18.0302" rx="1.5" fill="var(--cros-sys-illo-base)" />
<rect x="492" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="464" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="506" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="478" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="450" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="499" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="471" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="485" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="457" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="422" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="429" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="436" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="443" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-1)" />
<rect x="275" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="247" y="81" width="3" height="11" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="261" y="79" width="3" height="15" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="282" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="254" y="84.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="268" y="80" width="3" height="13" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<path d="M87.5 33L87.5 143" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
<path d="M86 31C86 25.4772 90.4772 21 96 21H139C144.523 21 149 25.4772 149 31V37C149 42.5228 144.523 47 139 47H88C86.8954 47 86 46.1046 86 45V31Z" fill="var(--cros-sys-illo-color1)" />
<path d="M87.5 221V237.5H225L221.5 221L213.5 204.5L200.5 186L185 171.5L169.5 167.5H158.5L154 189L133.5 169.5L112.5 180.5L96.5 197L87.5 221Z" fill="var(--cros-sys-illo-base)" />
<path fill-rule="evenodd" clip-rule="evenodd" d="M150.812 123.779C168.589 124.1 172.433 148.283 156.097 154.369L158.659 167.182L154.015 189.443L133.034 169.103C138.159 166.381 137.038 156.131 136.878 147.322H137.038C130.952 137.232 138.8 123.619 150.812 123.779Z" fill="var(--cros-sys-illo-base)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linejoin="round" />
<path d="M150.812 122.178C146.209 122.178 141.793 123.995 138.523 127.234C135.254 130.473 133.396 134.873 133.354 139.475C134.315 162.537 167.147 162.537 168.108 139.635C168.129 137.35 167.697 135.083 166.838 132.966C165.978 130.849 164.707 128.924 163.099 127.3C161.491 125.677 159.577 124.389 157.468 123.51C155.358 122.63 153.097 122.178 150.812 122.178ZM150.812 125.381C154.591 125.381 158.217 126.883 160.89 129.556C163.563 132.229 165.065 135.854 165.065 139.635C164.265 158.373 137.198 158.373 136.558 139.475C136.558 137.61 136.928 135.764 137.645 134.044C138.364 132.323 139.416 130.763 140.743 129.452C142.067 128.141 143.64 127.106 145.368 126.407C147.098 125.709 148.947 125.36 150.812 125.381Z" fill="var(--cros-sys-illo-color1)" />
<path fill-rule="evenodd" clip-rule="evenodd" d="M145.527 123.139C148.69 122.839 151.882 123.055 154.976 123.779C155.738 123.814 156.469 124.095 157.058 124.58C159.494 125.506 161.608 127.12 163.144 129.225C166.667 134.19 168.269 136.912 167.949 137.713L154.656 129.065L136.558 145.561C132.394 133.229 137.519 126.983 148.089 124.74L145.527 123.139Z" fill="var(--cros-sys-illo-color1)" />
<path fill-rule="evenodd" clip-rule="evenodd" d="M135.978 124.541C129.749 117.358 117.851 122.334 118.243 131.664C117.535 130.304 116.527 129.124 115.295 128.212C114.061 127.301 112.637 126.682 111.13 126.402C109.623 126.123 108.072 126.191 106.595 126.602C105.119 127.011 103.754 127.753 102.606 128.769C102.15 129.103 101.629 129.337 101.078 129.455C100.525 129.573 99.954 129.573 99.401 129.455C98.8496 129.337 98.3283 129.103 97.8733 128.77C97.4167 128.436 97.0372 128.01 96.7583 127.519C95.1308 125.862 92.9891 124.807 90.6837 124.526C88.3783 124.245 86.0461 124.756 84.0696 125.973L81.6302 128.11C81.2856 128.488 80.8631 128.786 80.3935 128.985C79.9224 129.183 79.4132 129.277 78.9024 129.259C78.3916 129.241 77.8905 129.112 77.4343 128.882C76.9782 128.651 76.5792 128.324 76.2617 127.923L71.5322 122.14C70.7031 121.114 69.6237 120.318 68.3982 119.83C67.1726 119.341 65.8419 119.177 64.5342 119.351C63.2266 119.526 61.9859 120.034 60.9315 120.827C59.8772 121.621 59.0446 122.672 58.5141 123.879C58.0449 125.123 57.8927 126.464 58.0711 127.781C58.2496 129.098 58.7532 130.35 59.5364 131.424C60.3195 132.498 61.3577 133.36 62.5573 133.933C63.7569 134.505 65.0801 134.77 66.4076 134.704L75.8272 133.813C76.6967 133.76 77.5563 134.016 78.2538 134.536C78.953 135.056 79.4446 135.807 79.6413 136.655C79.9376 138.406 80.7368 140.033 81.9437 141.336C82.7997 142.354 83.8523 143.189 85.0378 143.793C86.2249 144.396 87.5187 144.754 88.8466 144.847C90.1728 144.94 91.5053 144.766 92.763 144.334C94.0222 143.902 95.1805 143.222 96.1708 142.334L96.3293 142.31C96.7166 141.948 97.1821 141.678 97.6899 141.52C98.1962 141.363 98.7325 141.322 99.2587 141.401C99.7833 141.48 100.283 141.676 100.722 141.976C101.16 142.276 101.526 142.671 101.79 143.131C103.162 144.732 105.003 145.863 107.05 146.365C109.1 146.866 111.255 146.713 113.211 145.927C115.168 145.141 116.83 143.762 117.962 141.983C119.094 140.204 119.642 138.114 119.525 136.009C120.218 137.384 121.216 138.583 122.444 139.513C123.671 140.444 125.094 141.081 126.607 141.375C128.118 141.67 129.677 141.615 131.164 141.214C132.651 140.813 134.028 140.077 135.186 139.062C137.186 137.224 138.389 134.676 138.538 131.963C138.686 129.25 137.768 126.586 135.978 124.541Z" fill="var(--cros-sys-illo-color1)" />
<path d="M132.233 167.662C132.422 167.568 132.629 167.511 132.839 167.495C133.05 167.481 133.263 167.508 133.463 167.574C133.663 167.641 133.849 167.747 134.009 167.886C134.169 168.024 134.301 168.194 134.395 168.383C134.49 168.572 134.546 168.778 134.562 168.99C134.576 169.2 134.549 169.413 134.482 169.613C134.416 169.815 134.31 170 134.171 170.159C134.032 170.319 133.864 170.45 133.675 170.545C116.698 178.232 105.167 187.201 98.7605 197.451C63.8461 251.744 121.983 322.533 177.878 273.045L152.66 245.818L138.8 243.256C138.417 243.419 137.984 243.427 137.595 243.278C137.208 243.128 136.892 242.833 136.718 242.455H136.557L129.671 221.475C129.632 221.124 129.711 220.771 129.893 220.47C130.077 220.169 130.354 219.937 130.683 219.809C131.011 219.681 131.371 219.666 131.709 219.764C132.047 219.862 132.345 220.07 132.553 220.353H132.714L139.12 239.572L152.5 242.455C152.815 242.314 153.168 242.268 153.509 242.325C153.85 242.383 154.169 242.538 154.422 242.775H154.582L181.241 272.404C181.44 272.723 181.531 273.098 181.502 273.471C181.473 273.846 181.326 274.201 181.081 274.486C154.655 296.588 129.831 298.99 107.249 281.213C84.6667 263.435 77.2995 223.236 96.0378 195.689C102.764 184.959 114.936 175.67 132.233 167.662Z" fill="var(--cros-sys-illo-color1)" />
<path d="M153.534 187.842C153.937 187.742 154.362 187.805 154.721 188.015C155.079 188.223 155.344 188.564 155.456 188.963L156.577 192.806C156.897 193.927 158.018 197.611 158.178 198.572C158.339 199.533 160.1 205.299 160.741 208.342C161.382 211.385 162.342 216.349 162.983 220.193L163.624 223.717L164.104 227.72C164.151 227.922 164.154 228.13 164.112 228.332C164.071 228.536 163.987 228.726 163.866 228.894C163.744 229.061 163.588 229.2 163.407 229.301C163.228 229.402 163.028 229.465 162.823 229.482C162.421 229.53 162.017 229.425 161.691 229.188C161.364 228.949 161.14 228.597 161.061 228.201L160.581 225.158C159.94 220.834 159.139 216.029 158.178 211.865C157.302 207.164 156.181 202.513 154.815 197.931L153.053 191.685L152.413 189.763C152.35 189.363 152.427 188.953 152.631 188.602C152.836 188.253 153.154 187.984 153.534 187.842Z" fill="var(--cros-sys-illo-color1)" />
<path d="M159 167C171.5 165.667 185.553 169.5 194.5 179.5C221.7 209.9 225.5 231.5 225.5 250" stroke="var(--cros-sys-illo-color1)" stroke-width="3" />
<path d="M193 220L193 237" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
<path d="M164.091 145C159.654 146.743 156.045 146.967 152.212 145.671C151.461 145.418 150.681 146.039 150.95 146.785C153.599 154.137 164.091 151.521 164.091 145Z" fill="var(--cros-sys-illo-base)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" />
<path d="M305.976 203.598L298.3 235.264C298.147 235.894 298.624 236.5 299.271 236.5H328.256C328.698 236.5 329.087 236.21 329.214 235.787L333.848 220.34C334.147 219.343 335.582 219.41 335.786 220.432L338.839 235.696C338.933 236.164 339.343 236.5 339.82 236.5H431.803C432.222 236.5 432.596 236.239 432.741 235.846L435.92 227.218C435.973 227.074 435.992 226.921 435.976 226.769L434.509 212.59C434.503 212.53 434.492 212.471 434.475 212.414L430.041 197.14C430.014 197.047 429.974 196.959 429.921 196.878L421.097 183.151C421.033 183.051 420.951 182.963 420.856 182.892L407.149 172.612C407.051 172.538 406.939 172.483 406.82 172.449L391.133 168.037C391.045 168.013 390.954 168 390.862 168H344.185C344.063 168 343.942 168.022 343.828 168.066L327.18 174.431C327.061 174.477 326.952 174.544 326.859 174.631L314.143 186.368C314.049 186.455 313.972 186.56 313.917 186.677L306.043 203.408C306.014 203.469 305.992 203.533 305.976 203.598Z" fill="var(--cros-sys-illo-base)" />
<path d="M434 236H451" stroke="var(--cros-sys-illo-color1-2)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M336.812 203C336.812 203 333.94 215.855 339 236" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" />
<path d="M360 167.053C312.269 165.34 306.319 206.042 304.204 211.575L294 256.5L319.5 263C324.128 265.766 325.026 252.28 336 212.5" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" />
<path d="M345 196H357V203.533C357 205.446 355.304 207 353.217 207H348.783C346.696 207 345 205.565 345 203.652C345 203.652 345 203.652 345 203.533V196Z" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M375 276C406.685 273.348 439.579 252.662 435.685 217.522C430.986 176.547 401.449 167.928 382.384 167" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" />
<path d="M396.52 211C399.173 216.671 397.581 224.637 396.918 227.743C396.653 228.553 396.122 229.228 395.459 229.633L368 243.675L376.224 275" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" />
<path d="M362.229 156L360.924 166.858L351 167.281C351 167.281 354.264 178.14 372.153 177.999C379.857 177.858 387.038 174.05 392 167.704L380.248 166.012L378.551 156.564C378.551 156.564 365.363 158.679 362.229 156Z" fill="var(--cros-sys-illo-color1-2)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M385 143.499C385 134.888 377.979 128 369.5 128C361.021 128 354 135.021 354 143.499C354 152.11 361.021 158.998 369.5 158.998C377.979 159.131 385 152.11 385 143.499Z" fill="var(--cros-sys-illo-color1-2)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M388.453 135.571C388.453 135.571 399.685 133.262 400.338 128.781C401.122 123.212 383.49 130.139 383.49 130.139C383.49 130.139 397.203 123.077 394.33 118.323C391.196 113.027 378.919 127.287 378.919 127.287C378.919 127.287 389.759 110.854 384.012 109.224C376.307 106.78 371.474 125.114 371.474 125.114C371.474 125.114 373.956 114.385 369.123 114.249C364.291 114.113 365.728 125.793 365.728 125.793C365.728 125.793 362.593 114.792 358.544 116.422C354.234 118.052 360.373 127.287 360.373 127.287C360.373 127.287 353.843 119.682 351.231 122.398C348.618 125.114 356.716 130.546 356.716 130.546C347.704 129.188 343.002 131.497 344.178 134.484C345.353 137.88 356.455 135.435 356.455 135.435L367.034 138.966C369.515 141.275 372.258 143.176 375.262 144.806C378.135 146.3 381.27 147.522 384.404 148.473C384.535 147.25 384.665 146.028 384.796 144.806C384.796 144.806 392.763 157.436 396.812 153.09C399.554 150.102 390.02 141.411 390.02 141.411C398.379 146.707 403.081 145.077 403.864 143.04C405.693 137.201 388.453 135.571 388.453 135.571Z" fill="var(--cros-sys-illo-color1)" />
<path d="M365.5 150L361.5 155C361.5 155 359.5 154 358.5 152L358 151L365.5 150Z" fill="var(--cros-sys-illo-base)" />
<path d="M355 149C359.569 151.109 364.631 149.759 367.237 148.771C367.995 148.483 368.772 149.099 368.426 149.833C367.112 152.622 363.637 156.013 358 154" stroke="var(--cros-sys-illo-color1)" stroke-width="3" />
<path d="M181.206 152.014C191.888 149.837 193.485 140.845 192.714 135.22C192.628 134.589 193.102 134 193.739 134H206.826C207.442 134 207.909 134.569 207.797 135.174C204.085 155.244 191.117 156.668 180.97 154.114C179.901 153.845 180.126 152.234 181.206 152.014Z" fill="var(--cros-sys-illo-base)" />
<path d="M339.794 152.014C329.112 149.837 327.515 140.845 328.286 135.22C328.372 134.589 327.898 134 327.261 134H314.174C313.558 134 313.091 134.569 313.203 135.174C316.915 155.244 329.883 156.668 340.03 154.114C341.099 153.845 340.874 152.234 339.794 152.014Z" fill="var(--cros-sys-illo-color1-1)" />
<path d="M287 31C287 25.4772 291.477 21 297 21H340C345.523 21 350 25.4772 350 31V37C350 42.5228 345.523 47 340 47H289C287.895 47 287 46.1046 287 45V31Z" fill="var(--cros-sys-illo-base)" />
</svg>`],["onboarding_transcription", svg`<svg xmlns="http://www.w3.org/2000/svg" width="512" height="236" viewBox="0 0 512 236" fill="none">
<rect width="512" height="236" fill="var(--cros-sys-illo-color1-2)" />
<path d="M274.5 155.5L279.5 134.5L316.5 124.5L334 188L344.5 174.5L359 162L378 150L396.5 145.5L405.5 151.5H416L426.5 145.5L444 151.5L458.5 160L472.5 176.5L480.5 191.5L486 208.5V222.5L478 236.5H420.5L416 219.5L404 211.5L389.5 208.5L374.5 211.5L367.5 219.5L357 236.5H305L292 217.5L284.5 193L277.5 169L274.5 155.5Z" fill="var(--cros-sys-illo-base)" />
<path d="M209 41C209 29.9543 217.954 21 229 21H381C392.046 21 401 29.9543 401 41V99C401 110.046 392.046 119 381 119H229C217.954 119 209 110.046 209 99V41Z" fill="var(--cros-sys-illo-base)" />
<rect x="248" y="43" width="6" height="14" rx="2" transform="rotate(90 248 43)" fill="var(--cros-sys-illo-color1-2)" />
<rect x="248" y="80" width="6" height="14" rx="2" transform="rotate(90 248 80)" fill="var(--cros-sys-illo-color1-2)" />
<rect x="369" y="43" width="6.00001" height="114" rx="2" transform="rotate(90 369 43)" fill="var(--cros-sys-illo-color1-2)" />
<rect x="369" y="80" width="6.00001" height="114" rx="2" transform="rotate(90 369 80)" fill="var(--cros-sys-illo-color1-2)" />
<rect x="369" y="53" width="6.00001" height="114" rx="2" transform="rotate(90 369 53)" fill="var(--cros-sys-illo-color1-2)" />
<rect x="331" y="90" width="6" height="76" rx="2" transform="rotate(90 331 90)" fill="var(--cros-sys-illo-color1-2)" />
<rect x="331" y="63" width="6" height="76" rx="2" transform="rotate(90 331 63)" fill="var(--cros-sys-illo-color1-2)" />
<rect x="301" y="63" width="6" height="46" rx="2" transform="rotate(90 301 63)" fill="var(--cros-sys-illo-color1)" />
<path d="M25 42C25 30.9543 33.9543 22 45 22H139C150.046 22 159 30.9543 159 42V96C159 107.046 150.046 116 139 116H45C33.9543 116 25 107.046 25 96V42Z" fill="var(--cros-sys-illo-base)" />
<rect x="34" y="66.9199" width="3" height="7.32478" rx="1.5" fill="var(--cros-sys-illo-color1-2)" />
<rect x="62" y="55" width="3" height="30.9895" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="90" y="55" width="3" height="30.9895" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="41" y="64.8164" width="3" height="12.3958" rx="1.5" fill="var(--cros-sys-illo-color1-2)" />
<rect x="69" y="58.5059" width="3" height="24.7916" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="97" y="65.5176" width="3" height="10.142" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="48" y="67.6211" width="3" height="5.63445" rx="1.5" fill="var(--cros-sys-illo-color1-2)" />
<rect x="76" y="63.4141" width="3" height="14.6496" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="104" y="68.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-2)" />
<rect x="55" y="61.3105" width="3" height="19.1571" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="83" y="58.5059" width="3" height="24.7916" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="111" y="68.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-2)" />
<rect x="27" y="68.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-2)" />
<rect x="124" y="66.9199" width="3" height="7.32478" rx="1.5" fill="var(--cros-sys-illo-color1-2)" />
<rect x="152" y="55" width="3" height="30.9895" rx="1.5" fill="var(--cros-sys-illo-color1-2)" />
<rect x="131" y="64.8164" width="3" height="12.3958" rx="1.5" fill="var(--cros-sys-illo-color1-2)" />
<rect x="138" y="67.6211" width="3" height="5.63445" rx="1.5" fill="var(--cros-sys-illo-color1-2)" />
<rect x="145" y="61.3105" width="3" height="19.1571" rx="1.5" fill="var(--cros-sys-illo-color1-2)" />
<rect x="117" y="68.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1-2)" />
<path d="M311.299 124.316L286.76 130.649C286.76 130.649 279.571 129.375 278.327 121.472C277.083 113.569 277.622 112.745 277.622 112.745C277.622 112.745 270.043 112.623 268.865 104.934C267.786 97.2599 272.898 96.979 272.898 96.979C272.898 96.979 273.546 94.2477 277.927 91.6184C277.927 91.6184 279.098 88.1619 281.823 86.9852C284.663 85.7258 287.69 86.4221 287.69 86.4221C287.69 86.4221 283.411 80.3538 283.175 78.6942C282.939 77.0346 283.788 70.5871 290.147 74.4612C296.408 78.3191 303.75 90.4595 307.581 104.864C311.413 119.268 311.299 124.316 311.299 124.316Z" fill="var(--cros-sys-illo-color1-2)" />
<path d="M288.383 87.1441C282.655 84.994 279.004 89.3634 278.163 93.2791C277.322 97.1947 278.142 101.483 279.798 104.995C280.411 106.209 281.122 107.44 282.111 108.209C283.1 108.978 284.367 109.286 285.467 108.756C286.895 108.077 287.428 105.429 287.373 103.9" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" />
<path d="M278.422 92.3062C276.416 92.1817 275.319 93.3199 274.403 94.5889C273.486 95.858 273.229 97.4372 273.07 99.0324C272.787 102.634 273.589 106.412 276.097 109.05C277.648 110.722 280.217 111.748 282.235 110.558C282.792 110.243 283.284 109.716 283.479 109.139" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" />
<path d="M272.719 97.4566C271.271 97.0178 269.597 97.9607 268.862 99.3607C268.127 100.761 268.166 102.388 268.319 103.933C268.555 105.593 268.89 107.268 269.75 108.827C270.627 110.287 271.946 111.516 273.493 111.97C275.139 112.441 277.028 112.04 278.158 110.705" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" />
<path d="M311.99 124.427C308.938 112.075 305.591 99.6748 302.276 92.0418C299.773 86.2636 296.495 79.65 291.352 75.7717C289.902 74.7246 288.123 73.8266 286.282 73.9317C285.559 74.0164 284.804 74.2986 284.214 74.8103C283.592 75.5194 283.332 76.4902 283.483 77.4268C283.788 79.9082 285.702 81.8412 286.892 83.8591C288.414 86.3363 289.919 88.9121 290.997 91.6209C291.76 93.7719 292.425 95.9067 292.976 98.1242" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" />
<path d="M298.551 103.696C297.642 102.433 296.685 101.466 295.63 100.484C293.337 98.3872 291.276 96.734 288.462 95.9712C287.492 95.7115 286.358 95.8306 285.637 96.5236C284.702 97.2831 284.493 98.5661 284.711 99.7162C284.928 100.866 285.573 101.883 286.447 102.735C288.097 104.423 289.878 105.929 291.643 107.534C291.643 107.534 290.495 108.36 290.036 108.69C288.183 110.111 287.202 111.774 286.717 114.127C286.249 116.381 286.569 118.764 287.563 120.749" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" />
<path d="M277.617 111.529C276.865 117.385 278.205 129.052 287.353 131.355" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" />
<path d="M431.171 174.704L436.193 204.024" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M411.062 215.272C410.173 214.205 405.92 212.604 403.904 211.937L394.569 217.583L386.566 223.896L381.632 227.631C381.38 230.165 380.734 235.668 380.165 237.411C379.453 239.589 379.542 241.59 381.632 242.524C383.303 243.27 385.173 241.649 385.899 240.745L394.569 228.475C394.88 228.638 395.555 229.018 395.769 229.231C396.036 229.498 398.392 234.61 399.859 236.789C401.326 238.967 405.994 241.279 407.772 242.123C409.195 242.799 415.478 242.909 418.442 242.879C418.768 242.212 419.42 240.647 419.42 239.723C419.42 238.567 420.309 234.077 420.087 231.854C419.909 230.076 418.116 224.978 417.242 222.651C415.552 220.636 411.951 216.338 411.062 215.272Z" fill="var(--cros-sys-illo-color1-2)" />
<path d="M380.497 178.204C378.605 185.943 381.635 196.698 383.926 204.252C384.502 206.047 384.921 207.889 385.178 209.757" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M339.142 202.601C327.761 165.613 316.38 123.589 316.38 123.589L279.392 133.619C273.701 146.863 272.947 158.443 277.699 172.029C281.455 182.827 285.082 193.682 288.056 204.75C292.238 220.285 300.361 237.242 317.063 241.368C331.033 244.825 349.57 240.799 360.808 231.822" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M365.73 239.604C365.666 240.23 365.441 240.828 365.077 241.342C364.713 241.855 364.223 242.266 363.653 242.534C363.079 242.698 362.474 242.727 361.887 242.619C361.3 242.51 360.745 242.267 360.268 241.908C359.867 241.4 359.579 240.813 359.422 240.185C359.265 239.557 359.243 238.903 359.357 238.267C359.705 235.402 360.407 232.592 361.448 229.902C363.453 225.1 366.172 220.63 369.515 216.643C371.919 213.641 375.874 210.725 379.729 210.625C380.554 210.625 381.379 210.725 382.204 210.625C384.58 210.397 386.686 208.605 389.061 208.776C390.697 208.904 392.134 209.942 393.756 210.198C395.373 210.283 396.994 210.197 398.593 209.942C401.239 209.843 402.434 211.137 405.109 212.204" fill="var(--cros-sys-illo-color1-2)" />
<path d="M365.73 239.604C365.666 240.23 365.441 240.828 365.077 241.342C364.713 241.855 364.223 242.266 363.653 242.534C363.079 242.698 362.474 242.727 361.887 242.619C361.3 242.51 360.745 242.267 360.268 241.908C359.867 241.4 359.579 240.813 359.422 240.185C359.265 239.557 359.243 238.903 359.357 238.267C359.705 235.402 360.407 232.592 361.448 229.902C363.453 225.1 366.172 220.63 369.515 216.643C371.919 213.641 375.874 210.725 379.729 210.625C380.554 210.625 381.379 210.725 382.204 210.625C384.58 210.397 386.686 208.605 389.061 208.776C390.697 208.904 392.134 209.942 393.756 210.198C395.373 210.283 396.994 210.197 398.593 209.942C401.239 209.843 402.434 211.137 405.109 212.204" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M419.078 242.321C420.363 237.632 420.446 232.696 419.319 227.967C418.075 222.948 415.173 218.496 411.082 215.334C409.284 213.968 407.262 212.923 405.107 212.247C406.43 209.401 409.873 208.121 412.846 207.225C415.854 206.47 418.952 206.139 422.051 206.243C430.729 206.129 438.382 202.971 447.004 202.046C454.547 201.367 462.113 203.095 468.613 206.983" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M372.473 241.183C372.082 241.696 371.573 242.107 370.988 242.379C370.403 242.652 369.761 242.778 369.116 242.748C368.471 242.712 367.849 242.5 367.315 242.137C366.781 241.773 366.356 241.272 366.086 240.685C365.646 239.399 365.646 238.002 366.086 236.716C368.362 229.496 372.194 222.863 377.31 217.283" fill="var(--cros-sys-illo-color1-2)" />
<path d="M372.473 241.183C372.082 241.696 371.573 242.107 370.988 242.379C370.403 242.652 369.761 242.778 369.116 242.748C368.471 242.712 367.849 242.5 367.315 242.137C366.781 241.773 366.356 241.272 366.086 240.685C365.646 239.399 365.646 238.002 366.086 236.716C368.362 229.496 372.194 222.863 377.31 217.283" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M379.189 240.628C378.651 241.39 377.898 241.975 377.026 242.307C376.406 242.621 375.703 242.732 375.016 242.625C374.33 242.518 373.694 242.198 373.199 241.709C371.777 240.059 372.488 236.446 373.199 234.596C374.921 230.001 383.229 218.649 384.836 217.269" fill="var(--cros-sys-illo-color1-2)" />
<path d="M379.189 240.628C378.651 241.39 377.898 241.975 377.026 242.307C376.406 242.621 375.703 242.732 375.016 242.625C374.33 242.518 373.694 242.198 373.199 241.709C371.777 240.059 372.488 236.446 373.199 234.596C374.921 230.001 383.229 218.649 384.836 217.269" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M394.039 217.795C390.198 221.067 382.772 232.021 381.762 233.985C380.798 235.627 380.151 237.437 379.856 239.319C379.699 240.913 380.368 242.577 382.175 242.648C383.122 242.664 384.048 242.364 384.806 241.795C386.684 240.372 394.011 228.991 394.879 227.569C396.572 231.296 397.411 233.857 400.071 237.015C402.512 239.734 405.811 241.537 409.418 242.122C411.31 242.478 417.669 242.207 424.569 242.236H461.77C471.729 242.236 480.264 235.635 484.006 226.587C488.444 216.06 485.798 204.038 481.53 193.867C478.51 186.895 474.777 180.254 470.391 174.05C462.973 162.993 452.443 154.384 440.132 149.31C433.53 146.932 426.65 145.412 419.661 144.786M397.041 145.782C390.052 146.362 383.212 148.123 376.811 150.989C366.535 155.732 357.173 162.248 349.156 170.237C343.983 175.586 339.191 181.29 334.816 187.308" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M402.465 136.064C400.999 139.669 399.371 143.274 397.905 146.88C403.768 150.649 411.259 152.124 417.936 150.485C419.401 150.157 420.867 149.666 422.17 148.846C422.658 148.519 423.147 148.191 423.472 147.699C424.287 146.388 423.472 144.585 422.821 143.274C421.681 140.816 420.704 138.194 420.378 135.572C417.447 136.391 414.353 137.375 411.259 137.702C408.165 138.03 405.07 137.702 402.465 136.064Z" fill="var(--cros-sys-illo-color1-2)" />
<path d="M409.959 139.669C420.48 139.669 429.009 131.086 429.009 120.498C429.009 109.91 420.48 101.327 409.959 101.327C399.438 101.327 390.908 109.91 390.908 120.498C390.908 131.086 399.438 139.669 409.959 139.669Z" fill="var(--cros-sys-illo-color1-2)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
<path d="M409.784 113.638L428.66 117.507C428.311 113.638 426.213 109.417 423.417 106.603C420.621 103.789 416.95 102.03 412.93 101.502C410.833 101.326 404.366 101.502 402.968 103.085C401.57 104.492 405.415 106.779 406.464 108.362C407.338 110.12 409.61 111.703 409.784 113.638Z" fill="var(--cros-sys-illo-color1)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
<path d="M397.58 146.06L401 138.357" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
<path d="M409.374 102.413C406.752 98.0159 404.306 94.3224 400.286 90.6289C395.217 86.2318 388.052 84.1213 384.032 88.3424L383.857 88.6942C381.934 90.8048 381.585 94.4983 382.983 98.0159C383.682 99.7747 384.731 101.358 385.605 102.941L391.023 112.086L418.113 117.011L409.374 102.413Z" fill="var(--cros-sys-illo-color1-1)" />
<path d="M397.58 146.06C398.557 148.027 400.186 148.519 402.14 149.338C405.885 150.977 410.282 151.632 414.516 151.304C418.262 150.977 422.985 149.174 425.753 146.388" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
<path d="M421.52 137.539L424.125 145.405" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
<path d="M401.77 125.885C402.294 127.555 404.401 129.019 406.24 129.365C408.17 129.699 410.156 129.306 411.812 128.261" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M241.459 135.396C243.449 136.323 244.29 138.702 243.324 140.673L241.426 144.548L239.605 148.46C238.679 150.45 236.299 151.291 234.328 150.325L230.454 148.426L226.542 146.606C224.552 145.68 223.711 143.3 224.677 141.329L226.575 137.454L228.396 133.543C229.322 131.553 231.702 130.711 233.673 131.677L237.547 133.576L241.459 135.396Z" fill="var(--cros-sys-illo-color4)" />
<path d="M97.5674 139.442C94.1342 135.562 97.2274 129.484 102.385 129.975V129.975C103.959 130.125 105.525 129.615 106.71 128.567V128.567C110.589 125.134 116.668 128.227 116.177 133.384V133.384C116.027 134.959 116.536 136.525 117.585 137.71V137.71C121.018 141.589 117.925 147.668 112.767 147.176V147.176C111.193 147.026 109.627 147.536 108.442 148.584V148.584C104.562 152.018 98.4837 148.924 98.9753 143.767V143.767C99.1254 142.193 98.6156 140.626 97.5674 139.442V139.442Z" fill="var(--cros-sys-illo-color5)" />
<path d="M159.24 158.827L155.125 152.005C150.754 144.759 139.985 145.613 136.811 153.459L133.823 160.843C131.201 167.324 138.162 173.511 144.29 170.147C146.155 169.123 148.369 168.947 150.371 169.664C156.953 172.02 162.851 164.812 159.24 158.827Z" fill="var(--cros-sys-illo-color1-1)" />
<path d="M175.861 180.891C177.856 179.192 179.726 177.138 181.575 175.251C184.197 172.614 187.695 171.104 191.337 171.139C193.383 171.058 195.48 171.237 197.547 170.989C204.696 170.109 209.702 163.362 207.799 156.254C206.126 150.022 199.159 146.09 192.863 148.265C190.024 149.264 187.653 151.255 184.865 152.515C181.983 153.848 178.706 154.283 175.597 153.382C172.968 152.711 170.287 151.78 167.542 151.349C164.871 151.012 162.116 151.343 159.537 152.29C151.968 155.152 147.462 163.319 149.165 171.336C151.086 180.991 160.723 186.616 169.94 184.131C172.143 183.476 174.075 182.278 175.861 180.891Z" stroke="var(--cros-sys-illo-color3)" stroke-width="3" />
<path fill-rule="evenodd" clip-rule="evenodd" d="M147.355 169.247C148.367 169.177 149.395 169.314 150.372 169.664C150.384 169.669 150.397 169.673 150.41 169.678C149.733 163.968 152.417 158.356 157.075 155.236L155.524 152.665C150.082 156.247 146.864 162.635 147.355 169.247Z" fill="var(--cros-sys-illo-color1-2)" />
</svg>`],["onboarding_welcome", svg`<svg xmlns="http://www.w3.org/2000/svg" width="512" height="236" viewBox="0 0 512 236" fill="none">
<rect width="512" height="236" fill="var(--cros-sys-illo-color1-2)" />
<path d="M167.101 135C77.1014 148.2 81.9348 210.5 95.6014 240C149.268 255.667 256.401 271.7 255.601 210.5C254.801 149.3 216.935 137 198.101 138.5C187.301 150.9 172.935 141.333 167.101 135Z" fill="var(--cros-sys-illo-base)" />
<path d="M231 51C231 39.9543 239.954 31 251 31H404C415.046 31 424 39.9543 424 51V89C424 100.046 415.046 109 404 109H251C239.954 109 231 100.046 231 89V51Z" fill="var(--cros-sys-illo-base)" />
<rect x="262" y="66.9199" width="3" height="7.32478" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="290" y="55" width="3" height="30.9895" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="318" y="55" width="3" height="30.9895" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="346" y="63.4141" width="3" height="14.0861" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="374" y="55" width="3" height="30.9895" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="269" y="64.8164" width="3" height="12.3958" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="297" y="58.5059" width="3" height="24.7916" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="325" y="65.5176" width="3" height="10.142" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="353" y="64.8164" width="3" height="12.3958" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="381" y="64.8164" width="3" height="12.3958" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="276" y="67.6211" width="3" height="5.63445" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="304" y="63.4141" width="3" height="14.6496" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="332" y="68.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="360" y="58.5059" width="3" height="24.7916" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="388" y="62.7129" width="3" height="15.7765" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="283" y="61.3105" width="3" height="19.1571" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="311" y="58.5059" width="3" height="24.7916" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="339" y="68.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="367" y="62.0117" width="3" height="18.0302" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="395" y="68.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="402" y="68.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="409" y="68.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="416" y="68.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="248" y="68.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="234" y="68.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="255" y="68.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<rect x="241" y="68.3223" width="3" height="4.50756" rx="1.5" fill="var(--cros-sys-illo-color1)" />
<path d="M197.5 138C187.1 150.4 173.833 141.833 168.5 136L168 134.5L197.5 138Z" fill="var(--cros-sys-illo-color1-1)" />
<path d="M253.6 192.3C246.4 169.4 247.3 162 231.9 149.6C223.7 143 210.9 139 198 139" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" />
<path d="M288.176 129.692C280.548 135.311 275 148.656 275 148.656L302.047 162L310.369 157.786C310.369 157.786 333.254 163.405 341.577 158.489C346.398 155.64 349.412 151.018 347.331 146.803C339.009 143.994 348.511 143.739 345.045 139.525C343.658 136.014 330.573 136.035 325.627 135.311C317.03 134.054 313.143 132.502 313.143 132.502C313.143 132.502 322.159 133.205 322.159 128.287C322.159 123.372 295.805 124.073 288.176 129.692Z" fill="var(--cros-sys-illo-color1-1)" />
<path d="M275 149C275 149 277.651 130.845 295.002 127.435C304.998 126.197 316.262 124.439 319.293 125.173C322.326 125.908 324.495 128.612 322.287 130.913C320.08 133.215 311.146 132.602 311.146 132.602C311.146 132.602 317.134 134.767 324.518 135.636C331.904 136.505 339.766 136.134 342.686 137.336C345.606 138.537 346.546 139.489 345.705 141.95C344.865 144.412 333.693 143.349 330.967 142.918" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M301.083 162C301.083 162 306.767 158.461 309.897 157.837C313.026 157.214 325.404 161.752 331.286 161.42C337.169 161.089 344.084 160.508 342.857 156.477C341.63 152.446 332.193 154.175 327.471 152.705C322.749 151.233 319.013 149.575 311.729 145.97C304.444 142.364 297 144.811 297 144.811" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M319 144C319 144 325.067 147.202 332.433 148.942C339.798 150.682 346.12 148.634 346.966 153.028C347.264 154.577 345.579 155.496 343.148 156" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
<path d="M322 140C322 140 325.005 141.622 333.06 144.028C341.116 146.433 349.302 144.326 347.826 150.24C347.596 151.163 346.72 151.39 345.793 152" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" />
<path d="M267 265.5C270.6 258.7 291.057 253.5 302.1 202.7C304.1 193.5 306.6 175.5 308.4 163C296.6 158.2 284 152.9 272.2 148.1C261.8 169.5 254.9 186 245.4 207.5" fill="var(--cros-sys-illo-base)" />
<path d="M267 265.5C270.6 258.7 291.057 253.5 302.1 202.7C304.1 193.5 306.6 175.5 308.4 163C296.6 158.2 284 152.9 272.2 148.1C261.8 169.5 254.9 186 245.4 207.5" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-miterlimit="10" stroke-linecap="round" />
<path d="M197.532 139.472L189.316 121.482L172.035 120.774L167.36 135.506" fill="var(--cros-sys-illo-color1-1)" />
<path d="M197.532 139.472L189.316 121.482L172.035 120.774L167.36 135.506" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M186.2 126.723C195.822 126.723 203.623 118.922 203.623 109.3C203.623 99.6777 195.822 91.877 186.2 91.877C176.577 91.877 168.776 99.6777 168.776 109.3C168.776 118.922 176.577 126.723 186.2 126.723Z" fill="var(--cros-sys-illo-color1-1)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M192 114.7C194.5 116 197 115.5 198.1 113" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M195.266 95.4184C193.628 93.9735 191.659 92.9579 189.532 92.464C187.406 91.9694 185.19 92.0112 183.084 92.5853C178.976 93.5769 175.009 94.1435 172.176 97.4015C169.343 100.659 169.06 103.776 168.21 106.326C167.758 107.649 167.519 109.035 167.502 110.433C167.502 112.558 168.21 112.133 169.768 111.567C175.818 109.229 181.571 106.187 186.908 102.501C189.849 100.329 192.641 97.9638 195.266 95.4184Z" fill="var(--cros-sys-illo-color1)" />
<path d="M178.409 96.6932C176.709 97.4014 175.718 100.943 173.734 101.934C174.018 101.793 170.335 99.3846 171.751 97.5431C173.262 95.6464 175.081 94.0174 177.134 92.7269L183.933 87.7691L190.449 82.6697L193.424 80.8282C194.573 80.1125 195.894 79.7209 197.249 79.695C197.955 79.649 198.662 79.7803 199.305 80.0772C199.949 80.374 200.508 80.827 200.932 81.3948C201.266 82.2126 201.413 83.0945 201.365 83.9766C201.315 84.8586 201.07 85.7186 200.648 86.4943C202.195 85.6567 203.871 85.0823 205.606 84.7945C206.133 84.6289 206.691 84.5939 207.234 84.6926C207.778 84.7914 208.288 85.0208 208.722 85.3611C209.448 86.0824 209.898 87.0343 209.997 88.0524C210.422 92.302 207.731 96.1266 205.039 99.3846L203.198 100.943C202.631 101.084 200.365 97.6847 199.232 96.9765C193.566 93.5769 191.158 91.1688 178.409 96.6932Z" fill="var(--cros-sys-illo-color1)" />
<path d="M182.942 254.493C162.261 271.349 134.072 273.616 113.249 260.725C87.8938 245.144 84.4941 213.839 88.3187 194.857C93.8431 167.519 117.924 144.855 150.079 137.489C155.746 136.123 161.535 135.316 167.36 135.081C169.006 137.67 171.183 139.88 173.747 141.565C176.311 143.25 179.204 144.371 182.234 144.855C185.176 145.118 188.141 144.72 190.91 143.692C193.679 142.662 196.184 141.027 198.24 138.905" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M166 221L129 215L135.5 185" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M159.003 136.78C165.094 148.962 177.276 155.62 188.467 153.637C191.897 153.098 195.165 151.801 198.032 149.841C200.899 147.88 204 144.5 206.5 140" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M126 230H135V242V254H126V230Z" fill="var(--cros-sys-illo-color1-2)" />
<mask id="path-49-outside-1_127_25947" maskUnits="userSpaceOnUse" x="114" y="212" width="33" height="20" fill="black">
<rect fill="var(--cros-sys-illo-base)" x="114" y="212" width="33" height="20" />
<path d="M143 215.5C143.552 215.5 144.004 215.948 143.963 216.499C143.857 217.93 143.523 219.337 142.972 220.666C142.294 222.304 141.3 223.792 140.046 225.046C138.792 226.3 137.304 227.294 135.666 227.972C134.028 228.651 132.273 229 130.5 229C128.727 229 126.972 228.651 125.334 227.972C123.696 227.294 122.208 226.3 120.954 225.046C119.7 223.792 118.706 222.304 118.028 220.666C117.477 219.337 117.143 217.93 117.037 216.499C116.996 215.948 117.448 215.5 118 215.5L130.5 215.5H143Z" />
</mask>
<path d="M143 215.5C143.552 215.5 144.004 215.948 143.963 216.499C143.857 217.93 143.523 219.337 142.972 220.666C142.294 222.304 141.3 223.792 140.046 225.046C138.792 226.3 137.304 227.294 135.666 227.972C134.028 228.651 132.273 229 130.5 229C128.727 229 126.972 228.651 125.334 227.972C123.696 227.294 122.208 226.3 120.954 225.046C119.7 223.792 118.706 222.304 118.028 220.666C117.477 219.337 117.143 217.93 117.037 216.499C116.996 215.948 117.448 215.5 118 215.5L130.5 215.5H143Z" fill="var(--cros-sys-illo-base)" />
<path d="M143 215.5C143.552 215.5 144.004 215.948 143.963 216.499C143.857 217.93 143.523 219.337 142.972 220.666C142.294 222.304 141.3 223.792 140.046 225.046C138.792 226.3 137.304 227.294 135.666 227.972C134.028 228.651 132.273 229 130.5 229C128.727 229 126.972 228.651 125.334 227.972C123.696 227.294 122.208 226.3 120.954 225.046C119.7 223.792 118.706 222.304 118.028 220.666C117.477 219.337 117.143 217.93 117.037 216.499C116.996 215.948 117.448 215.5 118 215.5L130.5 215.5H143Z" stroke="var(--cros-sys-illo-color1)" stroke-width="6" mask="url(#path-49-outside-1_127_25947)" />
<path d="M138.5 205.5V216.5C138.5 220.918 134.918 224.5 130.5 224.5C126.082 224.5 122.5 220.918 122.5 216.5V205.5C122.5 201.082 126.082 197.5 130.5 197.5C134.918 197.5 138.5 201.082 138.5 205.5Z" fill="var(--cros-sys-illo-color1-2)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" />
<line x1="127.5" y1="230" x2="127.5" y2="242" stroke="var(--cros-sys-illo-color1)" stroke-width="3" />
<line x1="133.5" y1="230" x2="133.5" y2="242" stroke="var(--cros-sys-illo-color1)" stroke-width="3" />
<path d="M273.893 180.5H194.723C187.167 180.5 180.371 185.095 177.555 192.106L157.121 242.993H265.808L284.564 196.285C287.599 188.729 282.035 180.5 273.893 180.5Z" fill="var(--cros-sys-illo-color1-2)" stroke="var(--cros-sys-illo-color1)" stroke-width="3" />
<path d="M272.245 115.129C272.136 117.125 269.915 118.263 268.231 117.185L261.828 113.088C260.131 112.002 260.252 109.484 262.045 108.565L268.863 105.072C270.656 104.154 272.77 105.527 272.66 107.538L272.245 115.129Z" fill="var(--cros-sys-illo-color3)" />
<path d="M233.437 170.71C230.188 167.509 230.188 162.32 233.437 159.12L236.197 156.4C239.446 153.2 244.714 153.2 247.963 156.4C251.212 159.601 251.212 164.79 247.963 167.99L245.202 170.71C241.953 173.91 236.686 173.91 233.437 170.71Z" fill="var(--cros-sys-illo-color4)" />
<path d="M235.865 117.863C237.088 116.796 238.912 116.796 240.135 117.863L241.436 118.998C241.97 119.465 242.642 119.743 243.35 119.791L245.073 119.908C246.692 120.018 247.982 121.308 248.092 122.927L248.209 124.65C248.257 125.358 248.535 126.03 249.002 126.564L250.137 127.865C251.204 129.088 251.204 130.912 250.137 132.135L249.002 133.436C248.535 133.97 248.257 134.642 248.209 135.35L248.092 137.073C247.982 138.692 246.692 139.982 245.073 140.092L243.35 140.209C242.642 140.257 241.97 140.535 241.436 141.002L240.135 142.137C238.912 143.204 237.088 143.204 235.865 142.137L234.564 141.002C234.03 140.535 233.358 140.257 232.65 140.209L230.927 140.092C229.308 139.982 228.018 138.692 227.908 137.073L227.791 135.35C227.743 134.642 227.465 133.97 226.998 133.436L225.863 132.135C224.796 130.912 224.796 129.088 225.863 127.865L226.998 126.564C227.465 126.03 227.743 125.358 227.791 124.65L227.908 122.927C228.018 121.308 229.308 120.018 230.927 119.908L232.65 119.791C233.358 119.743 234.03 119.465 234.564 118.998L235.865 117.863Z" stroke="var(--cros-sys-illo-color2)" stroke-width="3" />
</svg>`],["recording_list_empty", svg`<svg xmlns="http://www.w3.org/2000/svg" width="640" height="600" viewBox="0 0 640 600" fill="none">
<path d="M350.952 303.287L374.115 301.568L400.709 303.287C393.846 342.396 386.394 390.077 389.826 432.624H357.628C345.804 396.571 350.952 343.256 350.952 303.287Z" fill="var(--cros-sys-illo-color1-1)" stroke="var(--cros-sys-illo-color1)" stroke-width="3.5" stroke-linecap="round" stroke-linejoin="round" />
<path d="M431 388.5C431 388.5 428.782 392.225 426.614 412.437C425.313 430.928 418.848 432.625 418.848 432.625" stroke="var(--cros-sys-illo-color1)" stroke-width="3.5" stroke-linecap="round" stroke-linejoin="round" />
<path d="M198.456 270.278C209.071 278.129 215.688 297.034 215.688 297.034L178.956 315.173L165.564 308.378C165.564 308.378 133.72 316.229 122.139 309.36C115.43 305.38 111.236 298.921 114.131 293.033C125.713 289.108 112.49 288.751 117.313 282.863C119.243 277.958 137.451 277.987 144.334 276.976C156.295 275.22 161.705 273.05 161.705 273.05C161.705 273.05 149.159 274.032 149.159 267.162C149.159 260.294 187.84 262.428 198.456 270.278Z" fill="var(--cros-sys-illo-color1-2)" />
<path d="M215.688 296.126C215.688 296.126 211.963 270.742 187.582 265.973C173.536 264.242 157.708 261.784 153.449 262.811C149.188 263.837 146.14 267.619 149.242 270.837C152.343 274.055 164.898 273.198 164.898 273.198C164.898 273.198 156.484 276.225 146.107 277.44C135.728 278.656 124.682 278.137 120.579 279.817C116.476 281.496 115.155 282.827 116.337 286.269C117.517 289.711 133.215 288.225 137.045 287.622" stroke="var(--cros-sys-illo-color1)" stroke-width="3.3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M179.135 314.265C179.135 314.265 171.178 309.451 166.797 308.602C162.416 307.754 145.09 313.928 136.855 313.477C128.619 313.026 118.939 312.235 120.657 306.751C122.375 301.267 135.586 303.62 142.195 301.62C148.806 299.618 154.036 297.362 164.232 292.458C174.43 287.552 184.851 290.881 184.851 290.881" stroke="var(--cros-sys-illo-color1)" stroke-width="3.5" stroke-linecap="round" stroke-linejoin="round" />
<path d="M153.108 289.777C153.108 289.777 144.853 294.133 134.833 296.5C124.813 298.868 116.212 296.082 115.062 302.06C114.656 304.166 116.948 305.417 120.255 306.103" stroke="var(--cros-sys-illo-color1)" stroke-width="3.5" stroke-linecap="round" />
<path d="M324.271 377.081C324.271 377.081 308.776 420.615 251.02 420.615C193.264 420.615 159.456 325.12 159.456 325.12L217.212 297.034L252.429 357.42C304.549 297.034 329.905 302.651 391.886 302.651" stroke="var(--cros-sys-illo-color1)" stroke-width="3.5" stroke-linecap="round" stroke-linejoin="round" />
<path d="M149.48 283.429C149.48 283.429 145.287 285.635 134.047 288.909C122.806 292.18 111.384 289.314 113.444 297.36C113.765 298.616 114.988 298.924 116.28 299.754" stroke="var(--cros-sys-illo-color1)" stroke-width="3.5" stroke-linecap="round" />
<path d="M333.65 147.009L355.807 159.882C361.282 163.064 361.243 170.986 355.736 174.112L333.279 186.862C327.772 189.989 320.949 185.963 321.023 179.631L321.323 154.007C321.397 147.724 328.217 143.852 333.65 147.009Z" stroke="var(--cros-sys-illo-color3)" stroke-width="3.5" />
<path d="M220.716 165.314H324.911C335.209 165.314 343.557 173.63 343.557 183.888V235.327C343.557 245.585 335.209 253.901 324.911 253.901H270.87L238.213 286.438C235.391 289.249 230.559 287.26 230.559 283.28V253.906H220.716C210.418 253.906 202.07 245.591 202.07 235.333V183.894C202.07 173.636 210.418 165.32 220.716 165.32V165.314Z" fill="var(--cros-sys-illo-color1-2)" />
<path d="M222.811 223.895C223.124 224.003 223.409 224.177 223.649 224.405C223.889 224.632 224.078 224.908 224.204 225.215C224.329 225.522 224.387 225.852 224.375 226.185C224.364 226.517 224.282 226.843 224.135 227.143C221.587 232.407 217.198 236.563 211.808 238.818C206.419 241.073 200.407 241.267 194.924 239.364C189.441 237.461 184.87 233.594 182.088 228.504C179.306 223.413 178.507 217.456 179.844 211.772C179.92 211.448 180.063 211.142 180.264 210.875C180.466 210.609 180.72 210.387 181.012 210.224C181.304 210.062 181.626 209.962 181.957 209.932C182.288 209.902 182.622 209.942 182.935 210.049L222.811 223.895Z" fill="var(--cros-sys-illo-color5)" />
<path fill-rule="evenodd" clip-rule="evenodd" d="M322.945 164.976L322.773 179.651C322.715 184.633 328.083 187.8 332.415 185.34L343.202 179.216C343.494 180.42 343.668 181.669 343.712 182.951L334.143 188.384C327.462 192.178 319.184 187.293 319.273 179.61L319.445 164.976H322.945Z" fill="var(--cros-sys-illo-base)" />
<path d="M325.013 353.265C323.586 356.672 322.016 369.105 327.155 391.587C333.578 419.69 326.298 432.464 354.134 432.89C376.402 433.231 405.951 433.032 417.941 432.89" stroke="var(--cros-sys-illo-color1)" stroke-width="3.5" stroke-linecap="round" stroke-linejoin="round" />
<path d="M391.886 302.65C448.093 304.4 479 340 496 379C505.154 400 511.5 419 514.5 455.5" stroke="var(--cros-sys-illo-color1)" stroke-width="3.5" stroke-linecap="round" stroke-linejoin="round" />
<path d="M424.5 360C428.5 380.5 443.7 444.4 444.5 456" stroke="var(--cros-sys-illo-color1)" stroke-width="3.5" stroke-linecap="round" stroke-linejoin="round" />
<path d="M341.756 432.171C338.531 440.857 333.467 453.678 332.5 457.5" stroke="var(--cros-sys-illo-color1)" stroke-width="3.5" stroke-linecap="round" stroke-linejoin="round" />
<path d="M418.848 433.078C425.035 439.837 431 446.5 434.5 456.5" stroke="var(--cros-sys-illo-color1)" stroke-width="3.5" stroke-linecap="round" stroke-linejoin="round" />
<path d="M374.596 289.544C367.842 290.43 361.71 287.402 361.71 287.402L362.455 301.435C362.455 301.435 362.455 311.15 372.891 311.51C382.955 312.229 388.918 301.795 388.918 301.795L385.023 285.243C385.023 285.243 381.349 288.659 374.596 289.544Z" fill="var(--cros-sys-illo-color1-2)" stroke="var(--cros-sys-illo-color1)" stroke-width="3.5" stroke-linecap="round" stroke-linejoin="round" />
<path d="M373.5 291.591C387.024 291.591 397.988 280.628 397.988 267.103C397.988 253.579 387.024 242.615 373.5 242.615C359.976 242.615 349.012 253.579 349.012 267.103C349.012 280.628 359.976 291.591 373.5 291.591Z" fill="var(--cros-sys-illo-color1-2)" stroke="var(--cros-sys-illo-color1)" stroke-width="3.5" />
<path d="M367.851 252.204C367.851 252.204 361.443 257.108 350.826 256.998C354.133 250.452 364.59 233.363 386.902 246.61C401.9 254.201 398.091 274.576 395.82 276.174C370.484 270.181 367.851 252.204 367.851 252.204Z" fill="var(--cros-sys-illo-color1)" />
<path d="M355.415 272.206C357.307 276.26 362.298 278.083 366.446 276.191" stroke="var(--cros-sys-illo-color1)" stroke-width="3.5" stroke-linecap="round" stroke-linejoin="round" />
<path d="M383.62 235.163C384.728 223.01 395.54 213.966 407.461 215.096C414.116 215.662 419.938 219.619 423.542 224.706C423.264 223.01 423.264 221.314 423.542 219.336C424.65 207.183 435.462 198.138 447.383 199.269C451.819 199.834 455.7 196.16 455.978 191.638C455.978 191.072 455.978 190.507 456.256 189.942C457.642 179.484 466.237 171.571 476.493 170.723C478.989 170.44 481.206 170.723 483.424 171.288C487.861 172.418 492.296 169.027 492.851 164.222L493.96 147.829C494.791 135.111 508.376 127.762 518.911 134.545C529.445 141.046 529.445 156.874 518.633 163.374L500.89 174.114C497.564 176.093 496.178 180.332 497.842 184.007C499.226 187.398 500.059 191.355 499.504 195.312C498.395 207.465 487.583 216.51 475.662 215.379H475.385C470.949 214.814 467.068 218.205 466.79 222.728C466.79 223.01 466.79 223.576 466.79 223.858C465.681 236.011 454.869 245.056 442.948 243.925C436.294 243.36 430.472 239.403 426.868 234.316C427.146 236.011 427.146 237.707 426.868 239.686C425.759 251.839 414.947 260.883 403.026 259.753C391.105 258.34 382.233 247.317 383.62 235.163Z" fill="var(--cros-sys-illo-color1)" />
<path d="M388.546 186.559C393.354 185.559 396.441 180.851 395.442 176.043C394.442 171.235 389.735 168.148 384.927 169.147C380.119 170.146 377.031 174.854 378.03 179.662C379.03 184.47 383.738 187.558 388.546 186.559Z" fill="var(--cros-sys-illo-color2)" />
<path d="M151.204 133.166C154.373 130.4 159.098 130.4 162.267 133.166L165.086 135.626C166.471 136.835 168.214 137.557 170.047 137.681L173.781 137.935C177.977 138.22 181.318 141.561 181.603 145.758L181.857 149.491C181.982 151.325 182.704 153.067 183.912 154.452L186.373 157.272C189.138 160.441 189.138 165.165 186.373 168.335L183.912 171.154C182.704 172.539 181.982 174.281 181.857 176.115L181.603 179.848C181.318 184.045 177.977 187.386 173.781 187.671L170.047 187.925C168.214 188.049 166.471 188.771 165.086 189.98L162.267 192.44C159.098 195.206 154.373 195.206 151.204 192.44L148.385 189.98C147 188.771 145.257 188.049 143.424 187.925L139.69 187.671C135.494 187.386 132.153 184.045 131.868 179.848L131.614 176.115C131.489 174.281 130.767 172.539 129.559 171.154L127.098 168.335C124.333 165.165 124.333 160.441 127.098 157.272L129.559 154.452C130.767 153.067 131.489 151.325 131.614 149.491L131.868 145.758C132.153 141.561 135.494 138.22 139.69 137.935L143.424 137.681C145.257 137.557 147 136.835 148.385 135.626L151.204 133.166Z" fill="var(--cros-sys-illo-color1-1)" />
</svg>`],["recording_list_no_result_found", svg`<svg xmlns="http://www.w3.org/2000/svg" width="300" height="100" viewBox="0 0 300 100" fill="none">
<path d="M216.82 38.5746C216.82 38.3846 216.859 38.1966 216.937 38.0231C217.014 37.8496 217.127 37.6941 217.269 37.5676C217.411 37.4411 217.578 37.3456 217.759 37.2886C217.94 37.2311 218.131 37.2126 218.32 37.2346C221.612 37.5981 224.655 39.1611 226.868 41.6256C229.081 44.0901 230.309 47.2836 230.317 50.5956C230.325 53.9076 229.113 57.1071 226.912 59.5821C224.711 62.0571 221.675 63.6351 218.385 64.0146C218.197 64.0366 218.006 64.0181 217.825 63.9611C217.644 63.9041 217.478 63.8091 217.336 63.6831C217.194 63.5571 217.081 63.4026 217.003 63.2296C216.925 63.0566 216.885 62.8691 216.885 62.6796L216.82 38.5746Z" fill="var(--cros-sys-illo-secondary)"/>
<path d="M164.36 40.9148C162.819 41.6043 161.316 42.3788 159.86 43.2348C157.817 44.3413 155.419 44.5933 153.19 43.9348C151.96 43.5158 150.709 43.1633 149.44 42.8798C144.97 42.0748 140.67 45.2548 140.55 49.8798C140.445 53.9598 143.92 57.6448 148.075 57.4548C149.99 57.3648 151.8 56.6248 153.69 56.3748C155.707 56.0823 157.763 56.5053 159.5 57.5698C161 58.4798 162.4 59.5348 164 60.2598C165.566 60.9733 167.284 61.2848 169 61.1648C171.717 60.9873 174.26 59.7683 176.1 57.7618C177.939 55.7553 178.934 53.1163 178.875 50.3943C178.816 47.6728 177.709 45.0788 175.785 43.1533C173.86 41.2283 171.267 40.1198 168.545 40.0598C167.106 40.0503 165.681 40.3413 164.36 40.9148Z" stroke="var(--cros-sys-illo-secondary)" stroke-width="1.5" stroke-miterlimit="10"/>
<path d="M113 52.15L125.64 59.65C125.937 59.826 126.275 59.9215 126.62 59.9255C126.965 59.93 127.306 59.8435 127.607 59.675C127.908 59.506 128.16 59.2615 128.337 58.9645C128.514 58.668 128.61 58.3305 128.615 57.985L128.805 43.275C128.809 42.9295 128.723 42.589 128.554 42.2875C128.385 41.986 128.14 41.7345 127.843 41.5575C127.546 41.381 127.208 41.285 126.863 41.2805C126.517 41.2755 126.177 41.3615 125.875 41.53L113.05 48.74C112.748 48.9085 112.496 49.1535 112.319 49.4505C112.142 49.747 112.047 50.085 112.041 50.4305C112.036 50.776 112.122 51.117 112.291 51.4185C112.459 51.7205 112.703 51.9725 113 52.15Z" fill="var(--cros-sys-illo-color1-2)"/>
<path d="M244.485 55.3146C247.075 55.3146 249.175 53.2146 249.175 50.6246C249.175 48.0346 247.075 45.9346 244.485 45.9346C241.894 45.9346 239.795 48.0346 239.795 50.6246C239.795 53.2146 241.894 55.3146 244.485 55.3146Z" fill="var(--cros-sys-illo-secondary)"/>
<path d="M74.945 61.3899C86.6035 61.3899 96.055 51.9384 96.055 40.2799C96.055 28.6214 86.6035 19.1699 74.945 19.1699C63.286 19.1699 53.835 28.6214 53.835 40.2799C53.835 51.9384 63.286 61.3899 74.945 61.3899Z" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-miterlimit="10"/>
<path d="M64.1552 58.4248L50.8252 80.8348" stroke="var(--cros-sys-illo-color1)" stroke-width="5.37" stroke-miterlimit="10"/>
<path d="M194.952 42.3006L189.101 48.1521C187.734 49.5186 187.734 51.7346 189.101 53.1016L194.952 58.9531C196.319 60.3196 198.535 60.3196 199.902 58.9531L205.753 53.1016C207.12 51.7346 207.12 49.5186 205.753 48.1521L199.902 42.3006C198.535 40.9336 196.319 40.9336 194.952 42.3006Z" fill="var(--cros-sys-illo-color1)"/>
</svg>`],["transcription_enable", svg`<svg xmlns="http://www.w3.org/2000/svg" width="158" height="136" viewBox="0 0 158 136" fill="none">
<path fill-rule="evenodd" clip-rule="evenodd" d="M94.6489 35L114.95 48.0978L114.951 48.0977V107.968C114.951 111.071 112.435 113.587 109.331 113.587H59.4467C56.3434 113.587 53.8276 111.071 53.8276 107.968V40.619C53.8276 37.5157 56.3434 35 59.4467 35H94.6489Z" fill="var(--cros-sys-illo-base)" />
<path fill-rule="evenodd" clip-rule="evenodd" d="M94.6489 35H59.4467C56.3434 35 53.8276 37.5157 53.8276 40.619V107.968C53.8276 111.071 56.3434 113.587 59.4467 113.587H109.331C112.435 113.587 114.951 111.071 114.951 107.968V48.0978L94.6489 35ZM93.7651 38H59.4467C58.0002 38 56.8276 39.1726 56.8276 40.619V107.968C56.8276 109.414 58.0002 110.587 59.4467 110.587H109.331C110.778 110.587 111.951 109.414 111.951 107.968V49.7325L93.7651 38Z" fill="var(--cros-sys-illo-color1-1)" />
<path d="M63.4819 55.8594H106.449" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M63.1235 75.6836H104.423" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M63.1235 65.7715H97.8149" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M63.1235 85.5957H84.5991" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M93.4185 36.3105C93.4185 37.755 93.4185 41.5105 93.4185 44.9772C93.4185 48.5883 96.4985 49.3105 98.5873 49.3105H112.418" stroke="var(--cros-sys-illo-color1-1)" stroke-width="3" />
<path d="M45.8216 94.3105H76.0153C78.9993 94.3105 81.4185 96.6877 81.4185 99.62V114.324C81.4185 117.256 78.9993 119.633 76.0153 119.633H60.3553L50.892 128.934C50.0741 129.738 48.6739 129.169 48.6739 128.032V119.635H45.8216C42.8375 119.635 40.4185 117.258 40.4185 114.326V99.6217C40.4185 96.6894 42.8375 94.3123 45.8216 94.3123V94.3105Z" fill="var(--cros-sys-illo-color1-2)" />
<path d="M45.5829 88.5907C47.6911 87.5894 47.9372 84.687 46.0279 83.3448L39.0697 78.4536C37.1455 77.101 34.4794 78.3456 34.2806 80.6892L33.5562 89.2297C33.3574 91.5733 35.7758 93.2492 37.9003 92.24L45.5829 88.5907Z" fill="var(--cros-sys-illo-color5)" />
<path d="M33.7832 103.059C35.2591 102.752 36.2068 101.307 35.9 99.831C35.5932 98.3551 34.1482 97.4073 32.6723 97.7141C31.1964 98.0208 30.2487 99.466 30.5554 100.942C30.8622 102.418 32.3073 103.365 33.7832 103.059Z" fill="var(--cros-sys-illo-color2)" />
<path d="M98.8059 86.4444L92.5148 80.1533L92.1621 85.4443C92.111 86.2116 92.7475 86.8483 93.5148 86.7971L98.8059 86.4444Z" fill="var(--cros-sys-illo-color1)" />
<path d="M125.767 59.4806L119.476 53.1895L92.5142 80.1513L98.8053 86.4424L125.767 59.4806Z" fill="var(--cros-sys-illo-color1-1)" />
<path d="M120.825 51.842C122.562 50.1048 125.379 50.1048 127.116 51.842C128.853 53.5792 128.853 56.3958 127.116 58.133L126.667 58.5824L120.375 52.2914L120.825 51.842Z" fill="var(--cros-sys-illo-color1)" />
</svg>`],["transcription_no_speech", svg`<svg xmlns="http://www.w3.org/2000/svg" width="158" height="136" viewBox="0 0 158 136" fill="none">
<path d="M142.126 78.168L127.187 90.4013C125.363 91.931 122.987 92.6769 120.581 92.4738C118.176 92.2708 115.938 91.1364 114.359 89.3195C113.577 88.4197 112.98 87.3795 112.603 86.258C112.226 85.1364 112.076 83.9555 112.161 82.7832C112.247 81.6108 112.566 80.4694 113.101 79.4242C113.636 78.3796 114.377 77.4514 115.28 76.6936L130.217 64.4645C132.041 62.9335 134.417 62.1871 136.823 62.3891C139.229 62.5911 141.467 63.7251 143.047 65.5422C144.625 67.3596 145.415 69.7106 145.242 72.0781C145.07 74.446 143.949 76.6363 142.126 78.168Z" fill="var(--cros-sys-illo-color5)" />
<path d="M18.4852 47.4985L12.2617 55.6875C11.4767 56.7205 11.6777 58.1942 12.7106 58.979L20.8028 65.1288C21.8357 65.9141 23.3095 65.7132 24.0945 64.6803L30.3179 56.4911C31.1032 55.4582 30.9017 53.9845 29.8688 53.1995L21.7769 47.0496C20.744 46.2646 19.2702 46.4655 18.4852 47.4985Z" fill="var(--cros-sys-illo-color3)" />
<path d="M51.4977 93.8342C51.7679 93.9881 52.0017 94.1976 52.184 94.4494C52.3664 94.7008 52.4934 94.9885 52.5561 95.2929C52.6187 95.5978 52.6157 95.9132 52.5475 96.2181C52.4794 96.5226 52.3477 96.8102 52.1604 97.062C48.9001 101.482 44.131 104.563 38.7665 105.716C33.4014 106.869 27.8173 106.012 23.0828 103.31C18.3477 100.608 14.7946 96.2497 13.1034 91.0698C11.4119 85.8898 11.7009 80.2519 13.9149 75.2344C14.0412 74.9477 14.2262 74.6902 14.4581 74.4789C14.6899 74.2672 14.9633 74.1062 15.2605 74.0067C15.5579 73.9067 15.8724 73.8704 16.1833 73.8994C16.4945 73.929 16.7954 74.0233 17.0663 74.1763L51.4977 93.8342Z" stroke="var(--cros-sys-illo-secondary)" stroke-width="3" stroke-miterlimit="10" />
<path d="M114.421 16.1694L114.439 16.1715L114.457 16.1731L117.527 16.4498C119.486 16.6264 121.193 17.8591 121.977 19.6639L123.204 22.4914L123.211 22.508L123.219 22.5244L124.514 25.3215C125.341 27.1068 125.127 29.2012 123.956 30.7822L122.121 33.2592L122.11 33.2737L122.1 33.2885L120.325 35.8089C119.192 37.4177 117.272 38.2793 115.317 38.0556L112.254 37.705L112.236 37.7029L112.218 37.7013L109.148 37.4246C107.189 37.248 105.482 36.0153 104.698 34.2105L103.471 31.383L103.463 31.3664L103.456 31.35L102.16 28.5529C101.334 26.7676 101.548 24.6732 102.719 23.0922L104.554 20.6152L104.565 20.6007L104.575 20.5859L106.35 18.0655C107.482 16.4568 109.403 15.5951 111.358 15.8189L114.421 16.1694Z" stroke="var(--cros-sys-illo-color4)" stroke-width="3" />
<path d="M70.5428 75.1683L70.1024 74.7299L69.481 74.7313L49.6852 74.7763C44.1275 74.7889 39.6117 70.2936 39.5991 64.7358L39.5263 32.7123C39.5136 27.1545 44.009 22.6387 49.5667 22.6261L96.6799 22.519L96.6799 22.5227L98.1799 22.5193C103.738 22.5067 108.254 27.002 108.266 32.5598L108.339 64.5833C108.352 70.1411 103.856 74.6569 98.2984 74.6695L94.4805 74.6782L92.9805 74.6816L92.9839 76.1816L93.0255 94.4686C93.0281 95.6076 91.65 96.1834 90.8413 95.3786C90.8413 95.3785 90.8412 95.3785 90.8412 95.3785L70.5428 75.1683Z" fill="var(--cros-sys-illo-base)" stroke="var(--cros-sys-illo-color1-1)" stroke-width="3" />
<path d="M71.9046 55.3253L71.9591 53.1261C71.985 52.0571 72.1306 51.1441 72.3936 50.3865C72.6884 49.5992 73.1341 48.8618 73.7318 48.1737C74.3614 47.4557 75.1597 46.6658 76.1289 45.8035C76.8158 45.2094 77.426 44.6439 77.9587 44.1071C78.4914 43.5703 78.903 42.9998 79.193 42.3958C79.5147 41.7619 79.6851 41.048 79.7047 40.254C79.7404 38.8185 79.2961 37.631 78.3724 36.6911C77.4785 35.7522 76.1764 35.2615 74.4661 35.219C73.3671 35.1915 72.43 35.3975 71.6546 35.8368C70.8799 36.2759 70.2545 36.841 69.7792 37.5321C69.3032 38.2233 68.935 38.9168 68.6727 39.6134L65.1371 38.0127C65.4964 37.0744 66.0713 36.0953 66.8601 35.076C67.6495 34.0565 68.6795 33.1958 69.9502 32.4938C71.2202 31.792 72.7563 31.4635 74.5585 31.5082C76.4216 31.5544 78.0308 31.9764 79.3861 32.7741C80.7732 33.5419 81.8317 34.5921 82.563 35.9242C83.3247 37.2268 83.6853 38.7027 83.6447 40.3518C83.6125 41.6347 83.3092 42.7731 82.7348 43.7672C82.1903 44.7623 81.5579 45.6175 80.8371 46.3332C80.1176 47.018 79.4916 47.5986 78.9602 48.0743C78.3045 48.6387 77.7558 49.1902 77.3151 49.7293C76.8737 50.2686 76.5389 50.8411 76.3097 51.4462C76.0807 52.052 75.9567 52.7367 75.9378 53.5001L75.8901 55.4241L71.9046 55.3253ZM73.6733 65.3166C72.8484 65.2963 72.1526 65.0036 71.5864 64.4397C71.0506 63.8456 70.7936 63.1365 70.8138 62.3115C70.8334 61.5176 71.1254 60.8523 71.6886 60.3165C72.2834 59.7503 72.9932 59.478 73.8176 59.4984C74.6115 59.518 75.2761 59.8253 75.8118 60.4187C76.3782 60.9833 76.6516 61.6619 76.6322 62.4564C76.6118 63.2807 76.3037 63.9758 75.7096 64.5419C75.1457 65.0779 74.4672 65.3362 73.6733 65.3166Z" fill="var(--cros-sys-illo-color1)" />
</svg>`],["transcription_off", svg`<svg xmlns="http://www.w3.org/2000/svg" width="158" height="136" viewBox="0 0 158 136" fill="none">
<path fill-rule="evenodd" clip-rule="evenodd" d="M48.6079 18.0408C49.4494 17.6918 50.3709 17.5 51.3334 17.5H54.9438C55.7722 17.5 56.4438 18.1716 56.4438 19C56.4438 19.8284 55.7722 20.5 54.9438 20.5H51.3334C50.7721 20.5 50.2407 20.6114 49.7571 20.812C48.9918 21.1293 48.1142 20.7662 47.7969 20.001C47.4796 19.2357 47.8427 18.3581 48.6079 18.0408ZM60.6646 19C60.6646 18.1716 61.3361 17.5 62.1646 17.5H69.3853C70.2137 17.5 70.8853 18.1716 70.8853 19C70.8853 19.8284 70.2137 20.5 69.3853 20.5H62.1646C61.3361 20.5 60.6646 19.8284 60.6646 19ZM75.1061 19C75.1061 18.1716 75.7777 17.5 76.6061 17.5H83.8268C84.6553 17.5 85.3268 18.1716 85.3268 19C85.3268 19.8284 84.6553 20.5 83.8268 20.5H76.6061C75.7777 20.5 75.1061 19.8284 75.1061 19ZM89.5476 19C89.5476 18.1716 90.2192 17.5 91.0476 17.5H94.658C94.9375 17.5 95.2115 17.5781 95.449 17.7255L98.4917 19.6139C99.1955 20.0508 99.412 20.9755 98.9752 21.6794C98.5383 22.3833 97.6136 22.5997 96.9097 22.1629L94.2304 20.5H91.0476C90.2192 20.5 89.5476 19.8284 89.5476 19ZM46.7153 21.0826C47.4806 21.3999 47.8437 22.2775 47.5263 23.0427C47.3258 23.5263 47.2144 24.0578 47.2144 24.6191V27.9276C47.2144 28.756 46.5428 29.4276 45.7144 29.4276C44.8859 29.4276 44.2144 28.756 44.2144 27.9276V24.6191C44.2144 23.6565 44.4062 22.735 44.7551 21.8936C45.0725 21.1283 45.9501 20.7652 46.7153 21.0826ZM102.512 23.8742C102.948 23.1703 103.873 22.9538 104.577 23.3907L110.662 27.1675C111.366 27.6044 111.583 28.5291 111.146 29.233C110.709 29.9369 109.784 30.1533 109.08 29.7165L102.995 25.9397C102.291 25.5028 102.075 24.5781 102.512 23.8742ZM114.682 31.4278C115.119 30.7239 116.044 30.5074 116.748 30.9443L119.713 32.7847C120.186 33.0401 120.5 33.5397 120.5 34.1047V37.6006C120.5 38.4291 119.828 39.1006 119 39.1006C118.172 39.1006 117.5 38.4291 117.5 37.6006V34.9421L115.166 33.4933C114.462 33.0564 114.245 32.1317 114.682 31.4278ZM45.7144 33.0446C46.5428 33.0446 47.2144 33.7162 47.2144 34.5446V41.1617C47.2144 41.9901 46.5428 42.6617 45.7144 42.6617C44.8859 42.6617 44.2144 41.9901 44.2144 41.1617V34.5446C44.2144 33.7162 44.8859 33.0446 45.7144 33.0446ZM119 43.0925C119.828 43.0925 120.5 43.7641 120.5 44.5925V51.5845C120.5 52.4129 119.828 53.0845 119 53.0845C118.172 53.0845 117.5 52.4129 117.5 51.5845V44.5925C117.5 43.7641 118.172 43.0925 119 43.0925ZM45.7144 46.2788C46.5428 46.2788 47.2144 46.9503 47.2144 47.7788V54.3958C47.2144 55.2243 46.5428 55.8958 45.7144 55.8958C44.8859 55.8958 44.2144 55.2243 44.2144 54.3958V47.7788C44.2144 46.9503 44.8859 46.2788 45.7144 46.2788ZM119 57.0764C119.828 57.0764 120.5 57.7479 120.5 58.5764V65.5683C120.5 66.3967 119.828 67.0683 119 67.0683C118.172 67.0683 117.5 66.3967 117.5 65.5683V58.5764C117.5 57.7479 118.172 57.0764 119 57.0764ZM45.7144 59.5129C46.5428 59.5129 47.2144 60.1845 47.2144 61.0129V67.63C47.2144 68.4584 46.5428 69.13 45.7144 69.13C44.8859 69.13 44.2144 68.4584 44.2144 67.63V61.0129C44.2144 60.1845 44.8859 59.5129 45.7144 59.5129ZM119 71.0602C119.828 71.0602 120.5 71.7318 120.5 72.5602V79.5521C120.5 80.3805 119.828 81.0521 119 81.0521C118.172 81.0521 117.5 80.3805 117.5 79.5521V72.5602C117.5 71.7318 118.172 71.0602 119 71.0602ZM45.7144 72.747C46.5428 72.747 47.2144 73.4186 47.2144 74.247V80.8641C47.2144 81.6925 46.5428 82.3641 45.7144 82.3641C44.8859 82.3641 44.2144 81.6925 44.2144 80.8641V74.247C44.2144 73.4186 44.8859 72.747 45.7144 72.747ZM119 85.044C119.828 85.044 120.5 85.7156 120.5 86.544V93.5359C120.5 94.3644 119.828 95.0359 119 95.0359C118.172 95.0359 117.5 94.3644 117.5 93.5359V86.544C117.5 85.7156 118.172 85.044 119 85.044ZM45.7144 85.9812C46.5428 85.9812 47.2144 86.6527 47.2144 87.4812V94.0982C47.2144 94.9267 46.5428 95.5982 45.7144 95.5982C44.8859 95.5982 44.2144 94.9267 44.2144 94.0982V87.4812C44.2144 86.6527 44.8859 85.9812 45.7144 85.9812ZM119 99.0279C119.828 99.0279 120.5 99.6994 120.5 100.528V104.024C120.5 104.986 120.308 105.908 119.959 106.749C119.642 107.515 118.764 107.878 117.999 107.56C117.234 107.243 116.871 106.365 117.188 105.6C117.389 105.117 117.5 104.585 117.5 104.024V100.528C117.5 99.6994 118.172 99.0279 119 99.0279ZM45.7144 99.2153C46.5428 99.2153 47.2144 99.8869 47.2144 100.715V104.024C47.2144 104.585 47.3258 105.117 47.5263 105.6C47.8437 106.365 47.4806 107.243 46.7153 107.56C45.9501 107.878 45.0725 107.515 44.7551 106.749C44.4062 105.908 44.2144 104.986 44.2144 104.024V100.715C44.2144 99.8869 44.8859 99.2153 45.7144 99.2153ZM47.7969 108.642C48.1142 107.877 48.9918 107.514 49.7571 107.831C50.2407 108.031 50.7721 108.143 51.3334 108.143H55.2114C56.0398 108.143 56.7114 108.814 56.7114 109.643C56.7114 110.471 56.0398 111.143 55.2114 111.143H51.3334C50.3709 111.143 49.4494 110.951 48.6079 110.602C47.8427 110.285 47.4796 109.407 47.7969 108.642ZM116.918 108.642C117.235 109.407 116.872 110.285 116.107 110.602C115.265 110.951 114.344 111.143 113.381 111.143H109.503C108.675 111.143 108.003 110.471 108.003 109.643C108.003 108.814 108.675 108.143 109.503 108.143H113.381C113.942 108.143 114.474 108.031 114.957 107.831C115.723 107.514 116.6 107.877 116.918 108.642ZM61.4673 109.643C61.4673 108.814 62.1389 108.143 62.9673 108.143H70.7233C71.5517 108.143 72.2233 108.814 72.2233 109.643C72.2233 110.471 71.5517 111.143 70.7233 111.143H62.9673C62.1389 111.143 61.4673 110.471 61.4673 109.643ZM76.9792 109.643C76.9792 108.814 77.6508 108.143 78.4792 108.143H86.2352C87.0636 108.143 87.7352 108.814 87.7352 109.643C87.7352 110.471 87.0636 111.143 86.2352 111.143H78.4792C77.6508 111.143 76.9792 110.471 76.9792 109.643ZM92.4911 109.643C92.4911 108.814 93.1627 108.143 93.9911 108.143H101.747C102.576 108.143 103.247 108.814 103.247 109.643C103.247 110.471 102.576 111.143 101.747 111.143H93.9911C93.1627 111.143 92.4911 110.471 92.4911 109.643Z" fill="var(--cros-sys-illo-color1-1)" />
<path fill-rule="evenodd" clip-rule="evenodd" d="M91.425 27.6787L110.321 39.87L110.322 39.8696V95.2076C110.322 98.3109 107.806 100.827 104.703 100.827H59.0478C55.9444 100.827 53.4287 98.3109 53.4287 95.2076V33.2978C53.4287 30.1944 55.9444 27.6787 59.0478 27.6787H91.425Z" fill="var(--cros-sys-illo-base)" />
<path fill-rule="evenodd" clip-rule="evenodd" d="M91.425 27.6787H59.0478C55.9444 27.6787 53.4287 30.1944 53.4287 33.2978V95.2076C53.4287 98.3109 55.9444 100.827 59.0478 100.827H104.703C107.806 100.827 110.322 98.3109 110.322 95.2076V39.87L91.425 27.6787ZM90.5412 30.6787H59.0478C57.6013 30.6787 56.4287 31.8513 56.4287 33.2978V95.2076C56.4287 96.6541 57.6013 97.8267 59.0478 97.8267H104.703C106.149 97.8267 107.322 96.6541 107.322 95.2076V41.5047L90.5412 30.6787Z" fill="var(--cros-sys-illo-color1-1)" />
<path d="M62.415 47.0947H102.408" stroke="var(--cros-sys-illo-color1-1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M62.0811 65.5469H100.522" stroke="var(--cros-sys-illo-color1-1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M62.0811 56.3203H94.3716" stroke="var(--cros-sys-illo-color1-1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M62.0811 74.7725H82.0704" stroke="var(--cros-sys-illo-color1-1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" />
<path d="M90 28.3926C90 29.7259 90 33.1926 90 36.3926C90 39.7259 93.0801 40.3926 95.1689 40.3926H109" stroke="var(--cros-sys-illo-color1-1)" stroke-width="3" />
<path d="M52 116C60.8365 116 68 108.837 68 100C68 91.1635 60.8365 84 52 84C43.1635 84 36 91.1635 36 100C36 108.837 43.1635 116 52 116Z" fill="var(--cros-sys-illo-color1)" />
<path fill-rule="evenodd" clip-rule="evenodd" d="M47.5072 103.286C47.1588 103.667 47.1848 104.258 47.5653 104.606C47.9458 104.954 48.5367 104.928 48.8851 104.548L51.8957 101.26L55.1221 104.336C55.4953 104.692 56.0866 104.678 56.443 104.305C56.7989 103.932 56.7849 103.34 56.4117 102.984L53.1576 99.8813L56.194 96.565C56.5425 96.1844 56.5163 95.5936 56.1356 95.2452C55.755 94.8968 55.1641 94.9228 54.8157 95.3034L51.8052 98.5917L48.5789 95.5149C48.2055 95.1588 47.6142 95.1729 47.2581 95.5462C46.9021 95.9196 46.9161 96.5109 47.2895 96.8669L50.5433 99.9699L47.5072 103.286Z" fill="var(--cros-sys-illo-base)" />
</svg>`],["icons/arrow_back", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path fill-rule="evenodd" d="m6.44 9 5.01-4.77L10.18 3 3 10l7.18 7 1.26-1.23-5-4.77H17V9H6.44Z" clip-rule="evenodd"/></svg>`],["icons/checked", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M13.707 7.293a1 1 0 0 0-1.414 0L9 10.586 7.707 9.293a1 1 0 0 0-1.414 1.414l2 2a1 1 0 0 0 1.414 0l4-4a1 1 0 0 0 0-1.414Z"/><path fill-rule="evenodd" d="M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16Zm0-2a6 6 0 1 0 0-12 6 6 0 0 0 0 12Z" clip-rule="evenodd"/></svg>`],["icons/chevron_down", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M5.41 6 10 10.94 14.59 6 16 7.52 10 14 4 7.52 5.41 6Z" clip-rule="evenodd"/></svg>`],["icons/chevron_right", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M10.7083 10L6.77083 6.0625L8 4.83333L13.1667 10L8 15.1667L6.77083 13.9375L10.7083 10Z" clip-rule="evenodd"/></svg>`],["icons/chevron_up", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M5.41 14 10 9.06 14.59 14 16 12.48 10 6l-6 6.48L5.41 14Z" clip-rule="evenodd"/></svg>`],["icons/circle_fill", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><circle cx="10" cy="10" r="7.5"/></svg>`],["icons/close", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path d="m6.06 15.17-1.23-1.23L8.77 10 4.83 6.06l1.23-1.23L10 8.77l3.94-3.94 1.23 1.23L11.23 10l3.94 3.94-1.23 1.23L10 11.23l-3.94 3.94Z"/></svg>`],["icons/delete", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 21 20"><path fill-rule="evenodd" d="M13.5 3V2h-6v1h-4v2h1v11c0 1.1.9 2 2 2h8a2 2 0 0 0 2-2V5h1V3h-4Zm1 13h-8V5h8v11Z" clip-rule="evenodd"/></svg>`],["icons/done", svg`<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24"><path d="M382-240 154-468l57-57 171 171 367-367 57 57-424 424Z"/></svg>`],["icons/duration", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 1.67a8.33 8.33 0 1 0 0 16.66 8.33 8.33 0 0 0 0-16.66Zm0 15a6.66 6.66 0 1 1 0-13.33 6.66 6.66 0 0 1 0 13.33ZM10.83 5v5l3.53 2.45-1.05 1.3-4.14-2.92V5h1.66Z" clip-rule="evenodd"/></svg>`],["icons/export", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20"><path d="M3 9a2 2 0 0 1 2-2h2v2H5v7h10V9h-2V7h2a2 2 0 0 1 2 2v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V9Z"/><path d="M12.59 5.91 14 4.5l-4-4-4 4 1.41 1.41L9 4.33V12h2V4.33l1.59 1.58Z"/></svg>`],["icons/forward_10", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M8.65 13.342V8.783h-.658L6.65 9.75l.442.675.691-.5v3.417h.867Zm3.775-4.35a1.681 1.681 0 0 0-1.008-.309c-.384 0-.717.1-1.009.309a2.006 2.006 0 0 0-.666.85 3.03 3.03 0 0 0-.234 1.225c0 .458.075.858.234 1.225.158.366.383.65.666.85.284.2.625.308 1.009.308.383 0 .716-.1 1.008-.308.292-.209.508-.492.667-.85.158-.359.233-.767.233-1.225a3.03 3.03 0 0 0-.233-1.225 1.897 1.897 0 0 0-.667-.85Zm-.092 2.875c-.083.241-.2.425-.358.558a.835.835 0 0 1-.558.2.828.828 0 0 1-.55-.2 1.272 1.272 0 0 1-.359-.558 2.407 2.407 0 0 1-.125-.8c0-.459.092-.834.284-1.125.191-.292.441-.442.75-.442.316 0 .575.142.758.433.183.292.283.667.283 1.134 0 .3-.041.566-.125.8Z"/><path d="M10 3.333c.175 0 .35.017.517.034L8.992 1.842 10.167.667l3.508 3.5-3.508 3.508L8.992 6.5l1.458-1.458C10.3 5.025 10.158 5 10 5a5.84 5.84 0 0 0-5.833 5.833A5.84 5.84 0 0 0 10 16.667a5.84 5.84 0 0 0 5.833-5.834H17.5a7.5 7.5 0 1 1-7.5-7.5Z"/></svg>`],["icons/info", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M9 14h2v-4H9v4Zm1-12a8 8 0 1 0 0 16 8 8 0 0 0 0-16Zm0 14a6 6 0 1 1 0-12 6 6 0 0 1 0 12ZM9 8h2V6H9v2Z" clip-rule="evenodd"/></svg>`],["icons/language", svg`<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 20 20"><path d="M10 18.167a8.205 8.205 0 0 1-3.188-.625 8.59 8.59 0 0 1-2.604-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 1.833 10c0-1.125.209-2.18.625-3.167.43-1 1.014-1.868 1.75-2.604a8.112 8.112 0 0 1 2.604-1.75c1-.43 2.063-.646 3.188-.646s2.18.216 3.167.646c1 .417 1.868 1 2.604 1.75a7.82 7.82 0 0 1 1.75 2.604c.43.986.646 2.042.646 3.167a7.974 7.974 0 0 1-.646 3.188c-.417.986-1 1.854-1.75 2.604a8.262 8.262 0 0 1-2.604 1.75 8.053 8.053 0 0 1-3.167.625Zm0-1.792c.222-.222.451-.653.688-1.292.236-.652.416-1.354.541-2.104H8.771c.125.75.298 1.452.52 2.104.237.64.473 1.07.709 1.292Zm-1.875-.208a6.717 6.717 0 0 1-.52-1.417 18.128 18.128 0 0 1-.355-1.77H4.312c.39.777.91 1.45 1.563 2.02a5.816 5.816 0 0 0 2.25 1.167Zm3.75 0A5.832 5.832 0 0 0 14.105 15a6.395 6.395 0 0 0 1.582-2.02H12.75a14.65 14.65 0 0 1-.375 1.77 7.628 7.628 0 0 1-.5 1.417ZM3.75 11.479h3.313c-.028-.264-.05-.52-.063-.77v-1.48c.014-.236.035-.472.063-.708H3.75c-.07.25-.118.5-.146.75-.028.236-.042.479-.042.729s.014.5.042.75c.028.236.077.48.146.73Zm4.833 0h2.834c.027-.278.041-.535.041-.77V9.291c0-.25-.014-.507-.041-.771H8.583c-.027.264-.048.52-.062.77v1.439c.014.235.035.485.062.75Zm4.354 0h3.313c.07-.25.118-.493.146-.729a6.781 6.781 0 0 0 0-1.5 4.234 4.234 0 0 0-.146-.73h-3.313c.014.265.021.522.021.772a13.508 13.508 0 0 1 0 1.479c0 .236-.007.472-.02.708Zm-.187-4.458h2.938a6.165 6.165 0 0 0-1.584-2 5.693 5.693 0 0 0-2.229-1.188c.194.403.361.875.5 1.417.153.542.278 1.132.375 1.77Zm-3.98 0h2.46a11.417 11.417 0 0 0-.543-2.083c-.236-.653-.465-1.09-.687-1.313-.236.222-.472.66-.708 1.313A12.687 12.687 0 0 0 8.77 7.02Zm-4.457 0H7.25c.097-.64.215-1.23.354-1.771a6.717 6.717 0 0 1 .521-1.417 5.678 5.678 0 0 0-2.25 1.188 6.292 6.292 0 0 0-1.563 2Z"/></svg>`],["icons/laptop_chromebook", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="none"><path d="M0 17.15v-1.57h1.92V2.83h16.16v12.75H20v1.57H0Zm8-2.07h4v-1H8v1ZM3.65 13h12.7V4.56H3.65V13Z"/></svg>`],["icons/mic", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 12.105c1.423 0 2.563-1.128 2.563-2.526l.008-5.053C12.571 3.128 11.423 2 10 2 8.577 2 7.429 3.128 7.429 4.526V9.58c0 1.398 1.148 2.526 2.571 2.526Zm4.543-2.526c0 2.526-2.177 4.295-4.543 4.295s-4.543-1.769-4.543-4.295H4c0 2.88 2.331 5.246 5.143 5.659V18h1.714v-2.762C13.67 14.834 16 12.459 16 9.579h-1.457Z" clip-rule="evenodd"/></svg>`],["icons/mic_alert", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20"><path d="M7.98 12.23a2.622 2.622 0 0 1-1.897-.772 2.61 2.61 0 0 1-.791-1.916V4.583c0-.75.264-1.389.791-1.916A2.61 2.61 0 0 1 8 1.875c.736 0 1.368.264 1.896.792a2.61 2.61 0 0 1 .791 1.916v4.959a2.61 2.61 0 0 1-.791 1.916 2.647 2.647 0 0 1-1.917.771ZM8 10.5c.264 0 .486-.09.667-.27a.898.898 0 0 0 .291-.688V4.583a.897.897 0 0 0-.291-.687A.906.906 0 0 0 8 3.625c-.278 0-.514.09-.708.27a.935.935 0 0 0-.271.688v4.959c0 .277.09.507.27.687.195.18.431.271.709.271Zm.813 6.813H7.167v-2.084c-1.43-.194-2.611-.826-3.542-1.896-.93-1.083-1.396-2.347-1.396-3.791h1.646c0 1.139.403 2.11 1.208 2.916.806.792 1.778 1.188 2.917 1.188h.396c.139-.014.278-.042.416-.084v3.75Zm5.354-1.042a.54.54 0 0 0 .396-.167.518.518 0 0 0 .166-.375.54.54 0 0 0-.166-.396.54.54 0 0 0-.396-.166.54.54 0 0 0-.396.166.581.581 0 0 0 0 .771.54.54 0 0 0 .396.167Zm-.542-2.104h1.104v-2.104h-1.104v2.104Zm.542 4c-1.111 0-2.056-.39-2.834-1.167-.777-.778-1.166-1.722-1.166-2.833 0-1.111.389-2.056 1.166-2.834.792-.777 1.736-1.166 2.834-1.166 1.11 0 2.055.396 2.833 1.187.778.778 1.167 1.715 1.167 2.813 0 1.11-.39 2.055-1.167 2.833-.778.778-1.722 1.167-2.833 1.167Z"/></svg>`],["icons/mic_external_on", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path d="M4.2292 5.9167c-.2084-.1945-.3542-.4306-.4375-.7084a3.508 3.508 0 0 1-.1042-.8541c0-.7223.25-1.3334.75-1.8334s1.1042-.75 1.8125-.75c.7222 0 1.3333.25 1.8333.75s.75 1.1111.75 1.8334c0 .2916-.0416.5764-.125.8541-.0833.264-.2222.5-.4166.7084H4.2292Zm4.5 12.3125c-.9167 0-1.6945-.2986-2.3334-.8959-.6389-.6111-.9583-1.3611-.9583-2.25H4.2917L3.2708 6.9167h6l-1.0416 8.1666h-1.125c0 .4306.1597.7917.4791 1.0834.3195.2777.7014.4166 1.1459.4166.4444 0 .8194-.1597 1.125-.4791.3194-.3195.4791-.7014.4791-1.1459V4.9792c0-.9028.3056-1.6598.9167-2.2709.625-.625 1.3889-.9375 2.2917-.9375.8889 0 1.6389.3125 2.25.9375.625.6111.9375 1.368.9375 2.2709v13.25h-1.6459V4.9583c0-.4166-.1597-.7778-.4791-1.0833-.3056-.3056-.6667-.4583-1.0834-.4583-.4166 0-.7777.1527-1.0833.4583s-.4583.6736-.4583 1.1042v9.9791c0 .9167-.3195 1.6945-.9584 2.3334-.625.625-1.3888.9375-2.2916.9375Z"/></svg>`],["icons/mic_mute", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20"><path d="M12.57 4.5v5c0 .46-.13.88-.35 1.25l-1.21-1.22v-.02l.04-5a1 1 0 1 0-2-.02l-.03 3.06-1.59-1.6V4.5C7.43 3.12 8.58 2 10 2a2.53 2.53 0 0 1 2.57 2.5ZM2.24 3.24 1 4.47l9.38 9.39-.38.01c-2.37 0-4.54-1.77-4.54-4.3H4c0 2.89 2.33 5.25 5.14 5.67V18h1.72v-2.76c.25-.04.5-.1.75-.16L15.52 19l1.24-1.24L2.24 3.24Zm11.4 8.93 1 1A5.48 5.48 0 0 0 16 9.57h-1.46a4.09 4.09 0 0 1-.9 2.58Z"/></svg>`],["icons/more_vertical", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 14a2 2 0 1 1 0 4 2 2 0 0 1 0-4Zm0-2a2 2 0 1 1 0-4 2 2 0 0 1 0 4Zm0-6a2 2 0 1 1 0-4 2 2 0 0 1 0 4Z" clip-rule="evenodd"/></svg>`],["icons/music_note", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="m10 3 .008 7.792a3.33 3.33 0 0 0-1.666-.459 3.334 3.334 0 1 0 0 6.667C10.192 17 12 15.508 12 13.667V6h3V3h-5Z" clip-rule="evenodd"/></svg>`],["icons/notes", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path d="M2.833 14.75v-1.73h9.334v1.73H2.833Zm0-3.875v-1.75h14.334v1.75H2.833Zm0-3.896V5.25h14.334v1.73H2.833Z"/></svg>`],["icons/page", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M5 2a1 1 0 0 0-1 1v14a1 1 0 0 0 1 1h10a1 1 0 0 0 1-1V7l-5-5H5Zm5 6V4H6v12h8V8h-4Z" clip-rule="evenodd"/></svg>`],["icons/pause", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 21 20"><path d="M9.5 5h-3v10h3V5ZM14.5 5h-3v10h3V5Z"/></svg>`],["icons/pause_hero", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path d="M19.33 27.67V4.33H26v23.34h-6.67ZM6 27.67V4.33h6.67v23.34H6Z"/></svg>`],["icons/pen_spark", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20"><path d="M5.4 10.48c0-1.28-.45-2.36-1.34-3.25A4.42 4.42 0 0 0 .8 5.89c1.28 0 2.36-.45 3.25-1.34A4.43 4.43 0 0 0 5.4 1.3c0 1.28.44 2.36 1.33 3.25A4.43 4.43 0 0 0 9.98 5.9c-1.27 0-2.36.45-3.25 1.34a4.43 4.43 0 0 0-1.33 3.25Zm0 5.62h.98l7.75-7.74-.5-.52-.48-.46-7.74 7.74v.98Zm-1.57 1.58v-3.22L14.26 4.03c.31-.31.68-.46 1.1-.46.44 0 .8.15 1.12.45l1 1a1.5 1.5 0 0 1 .46 1.1c0 .45-.15.81-.46 1.12L7.04 17.67h-3.2Zm10.3-9.32-.5-.52-.48-.46.97.98Z"/></svg>`],["icons/play_arrow", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path fill-rule="evenodd" d="m6 16 10-6L6 4v12Z" clip-rule="evenodd"/></svg>`],["icons/play_hero", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path d="M9.33 27.67V4.33L27.67 16 9.33 27.67Z"/></svg>`],["icons/rate_0_25", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M2.83 14v-1.57H4.4V14H2.83Zm8.74 0v-1.57h3.52v-1.64h-3.52V6h5.1v1.57h-3.52v1.64h1.95a1.54 1.54 0 0 1 1.57 1.58v1.64c0 .45-.15.82-.45 1.12-.3.3-.68.45-1.12.45h-3.53Zm-6.16 0v-3.21A1.53 1.53 0 0 1 7 9.21h2V7.57H5.41V6H9a1.53 1.53 0 0 1 1.57 1.58V9.2c0 .45-.15.82-.45 1.13a1.52 1.52 0 0 1-1.12.45h-2v1.64h3.57V14H5.41Z"/></svg>`],["icons/rate_0_5", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M5.92 14v-1.57h1.57V14H5.92Zm2.57 0v-1.57h3.53v-1.64H8.49V6h5.1v1.57h-3.52v1.64H12a1.54 1.54 0 0 1 1.57 1.58v1.64A1.53 1.53 0 0 1 12.02 14H8.5Z"/></svg>`],["icons/rate_0_75", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M3.33 14v-1.57H4.9V14H3.33Zm7.74 0v-1.57h3.52v-1.64h-3.52V6h5.1v1.57h-3.52v1.64h1.95a1.54 1.54 0 0 1 1.57 1.58v1.64c0 .45-.15.82-.45 1.12-.3.3-.68.45-1.12.45h-3.53Zm-4.66 0 2-6.42H4.9V6h3.8c.38 0 .69.13.95.39.26.25.39.57.39.94l-.07.4L8.05 14H6.4Z"/></svg>`],["icons/rate_1_0", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M5.41 14V7.65H3.98V6h3.08v8H5.41Zm4.11 0 2.37-4-2.37-4h1.91l1.4 2.43L14.24 6h1.91l-2.36 4 2.36 4h-1.91l-1.41-2.43-1.4 2.43h-1.9Z"/></svg>`],["icons/rate_1_25", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M4.88 14v-1.57h1.57V14H4.88Zm8.72 0v-1.57h3.53v-1.64H13.6V6h5.1v1.57h-3.53v1.64h1.95a1.54 1.54 0 0 1 1.57 1.58v1.64A1.53 1.53 0 0 1 17.13 14H13.6Zm-6.15 0v-3.21c0-.45.15-.82.45-1.13a1.52 1.52 0 0 1 1.13-.45h2V7.57H7.45V6h3.58a1.53 1.53 0 0 1 1.57 1.58V9.2c0 .45-.15.82-.45 1.13a1.52 1.52 0 0 1-1.12.45h-2v1.64h3.57V14H7.45ZM2.3 14V7.58H.8V6h3.08v8H2.3Z"/></svg>`],["icons/rate_1_5", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M5.35 14V7.58h-1.5V6h3.07v8H5.35Zm2.57 0v-1.57H9.5V14H7.92Zm2.58 0v-1.57h3.57v-1.64H10.5V6h5.15v1.57h-3.58v1.64h2a1.54 1.54 0 0 1 1.57 1.58v1.64A1.53 1.53 0 0 1 14.08 14H10.5Z"/></svg>`],["icons/rate_1_75", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M5.9 14v-1.57h1.58V14H5.9Zm7.67 0v-1.57h3.52v-1.64h-3.52V6h5.1v1.57h-3.52v1.64h1.95a1.54 1.54 0 0 1 1.57 1.58v1.64c0 .45-.15.82-.45 1.12-.3.3-.68.45-1.12.45h-3.53ZM3.33 14V7.58h-1.5V6h3.08v8H3.33Zm5.58 0 2-6.42H7.4V6h3.8c.38 0 .69.13.95.39.26.25.39.57.39.94l-.07.4L10.55 14H8.9Z"/></svg>`],["icons/rate_2_0", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M4 14v-3.21c0-.45.15-.82.45-1.13a1.52 1.52 0 0 1 1.13-.45h2V7.57H4V6h3.58a1.53 1.53 0 0 1 1.57 1.58V9.2c0 .45-.15.82-.45 1.13a1.52 1.52 0 0 1-1.12.45h-2v1.64h3.57V14H4Zm6.19 0 2.3-4.01L10.2 6h1.9l1.36 2.35L14.78 6h1.9l-2.27 3.98L16.7 14h-1.9l-1.35-2.37L12.1 14h-1.9Z"/></svg>`],["icons/remove_fill", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M2 10c0-4.424 3.576-8 8-8 4.424 0 8 3.576 8 8 0 4.424-3.576 8-8 8-4.424 0-8-3.576-8-8Zm10.072-3.2L10 8.872 7.928 6.8 6.8 7.928 8.872 10 6.8 12.072 7.928 13.2 10 11.128l2.072 2.072 1.128-1.128L11.128 10 13.2 7.928 12.072 6.8Z" clip-rule="evenodd"/></svg>`],["icons/replay_10", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M8.65 13.342V8.783h-.658L6.65 9.75l.442.675.691-.5v3.417h.867Zm3.775-4.35a1.681 1.681 0 0 0-1.008-.309c-.384 0-.717.1-1.009.309a2.006 2.006 0 0 0-.666.85 3.03 3.03 0 0 0-.234 1.225c0 .458.075.858.234 1.225.158.366.383.65.666.85.284.2.625.308 1.009.308.383 0 .716-.1 1.008-.308.292-.209.508-.492.667-.85.158-.359.233-.767.233-1.225a3.03 3.03 0 0 0-.233-1.225 1.897 1.897 0 0 0-.667-.85Zm-.092 2.875c-.083.241-.2.425-.358.558a.835.835 0 0 1-.558.2.828.828 0 0 1-.55-.2 1.272 1.272 0 0 1-.359-.558 2.407 2.407 0 0 1-.125-.8c0-.459.092-.834.284-1.125.191-.292.441-.442.75-.442.316 0 .575.142.758.433.183.292.283.667.283 1.134 0 .3-.041.566-.125.8ZM10 3.333c-.175 0-.35.017-.517.034l1.525-1.525L9.833.667l-3.508 3.5 3.508 3.508L11.008 6.5 9.55 5.042C9.7 5.025 9.842 5 10 5a5.84 5.84 0 0 1 5.833 5.833A5.84 5.84 0 0 1 10 16.667a5.84 5.84 0 0 1-5.833-5.834H2.5a7.5 7.5 0 1 0 7.5-7.5Z"/></svg>`],["icons/search", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path fill-rule="evenodd" d="m17.49 16-3.73-3.73C14.53 11.2 15 9.91 15 8.5A6.5 6.5 0 1 0 8.5 15c1.41 0 2.7-.47 3.77-1.24L16 17.49 17.49 16ZM4 8.5C4 6.01 6.01 4 8.5 4S13 6.01 13 8.5 10.99 13 8.5 13 4 10.99 4 8.5Z" clip-rule="evenodd"/></svg>`],["icons/settings", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M11.478 18H8.52c-.592 0-1.088-.422-1.16-.992l-.216-1.475a7.277 7.277 0 0 1-.631-.36l-1.44.563c-.56.202-1.176-.024-1.448-.508l-1.463-2.475c-.28-.516-.16-1.125.288-1.469l1.223-.929a5.168 5.168 0 0 1-.016-.359c0-.117.008-.242.016-.36l-1.215-.928A1.106 1.106 0 0 1 2.16 7.24l1.48-2.491c.271-.484.887-.703 1.431-.492l1.448.57a8.51 8.51 0 0 1 .623-.36l.216-1.49C7.431 2.428 7.927 2 8.511 2h2.96c.59 0 1.087.422 1.159.992l.216 1.476c.216.109.424.226.631.359l1.44-.562c.568-.204 1.184.023 1.456.507l1.471 2.483a1.13 1.13 0 0 1-.288 1.468l-1.215.93c.008.117.016.234.016.359 0 .125-.008.242-.016.359l1.215.93c.448.35.576.96.296 1.452l-1.487 2.514c-.272.484-.888.703-1.44.492l-1.44-.562a8.54 8.54 0 0 1-.623.359l-.216 1.491c-.08.531-.576.953-1.168.953Zm-2.531-2h2.114l.283-1.854.406-.16c.337-.132.674-.32 1.026-.568l.345-.247 1.822.698L16 12.124l-1.555-1.15.054-.407c.023-.189.046-.37.046-.567 0-.196-.023-.385-.046-.567l-.054-.408L16 7.876l-1.065-1.745-1.83.698-.344-.254a4.632 4.632 0 0 0-1.019-.56l-.398-.16L11.061 4H8.947l-.283 1.855-.406.152a4.91 4.91 0 0 0-1.026.575l-.345.24-1.823-.691L4 7.869l1.555 1.15-.054.406c-.023.19-.046.386-.046.575 0 .19.015.386.046.567l.054.408L4 12.123l1.057 1.745 1.83-.698.345.255c.329.24.658.421 1.018.56l.406.16L8.947 16ZM10 12.5a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5Z" clip-rule="evenodd"/></svg>`],["icons/sort_by", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path d="M14 14.71V9h-2v5.63l-1.87-1.87L9 13.9 13 18l4-4.1-1.13-1.14L14 14.7ZM11 6.1 7 2 3 6.1l1.13 1.14L6 5.3V11h2V5.37l1.87 1.87L11 6.1Z"/></svg>`],["icons/stop", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 33 32"><path d="M8.5 24V8h16v16h-16Z"/></svg>`],["icons/summarize_auto", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20"><path d="M6.75 13.98c.208 0 .382-.07.52-.21a.74.74 0 0 0 .23-.54.675.675 0 0 0-.23-.522.675.675 0 0 0-.52-.229.779.779 0 0 0-.542.209.707.707 0 0 0-.208.52c0 .223.07.41.208.563a.779.779 0 0 0 .542.208Zm0-3.23c.208 0 .382-.07.52-.208A.74.74 0 0 0 7.5 10a.675.675 0 0 0-.23-.52.675.675 0 0 0-.52-.23.74.74 0 0 0-.542.23A.707.707 0 0 0 6 10c0 .208.07.389.208.542a.779.779 0 0 0 .542.208Zm0-3.23a.706.706 0 0 0 .52-.207.675.675 0 0 0 .23-.521.698.698 0 0 0-.23-.542.675.675 0 0 0-.52-.23.74.74 0 0 0-.542.23.707.707 0 0 0-.208.52c0 .21.07.39.208.543a.779.779 0 0 0 .542.208ZM9 13.98h5v-1.5H9v1.5Zm0-3.23h4v-1.5H9v1.5Zm-4.438 6.417c-.486 0-.895-.167-1.229-.5a1.716 1.716 0 0 1-.5-1.23V4.563c0-.473.167-.875.5-1.209.334-.347.743-.52 1.23-.52H11v1.729H4.562v10.875h10.875V9h1.73v6.438c0 .472-.167.881-.5 1.229-.334.333-.743.5-1.23.5H4.563ZM14.5 10c0-1.264-.438-2.326-1.313-3.188C12.328 5.938 11.264 5.5 10 5.5c1.264 0 2.326-.43 3.188-1.292C14.062 3.333 14.5 2.264 14.5 1c0 1.264.43 2.333 1.292 3.208C16.667 5.07 17.736 5.5 19 5.5c-1.264 0-2.333.438-3.208 1.313C14.93 7.673 14.5 8.736 14.5 10Z"/></svg>`],["icons/thumb_down", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path d="M5.22 3.18h9.53v10.18L8.82 19.3l-.8-.54c-.24-.17-.44-.4-.57-.67a1.36 1.36 0 0 1-.11-.86l.02-.04.77-3.82H2.7c-.48 0-.88-.16-1.22-.5a1.67 1.67 0 0 1-.51-1.23v-.88c0-.12 0-.23.03-.33.02-.1.06-.2.1-.3l2.51-5.9a1.75 1.75 0 0 1 1.6-1.05Zm7.87 1.72H5.22L2.7 10.75v.88h7.46l-.96 4.82 3.88-3.88V4.9Zm1.66 8.46v-1.73h2.84V4.9h-2.84V3.18h4.57v10.18h-4.57Z"/></svg>`],["icons/thumb_down_filled", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path d="M5.02 3.17h9.53v10.2l-5.92 5.92-.8-.54a1.69 1.69 0 0 1-.59-.72c-.12-.3-.15-.6-.08-.91v.05l.78-3.8H2.5c-.47 0-.88-.18-1.22-.52a1.66 1.66 0 0 1-.5-1.22v-.88a1.5 1.5 0 0 1 .13-.63l2.5-5.9a1.76 1.76 0 0 1 1.6-1.05Zm11.03 10.2V3.16h3.08v10.2h-3.08Z"/></svg>`],["icons/thumb_up", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path d="M15.07 17.29H5.54V7.1l5.93-5.92.8.53c.24.18.44.4.57.67.13.28.17.56.12.86l-.02.05-.78 3.81h5.43c.47 0 .88.17 1.22.5.34.35.51.75.51 1.23v.88c0 .12 0 .23-.03.33-.02.1-.05.2-.1.3l-2.51 5.9c-.14.32-.36.57-.65.76-.3.19-.61.29-.96.29ZM7.2 15.56h7.87l2.51-5.85v-.88h-7.46L11.08 4 7.2 7.9v7.66ZM5.54 7.1v1.73H2.7v6.73h2.84v1.73H.97V7.1h4.57Z"/></svg>`],["icons/thumb_up_filled", svg`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path d="M14.88 17.29H5.35V7.1l5.92-5.93.8.54c.26.19.46.43.58.72.13.3.16.6.09.91V3.3l-.78 3.81h5.44c.47 0 .88.17 1.22.5.34.35.5.76.5 1.23v.88a1.5 1.5 0 0 1-.13.63l-2.5 5.9c-.15.32-.36.57-.65.76-.3.2-.62.29-.96.29ZM3.85 7.1v10.19H.77V7.1h3.08Z"/></svg>`],["icons/time_created", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M15 5h-1V3h-2v2H8V3H6v2H5a2 2 0 0 0-2 2v9c0 1.1.9 2 2 2h10a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2Zm0 11H5v-6h10v6Z"/></svg>`],["icons/volume_down", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M1 13h3.5L8 16.5v-13L4.5 7H1v6Zm9-6.5v7a4 4 0 0 0 2.5-3.5A4 4 0 0 0 10 6.5Z" clip-rule="evenodd"/></svg>`],["icons/volume_mute", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 6.51v1.47l2.46 2.57c.15-.43.04-3.12-2.46-4.04Zm4 5.82 1.18 1.12c.57-1.12.82-2.12.82-3.49 0-3.88-3-6.83-6-7.46v1.78c2.64.78 4.5 3.22 4.5 5.68 0 .86-.2 1.63-.5 2.37ZM1 3.13l3.71 3.62L4.5 7H1v6h3.5L8 16.5V10l4.5 4.35c-.71.5-.95.86-2.5 1.39v1.75a7.2 7.2 0 0 0 3.56-1.87L15.87 18 17 16.87 2.13 2 1 3.13Zm5.57 1.7L8 6.16V3.5L6.57 4.83Z" clip-rule="evenodd"/></svg>`],["icons/volume_off", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M1 13h3.5L8 16.5v-13L4.5 7H1v6Z" clip-rule="evenodd"/></svg>`],["icons/volume_up", svg`<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M1 13h3.467L8 16.4v-13L4.467 7H1v6Zm9-6.6v7c1.776-.635 2.5-2.496 2.5-3.5s-.724-2.857-2.5-3.5Zm0-2.238c2.477.735 4.5 3.027 4.5 5.738 0 2.711-2.023 5.003-4.5 5.738V17.4c3.437-.778 6-3.84 6-7.5s-2.563-6.722-6-7.5v1.762Z" clip-rule="evenodd"/></svg>`]]);