// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{MdDialog}from"chrome://resources/mwc/@material/web/dialog/dialog.js";import{css}from"chrome://resources/mwc/lit/index.js";export class CraDialog extends MdDialog{static{this.styles=[...MdDialog.styles,css`
      :host {
        --md-dialog-container-shape: 20px;
        --md-dialog-container-color: var(--cros-sys-dialog_container);
        --md-dialog-headline-color: var(--cros-sys-on_surface);
        --md-dialog-headline-font: var(--cros-display-7-font-family);
        --md-dialog-headline-line-height: var(--cros-display-7-line-height);
        --md-dialog-headline-size: var(--cros-display-7-font-size);
        --md-dialog-headline-weight: var(--cros-display-7-font-weight);
        --md-dialog-supporting-text-color: var(--cros-sys-on_surface_variant);
        --md-dialog-supporting-text-font: var(--cros-body-1-font-family);
        --md-dialog-supporting-text-line-height: var(--cros-body-1-line-height);
        --md-dialog-supporting-text-size: var(--cros-body-1-font-size);
        --md-dialog-supporting-text-weight: var(--cros-body-1-font-weight);

        /* All dialog are "fixed" width in Recorder app. */
        max-width: none;
      }

      .scrim {
        background: var(--cros-sys-scrim);

        /* The opacity is already included in --cros-sys-scrim */
        opacity: 1;

        /*
         * The default z-index is 1, which makes it hard for anything below to
         * be ordered by z-index and not accidentally being "over" the scrim.
         * Change it to a higher value to make styling easier.
         */
        z-index: 100;
      }

      dialog {
        box-shadow: var(--cros-sys-app_elevation3);
      }

      slot[name="headline"]::slotted(*) {
        padding: 32px 32px 0;
      }

      slot[name="content"]::slotted(*) {
        padding: 16px 32px 0;
      }

      .has-actions slot[name="content"]::slotted(*) {
        padding-bottom: 0;
      }

      .scrollable.has-headline slot[name="content"]::slotted(*) {
        padding-top: 16px;
      }

      slot[name="actions"]::slotted(*) {
        padding: 32px 32px 28px;
      }

      /* CrOS dialog spec doesn't have the divider when the content scrolls. */
      md-divider {
        display: none !important;
      }
    `]}constructor(){super();const oldOpenAnimation=this.getOpenAnimation();this.getOpenAnimation=()=>({...oldOpenAnimation,scrim:[[[{opacity:0},{opacity:1}],{duration:500,easing:"linear"}]],container:[[[{opacity:0},{opacity:1}],{duration:50,easing:"linear",pseudoElement:"::before"}]]});const oldCloseAnimation=this.getCloseAnimation();this.getCloseAnimation=()=>({...oldCloseAnimation,scrim:[[[{opacity:1},{opacity:0}],{duration:150,easing:"linear"}]],container:[[[{opacity:"1"},{opacity:"0"}],{delay:100,duration:50,easing:"linear",pseudoElement:"::before"}]]})}updated(changedProperties){super.updated(changedProperties);if(this.ariaLabel!==null){const dialog=this.shadowRoot?.querySelector("dialog")??null;dialog?.removeAttribute("aria-labelledby")}}}window.customElements.define("cra-dialog",CraDialog);