// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{images}from"/images/images.js";import{css,LitElement}from"chrome://resources/mwc/lit/index.js";import{assertExists}from"../../core/utils/assert.js";export class CraIcon extends LitElement{constructor(){super(...arguments);this.name=null}static{this.styles=css`
    :host {
      display: block;
    }

    svg {
      display: block;
      fill: currentcolor;
      height: 100%;
      stroke-width: 0;
      stroke: currentcolor;
      width: 100%;
    }
  `}static{this.properties={name:{type:String}}}connectedCallback(){super.connectedCallback();if(!this.hasAttribute("aria-hidden")){this.setAttribute("aria-hidden","true")}}render(){if(this.name===null){return null}return assertExists(images.get(`icons/${this.name}`))}}window.customElements.define("cra-icon",CraIcon);