// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./cra/cra-button.js";import"./cra/cra-dialog.js";import{classMap,createRef,css,html,nothing,ref}from"chrome://resources/mwc/lit/index.js";import{focusToBody}from"../core/focus.js";import{i18n}from"../core/i18n.js";import{ReactiveLitElement}from"../core/reactive/lit.js";export class DeleteRecordingDialog extends ReactiveLitElement{constructor(){super(...arguments);this.current=false;this.closedByDelete=false;this.dialog=createRef()}static{this.styles=css`
    :host {
      display: contents;
    }

    cra-dialog {
      width: 440px;

      &.current {
        width: 368px;
      }
    }
  `}static{this.properties={current:{type:Boolean}}}async show(){this.closedByDelete=false;await(this.dialog.value?.show())}hide(){this.dialog.value?.close()}onClosed(){if(this.closedByDelete){focusToBody()}}emitDelete(){this.dispatchEvent(new CustomEvent("delete"));this.closedByDelete=true;this.hide()}render(){const classes={current:this.current};const headline=this.current?i18n.recordDeleteDialogCurrentHeader:i18n.recordDeleteDialogHeader;const description=this.current?nothing:html`<div slot="content">${i18n.recordDeleteDialogDescription}</div>`;return html`<cra-dialog
      ${ref(this.dialog)}
      class=${classMap(classes)}
      @closed=${this.onClosed}
    >
      <div slot="headline">${headline}</div>
      ${description}
      <div slot="actions">
        <cra-button
          .label=${i18n.recordDeleteDialogCancelButton}
          button-style="secondary"
          @click=${this.hide}
        ></cra-button>
        <cra-button
          .label=${i18n.recordDeleteDialogDeleteButton}
          @click=${this.emitDelete}
        ></cra-button>
      </div>
    </cra-dialog>`}}window.customElements.define("delete-recording-dialog",DeleteRecordingDialog);