// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cros_components/checkbox/checkbox.js";import"chrome://resources/cros_components/dropdown/dropdown_option.js";import"chrome://resources/mwc/@material/web/focus/md-focus-ring.js";import"./cra/cra-dropdown.js";import"./expandable-card.js";import{Checkbox as CrosCheckbox}from"chrome://resources/cros_components/checkbox/checkbox.js";import{classMap,css,html,map,nothing}from"chrome://resources/mwc/lit/index.js";import{ReactiveLitElement}from"../core/reactive/lit.js";import{assertInstanceof}from"../core/utils/assert.js";import{CraDropdown}from"./cra/cra-dropdown.js";export class ExportDialogSection extends ReactiveLitElement{constructor(){super(...arguments);this.checked=false;this.disabled=false;this.options=[];this.value=null}static{this.shadowRootOptions={...ReactiveLitElement.shadowRootOptions,delegatesFocus:true}}static{this.styles=css`
    :host {
      display: contents;
    }

    slot[name="header"] {
      color: var(--cros-sys-on_surface);
      font: var(--cros-headline-1-font);
    }

    cros-dropdown-option cra-icon {
      color: var(--cros-sys-primary);
    }

    #container {
      border-radius: 12px;
      cursor: pointer;
      outline: 1px solid var(--cros-sys-separator);
      position: relative;

      &.disabled {
        opacity: var(--cros-disabled-opacity);
        pointer-events: none;
      }

      & > md-focus-ring {
        --md-focus-ring-active-width: 2px;
        --md-focus-ring-color: var(--cros-sys-focus_ring);
        --md-focus-ring-duration: 0s;
        --md-focus-ring-shape: 12px;
        --md-focus-ring-width: 2px;
      }
    }
  `}static{this.properties={checked:{type:Boolean},disabled:{type:Boolean},options:{attribute:false},value:{type:String}}}renderDropdownOptions(options,selected){return map(options,(({headline:headline,value:value})=>{const icon=value===selected?html`<cra-icon name="checked" slot="end"></cra-icon>`:nothing;return html`
        <cros-dropdown-option .headline=${headline} .value=${value}>
          ${icon}
        </cros-dropdown-option>
      `}))}onCheckChange(checked){this.dispatchEvent(new CustomEvent("check-changed",{detail:checked}))}onValueChange(ev){const value=assertInstanceof(ev.target,CraDropdown).value;this.dispatchEvent(new CustomEvent("value-changed",{detail:value}))}renderExpandableCard(){if(this.value===null){return nothing}const options=this.renderDropdownOptions(this.options,this.value);const onExpanded=()=>{this.onCheckChange(true)};const onCollapsed=()=>{this.onCheckChange(false)};return html`
      <expandable-card
        ?expanded=${this.checked}
        ?disabled=${this.disabled}
        @expandable-card-expanded=${onExpanded}
        @expandable-card-collapsed=${onCollapsed}
      >
        <slot slot="header" name="header"></slot>
        <cra-dropdown
          .value=${this.value}
          slot="content"
          @change=${this.onValueChange}
        >
          ${options}
        </cra-dropdown>
      </expandable-card>
    `}onRowClick(){this.onCheckChange(!this.checked)}onRowKeyDown(e){if(e.key==="Enter"||e.key===" "){e.preventDefault();this.onRowClick()}}renderRow(){const onCheckboxChange=ev=>{const checkbox=assertInstanceof(ev.target,CrosCheckbox);this.onCheckChange(checkbox.checked)};const classes={disabled:this.disabled};return html`<div
      id="container"
      class=${classMap(classes)}
      tabindex=${this.disabled?-1:0}
      @click=${this.onRowClick}
      @keydown=${this.onRowKeyDown}
      role="checkbox"
      aria-checked=${this.checked}
      aria-disabled=${this.disabled}
    >
      <cros-checkbox
        slot="leading"
        ?checked=${this.checked}
        ?disabled=${this.disabled}
        @change=${onCheckboxChange}
        tabindex="-1"
        aria-hidden="true"
      >
      </cros-checkbox>
      <slot slot="header" name="header" id="header"></slot>
      <md-focus-ring inward></md-focus-ring>
    </div>`}render(){if(this.options.length<=1){return this.renderRow()}else{return this.renderExpandableCard()}}}window.customElements.define("export-dialog-section",ExportDialogSection);