// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./language-list-item.js";import{html,map}from"chrome://resources/mwc/lit/index.js";import{usePlatformHandler}from"../core/lit/context.js";import{ReactiveLitElement}from"../core/reactive/lit.js";export class LanguageList extends ReactiveLitElement{constructor(){super(...arguments);this.selectedLanguage=null;this.platformHandler=usePlatformHandler()}static{this.properties={selectedLanguage:{attribute:false}}}renderLanguageRow(langPack){const{languageCode:languageCode}=langPack;const sodaState=this.platformHandler.getSodaState(languageCode).value;return html`
      <language-list-item
        .langPackInfo=${langPack}
        .sodaState=${sodaState}
        ?selected=${languageCode===this.selectedLanguage}
      >
      </language-list-item>
    `}render(){const list=this.platformHandler.getLangPackList();return map(list,(langPack=>this.renderLanguageRow(langPack)))}}window.customElements.define("language-list",LanguageList);