// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cros_components/menu/menu_separator.js";import"./cra/cra-icon.js";import"./cra/cra-icon-dropdown.js";import"./cra/cra-icon-dropdown-option.js";import{css,html,live,map,nothing}from"chrome://resources/mwc/lit/index.js";import{i18n}from"../core/i18n.js";import{useMicrophoneManager,usePlatformHandler}from"../core/lit/context.js";import{ReactiveLitElement}from"../core/reactive/lit.js";import{settings}from"../core/state/settings.js";import{assert}from"../core/utils/assert.js";import{withTooltip}from"./directives/with-tooltip.js";export class MicSelectionButton extends ReactiveLitElement{constructor(){super(...arguments);this.microphoneManager=useMicrophoneManager();this.platformHandler=usePlatformHandler()}static{this.styles=css`
    :host {
      display: block;
    }

    cra-icon-dropdown {
      display: block;
    }

    cra-icon-dropdown::part(menu) {
      --cros-menu-width: 320px;
    }

    #mic-error-container {
      align-items: center;
      background: var(--cros-sys-warning_container);
      border-radius: 8px;
      box-sizing: border-box;
      display: flex;
      flex-flow: row;
      gap: 16px;
      margin: 0 8px;
      padding: 6px 8px;
      width: var(--cros-menu-width);

      & > cra-icon {
        height: 20px;
        width: 20px;
      }

      & > .content {
        color: var(--cros-sys-on_warning_container);
        margin: 0;
      }

      & > #text {
        font: var(--cros-button-2-font);
      }
    }
  `}toggleSystemAudio(){settings.mutate((d=>{d.includeSystemAudio=!d.includeSystemAudio}))}checkSystemAudioConsent(){const triggerSystemAudioConsent=!settings.value.includeSystemAudio&&!settings.value.systemAudioConsentDone;if(!triggerSystemAudioConsent){this.toggleSystemAudio()}else{this.dispatchEvent(new CustomEvent("trigger-system-audio-consent"));this.requestUpdate()}}renderMicrophone(mic,selectedMic){const micIcon=mic.isInternal?"mic":"mic_external_on";const isSelectedMic=mic.deviceId===selectedMic;const onSelectMic=()=>{this.microphoneManager.setSelectedMicId(mic.deviceId)};return html`
      <cra-icon-dropdown-option
        headline=${mic.label}
        itemStart="icon"
        ?checked=${isSelectedMic}
        @cros-icon-dropdown-option-triggered=${onSelectMic}
        data-role="menuitemcheckbox"
      >
        <cra-icon slot="start" name=${micIcon}></cra-icon>
      </cra-icon-dropdown-option>
    `}onSwitchChange(){this.requestUpdate()}renderSystemAudioSwitch(){if(!this.platformHandler.canCaptureSystemAudioWithLoopback.value){return nothing}const{includeSystemAudio:includeSystemAudio}=settings.value;return html`
      <cros-menu-separator></cros-menu-separator>
      <cra-icon-dropdown-option
        headline=${i18n.micSelectionMenuSystemAudioOption}
        itemStart="icon"
        itemEnd="switch"
        .switchSelected=${live(includeSystemAudio)}
        @cros-menu-item-triggered=${this.checkSystemAudioConsent}
        @change=${this.onSwitchChange}
      >
        <cra-icon slot="start" name="laptop_chromebook"></cra-icon>
      </cra-icon-dropdown-option>
    `}renderMicList(){const selectedMic=this.microphoneManager.getSelectedMicId().value;if(selectedMic===null){return html`
        <div id="mic-error-container">
          <cra-icon class="content" name="mic_alert"></cra-icon>
          <div id="text" class="content">
            ${i18n.micSelectionMenuMicConnectionErrorDescription}
          </div>
        </div>
      `}const microphones=this.microphoneManager.getMicrophoneList().value;assert(microphones.length!==0,"No connected mic but `getSelectedMicId` returns non-null id.");return map(microphones,(mic=>this.renderMicrophone(mic,selectedMic)))}render(){return html`
      <cra-icon-dropdown
        id="mic-selection-button"
        shape="circle"
        anchor-corner="start-start"
        menu-corner="end-start"
        menu-type="menu"
        aria-label=${i18n.micSelectionMenuButtonTooltip}
        ${withTooltip()}
      >
        <cra-icon slot="button-icon" name="mic"></cra-icon>
        ${this.renderMicList()}
        ${this.renderSystemAudioSwitch()}
      </cra-icon-dropdown>
    `}}window.customElements.define("mic-selection-button",MicSelectionButton);