// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./cra/cra-button.js";import"./cra/cra-image.js";import"./language-dropdown.js";import"./speaker-label-consent-dialog-content.js";import"./unescapable-dialog.js";import{createRef,css,html,keyed,ref}from"chrome://resources/mwc/lit/index.js";import{i18n}from"../core/i18n.js";import{usePlatformHandler}from"../core/lit/context.js";import{ReactiveLitElement}from"../core/reactive/lit.js";import{computed,signal}from"../core/reactive/signal.js";import{settings,SpeakerLabelEnableState}from"../core/state/settings.js";import{disableTranscription,enableTranscriptionSkipConsentCheck,setTranscriptionLanguage}from"../core/state/transcription.js";import{assertExhaustive}from"../core/utils/assert.js";import{DESCRIPTION_NAMES as SPEAKER_LABEL_DIALOG_DESCRIPTION_NAMES}from"./speaker-label-consent-dialog-content.js";export class OnboardingDialog extends ReactiveLitElement{constructor(){super(...arguments);this.onboarding=false;this.step=0;this.platformHandler=usePlatformHandler();this.autoFocusItem=createRef();this.selectedLanguage=signal(this.platformHandler.getDefaultLanguage());this.availableLanguages=computed((()=>{const languageList=this.platformHandler.getLangPackList();return languageList.filter((langPack=>{const sodaState=this.platformHandler.getSodaState(langPack.languageCode);return sodaState.value.kind!=="unavailable"}))}))}static{this.styles=css`
    :host {
      display: block;
    }

    #dialog {
      height: 512px;

      /* Want at least 80px left/right margin. */
      width: min(512px, 100vw - 160px);

      /* From CrOS dialog style. Min width for Recorder App is 480px. */
      @media (width < 520px) {
        width: 360px;
      }
    }

    language-dropdown {
      margin-top: 16px;
    }

    .left {
      margin-right: auto;
    }
  `}static{this.properties={onboarding:{type:Boolean},step:{state:true}}}updated(changedProperties){if(changedProperties.has("step")||changedProperties.has("onboarding")){const autoFocusItem=this.autoFocusItem.value;if(autoFocusItem!==undefined){autoFocusItem.updateComplete.then((()=>{autoFocusItem.focus()}))}}}sendOnboardEvent(){this.platformHandler.eventsSender.sendOnboardEvent({speakerLabelEnableState:settings.value.speakerLabelEnabled,transcriptionAvailable:this.platformHandler.isSodaAvailable(),transcriptionEnableState:settings.value.transcriptionEnabled})}close(){this.finishOnboard(true)}finishOnboard(isDialogShown){this.sendOnboardEvent();this.dispatchEvent(new CustomEvent("onboarded",{detail:isDialogShown}))}renderDialog(step,imageName,header,description,buttons){return keyed(step,html`<unescapable-dialog
        id="dialog"
        illustrationName=${imageName}
        header=${header}
        ?open=${this.onboarding}
      >
        <div slot="description">${description}</div>
        <div id="buttons" slot="actions">${buttons}</div>
      </unescapable-dialog>`)}render(){if(!this.platformHandler.isSodaAvailable()){if(!this.onboarding){return}this.finishOnboard(false);return}switch(this.step){case 0:{const nextStep=()=>{this.step=this.platformHandler.isMultipleLanguageAvailable()?2:1};const welcomeDescription=this.platformHandler.isGenAiAvailable()?i18n.onboardingDialogWelcomeDescription:i18n.onboardingDialogWelcomeDescriptionWithoutGenAiFeatures;return this.renderDialog(this.step,"onboarding_welcome",i18n.onboardingDialogWelcomeHeader,welcomeDescription,html`<cra-button
            .label=${i18n.onboardingDialogWelcomeNextButton}
            @click=${nextStep}
            ${ref(this.autoFocusItem)}
          ></cra-button>`)}case 1:{const turnOnTranscription=()=>{enableTranscriptionSkipConsentCheck();if(!this.platformHandler.canUseSpeakerLabel.value){this.close();return}this.step=4};const turnOffTranscription=()=>{disableTranscription(true);this.close()};return this.renderDialog(this.step,"onboarding_transcription",i18n.onboardingDialogTranscriptionHeader,i18n.onboardingDialogTranscriptionDescription,html`
            <cra-button
              .label=${i18n.onboardingDialogTranscriptionDeferButton}
              class="left"
              @click=${this.close}
              ${ref(this.autoFocusItem)}
            ></cra-button>
            <cra-button
              .label=${i18n.onboardingDialogTranscriptionCancelButton}
              @click=${turnOffTranscription}
            ></cra-button>
            <cra-button
              .label=${i18n.onboardingDialogTranscriptionDownloadButton}
              @click=${turnOnTranscription}
            ></cra-button>
          `)}case 2:{const turnOnTranscription=()=>{enableTranscriptionSkipConsentCheck();this.step=3};const turnOffTranscription=()=>{disableTranscription(true);this.close()};return this.renderDialog(this.step,"onboarding_transcription",i18n.onboardingDialogTranscriptionTurnOnHeader,i18n.onboardingDialogTranscriptionTurnOnDescription,html`
            <cra-button
              .label=${i18n.onboardingDialogTranscriptionDeferButton}
              class="left"
              @click=${this.close}
              ${ref(this.autoFocusItem)}
            ></cra-button>
            <cra-button
              .label=${i18n.onboardingDialogTranscriptionCancelButton}
              @click=${turnOffTranscription}
            ></cra-button>
            <cra-button
              .label=${i18n.onboardingDialogTranscriptionTurnOnButton}
              @click=${turnOnTranscription}
            ></cra-button>
          `)}case 3:{const onDropdownChange=ev=>{this.selectedLanguage.value=ev.detail};const dialogBody=html`
          ${i18n.onboardingDialogLanguageSelectionDescription}
          <language-dropdown
            .defaultLanguage=${this.platformHandler.getDefaultLanguage()}
            .languageList=${this.availableLanguages.value}
            @dropdown-changed=${onDropdownChange}
            ${ref(this.autoFocusItem)}
          >
          </language-dropdown>
        `;const downloadLanguage=()=>{const languageCode=this.selectedLanguage.value;if(languageCode===null){return}setTranscriptionLanguage(languageCode);if(!this.platformHandler.canUseSpeakerLabel.value){this.close();return}this.step=4};const cancelSelection=()=>{this.close()};return this.renderDialog(this.step,"onboarding_transcription",i18n.onboardingDialogLanguageSelectionHeader,dialogBody,html`
            <cra-button
              .label=${i18n.onboardingDialogLanguageSelectionCancelButton}
              @click=${cancelSelection}
            ></cra-button>
            <cra-button
              label=${i18n.onboardingDialogLanguageSelectionDownloadButton}
              @click=${downloadLanguage}
              .disabled=${this.selectedLanguage.value===null}
            ></cra-button>
          `)}case 4:{const ALLOW_BUTTON_NAME="onboardingDialogSpeakerLabelAllowButton";const DISALLOW_BUTTON_NAME="onboardingDialogSpeakerLabelDisallowButton";const disableSpeakerLabel=()=>{settings.mutate((s=>{s.speakerLabelEnabled=SpeakerLabelEnableState.DISABLED_FIRST}));this.platformHandler.recordSpeakerLabelConsent(false,SPEAKER_LABEL_DIALOG_DESCRIPTION_NAMES,DISALLOW_BUTTON_NAME);this.close()};const enableSpeakerLabel=()=>{settings.mutate((s=>{s.speakerLabelEnabled=SpeakerLabelEnableState.ENABLED}));this.platformHandler.recordSpeakerLabelConsent(true,SPEAKER_LABEL_DIALOG_DESCRIPTION_NAMES,ALLOW_BUTTON_NAME);this.close()};return this.renderDialog(this.step,"onboarding_speaker_label",i18n.onboardingDialogSpeakerLabelHeader,html`<speaker-label-consent-dialog-content>
          </speaker-label-consent-dialog-content>`,html`
            <cra-button
              .label=${i18n.onboardingDialogSpeakerLabelDeferButton}
              class="left"
              @click=${this.close}
              ${ref(this.autoFocusItem)}
            ></cra-button>
            <cra-button
              .label=${i18n[DISALLOW_BUTTON_NAME]}
              @click=${disableSpeakerLabel}
            ></cra-button>
            <cra-button
              .label=${i18n[ALLOW_BUTTON_NAME]}
              @click=${enableSpeakerLabel}
            ></cra-button>
          `)}default:assertExhaustive(this.step)}}}window.customElements.define("onboarding-dialog",OnboardingDialog);