// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cros_components/textfield/textfield.js";import"chrome://resources/cros_components/snackbar/snackbar.js";import"./cra/cra-icon.js";import"./cra/cra-icon-button.js";import"./recording-title-suggestion.js";import{Textfield}from"chrome://resources/cros_components/textfield/textfield.js";import{createRef,css,html,nothing,ref}from"chrome://resources/mwc/lit/index.js";import{i18n}from"../core/i18n.js";import{usePlatformHandler,useRecordingDataManager}from"../core/lit/context.js";import{ReactiveLitElement,ScopedAsyncComputed}from"../core/reactive/lit.js";import{computed,signal}from"../core/reactive/signal.js";import{settings,SummaryEnableState}from"../core/state/settings.js";import{assertExists,assertInstanceof}from"../core/utils/assert.js";import{withTooltip}from"./directives/with-tooltip.js";export class RecordingTitle extends ReactiveLitElement{constructor(){super(...arguments);this.recordingMetadata=null;this.recordingMetadataSignal=this.propSignal("recordingMetadata");this.editing=signal(false);this.suggestionShown=signal(false);this.recordingDataManager=useRecordingDataManager();this.platformHandler=usePlatformHandler();this.renameContainer=createRef();this.snackBar=createRef();this.suggestTitleButton=createRef();this.recordingTitleSuggestion=createRef();this.recordingId=computed((()=>this.recordingMetadataSignal.value?.id??null));this.transcription=new ScopedAsyncComputed(this,(async()=>{if(this.recordingId.value===null){return null}return this.recordingDataManager.getTranscription(this.recordingId.value)}));this.shouldShowTitleSuggestion=computed((()=>{const modelState=this.platformHandler.getGenAiModelState();return modelState.kind==="installed"&&settings.value.summaryEnabled===SummaryEnableState.ENABLED&&this.transcription.value!==null&&!this.transcription.value.isEmpty()}));this.suggestedTitles=new ScopedAsyncComputed(this,(async()=>{if(!this.suggestionShown.value||!this.shouldShowTitleSuggestion.value){return null}if(this.transcription.value===null){return null}const text=this.transcription.value.toPlainText();const language=this.transcription.value.language;this.platformHandler.perfLogger.start({kind:"titleSuggestion",wordCount:this.transcription.value.getWordCount()});const{titleSuggestionModelLoader:titleSuggestionModelLoader}=this.platformHandler;const suggestions=await titleSuggestionModelLoader.loadAndExecute(text,language);this.platformHandler.perfLogger.finish("titleSuggestion");return suggestions}))}static{this.styles=css`
    :host {
      display: block;
      min-width: 0;
    }

    cros-textfield {
      anchor-name: --title-textfield;
      width: 283px;
    }

    recording-title-suggestion {
      position: absolute;
      position-anchor: --title-textfield;
      position-area: bottom span-right;
      margin-top: 4.5px;

      /* Prevents overflow and excessive resizing beyond content size. */
      max-width: calc-size(
        fit-content,
        /* Excludes page margins, icon-button size, and header padding. */
        min(size, 100vw - 16px * 2 - 44px - var(--header-padding))
      );
      min-width: 360px;
      width: fit-content;
    }

    #title {
      anchor-name: --title;
      border-radius: 12px;
      box-sizing: border-box;
      font: var(--cros-headline-1-font);
      overflow: hidden;
      padding: 8px 16px;
      text-overflow: ellipsis;
      white-space: nowrap;

      &:hover {
        background-color: var(--cros-sys-hover_on_subtle);
      }
    }
  `}static{this.properties={recordingMetadata:{attribute:false}}}get renameContainerForTest(){return assertExists(this.renameContainer.value)}get suggestTitleButtonForTest(){return assertExists(this.suggestTitleButton.value)}get titleSuggestionForTest(){return assertExists(this.recordingTitleSuggestion.value)}get editTextfield(){return this.shadowRoot?.querySelector("cros-textfield")??null}async startEditTitle(){this.editing.value=true;await this.updateComplete;await this.updateComplete;await this.updateComplete;this.editTextfield?.focusTextfield()}onFocusout(ev){if(this.suggestionShown.value){return}const newTarget=ev.relatedTarget;if(newTarget instanceof Node&&this.editTextfield?.contains(newTarget)){return}this.editing.value=false;this.requestUpdate()}onTextfieldKeyDown(ev){const target=assertInstanceof(ev.target,Textfield);if(ev.key==="Escape"){target.value=this.recordingMetadata?.title??"";target.blurTextfield()}else if(ev.key==="Enter"){target.blurTextfield()}}onSuggestTitleButtonKeyDown(ev){ev.stopPropagation();if(ev.key==="Escape"){this.editTextfield?.focusTextfield()}}setTitle(title){const meta=this.recordingMetadata;if(meta===null){return}this.recordingDataManager.setMetadata(meta.id,{...meta,title:title});const snackBar=assertExists(this.snackBar.value);snackBar.showPopover()}onChangeTitle(ev){const target=assertInstanceof(ev.target,Textfield);if(target.value!==""){this.setTitle(target.value)}}onSuggestTitle(ev){this.setTitle(ev.detail)}openSuggestionDialog(){this.suggestionShown.value=true}closeSuggestionDialog(){this.editTextfield?.focusTextfield();this.suggestionShown.value=false}renderSuggestionDialog(){if(!this.suggestionShown.value){return nothing}return html`<recording-title-suggestion
      @close=${this.closeSuggestionDialog}
      @change=${this.onSuggestTitle}
      .suggestedTitles=${this.suggestedTitles}
      .wordCount=${this.transcription.value?.getWordCount()??0}
      .transcription=${this.transcription.value?.toPlainText()??""}
      ${ref(this.recordingTitleSuggestion)}
    ></recording-title-suggestion>`}renderTitle(){if(this.editing.value){const suggestionIconButton=this.suggestionShown.value||!this.shouldShowTitleSuggestion.value?nothing:html`<cra-icon-button
              buttonstyle="floating"
              size="small"
              slot="trailing"
              shape="circle"
              @click=${this.openSuggestionDialog}
              @keydown=${this.onSuggestTitleButtonKeyDown}
              ${ref(this.suggestTitleButton)}
              aria-label=${i18n.titleSuggestionButtonTooltip}
              ${withTooltip()}
            >
              <cra-icon slot="icon" name="pen_spark"></cra-icon>
            </cra-icon-button>`;return html`<cros-textfield
          type="text"
          .value=${this.recordingMetadata?.title??""}
          @change=${this.onChangeTitle}
          @focusout=${this.onFocusout}
          @keydown=${this.onTextfieldKeyDown}
          aria-label=${i18n.titleTextfieldAriaLabel}
        >
          ${suggestionIconButton}
        </cros-textfield>
        ${this.renderSuggestionDialog()}`}return html`
      <div
        id="title"
        tabindex="0"
        @focus=${this.startEditTitle}
        @click=${this.startEditTitle}
        ${ref(this.renameContainer)}
        ${withTooltip(i18n.titleEditTooltip)}
      >
        ${this.recordingMetadata?.title??""}
      </div>
    `}render(){return html`
      <cros-snackbar
        message=${i18n.titleEditSnackbarMessage}
        timeoutMs="4000"
        ${ref(this.snackBar)}
      ></cros-snackbar>
      ${this.renderTitle()}
    `}}window.customElements.define("recording-title",RecordingTitle);