// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{html,nothing}from"chrome://resources/mwc/lit/index.js";import{ReactiveLitElement}from"../core/reactive/lit.js";import{formatDuration}from"../core/utils/datetime.js";export class TimeDuration extends ReactiveLitElement{constructor(){super(...arguments);this.digits=0;this.duration=null}static{this.properties={digits:{type:Number},duration:{attribute:false}}}render(){if(this.duration===null){return nothing}return html`
      <div aria-label=${formatDuration(this.duration,this.digits,true)}>
        <span aria-hidden="true">
          ${formatDuration(this.duration,this.digits)}
        </span>
      </div>
    `}}window.customElements.define("time-duration",TimeDuration);