// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./cra/cra-button.js";import"./cra/cra-feature-tour-dialog.js";import"./language-selection-dialog.js";import"./speaker-label-consent-dialog.js";import{createRef,css,html,ref}from"chrome://resources/mwc/lit/index.js";import{i18n}from"../core/i18n.js";import{usePlatformHandler}from"../core/lit/context.js";import{ReactiveLitElement}from"../core/reactive/lit.js";import{disableTranscription,enableTranscriptionSkipConsentCheck}from"../core/state/transcription.js";export class TranscriptionConsentDialog extends ReactiveLitElement{constructor(){super(...arguments);this.dialog=createRef();this.languageSelectionDialog=createRef();this.speakerLabelConsentDialog=createRef();this.platformHandler=usePlatformHandler();this.shouldShowSelector=this.platformHandler.isMultipleLanguageAvailable()}static{this.styles=css`
    :host {
      display: contents;
    }

    .left {
      margin-right: auto;
    }

    cra-feature-tour-dialog {
      height: 512px;
    }
  `}async show(){await(this.dialog.value?.show())}hide(){this.dialog.value?.hide()}disableTranscription(){disableTranscription(true);this.hide()}enableTranscription(){enableTranscriptionSkipConsentCheck();if(!this.shouldShowSelector){if(this.platformHandler.canUseSpeakerLabel.value){this.speakerLabelConsentDialog.value?.show()}}else{this.languageSelectionDialog.value?.show()}this.hide()}render(){const header=this.shouldShowSelector?i18n.onboardingDialogTranscriptionTurnOnHeader:i18n.onboardingDialogTranscriptionHeader;const description=this.shouldShowSelector?i18n.onboardingDialogTranscriptionTurnOnDescription:i18n.onboardingDialogTranscriptionDescription;const turnOnButtonLabel=this.shouldShowSelector?i18n.onboardingDialogTranscriptionTurnOnButton:i18n.onboardingDialogTranscriptionDownloadButton;return html`<cra-feature-tour-dialog
        ${ref(this.dialog)}
        illustrationName="onboarding_transcription"
        header=${header}
      >
        <div slot="content">${description}</div>
        <div slot="actions">
          <cra-button
            .label=${i18n.onboardingDialogTranscriptionDeferButton}
            class="left"
            @click=${this.hide}
          ></cra-button>
          <cra-button
            .label=${i18n.onboardingDialogTranscriptionCancelButton}
            @click=${this.disableTranscription}
          ></cra-button>
          <cra-button
            .label=${turnOnButtonLabel}
            @click=${this.enableTranscription}
          ></cra-button>
        </div>
      </cra-feature-tour-dialog>
      <language-selection-dialog ${ref(this.languageSelectionDialog)}>
      </language-selection-dialog>
      <speaker-label-consent-dialog ${ref(this.speakerLabelConsentDialog)}>
      </speaker-label-consent-dialog>`}}window.customElements.define("transcription-consent-dialog",TranscriptionConsentDialog);