// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{join}from"chrome://resources/mwc/lit/index.js";import{PlatformHandler}from"../platforms/index.js";import{forceCast}from"./utils/type_utils.js";function withArgs(){return forceCast(null)}const noArgStringNames=["appName","backToMainButtonAriaLabel","backToMainButtonTooltip","closeDialogButtonTooltip","errorDialogConsentButton","exportDialogAudioFormatWebmOption","exportDialogAudioHeader","exportDialogCancelButton","exportDialogHeader","exportDialogSaveButton","exportDialogTranscriptionFormatTxtOption","exportDialogTranscriptionHeader","genAiDisclaimerText","genAiDownloadErrorStatusMessage","genAiDownloadFinishedStatusMessage","genAiDownloadStartedStatusMessage","genAiErrorGeneralLabel","genAiErrorModelDownloadButton","genAiErrorModelDownloadButtonAriaLabel","genAiErrorModelLoadFailureLabel","genAiErrorSummaryLanguageUnsupportedLabel","genAiErrorSummaryNeedsRebootLabel","genAiErrorSummaryTranscriptTooLongLabel","genAiErrorSummaryTranscriptTooShortLabel","genAiErrorSummaryTrustAndSafetyLabel","genAiErrorTitleSuggestionLanguageUnsupportedLabel","genAiErrorTitleSuggestionNeedsRebootLabel","genAiErrorTitleSuggestionTranscriptTooLongLabel","genAiErrorTitleSuggestionTranscriptTooShortLabel","genAiErrorTitleSuggestionTrustAndSafetyLabel","genAiExperimentBadge","genAiFeedbackModelInputField","genAiFeedbackPrompt","genAiFeedbackSummaryOutputField","genAiFeedbackTitleSuggestionOutputField","genAiLearnMoreLink","genAiLearnMoreLinkTooltip","genAiNeedsRebootStatusMessage","genaiNegativeFeedbackButtonTooltip","genaiPositiveFeedbackButtonTooltip","languageDropdownHintOption","languagePickerAvailableLanguagesHeader","languagePickerBackButtonAriaLabel","languagePickerBackButtonTooltip","languagePickerHeader","languagePickerLanguageDownloadButton","languagePickerLanguageDownloadingButton","languagePickerLanguageErrorDescription","languagePickerLanguageNeedsRebootDescription","languagePickerLanguagesListLandmarkAriaLabel","languagePickerSelectedLanguageHeader","languagePickerSelectedLanguageNoneLabel","mainChooseMicNudge","mainRecordingBarLandmarkAriaLabel","mainRecordingsListLandmarkAriaLabel","mainSearchLandmarkAriaLabel","mainStartRecordButtonTooltip","mainStartRecordNudge","micConnectionErrorDialogDescription","micConnectionErrorDialogHeader","micSelectionMenuButtonTooltip","micSelectionMenuMicConnectionErrorDescription","micSelectionMenuSystemAudioOption","onboardingDialogLanguageSelectionCancelButton","onboardingDialogLanguageSelectionDescription","onboardingDialogLanguageSelectionDownloadButton","onboardingDialogLanguageSelectionHeader","onboardingDialogSpeakerLabelAllowButton","onboardingDialogSpeakerLabelDeferButton","onboardingDialogSpeakerLabelDescriptionListItem1","onboardingDialogSpeakerLabelDescriptionListItem2","onboardingDialogSpeakerLabelDescriptionListItem3","onboardingDialogSpeakerLabelDescriptionPrefix","onboardingDialogSpeakerLabelDescriptionSuffix","onboardingDialogSpeakerLabelDisallowButton","onboardingDialogSpeakerLabelHeader","onboardingDialogSpeakerLabelLearnMoreLink","onboardingDialogTranscriptionCancelButton","onboardingDialogTranscriptionDeferButton","onboardingDialogTranscriptionDescription","onboardingDialogTranscriptionDownloadButton","onboardingDialogTranscriptionHeader","onboardingDialogTranscriptionTurnOnButton","onboardingDialogTranscriptionTurnOnDescription","onboardingDialogTranscriptionTurnOnHeader","onboardingDialogWelcomeDescription","onboardingDialogWelcomeDescriptionWithoutGenAiFeatures","onboardingDialogWelcomeHeader","onboardingDialogWelcomeNextButton","playbackBackwardButtonTooltip","playbackControlsLandmarkAriaLabel","playbackFloatingVolumeCloseButtonAriaLabel","playbackFloatingVolumeShowButtonAriaLabel","playbackForwardButtonTooltip","playbackHideTranscriptButtonTooltip","playbackMenuButtonTooltip","playbackMenuDeleteOption","playbackMenuExportOption","playbackMenuShowDetailOption","playbackMuteButtonTooltip","playbackPauseButtonTooltip","playbackPlayButtonTooltip","playbackSeekSliderAriaLabel","playbackShowTranscriptButtonTooltip","playbackSpeedButtonTooltip","playbackSpeedNormalOption","playbackTranscriptLandmarkAriaLabel","playbackUnmuteButtonTooltip","playbackVolumeSliderAriaLabel","recordDeleteButtonTooltip","recordDeleteDialogCancelButton","recordDeleteDialogCurrentHeader","recordDeleteDialogDeleteButton","recordDeleteDialogDescription","recordDeleteDialogHeader","recordExitDialogCancelButton","recordExitDialogDeleteButton","recordExitDialogDescription","recordExitDialogHeader","recordExitDialogSaveAndExitButton","recordGeneralAudioErrorDialogDescription","recordGeneralAudioErrorDialogHeader","recordHideTranscriptButtonTooltip","recordInfoDialogDateLabel","recordInfoDialogDurationLabel","recordInfoDialogHeader","recordInfoDialogSizeLabel","recordInfoDialogTitleLabel","recordMenuButtonTooltip","recordMenuDeleteOption","recordMenuToggleSpeakerLabelOption","recordMenuToggleTranscriptionOption","recordMuteButtonTooltip","recordPauseButtonTooltip","recordResumeButtonTooltip","recordShowTranscriptButtonTooltip","recordStopButton","recordTranscriptionEntryPointDescription","recordTranscriptionEntryPointDisableButton","recordTranscriptionEntryPointEnableButton","recordTranscriptionEntryPointHeader","recordTranscriptionOffDescription","recordTranscriptionOffHeader","recordTranscriptionUnusableErrorDescription","recordTranscriptionUnusableHeader","recordTranscriptionUnusableNeedsRebootDescription","recordTranscriptionUnusableNotInstalledDescription","recordTranscriptionUnusableSelectLanguageDescription","recordTranscriptionWaitingDownloadText","recordUnmuteButtonTooltip","recordingItemOptionsButtonTooltip","recordingItemPauseButtonTooltip","recordingItemPlayButtonTooltip","recordingListHeader","recordingListNoMatchText","recordingListSearchBoxClearButtonAriaLabel","recordingListSearchBoxCloseButtonAriaLabel","recordingListSearchBoxPlaceholder","recordingListSearchButtonTooltip","recordingListSortButtonTooltip","recordingListSortByDateOption","recordingListSortByTitleOption","recordingListThisMonthHeader","recordingListTodayHeader","recordingListYesterdayHeader","settingsHeader","settingsOptionsDoNotDisturbDescription","settingsOptionsDoNotDisturbLabel","settingsOptionsGenAiDescription","settingsOptionsGenAiDownloadButton","settingsOptionsGenAiDownloadButtonAriaLabel","settingsOptionsGenAiDownloadingButton","settingsOptionsGenAiDownloadingProgressDescription","settingsOptionsGenAiErrorDescription","settingsOptionsGenAiLabel","settingsOptionsGenAiLearnMoreLink","settingsOptionsGenAiLearnMoreLinkAriaLabel","settingsOptionsGenAiNeedsRebootDescription","settingsOptionsKeepScreenOnLabel","settingsOptionsLanguageSubpageButtonAriaLabel","settingsOptionsSpeakerLabelDescription","settingsOptionsSpeakerLabelLabel","settingsOptionsTranscriptionDownloadButton","settingsOptionsTranscriptionDownloadButtonAriaLabel","settingsOptionsTranscriptionDownloadingButton","settingsOptionsTranscriptionErrorDescription","settingsOptionsTranscriptionLabel","settingsOptionsTranscriptionLanguageDescription","settingsOptionsTranscriptionLanguageLabel","settingsOptionsTranscriptionNeedsRebootDescription","settingsSectionGeneralHeader","settingsSectionTranscriptionSummaryHeader","summaryCollapseTooltip","summaryDisabledLabel","summaryDownloadGenAiModelDescription","summaryDownloadGenAiModelDisableButton","summaryDownloadGenAiModelDownloadButton","summaryDownloadGenAiModelHeader","summaryExpandTooltip","summaryFailedStatusMessage","summaryFinishedStatusMessage","summaryHeader","summaryStartedStatusMessage","systemAudioConsentDialogCancelButton","systemAudioConsentDialogConsentButton","systemAudioConsentDialogDescription","systemAudioConsentDialogHeader","titleEditSnackbarMessage","titleEditTooltip","titleSuggestionButtonTooltip","titleSuggestionFailedStatusMessage","titleSuggestionFinishedStatusMessage","titleSuggestionHeader","titleSuggestionStartedStatusMessage","titleTextfieldAriaLabel","transcriptionAutoscrollButton","transcriptionNoSpeechText","transcriptionSpeakerLabelPendingLabel","transcriptionWaitingSpeechText"];const withArgsStringNames={languagePickerLanguageDownloadButtonAriaLabel:withArgs(),languagePickerLanguageDownloadErrorAriaLabel:withArgs(),languagePickerLanguageDownloadErrorStatusMessage:withArgs(),languagePickerLanguageDownloadFinishedStatusMessage:withArgs(),languagePickerLanguageDownloadStartedStatusMessage:withArgs(),languagePickerLanguageDownloadingAriaLabel:withArgs(),languagePickerLanguageDownloadingProgressDescription:withArgs(),languagePickerLanguageNeedsRebootAriaLabel:withArgs(),languagePickerLanguageNeedsRebootStatusMessage:withArgs(),languagePickerLanguageNotDownloadedAriaLabel:withArgs(),languagePickerLanguageNotSelectedAriaLabel:withArgs(),languagePickerLanguageSelectedAriaLabel:withArgs(),recordingItemOptionsButtonAriaLabel:withArgs(),recordingItemPauseButtonAriaLabel:withArgs(),recordingItemPlayButtonAriaLabel:withArgs(),settingsOptionsGenAiDownloadingProgressDescription:withArgs(),settingsOptionsTranscriptionDownloadingProgressDescription:withArgs(),summaryGenAiDownloadingProgressDescription:withArgs(),transcriptionSpeakerLabelLabel:withArgs()};const withDeviceStringNames=["genAiDownloadErrorStatusMessage","genAiErrorModelLoadFailureLabel","genAiErrorSummaryNeedsRebootLabel","genAiErrorTitleSuggestionLanguageUnsupportedLabel","genAiErrorTitleSuggestionNeedsRebootLabel","genAiNeedsRebootStatusMessage","languagePickerLanguageDownloadErrorAriaLabel","languagePickerLanguageDownloadErrorStatusMessage","languagePickerLanguageErrorDescription","languagePickerLanguageNeedsRebootAriaLabel","languagePickerLanguageNeedsRebootDescription","languagePickerLanguageNeedsRebootStatusMessage","micSelectionMenuSystemAudioOption","recordGeneralAudioErrorDialogDescription","recordTranscriptionUnusableErrorDescription","recordTranscriptionUnusableNeedsRebootDescription","settingsOptionsGenAiErrorDescription","settingsOptionsGenAiNeedsRebootDescription","settingsOptionsTranscriptionErrorDescription","settingsOptionsTranscriptionNeedsRebootDescription","systemAudioConsentDialogDescription","systemAudioConsentDialogHeader"];function maybeReplaceDeviceType(name,i18nString){if(withDeviceStringNames.includes(name)){return i18nString.replaceAll("[deviceType]",PlatformHandler.getDeviceType())}return i18nString}function getI18nString(name){return maybeReplaceDeviceType(name,PlatformHandler.getStringF(name))}function createI18nStringFormatter(name){return(...args)=>maybeReplaceDeviceType(name,PlatformHandler.getStringF(name,...args))}export const i18n=forceCast(Object.fromEntries([...noArgStringNames.map((name=>[name,getI18nString(name)])),...Object.keys(withArgsStringNames).map((name=>[name,createI18nStringFormatter(name)]))]));export function replacePlaceholderWithHtml(s,placeholder,html){const parts=s.split(placeholder);if(parts.length<=1){console.error(`Translated string doesn't contain expected placeholder`,s,placeholder)}return join(parts,(()=>html))}