// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{DataDir}from"./data_dir.js";import{initContext}from"./lit/context.js";import{MicrophoneManager}from"./microphone_manager.js";import{RecordingDataManager}from"./recording_data_manager.js";import{installRouter}from"./state/route.js";import{init as initSettings}from"./state/settings.js";export async function init(platformHandler){let dataDir=null;platformHandler.perfLogger.start({kind:"appStart"});window.addEventListener("unhandledrejection",(rejection=>{platformHandler.handleUncaughtError(rejection.reason)}));window.addEventListener("error",(errorEvent=>{console.error(errorEvent.error);platformHandler.handleUncaughtError(errorEvent.error)}));installRouter();initSettings();const microphoneManager=await MicrophoneManager.create((deviceId=>platformHandler.getMicrophoneInfo(deviceId)));dataDir=await DataDir.createFromOpfs();const recordingDataManager=await RecordingDataManager.create(dataDir);initContext({microphoneManager:microphoneManager,recordingDataManager:recordingDataManager,platformHandler:platformHandler})}