// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{createTranscriptionModelDownloadPerf}from"./events_sender.js";import{getModelUiOrder}from"./on_device_model/types.js";import{effect}from"./reactive/signal.js";import{LanguageCode}from"./soda/language_info.js";import{settings}from"./state/settings.js";export class PlatformHandler{static getStringF(_id,..._args){throw new Error("getStringF not implemented")}static getDeviceType(){throw new Error("getDeviceType not implemented")}getGenAiModelState(){const summaryModelState=this.summaryModelLoader.state.value;const summaryUiOrder=getModelUiOrder(summaryModelState);const titleSuggestionModelState=this.titleSuggestionModelLoader.state.value;const titleSuggestionUiOrder=getModelUiOrder(titleSuggestionModelState);if(summaryModelState.kind==="installing"&&titleSuggestionModelState.kind==="installing"){if(summaryModelState.progress<titleSuggestionModelState.progress){return summaryModelState}return titleSuggestionModelState}if(summaryUiOrder<titleSuggestionUiOrder){return summaryModelState}return titleSuggestionModelState}isGenAiAvailable(){return this.getGenAiModelState().kind!=="unavailable"}downloadGenAiModel(){this.summaryModelLoader.download();this.titleSuggestionModelLoader.download()}getSelectedLanguage(){let selectedLanguage=settings.value.transcriptionLanguage;if(selectedLanguage!==null&&this.getSodaState(selectedLanguage).value.kind==="unavailable"){selectedLanguage=null}if(selectedLanguage===null&&!this.isMultipleLanguageAvailable()){selectedLanguage=LanguageCode.EN_US}return selectedLanguage}getSelectedLangPackInfo(){const selectedLanguage=this.getSelectedLanguage();return selectedLanguage===null?null:this.getLangPackInfo(selectedLanguage)}getSelectedLanguageState(){const selectedLanguage=this.getSelectedLanguage();return selectedLanguage===null?null:this.getSodaState(selectedLanguage)}getLocale(){return undefined}initPerfEventWatchers(){effect((()=>{const state=this.summaryModelLoader.state.value;const summaryEventType="summaryModelDownload";if(state.kind==="installed"){this.perfLogger.tryFinish(summaryEventType)}}));const languageList=this.getLangPackList();for(const language of languageList){effect((()=>{const state=this.getSodaState(language.languageCode).value;if(state.kind==="installed"){this.perfLogger.tryFinish(createTranscriptionModelDownloadPerf(language.languageCode).kind)}}))}}}