// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{LitElement}from"chrome://resources/mwc/lit/index.js";import{batch,effect,signal}from"./signal.js";export class ReactiveLitElement extends LitElement{constructor(){super(...arguments);this.disposeUpdateEffect=null;this.inPerformUpdate=false;this.updateTrigger=signal(false);this.propertySignalBindings=[]}performUpdate(){if(!this.isUpdatePending||!this.isConnected){return}this.inPerformUpdate=true;if(this.disposeUpdateEffect!==null){this.updateTrigger.update((x=>!x));return}this.disposeUpdateEffect=effect((()=>{void this.updateTrigger.value;if(this.inPerformUpdate){this.inPerformUpdate=false;super.performUpdate()}else{this.requestUpdate()}}))}connectedCallback(){super.connectedCallback();this.requestUpdate()}disconnectedCallback(){super.disconnectedCallback();this.disposeUpdateEffect?.();this.disposeUpdateEffect=null}registerPropertySignal(signal,prop){this.propertySignalBindings.push({signal:signal,prop:prop})}willUpdate(changedProperties){batch((()=>{for(const{signal:signal,prop:prop}of this.propertySignalBindings){if(changedProperties.has(prop)){signal.value=Reflect.get(this,prop)}}}))}propSignal(prop){const sig=signal(Reflect.get(this,prop));this.registerPropertySignal(sig,prop);return sig}}export var ComputedState;(function(ComputedState){ComputedState["DONE"]="DONE";ComputedState["ERROR"]="ERROR";ComputedState["RUNNING"]="RUNNING";ComputedState["UNINITIALIZED"]="UNINITIALIZED"})(ComputedState||(ComputedState={}));export class ScopedAsyncComputed{constructor(host,callback){this.callback=callback;this.dispose=null;this.stateInternal=signal(ComputedState.UNINITIALIZED);this.valueInternal=signal(null);this.forceRerunToggle=signal(false);host.addController(this)}rerun(){this.forceRerunToggle.update((x=>!x))}get state(){return this.stateInternal.value}get value(){return this.valueInternal.value}get valueSignal(){return this.valueInternal}hostConnected(){let latestRun;let abortController=null;this.dispose=effect((()=>{void this.forceRerunToggle.value;abortController?.abort();abortController=new AbortController;const thisRun=Symbol();latestRun=thisRun;this.stateInternal.value=ComputedState.RUNNING;this.callback(abortController.signal).then((val=>{if(latestRun===thisRun){this.valueInternal.value=val;this.stateInternal.value=ComputedState.DONE}}),(e=>{if(latestRun===thisRun){console.error(e);this.stateInternal.value=ComputedState.ERROR}}))}))}hostDisconnected(){this.dispose?.();this.dispose=null;this.stateInternal.value=ComputedState.UNINITIALIZED;this.valueInternal.value=null}}export const ScopedAsyncEffect=ScopedAsyncComputed;export class ScopedEffect{constructor(host,callback){this.callback=callback;this.dispose=null;host.addController(this)}hostConnected(){if(this.dispose===null){this.dispose=effect(this.callback)}}hostDisconnected(){this.dispose?.();this.dispose=null}}