// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"../../utils/assert.js";import{IterableWeakSet}from"../../utils/iterable_weak_set.js";import{forceCast}from"../../utils/type_utils.js";import{Signal}from"./types.js";var DirtyState;(function(DirtyState){DirtyState[DirtyState["CLEAN"]=0]="CLEAN";DirtyState[DirtyState["TO_CHECK"]=1]="TO_CHECK";DirtyState[DirtyState["DIRTY"]=2]="DIRTY";DirtyState[DirtyState["DISPOSED"]=3]="DISPOSED"})(DirtyState||(DirtyState={}));let currentComputing=null;export class SignalImpl extends Signal{constructor(valueInternal){super();this.valueInternal=valueInternal;this.children=new IterableWeakSet}get value(){if(currentComputing!==null){this.children.add(currentComputing);currentComputing.addParent(this)}return this.valueInternal}set value(newValue){if(newValue!==this.valueInternal){this.valueInternal=newValue;for(const child of this.children){child.markDirtyRecursive()}Effect.processBatchedEffect()}}peek(){return this.valueInternal}maybeUpdate(){return}removeChild(child){this.children.delete(child)}numChildrenForTesting(){return this.children.sizeForTesting()}}const uninitialized=Symbol("uninitialized");export class ComputedImpl extends Signal{constructor(get,set){super();this.get=get;this.set=set;this.valueInternal=forceCast(uninitialized);this.state=DirtyState.DIRTY;this.parents=new Set;this.children=new IterableWeakSet}get value(){assert(this.state!==DirtyState.DISPOSED);if(currentComputing!==null){this.children.add(currentComputing);currentComputing.addParent(this)}return this.peek()}set value(val){assert(this.set!==undefined,"value setter called on computed without set");this.set(val)}peek(){assert(this.state!==DirtyState.DISPOSED);this.maybeUpdate();return this.valueInternal}markDirty(){this.state=DirtyState.DIRTY}markDirtyRecursive(){if(this.state!==DirtyState.DIRTY){this.state=DirtyState.DIRTY;for(const child of this.children){child.markToCheckRecursive()}}}markToCheckRecursive(){if(this.state!==DirtyState.TO_CHECK&&this.state!==DirtyState.DIRTY){this.state=DirtyState.TO_CHECK;for(const child of this.children){child.markToCheckRecursive()}}}addParent(parent){this.parents.add(parent)}dispose(){for(const parent of this.parents){parent.removeChild(this)}this.parents.clear();this.state=DirtyState.DISPOSED}maybeUpdate(){if(this.state===DirtyState.CLEAN){return}if(this.state===DirtyState.TO_CHECK){for(const parent of this.parents){parent.maybeUpdate();if(this.state===DirtyState.DIRTY){break}}if(this.state===DirtyState.TO_CHECK){this.state=DirtyState.CLEAN;return}}this.dispose();const oldComputing=currentComputing;currentComputing=this;const newValue=this.get();currentComputing=oldComputing;if(newValue!==this.valueInternal){this.valueInternal=newValue;for(const child of this.children){child.markDirty()}}this.state=DirtyState.CLEAN}removeChild(child){this.children.delete(child)}numChildrenForTesting(){return this.children.sizeForTesting()}}const allEffects=new Set;export class Effect{static{this.batchedEffect=new Set}static{this.batchDepth=0}constructor(callback){this.callback=callback;this.parents=new Set;this.state=DirtyState.CLEAN;this.dispose=()=>{allEffects.delete(this);this.state=DirtyState.DISPOSED;this.disconnect()};allEffects.add(this);this.execute()}markDirty(){if(this.state!==DirtyState.DIRTY){this.state=DirtyState.DIRTY;Effect.batchedEffect.add(this)}}markDirtyRecursive(){this.markDirty()}markToCheckRecursive(){if(this.state!==DirtyState.DIRTY&&this.state!==DirtyState.TO_CHECK){this.state=DirtyState.TO_CHECK;Effect.batchedEffect.add(this)}}disconnect(){for(const parent of this.parents){parent.removeChild(this)}this.parents.clear()}execute(){this.disconnect();const oldComputing=currentComputing;currentComputing=this;this.callback({dispose:this.dispose});currentComputing=oldComputing;if(this.state!==DirtyState.DISPOSED){this.state=DirtyState.CLEAN}}maybeExecute(){if(this.state===DirtyState.TO_CHECK){for(const parent of this.parents){parent.maybeUpdate();if(this.state===DirtyState.DIRTY){break}}if(this.state===DirtyState.TO_CHECK){this.state=DirtyState.CLEAN;return}}if(this.state===DirtyState.DIRTY){this.execute()}}addParent(parent){assert(this.state!==DirtyState.DISPOSED,"addParent called after the effect had been disposed");this.parents.add(parent)}static processBatchedEffect(){if(Effect.batchDepth!==0){return}let cnt=0;while(Effect.batchedEffect.size>0){cnt++;if(cnt===1e4){throw new Error("Effect recurse for more than 10000 times")}const effects=Effect.batchedEffect;Effect.batchedEffect=new Set;for(const effect of effects){effect.maybeExecute()}}}}